      SUBROUTINE DMCARD (IPRT,   ICRD,   NTRCS, NFOLD, mtap,
     &             NREC,   ICC,    IOREC, DSTMIN, DSTMAX,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             ANGMAX, TC,     VC,    NPAIRS, ANGMIN,
     &             RECLEN, IX1, IY1, IX2, IY2, IX3,
     &             IY3,    IX4, IY4, NTPL,NLI, NDI,
     &             DIVEXP, TRCSPC,   verbos, norm, shot,
     &             aliasflag, ampflag, sprdflag,tape,mute,
     &             lumute, XM, TM, NM, tap1, nmoap, JHEAD,
     &             agc, iwind, agcs)
C***********************************************************************00001970
C                                                                       00001980
C     PROGRAM NAME: DMCARD (READ USER CARDS FOR DM3D)                   00001990
C                                                                       00002000
C     LANGUAGE: FORTRAN                                                 00002010
C                                                                       00002020
C     AUTHOR: G.MURPHY                                                  00002030
C                                                                       00002040
C     DATE WRITTEN: 07/01/88                                            00002050
C                                                                       00002060
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00002080
C                                                                       00002100
C     ABSTRACT: READ DM3D CARDS                                         00002110
C                                                                       00002120
C                                                                       00002130
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00002140
C                                                                       00002150
C***********************************************************************00002160
C                                                                       00002170
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      REAL          TC (*), VC (*)
      REAL          XM (SZLNHD), TM (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      character     mtap * (*), tap1 * (*)
      integer       argis
      integer       aliasflag, ampflag, sprdflag
      integer       key (SZLNHD)
      real          tmp (SZLNHD)
      CHARACTER*80  CARD
      logical       alias, sprd, verbos, norm, shot, tape, mute
      logical       csamp, coamp, bkamp, nmoap, agc
      DATA IEND, IFLAG /0,1/

c---
C *** read TDFN file if not a velocity tape input
c---

      IF (.not. tape .AND. .not. nmoap) THEN

         NPAIRS = 0
         ICC = 0
         READ (ICRD, 140, END=2000) CARD
  140    FORMAT (A80)
         CALL WRCARD (CARD, IFLAG, IPRT)
         IFLAG = 3
         rewind ICRD

      ENDIF

         call argr4 ('-dmin',  DSTMIN, 0., 0.)
         call argr4 ('-dmax',  DSTMAX, 0., 0.)
         call argr4 ('-ddel',  DSTDEL, 0., 0.)
         call argr4 ('-angmn', ANGMIN, 0., 0.)
         call argr4 ('-angmx', ANGMAX, 0., 0.)
         call argr4 ('-dexp',  DIVEXP, 1., 1.)
         call argi4 ('-ntrc',  NTRCST, 0 , 0 )
         call argi4 ('-dimin', MINDI , 1 , 1 )
         call argi4 ('-dimax', MAXDI , 0 , 0 )
         call argi4 ('-limin', MINLI , 1 , 1 )
         call argi4 ('-limax', MAXLI , 0 , 0 )
         call argi4 ('-iorec', IOREC , 0 , 0 )
         call argi4 ('-w'    , iwind , 0 , 0 )
         call argr4 ('-s'    , agcs  ,15. ,15. )

         agc = .false.
         if (iwind .ne. 0) agc = .true.

         alias  = (argis('-AS') .gt. 0)
         if (alias) then
            aliasflag = 1
         else
            aliasflag = 0
         endif

         sprd   = (argis('-GS') .gt. 0)
         if (sprd) then
            sprdflag = 0
         else
            sprdflag = 1
         endif

         csamp    = (argis('-CSA') .gt. 0)
         coamp    = (argis('-COA') .gt. 0)
         bkamp    = (argis('-BKA') .gt. 0)
         ampflag = 0
         if (csamp) ampflag = 0
         if (coamp) ampflag = 1
         if (bkamp) ampflag = 2

         shot   = (argis('-shot') .gt. 0)
         norm   = (argis('-norm') .gt. 0)
         verbos = (argis('-V') .gt. 0)

         if (.not. norm .AND. (tap1(1:1) .ne. ' ') ) then
            write(LERR,*)' '
            write(LERR,*)'WARNING:'
            write(LERR,*)'An output file name for normalization'
            write(LERR,*)'was given but -norm was not flagged'
            write(LERR,*)'on the command line.'
            write(LERR,*)' '
         elseif (norm .AND. (tap1(1:1) .eq. ' ') ) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR:'
            write(LERR,*)'Normalization was flagged but no file'
            write(LERR,*)'name was given using -T[]'
            write(LERR,*)'on the command line.'
            write(LERR,*)' '
            stop
         endif

C *** FILL IN THE DEFAULTS                                              00002460


         IF (NTRCST .NE. 0 ) NTRCS  = NTRCST
         IF (IOREC  .EQ. 0 ) IOREC  = 1

c        READ (CARD, 160) IX3, IY3, IX4, IY4, DYT, DXT                  00002680

         call argi4 ('-x1', ix1, 0 , 0 )
         call argi4 ('-y1', iy1, 0 , 0 )
 
         call argi4 ('-x2', ix2, 0 , 0 )
         call argi4 ('-y2', iy2, 0 , 0 )
 
         call argi4 ('-x3', ix3, 0 , 0 )
         call argi4 ('-y3', iy3, 0 , 0 )
 
         call argi4 ('-x4', ix4, 0 , 0 )
         call argi4 ('-y4', iy4, 0 , 0 )

         call argr4 ('-cldm', dxt, 0., 0.)
         call argr4 ('-ildm', dyt, 0., 0.)

         if (dxt .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmostk3d:'
            write(LERR,*)'Must enter x-line cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmostk3d:'
            write(LER ,*)'Must enter x-line cell dimension -cldm[]'
            stop
         endif

         if (dyt .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmostk3d:'
            write(LERR,*)'Must enter inline cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmostk3d:'
            write(LER ,*)'Must enter inline cell dimension -ildm[]'
            stop
         endif

         if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1   .AND.
     2       ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3   then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in dmostk3d:'
            write(LERR,*)'Must enter 4 corners of survey using -x1[]'
            write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in dmostk3d:'
            write(LER ,*)'Must enter 4 corners of survey using -x1[]'
            write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            stop
         endif
     
C *** COMPUTE NUMBER OF INPUT TRACES                                    00002700

         IF (DYT .NE. 0.) DY = DYT
         IF (DXT .NE. 0.) DX = DXT
         TRCSPC = MIN (DY, DX)

         if (DSTMAX .ne. 0.0 .AND. DSTMIN .ne. 0.0 .AND.
     1       DSTDEL .ne. 0.0) then
             NFOLD  = (DSTMAX - DSTMIN) / DSTDEL + 1
             TRCSPC = DSTDEL
         endif

         if (DSTMAX .eq. 0.0) DSTMAX =  999999.
         if (DSTMIN .eq. 0.0) DSTMIN = -999999.

         if (.not. tape .AND. .not. nmoap) then
            call RCTDFN (ICRD, IPRT, NSAMP,NSI,TC,VC,npairs,ltdri,
     1                   CARD,ICDRDR,IERROR,IEOF)
         endif

 2000 CONTINUE

C *** WRITE PARAMETERS TO USER REPORT                                   00003220

      if (.not. tape .AND. .not. nmoap) then
         write(IPRT,*)' '
         do  i = 1, npairs
             write(IPRT,*)'Time(ms)= ',tc(i),'  Velocity= ',vc(i)
         enddo
         write(IPRT,*)' '
      endif

      IF (mute) THEN

         open (unit=lumute, file = mtap, status = 'old', iostat = ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'Could not open cdpvel3d mute card file ',
     1                    mtap
            write(LERR,*)'Check existence'
            stop
         endif

         nm = 0
         do while (1.eq.1)
            read(lumute,'(a80)',end=999,err=998) card
            nm = nm + 1
            call fsscnf (card,'%f %f %d',TM(nm),XM(nm),idum)
            if (TM(nm) .lt. 0.) go to 999
         enddo
         go to 999

998      continue
            write(LERR,*)'Fatal error in cdpstk3d:'
            write(LERR,*)'Error reading X-T mute file'
            stop

999      continue
         nm = nm - 1
         if (nm .lt. 2) then
            write(LERR,*)'Fatal error in cdpstk3d:'
            write(LERR,*)'Mute file contains < 2 entries. Must have'
            write(LERR,*)'at least 2'
            stop
         endif

         call sortr (xm, key, nm)
         do  i = 1, nm
             tmp (i) = tm ( key(i) )
         enddo
         do  i = 1, nm
             tm (i) = tmp (i)
         enddo
         write(LERR,*)' '
         write(LERR,*)'Mute Function'
         write(LERR,*)'Distance    Time'
         do  i = 1, nm
            write(LERR,777) XM(i),Tm(i)
         enddo
         write(LERR,*)' '
777      format (2f10.0)
            
      ENDIF

      WRITE (IPRT, 180) DSTMIN, DSTMAX, DSTDEL, ANGMAX, ANGMIN,
     &                  MINLI, MAXLI, MINDI, MAXDI, DIVEXP
  180 FORMAT (//, 30X, 'COMMAND LINE PARAMETERS:'                 ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',F15.5  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',F15.5  ,
     &        //, 23X, '  DELTA DISTANCE... . . . . . . .',F15.5  ,
     &        //, 23X, '  MAXIMUM THETA . . . . . . . . .',F15.5  ,
     &        //, 23X, '  MINIMUM THETA . . . . . . . . .',F15.5  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  NORMALIZATION EXPONENT. . . . .',F15.5  )
      WRITE (IPRT, 190) IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4,
     &                  IOREC, DY, DX
  190 FORMAT ( /, 23X, '  CORNER 1 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 1 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 2 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 3 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 X. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  CORNER 4 Y. . . . . . . . . . .',1X,I9  ,
     &        //, 23X, '  STARTING OUTPUT RECORD NUMBER .',1X,I9  ,
     &        //, 23X, '  CROSSLINE CELL DIMENSION. . . .',F15.5  ,
     &        //, 23X, '  INLINE CELL DIMENSION . . . . .',F15.5,//)

      RETURN
      END
