C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine nmo( X, v, PT, offset, NS, sr, Y, R)
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM HYPERBOLIC MOVEOUT CORRECTION.              *
*      INPUTS ARE:                                                     *
*           X = DATA TO BE CORRECTED                                   *
*           V = SQURARED VELOCITY ARRAY                                *
*          PT = ARRAY TO TP's                                          *
*      OFFSET = OFFSET FOR X                                           *
*          NS = NUMBER SAMPLES PER TRACE                               *
*          sr = SAMPLE INTERVAL IN sec                                  *
*           Y = CORRECTED DATA                                         *
*          V0 = VELOCITY OF RECORDING MEDIUM FORM IMAGE POINT COMPS    *
*                                                                      *
************************************************************************
#include <f77/lhdrsz.h>

      DIMENSION X(*),PT(*),Y(*),v(*)
      real      work(SZLNHD)
      logical   R

      call vclr (work, 1, SZLNHD)
      call vmov(x, 1, work(2), 1, ns)

      work(ns+2) = 0
      dist = offset * offset
      call vclr(work(ns+2), 1, 2)

      IF (.not.R) THEN

       do i=1,ns

        t0   = (i-1) * sr
        v2   = v(i) * v(i)
        shft = sqrt(t0*t0 + dist/v2) - t0
        shft = shft / sr

        if (shft .le. ns-2) then

           if (shft .gt. 0) then
              tj = i + shft
              it = int (tj)
              if (it .eq. 0) it = 1
               f = tj - aint (tj)
               fs = f * f
               c1 = fs - f
               c2 = 2.0 - 2.0 * fs
               c3 = fs + f
               y(i) =0.5       * (
     :              work(it)   * c1 +
     :              work(it+1) * c2 +
     :              work(it+2) * c3
     :                            )
             else
               y(i) = work(i)
             endif

        else
             y(i) = 0
        endif

       end do

      else

       call vclr(y, 1, ns)
       do i = 2, ns
        t0 = (i-1) * sr
        v2   = v(i) * v(i)
        shft = sqrt(t0*t0 + dist/v2) - t0
        shft = shft/sr
        tj   = i + shft
        it   = int (tj)
        if (it .ge. 0) then
         if( it .eq. 0) it = 1
         f = tj - aint (tj)
         fs = f * f
         c1 = fs - f
         c2 = 2.0 - 2.0 * fs
         c3 = fs + f
         y(it) = 0.5      *   (
     :          work(i-1) * c3 +
     :          work(i)   * c2 +
     :          work(i+1) * c1
     :                         )
        endif
       end do

      endif

      RETURN
      END
