c -----------------  corners  -----------------------
c
c     copyright 2002, Amoco Production Company 
c              All rights reserved
c        an affiliate of BP America Inc.
c
c -----------------  ------------ -----------------------

c     Program Changes:

c      - original written: June 7, 1996
c      - author:  Paul R. Gutowski

c   Feb 12, 2003: Fixed bug where 1/2 bin fringe was misapplied
c                 when orientation of grid did not fit the assumptions
c                 of the initial logic.  Postive angles would work 
c                 just fine but negative angles would result in 
c                 the SW and NE corners being miscalculated in X.
c                 The current logic seems to work independant of
c                 grid orientation.
c
c                 also installed implicit none and declared all 
c                 missing variables explicitly
c   Garossino

c     Program Description:

c      - simple grid determination routine to test for squareness 
c        of project grid and offer an easy way to go between USP
c        corner of cornermost bin grid definition and Seisworks
c        center of cornermost bin coordinates.

      implicit none

c get machine dependent parameters 

#include     <f77/iounit.h>

      integer   limin, limax, dimin, dimax
      integer   ix1, ix2, ix3, ix4, iy1, iy2, iy3, iy4
      integer   ixc (4), iyc (4)
      integer   ixo (4), iyo (4)
      integer   mask (4)
      integer   NWx, NEx, SEx, SWx
      integer   NWx_fringe, NEx_fringe, SEx_fringe, SWx_fringe
      integer   NWy, NEy, SEy, SWy
      integer   NWy_fringe, NEy_fringe, SEy_fringe, SWy_fringe
      integer   argis, nx, ny, iwrn, i
      integer   icdpx1, icdpy1, icdpx2, icdpy2, icdpx3, icdpy3
      integer   icdpx4, icdpy4
      integer   minx, miny, maxx, maxy

      real      dx, dy, rad2deg, pi2, dely, delx
      real      dx2, dy2, dr, theta, phi, thetad, phid
      real      dxcos, dxsin, dycos, dysin
      real      cdpx, cdpy

      REAL*8    XX, XY, YX, YY, XXT, XYT, YXT, YYT
      REAL*8    DE, DF, E, F, XYYXXY

      logical   para, NSEW

      data      mask/4*0/
      data      NSEW/.false./


c initialize variables

      rad2deg = 180. / 3.14159265
      pi2     = 3.14159265 / 2.

c get command line help if requested
      
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif
 
c parse command line

      call cmdln ( ix1, iy1, ix2, iy2, ix3, iy3, ix4, iy4, dx, dy, 
     :     dimin, dimax, limin, limax, para )

      ixc (1) = ix1
      ixc (2) = ix2
      ixc (3) = ix3
      ixc (4) = ix4
      ixo (1) = ix1
      ixo (2) = ix2
      ixo (3) = ix3
      ixo (4) = ix4
      iyc (1) = iy1
      iyc (2) = iy2
      iyc (3) = iy3
      iyc (4) = iy4
      iyo (1) = iy1
      iyo (2) = iy2
      iyo (3) = iy3
      iyo (4) = iy4

c test for parallelogram

      CALL XFMI ( IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1     IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT, para )
 
      if (para) then
         write(ler,*)' '
         write(ler,*)' '
         write(ler,*)'corners: Normal Completion '
         stop
      endif

      DE = DBLE(FLOAT(IX1)) * XXT + DBLE(FLOAT(IY1)) * XYT
      DF = DBLE(FLOAT(IX1)) * YXT + DBLE(FLOAT(IY1)) * YYT
      XYYXXY =  XYT * YXT - XXT * YYT
      if (XYYXXY .eq. 0.) then
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR in corners:'
         write(LER ,*)'Attempt to use survey coords to fill in bin'
         write(LER ,*)'centers failed due to coord transform'
         write(LER ,*)'singularity (bad coord choice most likely)'
         stop 666
      endif

      dely = float ( iy2 - iy1 )
      delx = float ( ix2 - ix1 )
      
      dx2 = .5 * dx
      dy2 = .5 * dy
      dr  = amin1 (dx2, dy2)

      if (abs(delx) .lt. dr) delx = 0.
      if (abs(dely) .lt. dr) dely = 0.
      if (delx .eq. 0.0 .OR. dely .eq. 0.0) NSEW = .true.

      theta = atan2 ( dely, delx)
      phi   = pi2 - atan  ( abs(dely / delx) )
      dxcos = dx2 * cos (phi)
      dxsin = dx2 * sin (phi)
      dycos = dy2 * cos (phi)
      dysin = dy2 * sin (phi)

      thetad = rad2deg * theta
      phid   = rad2deg * phi
      
      if (limax .eq. 0) limax = NX
      if (dimax .eq. 0) dimax = NY

      write(LER ,*)' '
      write(LER ,*)'Input box:'
      write(LER ,*) ' X1, Y1 =  ',ix1,'  ',iy1
      write(LER ,*) ' X2, Y2 =  ',ix2,'  ',iy2
      write(LER ,*) ' X3, Y3 =  ',ix3,'  ',iy3
      write(LER ,*) ' X4, Y4 =  ',ix4,'  ',iy4
      write(LER ,*) ' inline (side 1-2) dimension =  ',dy
      write(LER ,*) ' xline (side 2-3) dimension  =  ',dx
      write(LER ,*) ' number cells along 1-2      =  ',ny
      write(LER ,*) ' number cells along 2-3      =  ',nx
      write(LER ,*)' '
      write(LER ,*) ' minimum LI = ',limin
      write(LER ,*) ' minimum DI = ',dimin
      write(LER ,*) ' maximum LI = ',limax
      write(LER ,*) ' maximum DI = ',dimax
      write(LER ,*)' '
      write(LER ,*) ' angle of 1-2 direction to E-W axis = ',thetad
      write(LER ,*) ' angle of 1-2 direction to N-S axis = ',phid
      write(LER ,*) ' delta Y length caused by adding half bin to'
      write(LER ,*) ' to 1-2 direction = ',dycos,dysin
      write(LER ,*) ' delta X length caused by adding half bin to'
      write(LER ,*) ' to 1-4 direction = ',dxcos,dxsin
      write(LER ,*)' '
      
      
      E = (DBLE(FLOAT(limin)) - 0.5) * DX + DE
      F = (DBLE(FLOAT(dimin)) - 0.5) * DY + DF
      CDPX  = (F * XYT - E * YYT) / XYYXXY
      if (YYT .ne. 0.) then
         CDPY  = (F - CDPX * YXT) / YYT
      elseif (XYT .ne. 0.) then
         CDPY  = (E - CDPX * XXT) / XYT
      endif
      ICDPX1 = CDPX
      ICDPY1 = CDPY
      
      E = (DBLE(FLOAT(limin)) - 0.5) * DX + DE
      F = (DBLE(FLOAT(dimax)) - 0.5) * DY + DF
      CDPX  = (F * XYT - E * YYT) / XYYXXY
      if (YYT .ne. 0.) then
         CDPY  = (F - CDPX * YXT) / YYT
      elseif (XYT .ne. 0.) then
         CDPY  = (E - CDPX * XXT) / XYT
      endif
      ICDPX2 = CDPX
      ICDPY2 = CDPY
      
      E = (DBLE(FLOAT(limax)) - 0.5) * DX + DE
      F = (DBLE(FLOAT(dimax)) - 0.5) * DY + DF
      CDPX  = (F * XYT - E * YYT) / XYYXXY
      if (YYT .ne. 0.) then
         CDPY  = (F - CDPX * YXT) / YYT
      elseif (XYT .ne. 0.) then
         CDPY  = (E - CDPX * XXT) / XYT
      endif
      ICDPX3 = CDPX
      ICDPY3 = CDPY
      
      E = (DBLE(FLOAT(limax)) - 0.5) * DX + DE
      F = (DBLE(FLOAT(dimin)) - 0.5) * DY + DF
      CDPX  = (F * XYT - E * YYT) / XYYXXY
      if (YYT .ne. 0.) then
         CDPY  = (F - CDPX * YXT) / YYT
      elseif (XYT .ne. 0.) then
         CDPY  = (E - CDPX * XXT) / XYT
      endif
      ICDPX4 = CDPX
      ICDPY4 = CDPY

      minx = min0 (ix1, ix2, ix3, ix4)
      miny = min0 (iy1, iy2, iy3, iy4)
      maxx = max0 (ix1, ix2, ix3, ix4)
      maxy = max0 (iy1, iy2, iy3, iy4)

      IF ( NSEW ) THEN

c grid is orthogonal to x,y axis, angle at corners is 90 degrees

         NWx = minx
         NWy = maxy
         NEx = maxx
         NEy = maxy
         SEx = maxx
         SEy = miny
         SWx = minx
         SWy = miny

      ELSE

         if ( phid .lt. 45.0 ) then
   
c assign NW, NE, SW, SE corners when phid is less than 45

            do  i = 1, 4
               if (minx .eq. ixc(i) .AND. mask(i) .eq. 0) then
                  NWx = ixc(i)
                  NWy = iyc(i)
                  mask (i) = 1
                  go to 1
               endif
            enddo
 1          continue
            
            do  i = 1, 4
               if (maxy .eq. iyc(i) .AND. mask(i) .eq. 0) then
                  NEx = ixc(i)
                  NEy = iyc(i)
                  mask (i) = 1
                  go to 2
               endif
            enddo
 2          continue
            
            do  i = 1, 4
               if (maxx .eq. ixc(i) .AND. mask(i) .eq. 0) then
                  SEx = ixc(i)
                  SEy = iyc(i)
                  mask (i) = 1
                  go to 3
               endif
            enddo
 3          continue
            
            do  i = 1, 4
               if (miny .eq. iyc(i) .AND. mask(i) .eq. 0) then
                  SWx = ixc(i)
                  SWy = iyc(i)
                  mask (i) = 1
                  go to 4
               endif
            enddo
 4          continue

         elseif ( phid .gt. 45 ) then

c assign NW, NE, SW, SE corners when phid is greater than 45

            do  i = 1, 4
               if (maxy .eq. iyc(i) .AND. mask(i) .eq. 0) then
                  NWx = ixc(i)
                  NWy = iyc(i)
                  mask (i) = 1
                  go to 5
               endif
            enddo
 5          continue
            
            do  i = 1, 4
               if (maxx .eq. ixc(i) .AND. mask(i) .eq. 0) then
                  NEx = ixc(i)
                  NEy = iyc(i)
                  mask (i) = 1
                  go to 6
               endif
            enddo
 6          continue
            
            do  i = 1, 4
               if (miny .eq. iyc(i) .AND. mask(i) .eq. 0) then
                  SEx = ixc(i)
                  SEy = iyc(i)
                  mask (i) = 1
                  go to 7
               endif
            enddo
 7          continue
            
            do  i = 1, 4
               if (minx .eq. ixc(i) .AND. mask(i) .eq. 0) then
                  SWx = ixc(i)
                  SWy = iyc(i)
                  mask (i) = 1
                  go to 8
               endif
            enddo
 8          continue

         else

c if phid is 45 then NSEW should be .true. and we should never get here

            write(LER,*)' corners: something fishy 1'
         endif

      ENDIF

c determine if angle is positive [NWx - SWx > 0.0] 
c or negative [NWx - SWx < 0]
c as addition and subtraction of sin and cos projections 
c at each corner is a function of this angle.

      IF ( ( NWx - SWx ) .gt. 0.0 ) THEN

c positive angle

         do  i = 1, 4

            if (NWx .eq. ixc(i) .AND. NWy .eq. iyc(i)) then

c at the NW corner

               NWx_fringe = NWx - dxcos + dysin
               NWy_fringe = NWy + dxsin + dycos
               ixo (i) = NWx_fringe
               iyo (i) = NWy_fringe

            elseif (NEx .eq. ixc(i) .AND. NEy .eq. iyc(i)) then

c at the NE corner

               NEx_fringe = NEx + dxcos + dysin
               NEy_fringe = NEy - dxsin + dycos
               ixo (i) = NEx_fringe
               iyo (i) = NEy_fringe

            elseif (SEx .eq. ixc(i) .AND. SEy .eq. iyc(i)) then

c at the SE corner

               SEx_fringe = SEx + dxcos - dysin
               SEy_fringe = SEy - dxsin - dycos
               ixo (i) = SEx_fringe
               iyo (i) = SEy_fringe

            elseif (SWx .eq. ixc(i) .AND. SWy .eq. iyc(i)) then

c at the SW corner

               SWx_fringe = SWx - dxcos - dysin
               SWy_fringe = SWy + dxsin - dycos
               ixo (i) = SWx_fringe
               iyo (i) = SWy_fringe
               
            endif

         enddo

      ELSEIF (( NWx - SWx ) .lt. 0.0 ) THEN

c negative angle

         do  i = 1, 4

            if (NWx .eq. ixc(i) .AND. NWy .eq. iyc(i)) then

c at the NW corner

               NWx_fringe = NWx - dxcos - dysin
               NWy_fringe = NWy - dxsin + dycos
               ixo (i) = NWx_fringe
               iyo (i) = NWy_fringe

            elseif (NEx .eq. ixc(i) .AND. NEy .eq. iyc(i)) then

c at the NE corner

               NEx_fringe = NEx + dxcos - dysin
               NEy_fringe = NEy + dxsin + dycos
               ixo (i) = NEx_fringe
               iyo (i) = NEy_fringe

            elseif (SEx .eq. ixc(i) .AND. SEy .eq. iyc(i)) then

c at the SE corner

               SEx_fringe = SEx + dxcos + dysin
               SEy_fringe = SEy + dxsin - dycos
               ixo (i) = SEx_fringe
               iyo (i) = SEy_fringe

            elseif (SWx .eq. ixc(i) .AND. SWy .eq. iyc(i)) then

c at the SW corner

               SWx_fringe = SWx - dxcos + dysin
               SWy_fringe = SWy - dxsin - dycos
               ixo (i) = SWx_fringe
               iyo (i) = SWy_fringe
      
            endif
         enddo
      
      ELSE

c NSEW must be true

         if ( .not. NSEW ) then

            write(LER,*)'corners: something fishy 2'
            stop

         else

            do i = 1,4
c do NSEW corner move

               if (NWx .eq. ixc(i) .AND. NWy .eq. iyc(i)) then

c at the NW corner

                  NWx_fringe = NWx - dx2
                  NWy_fringe = NWy + dy2
                  ixo (i) = NWx_fringe
                  iyo (i) = NWy_fringe

               elseif (NEx .eq. ixc(i) .AND. NEy .eq. iyc(i)) then

c at the NE corner
               
                  NEx_fringe = NEx + dx2
                  NEy_fringe = NEy + dy2
                  ixo (i) = NEx_fringe
                  iyo (i) = NEy_fringe

               elseif (SEx .eq. ixc(i) .AND. SEy .eq. iyc(i)) then

c at the SE corner

                  SEx_fringe = SEx + dx2
                  SEy_fringe = SEy - dy2
                  ixo (i) = SEx_fringe
                  iyo (i) = SEy_fringe
               

               elseif (SWx .eq. ixc(i) .AND. SWy .eq. iyc(i)) then

c at the SW corner

                  SWx_fringe = SWx - dx2
                  SWy_fringe = SWy - dy2
                  ixo (i) = SWx_fringe
                  iyo (i) = SWy_fringe
               endif

            enddo
            
         endif

      ENDIF
      
      write(LER,*)' '
      write(LER,*)'CORNER BIN CENTER XYs contained with input box:'
      write(LER,*)' '
      write(LER,*)' Corner 1 [limin:dimin] - X ',ICDPX1,'  Y ',ICDPY1
      write(LER,*)' Corner 2 [limin:dimax] - X ',ICDPX2,'  Y ',ICDPY2
      write(LER,*)' Corner 3 [limax:dimax] - X ',ICDPX3,'  Y ',ICDPY3
      write(LER,*)' Corner 4 [limax:dimin] - X ',ICDPX4,'  Y ',ICDPY4
      write(LER,*)' '

      write(LER,*)' '
      write(LER,*)'CORNER XYs for 1/2-bin fringe around input box:'
      write(LER,*)' '
      write(LER,*)' Corner 1 [+fringe]     - X ',ixo(1),'  Y ',iyo(1)
      write(LER,*)' Corner 2 [+fringe]     - X ',ixo(2),'  Y ',iyo(2)
      write(LER,*)' Corner 3 [+fringe]     - X ',ixo(3),'  Y ',iyo(3)
      write(LER,*)' Corner 4 [+fringe]     - X ',ixo(4),'  Y ',iyo(4)
      write(LER,*)' '

      write(ler,*)' '
      write(ler,*)' '
      write(ler,*)'corners: Normal Completion '
      
      stop
      end
