C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  computes the time varying autocorrelation from the input
c  data - x and stores the result in output vector x

      subroutine prdapt (nsamps, x, pred, lopp, peo, prew,
     1                   lslide, nwin, ovlp, lacorr,
     1                   acorr, work)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real    x (*), work (*)
      real    acorr (*), peo (*)
      real    hold1 (SZLNHD), sumb (SZLNHD), right (SZLNHD)
      real    acorrn (SZLNHD), decop (SZLNHD)
      integer lslide, nwin, ovlp, lacorr, nsamps, ilast, ifirst
      integer jmove, nmove, lwind
      integer pred, lopp, ioff

      call vclr (hold1, 1, SZLNHD)
      call vclr (sumb , 1, SZLNHD)

      LF   = pred + lopp
      ioff = pred
      imid1 = 0
      DO  KK = 1, nwin
 
         if (kk .eq. 1) then
             nmove  = lslide + ovlp
             ilast  = lslide + ovlp
             ifirst = 1
             if (lslide .eq. nsamps) nmove = nsamps
             jmove = nmove
         else
             nmove  = lslide + ovlp
             jmove  = nmove
             ifirst = ifirst + ovlp
             imid1  = ifirst
             ilast  = ifirst + nmove - 1
             if (ilast .gt. nsamps) then
                 jmove = nsamps - ifirst + 1
             endif
         endif
         do   mm = 1, nmove
              work(mm) = 0.
         end do
         call vmov (x(ifirst), 1, work, 1, jmove)
         lwind = nmove
         xavg  = 0.
         xknt  = 0.
         jj = 1
         do   i = 1, lwind
              if (work(jj) .ne. 0.0) then
                  xavg = xavg + work(jj)
                  xknt = xknt + 1.
              endif
              jj = jj + 1
         end do
         if (xknt .ne. 0.0) then
               xavg = xavg/xknt
         else
               xavg = 0.
         end if
         do i=1,lwind
              work (i) = work(i) - xavg
         end do

         ip = (KK-1) * lacorr
         do  i = 1, LF
             acorrn (i) = acorr (i+ip)
         enddo

         acorrn (1) =  (1.0 + prew) * acorrn (1)

         if (ioff .le. 1) then

            call vmov (acorrn(2), 1, right, 1, lopp)
         else
            call vmov (acorrn(ioff+1), 1, right, 1, lopp)
         endif

         if (acorrn(1) .gt. 0.0) then
             call wiener (lopp, acorrn, right, decop, peo, 1, ierr)
         else
             ierr = 1
         endif
         if (ierr .ne. 0) then
            call vclr (decop, 1, lopp)
            call vclr (peo  , 1, lopp)
            peo (1) = 1.0
         endif

C +----------------------------------------------------+
C | CREATE PROPER peo FOR GIVEN PREDICTION DISTANCE    |
C +----------------------------------------------------+
         lconv = lopp + ioff

         if (ioff .gt. 1) then

            do  i = lopp, 1, -1
                peo (i+ioff) = -decop (i)
            end do
            do  i = 1, ioff
                peo (i) = 0.0
            enddo
            peo (1) = 1.

         endif



C +----------------------------------------------------+
C | CONVOLVE THE FILTER WITH DATA                      |
C +----------------------------------------------------+

c     write(7,*)'kk= ',kk
c     write(7,*)(peo(ii),ii=1,lf)

      call fold (LF, peo, lwind, work, nfld, hold1)

      if (kk .eq. 1) then

         do  i = 1, lwind
             sumb (i) = hold1 (i)
         end do

      else

        jj = imid1 - 1
        xj = ovlp

        do  i = 1, ovlp
           jj = jj + 1
           x1 = (i-1) / xj
           x2 = 1.0 - x1
           sumb (jj) = sumb (jj) * x2 + hold1(i) * x1
        end do

        do  i = ovlp+1, jmove
           jj = jj + 1
           sumb (jj) = hold1 (i)
        end do

      endif



      ENDDO

      do  i = 1, nsamps
          x (i) = sumb (i)
      enddo

      return
      END
