C***********************************************************************00000010
C                                                                       00000020
C     PROGRAM NAME: DM3D  (DIP MOVEOUT FOR 3D DATA)                     00000030
C                                                                       00000040
C     LANGUAGE: FORTRAN                                                 00000050
C                                                                       00000060
C     AUTHOR: G.MURPHY                                                  00000070
C                                                                       00000080
C     DATE WRITTEN: 07/01/88                                            00000090
C                                                                       00000100
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00000120
C                                                                       00000140
C     ABSTRACT: OUTPUT CDP GATHERS WITH PSUEDO TRACE SPACING.           00000150
C                                                                       00000160
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00000170
C                                                                       00000180
C***********************************************************************00000190
C                                                                       00000200
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      REAL          TC (63), VC (63)
      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      CHARACTER*66  CTITLE
      real          spread (SZLNHD), amn (SZLNHD), amx (SZLNHD)
      character     ntap * 256, otap(100) * 256, name*10
      character     vtap * 256, tap1 * 256, ttap * 256, atap * 256
      integer       argis, aliasflag, ampflag, sprdflag
      integer       NCA (70), JRA (70), luout (100)
      logical       verbos, norm, shot, tape, intrp, restart, query
      logical       halt
      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
      DATA CTITLE/'                      DIP MOVEOUT FOR 3-D DATA       
     &             '/                                                   
      DATA ICRDa  /47/
      DATA IBYTES /32256/
      DATA name /'DMOANGST3D'/

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help ()
          stop
      endif

      IPRT = LERR

#include <f77/open.h>
 
      call argstr( '-N', ntap, ' ', ' ' )

      nu = 0
      do  i = 1, 100
          nu = nu + 1
          call argstr( '-O', otap(i), ' ', ' ' )
          if (otap(i) .eq. ' ') go to 1
      enddo
1     continue
      nu = nu -1
      if (nu .eq. 0) then
         write(IPRT,*)'Fatal Error in dmoangst3d:'
         write(IPRT,*)'Must have at least 1 output file name'
         write(IPRT,*)'using -O[]'
         stop
      endif

      call argstr( '-v', vtap, ' ', ' ' )
      call argstr( '-a', ttap, ' ', ' ' )
      call argi4 ( '-dinc', inca, 10 , 10  )
      call argstr( '-A', atap, ' ', ' ' )
      call argstr( '-T', tap1, ' ', ' ' )

      restart = (argis('-R') .gt. 0)

      call getln(ITAPIN, ntap,'r', 0)

      if (.not. restart) then
         call getln(luang, ttap, 'w+', -1)
         call getln(lunrm, tap1, 'w+', -1)
      else
         call getln(luang, ttap, 'r+', -1)
         call getln(lunrm, tap1, 'r+', -1)
         call rwd (luang)
         call rwd (lunrm)
      endif

      if (.not. restart) then
         do  i = 1, nu
             call getln(luout(i), otap(i),'w+', -1)
         enddo
      else
         do  i = 1, nu
             call getln(luout(i), otap(i),'r+', -1)
             call rwd  (luout(i))
         enddo
      endif

      do  i = 1, nu
      if (luout(i) .lt. 1) then
          write(IPRT,*)' '
          write(IPRT,*)'Fatal error in dmoangst3d:'
          write(IPRT,*)'Cannot pipe out - use named disk file(s) -O[]'
          stop
      endif
      enddo

      if (atap(1:1) .eq. ' ') then
         write(IPRT,*)' '
         write(IPRT,*)'Fatal Error in dmoangst3d:'
         write(IPRT,*)'Must supply angle cards using -A[]'
         stop
      endif
 
      if (ttap(1:1) .eq. ' ') then
         write(IPRT,*)' '
         write(IPRT,*)'Fatal Error in dmoangst3d:'
         write(IPRT,*)'Must supply angle-time data set using -t[]'
         stop
      endif


      call getln (luvel, vtap, 'r', -1)
      if (luvel .lt. 1) then
         write(IPRT,*)' '
         write(IPRT,*)'Fatal error in dmoangst3d:'
         write(IPRT,*)'Cannot pipe into velocity tape input. Must'
         write(IPRT,*)'use named disk file using -v[]'
         stop
      endif
      call sislgbuf (luvel, 'off')
      tape = .true.
 
      open (unit=ICRDa, file = atap, status='old', iostat=ierr)
      if (ierr .ne. 0) then
         write(IPRT,*)'Fatal error in dmoangst3d:'
         write(LERR,*)'Could not open dmoangst3d angle card file ',atap
         write(LERR,*)'Check existence'
         stop
      endif



C *** INITIALIZE PROGRAM

      CALL DMLINE (CTITLE, IPRT,   ITAPIN, NFOLD,
     &             NREC,   ICC,    IOLEN,  IBYTES, NTRCS,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             RECLEN, NSAMPS, dt, si, nsmpv, siv, tape,
     &             nrecv, intrp, luvel, restart)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** READ 1DM3D CARD AND ONE TDFN FUNCTION

      CALL DMCARD (IPRT,   ICRDa,   NTRCS, NFOLD, reverse,
     &             NREC,   ICC,    IOREC, DSTMIN, DSTMAX,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             ANGMAX, TC,     VC,    NPAIRS, ANGMIN,
     &             RECLEN, IX1, IY1, IX2, IY2, IX3, spread,
     &             IY3, IX4, IY4,  NTPL,  NLI, NDI, ngrp,
     &             DIVEXP, TRCSPC, verbos, norm, shot, mode,
     &             aliasflag, ampflag, sprdflag, tape,
     &             amn, amx, nang, nca, jra, iem, otap,
     &             nu, nsamps, si, iord, saf, halt)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** PROCESS THE INPUT DATA SET.

      CALL DMTAPE (IPRT,   ITAPIN, luout,  IBYTES, luvel, nu,
     &             IREC,   NREC,   IOREC,  ICC,    IOLEN,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, TC, VC, nsmpv,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, siv,
     &             NSAMPS, IFMT,   SI,     RECLEN, IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, norm, shot, tape,
     &             aliasflag, ampflag, sprdflag, tap1, dt,
     &             nrecv, intrp, restart, divexp, amn, amx,
     &             nang, inca, luang, spread, ngrp, mode, iem,
     &             ttap, reverse, iord, lunrm, saf, halt)

C *** FINISHED -- CLOSE I/O DEVICES

 9999 CONTINUE

      CALL LBCLOS (ITAPIN)
      do  iu = 1, nu
          CALL LBCLOS (luout(iu))
      enddo

      CALL CCEXIT (ICC)

      END
