C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine center_xy ( IX, IY, IX1, IY1, dx, dy, name,
     1                       XX, XY, YX, YY, XY1, YX1,
     2                       XX1, YY1, LER, LERR, IXC, IYC,
     3                       first)

      REAL*8    XX    , XY    , YX    , YY
      REAL*8    XX1, XY1, YX1, YY1, E, F, DE, DF, XYYXXY
      REAL      dx, dy
      INTEGER   LER, LERR, IXC, IYC
      character name*(*)
      logical   first
      SAVE

      if (.not. first) then

         DE = DBLE(FLOAT(IX1)) * XX1 + DBLE(FLOAT(IY1)) * XY1
         DF = DBLE(FLOAT(IX1)) * YX1 + DBLE(FLOAT(IY1)) * YY1
         XYYXXY =  XY1 * YX1 - XX1 * YY1
 
      endif

      E = ( dble(float(IX)) - 0.5) * dx + DE
      F = ( dble(float(IY)) - 0.5) * dy + DF

      if (XYYXXY .eq. 0.0) then

         write(LERR,*)' '
         write(LERR,*)'WARNING in ',name(1:lenth(name)),':'
         write(LERR,*)'Unable to compute bin center coords for'
         write(LERR,*)'IX= ',ix,' IY= ',iy
         write(LERR,*)' '
         write(LER ,*)'ERROR in ',name(1:lenth(name)),':'
         write(LER ,*)'Unable to compute bin center coords for'
         write(LER ,*)'IX= ',ix,' IY= ',iy
         IXC = 0
         IYC = 0
         return
      else

         IXC = (F * XY1 - E * YY1) / XYYXXY

      endif

      if (XY1 .ne. 0.0) then

          IYC = (E - dble(float(IXC)) * XX1) / XY1
      elseif (YY1 .ne. 0.0) then

          IYC = (F - dble(float(IXC)) * YX1) / YY1
      else

          IYC = 0
      endif

      first = .true.

      return
      end
