      SUBROUTINE DMTAPE (IPRT,   ITAPIN, luout , IBYTES, luvel,
     &             IREC,   NREC,   IOREC,  ICC,    IOLEN,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, TC, VC, nsmpv,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, siv,
     &             NSAMPS, IFMT,   SI,     RECLEN, IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, norm, shot, tape,
     &             aliasflag, ampflag, sprdflag, tap1, dt,
     &             nrecv, intrp, restart, divexp, IDSK1)
C***********************************************************************00003620
C                                                                       00003630
C     PROGRAM NAME: DMTAPE (READ TAPE, DUMP AND WRITE MODIFIED OUTPUT)  00003640
C                                                                       00003650
C     LANGUAGE: FORTRAN                                                 00003660
C                                                                       00003670
C     AUTHOR: G.MURPHY                                                  00003680
C                                                                       00003690
C     DATE WRITTEN: 06/14/88                                            00003700
C                                                                       00003710
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00003730
C                                                                       00003750
C     ABSTRACT: READS INPUT DATASET DUMPS AND WRITES MODIFIED DATASET   00003760
C                                                                       00003770
C                                                                       00003780
C     MODIFICATION HISTORY: 06/14/88  -  INITIAL RELEASE                00003790
C                                                                       00003800
C***********************************************************************00003810
C                                                                       00003820
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

      DIMENSION     TC (*), VC (*)
      DIMENSION     RHEAD  (SZLNHD)
      DIMENSION     TRACE  (SZLNHD)
      DIMENSION     V      (SZLNHD)
      INTEGER       VHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      integer       icelli (SZLNHD)
      integer       iceldi (SZLNHD)
      integer       aliasflag, ampflag, sprdflag, IDSK1, obytes
      integer       ordfft, irrec, nrrec
      real          sincs (41), w(SZLNHD), vel1(SZLNHD)
      complex       ctrace(SZLNHD)
      REAL          SUM, DMO, TAB
      pointer       (wkdmo,   DMO(1))
      pointer       (wksum,   SUM(1))
      pointer       (wktab,   TAB(1))

      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT
      character     tap1 * (*)
      character     name * 8
      logical       verbos, norm, shot, tape, intrp, restart, detm
      logical       first

      real          tabl1 (SZLNHD), tabl2 (SZLNHD), zz (4*SZLNHD)
      integer       iz (SZLNHD)

      integer       ISLIMN,ISDIMN,IRLIMN,IRDIMN,ICLIMN,ICDIMN,ISLIMX
      integer       ISDIMX,IRLIMX,IRDIMX,ICLIMX,ICDIMX,MINDST,MAXDST
      integer       MAXFLDs, MAXDMO
      integer       MAXFLDr
      integer       MAXFLDx
      integer       minJ, maxJ, minI, maxI

      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)

      DATA first   / .false. /
      DATA name    / 'dmostk3d' /

      DATA ISLIMN / 999999999 /
      DATA ISDIMN / 999999999 /
      DATA IRLIMN / 999999999 /
      DATA IRDIMN / 999999999 /
      DATA ICLIMN / 999999999 /
      DATA ICDIMN / 999999999 /
      DATA ISLIMX /-999999999 /
      DATA ISDIMX /-999999999 /
      DATA IRLIMX /-999999999 /
      DATA IRDIMX /-999999999 /
      DATA ICLIMX /-999999999 /
      DATA ICDIMX /-999999999 /
      DATA MINDST / 999999999 /
      DATA MAXDST /-999999999 /
      DATA MAXFLD /-999999999 /
      DATA MAXFLDs /-999999999 /
      DATA MAXFLDr /-999999999 /
      DATA MAXFLDx /-999999999 /
      DATA MAXDMO /-999999999 /
      DATA minJ / 999999999 /
      DATA maxJ /-999999999 /
      DATA minI / 999999999 /
      DATA maxI /-999999999 /
      DATA IRREC  /0/
      DATA NRREC  /0/
      DATA IOLD   /0/

      pi = 3.14159265
      nu = ordfft( nsamps )
      nt = 2 ** nu

      celscl = 0.5
      DX2 = celscl * DX
      DY2 = celscl * DY

      icinit = 1

C *** build pointers into trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcAz',ifmt_SrRcAz,l_SrRcAz,ln_SrRcAz,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      IREC = 0
      angmax = sin ( angmax * pi / 180.)
      scale  = 1. / (4 * sqrt (2*pi) )

C *** SET THE TRANSLATION SUBSYSTEM                                     00004570

      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)
      
      if (MAXLI .eq. 0) then
          MAXLI  = NX
      endif
      if (MAXDI .eq. 0) then
          MAXDI  = NY
      endif
      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1

      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)'DMO starts:'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'*********************************'
      write(LER,*)' '

      NRECo  = NX * NY
      NBYTR  = NSAMPS * SZSMPD
      NTRKS  = NX * NY * NFOLD
      obytes = NBYTR + SZTRHD

      NXNY  = NX * NY
      NXY   = sqrt ( float(NX*NX) + float(NY*NY) )

      write(LERR,*)'nx,ny,nxny= ',nx,ny,nxny
      if (tape) then
         if (nrecv .ne. nxny) then
            write(LERR,*)'FATAL ERROR in dm3d:'
            write(LERR,*)'number of records in velocity tape data set'
            write(LERR,*) nrecv
            write(LERR,*)'is not equal to number of output cells'
            write(LERR,*) nxny
            write(LERR,*)'Check velocity tape building steps'
            stop
         endif
         if (intrp) then
            do  i = 1, nsmpv
                tabl1 (i) = float (i) * siv
            enddo
            do  i = 1, nsamps
                tabl2 (i) = float (i) * si
            enddo
         endif
      endif

      items = nsamps * min (NX,NY)
      call galloc (wktab,   SZSMPD * nsamps, ierr3, iabort3)
      call galloc (wkdmo,   SZSMPD * items , ierr1, iabort1)
      call galloc (wksum,   SZSMPD * items , ierr2, iabort2)

      if (ierr1 .ne. 0 .or. ierr2 .ne. 0) then
         write(LER ,*)'Unable to allocate DMO arrays - too big'
         write(LER ,*)'2 arrays each sized ',SZSMPD*items,' Mb'
         write(LER ,*)'Try killing off some of your jobs or'
         write(LER ,*)'rerunning on a bigger machine'
         stop
      endif

      call vclr ( TAB, 1, nsamps)


      write(LERR,*)' '
      write(LERR,*)'ix,iy ',IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX
      write(LERR,*)'x,y ',xx,xy,yx,yy,xxt,xyt,yxt,yyt,nxy
      write(LERR,*)'NX,NY,nxy,items= ',NX,NY,NDI,NLI,nxy,items
      write(LERR,*)'minli,maxli,mindi,maxdi= ',minli,maxli,mindi,maxdi
      write(LERR,*)'ntrcs,angmax,scale= ',ntrcs,angmax,scale
      write(LERR,*)'TRCSPC= ',TRCSPC,' SI= ',si,' norm? ',norm,shot
      write(LERR,*)' '

c-----
C *** adjust line header & write output LH
c-----
      call savew (JHEAD, 'NumTrc', NY     , LINHED)
      call savew (JHEAD, 'NumRec', NX     , LINHED)
      call savew (JHEAD, 'NumSmp', NSAMPS , LINHED)
      call savew (JHEAD, 'Format', 3      , LINHED)
      call savew (JHEAD, 'CDPFld', NFOLD  , LINHED)
      call savew (JHEAD, 'MnLnIn', MINLI  , LINHED)
      call savew (JHEAD, 'MxLnIn', MAXLI  , LINHED)
      call savew (JHEAD, 'MnDpIn', MINDI  , LINHED)
      call savew (JHEAD, 'MxDpIn', MAXDI  , LINHED)
      call savew (JHEAD, 'ILClIn', DX     , LINHED)
      call savew (JHEAD, 'CLClIn', DY     , LINHED)

      if (.not. restart) then
         call savhlh (JHEAD, IBYTES, lbyout)
         CALL WRTAPE (luout , JHEAD, lbyout)
         if (norm) then
             CALL WRTAPE (IDSK1 , JHEAD, lbyout)
         endif
      endif


c-----
C *** fill up output data set and the rewind and read over LH
c-----
      call vmov (tab, 1, jhead(ITHWP1), 1, nsamps)

      if (.not. restart) then
         call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               30000 , TRACEHEADER)
         call savew2(JHEAD,ifmt_VPick1,l_VPick1, ln_VPick1,
     1               0     , TRACEHEADER)
         do  i = 1, NXNY
             call wrtape (luout , jhead, obytes)
         enddo
      endif
      call rwd (luout )
      call sislgbuf (luout , 'off')
      call rtape (luout , jhead, IBYTES)
      call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            0 , TRACEHEADER)

c-----
c *** fill up optional scratch file for normalization
c-----
      call vclr (tab, 1, nsamps)
      call vmov (tab, 1, jhead(ITHWP1), 1, nsamps)
 
      if (norm .AND. .not.restart) then
         do  i = 1, NXNY
             call wrtape (IDSK1, jhead, obytes)
         enddo
      endif
 
      if (norm) then
         call rwd (IDSK1)
         call sislgbuf (IDSK1, 'off')
         call rtape (IDSK1 , jhead, IBYTES)
      endif

      msx = nxy

c     iswath = min (NX,NY)
      iswath = 3


c-----
C for flat file velocity function input (can have single function only)
c (... for velocity tape see below)
c-----
      if (.not. tape) then
         call vel (TC, VC, nsamps, si, npairs, V)
      endif

c-----
C *** zero out dmo panel; compute frequency DMO scaling
c-----
      call vclr (dmo, 1, nsamps*iswath)
      call init (dt, w, sincs, nt)

c-----
C *** READ THE TRACES.                                                  00004650
c-----

 1500 CONTINUE

      IBYTES = IOLEN
      IWRN = 0
      call vclr (trace, 1, nt)

      CALL RTAPE (ITAPIN, JHEAD, IBYTES)
      call vmov  (JHEAD(ITHWP1), 1, TRACE, 1, NSAMPS)

C *** GO TO BEGIN OUTPUT IF END OF INPUT TAPE                           00004710

      IF (IBYTES .EQ. 0) GO TO 5000

      call saver2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            IRREC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            IRTRC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            IDEAD  , TRACEHEADER)
      call saver2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1            IDIST  , TRACEHEADER)

      IF (IRREC .NE. IOLD) THEN
         IOLD  = IRREC
         NRREC = NRREC + 1
         write(LER,*)'DMO on Record ',IRREC
      END IF

C *** GET SOURCE TO RECEIVER DISTANCE                                   00004810

      IF (IDEAD .GE. 30000) GO TO 1500

c-----
c  preprocess trace
c-----
      call iwtrace(trace, nsamps, nt, dt, ctrace, w)

      IDIST = IABS (IDIST)

C *** GET SHOT COORDINATE                                               00004930

         call saver2(JHEAD,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               ISX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1               ISY     , TRACEHEADER)
         SX = ISX
         SY = ISY

C *** GET RECEIVER COORDINATE                                           00004980

         call saver2(JHEAD,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               IRX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               IRY     , TRACEHEADER)
         RX = IRX
         RY = IRY

C *** GET THE CDP COORDINATE (if shot mode we have to compute it)

         ICDPX = 0.5 * float (ISX + IRX) + 0.5
         ICDPY = 0.5 * float (ISY + IRY) + 0.5
         CX = ICDPX
         CY = ICDPY


C *** TRANSLATE SHOT AND RECEIVER INTO GRID COORDINATE SYSTEM

      CALL XFMFWD (SX, SY, ISLI, ISDI, SXT, SYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      CALL XFMFWD (RX, RY, IRLI, IRDI, RXT, RYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI)

      ISLIMN = MIN (ISLIMN, ISLI)
      ISDIMN = MIN (ISDIMN, ISDI)
      IRLIMN = MIN (IRLIMN, IRLI)
      IRDIMN = MIN (IRDIMN, IRDI)
      ICLIMN = MIN (ICLIMN, ICLI)
      ICDIMN = MIN (ICDIMN, ICDI)
      ISLIMX = MAX (ISLIMX, ISLI)
      ISDIMX = MAX (ISDIMX, ISDI)
      IRLIMX = MAX (IRLIMX, IRLI)
      IRDIMX = MAX (IRDIMX, IRDI)
      ICLIMX = MAX (ICLIMX, ICLI)
      ICDIMX = MAX (ICDIMX, ICDI)
      MINDST = MIN (MINDST, IDIST)
      MAXDST = MAX (MAXDST, IDIST)

C *** COMPUTE PRIMARY DIRECTION OF S/R AZIMUTH RELATIVE TO GRID
C *** COMPUTE offset and check offset limits

      DXT  = SXT - RXT
      DYT  = SYT - RYT
      off  = sqrt ( DXT*DXT + DYT*DYT )
      H    = 0.5 * off

      if (off .gt. DSTMAX) go to 1500
      if (off .lt. DSTMIN) go to 1500

c-----
c  figure out whether the S-R line is primarily in the DI (or X)
c  direction or the LI (orY) direction. this is necessary to
c  calculate the proper step sizes in each direction
c-----
      IF (ABS(DXT) .GE. ABS(DYT)) THEN
         DDX    = DX2
         DDY    = abs (DYT * DDX / DXT )
      ELSE
         DDY    = DY2
         DDX    = abs (DXT * DDY / DYT )
      END IF
c-----
c  based on the orientation of the S-R line we compute the sign
c  of the steps in the X and Y directions. thus we step from
c  the S cell location along the line to the R location.
c-----
      if (DXT .ne. 0.) then
          sgnx = -sign (1.0, DXT)
          DDX  = sgnx * DDX
      endif
      if (DYT .ne. 0.) then
          sgny = -sign (1.0, DYT)
          DDY  = sgny * DDY
      endif

C *** COMPUTE THE TRACE SPACING

      B = SQRT (DDX*DDX + DDY*DDY)

c----
c   if the current midpoint location of this trace is out of bounds
c   skip over any computations and drop to the end of the loop - go
c   back and read a new trace
c----

      IWRN = 0

      IF (ICLI .LT. MINLI) IWRN = 1
      IF (ICLI .GT. MAXLI) IWRN = 1
      IF (ICDI .LT. MINDI) IWRN = 1
      IF (ICDI .GT. MAXDI) IWRN = 1

      IF (IWRN .EQ. 0) THEN

c-----
c  get velocity if it is a velocity tape data set. each velocity trace
c  must reside at a location corresponding to the output grid. If
c  the velocity trace is coarsely sampled the interpolate.
c-----
          if (tape) then
             
              ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1
              call sisseek (luvel, ipntr)
              call rtape (luvel, vhead, nvbytes)
              if (nvbytes .eq. 0) then
                 write(LERR,*)'FATAL ERROR in dm3d:'
                 write(LERR,*)'Premature end of velocity data. Check'
                 write(LERR,*)'velocity tape building steps.'
                 stop
              endif
              call vmov (vhead(ITHWP1), 1, vel1, 1, nsmpv)
              if (intrp) then
                 call fcuint (tabl1, vel1, nsmpv, tabl2, V, nsamps,
     1                        iz, zz, icinit)
                 icinit = 0
              else
                 call vmov (vel1, 1, V, 1, nsamps)
              endif
              call minv (V, 1, vmin, loc, nsamps)
              if (vmin .le. 0.) then
                 write(LERR,*)'FATAL ERROR in dm3d:'
                 write(LERR,*)'detected velocity < 0. Something bad'
                 write(LERR,*)'either in input velocity traces, or'
                 write(LERR,*)'in the interpolation.'
                 stop
              endif
          endif

c-----
c  for current S & R positions find LI & DI cell numbers that lie
c  along this line starting from the S position...
c-----
          nrad = nint ( off / b )
          ic = 0
          offcum = 0.0
          cldii = DDY / DY2
          cllii = DDX / DX2
 
c     write(0,*)'1:off,b,nrad,cldii,cllii= ',off,b,nrad,cldii,cllii
c     write(0,*)'ISLI/DI= ',ISLI,ISDI,' IRLI,DI= ',IRLI,IRDI
 
          do  i = 1, nrad
              offcum = offcum + b
              ddi   = celscl * float(I) * cldii
              dli   = celscl * float(I) * cllii
              icldi = ISDI + nint (ddi)
              iclli = ISLI + nint (dli)
              if (offcum .lt. off) then
                      ic = ic + 1
                      iceldi (ic) = icldi
                      icelli (ic) = iclli
              endif
          enddo
          ncells = ic

          if (ncells .gt. iswath) then
             iswath = ncells
             MAXDMO = max (MAXDMO, iswath)
             items  = iswath * nsamps * SZSMPD
             call grealloc (wkdmo, items, ierr1, iabort1)
             call grealloc (wksum, items, ierr2, iabort2)
             if (ierr1 .ne. 0 .OR. ierr2 .ne. 0) then
                write(LER,*)' '
                write(LER,*)'dmostk3d: FATAL ERROR'
                write(LER,*)'Unable to dmo swath ',ncells,' wide'
                write(LER,*)'because of too much memory.'
                write(LER,*)'Try freeing up some memory in your'
                write(LER,*)'machine or re-run on a larger machine.'
                return
             endif
          endif

c-----
c  extract the current dmo summed data swatch from this part of the output
c  volume
c  find the midpoint along the line joining S & R
c  Note: swapping the i's & j's in the ipntr expression below transposes
c        the data (as viewed in time slice domain).

c            ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1
             ipntr =      icd       +       jcl      * ndi + 1
c-----
          IF (ncells .gt. 0) THEN

          imid = 0
          do  i = 1, ncells
               icldi = iceldi (i)
               iclli = icelli (i)
               if (icldi .eq. ICDI .AND. iclli .eq. ICLI) then
                   imid = i
               endif
               istr  = (i-1) * nsamps

               jcl = iclli - minli
               icd = icldi - mindi
               ipntr = icd + jcl * ndi + 1

               maxJ = max (maxJ, jcl)
               minJ = min (minJ, jcl)
               maxI = max (maxI, icd)
               minI = min (minI, icd)
               call sisseek (luout , ipntr)
               call rtape (luout , jhead, nbytes)
               call vmov (jhead(ITHWP1), 1, dmo(istr+1), 1, nsamps)

               if (norm) then
                  call sisseek (IDSK1, ipntr)
                  call rtape   (IDSK1, jhead, nbytes)
                  call vmov    (jhead(ITHWP1), 1, tab, 1, nsamps)
                  call vmov (tab, 1, sum(istr+1), 1, nsamps)
               endif
          enddo

c-----
c  find the midpoint along the progression of cells from S to R. If ncells
c  even we need to drop the last cell; if ncells odd we need to move the
c  midpoint to the center
c-----
          if (ncells .ge. 2) then
              if (mod(ncells,2) .eq. 0) then
                  imid = ncells / 2
                  ncells = ncells - 1
              else
                  imid = ncells / 2 + 1
              endif
          else
              imid = ncells
          endif

          ENDIF

c-----
c  take current input trace, spray out along dmo ellipse and sum amplitudes
c  into the current swatch of traces from output volume
c-----
          IF (ncells .gt. 0) THEN

             if (norm) then
                call born1 (trace, dmo, V, nsamps, dt, B, H, iswath,
     1                     off, angmax, aliasflag, ampflag, sum,
     2                     sprdflag, sincs, ncells, iswath, scale, imid)
             else
                call born0 (trace, dmo, V, nsamps, dt, B, H,
     1                     off, angmax, aliasflag, ampflag,
     2                     sprdflag, sincs, ncells, iswath, scale, imid)
             endif

          ENDIF

      if (verbos) then
      write(LERR,*)'S,D,R,bins: ',ISLI,ISDI,ICLI,ICDI,IRLI,IRDI,ncells,
     1 off,B
      endif
c-----
c  put new summed swatch back into output volume
c-----
          IF (ncells .gt. 0) THEN

          do  i = 1, ncells
               icldi = iceldi (i)
               iclli = icelli (i)
               istr  = (i-1) * nsamps
               ipntr = (icldi - mindi) + (iclli - minli) * ndi + 1
               call vmov (dmo(istr+1), 1, jhead(ITHWP1), 1, nsamps)
               call sisseek (luout , ipntr)
               call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     0      , TRACEHEADER)
               if (i .eq. imid) then
                   call savew2(JHEAD,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                         ICDPX   , TRACEHEADER)
                   call savew2(JHEAD,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                         ICDPY   , TRACEHEADER)
               endif
               call wrtape (luout , jhead, nbytes)

               if (norm) then
                  call vmov (sum(istr+1), 1, tab, 1, nsamps)
                  call vmov    (tab, 1, jhead(ITHWP1), 1, nsamps)
                  call sisseek (IDSK1, ipntr)
                  call wrtape  (IDSK1, jhead, obytes)
               endif
          enddo
          ENDIF

      END IF

      go to 1500
 5000 CONTINUE

      write(IPRT,*)' '
      write(IPRT,*)'minJ, maxJ, minI, maxI= ',minJ, maxJ, minI, maxI
      write(IPRT,*)' '
      write(LER,*)'Completed DMO stacking...'
      if (norm) then
         write(LER,*)'... now doing normalization step'
         write(LER,*)' '
      endif

      IF (norm) THEN
 
          DO  I = 1, ndi
              DO  J = 1, nli
 
                  ipntr = I + (J-1) * ndi
                  call sisseek (IDSK1, ipntr)
                  call rtape   (IDSK1, jhead, nbytes)
                  call vmov    (jhead(ITHWP1), 1, tab, 1, nsamps)
                  call sisseek (luout , ipntr)
                  call rtape (luout , jhead, nbytes)
                  call vmov  (jhead(ITHWP1), 1, trace, 1, nsamps)

                  im = 0
                  detm = .false.
                  do  ii = 1, nsamps
                      xlive = tab (ii)
                      if (xlive .eq. 0.) then
                          if (.not.detm) im = im + 1
                          xlive = 1.
                      else
                          detm = .true.
                          imt  = im * si
                      endif
                      trace (ii) = trace (ii) / (xlive ** divexp)
                      live = nint (xlive)
                      maxfld = max (maxfld, live)
                  enddo

                  call center_xy ( J, I, IX1, IY1, dx, dy, name,
     1                             XX, XY, YX, YY, XYT, YXT,
     2                             XXT, YYT, LER, LERR, IXC, IYC,
     3                             first)
                  call savew2(jhead,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                        IXC , TRACEHEADER)
                  call savew2(jhead,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                        IYC , TRACEHEADER)

                  if (im .eq. nsamps)
     1            call savew2(jhead,ifmt_StaCor,l_StaCor, ln_StaCor,
     2                        30000 , TRACEHEADER)
                  call savew2(jhead,ifmt_VPick1,l_VPick1, ln_VPick1,
     1                        imt , TRACEHEADER)
                  call savew2(jhead,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        J   , TRACEHEADER)
                  call savew2(jhead,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        I   , TRACEHEADER)
                  call savew2(jhead,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                        J   , TRACEHEADER)
                  call savew2(jhead,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        I   , TRACEHEADER)

                 call sisseek (luout , ipntr)
                 call vmov (trace, 1, jhead(ITHWP1), 1, nsamps)
                 call wrtape (luout , jhead, nbytes)
              ENDDO
          ENDDO

      ELSE

          DO  I = 1, ndi
              DO  J = 1, nli
 
                  ipntr = I + (J-1) * ndi
                  call sisseek (luout , ipntr)
                  call rtape (luout , jhead, nbytes)
                  call vmov  (jhead(ITHWP1), 1, trace, 1, nsamps)
 
                  im = 0
                  detm = .false.
                  do  ii = 1, nsamps
                      xlive = trace (ii)
                      if (xlive .eq. 0.) then
                          if (.not.detm) im = im + 1
                      else
                          detm = .true.
                          imt  = im * si
                      endif
                  enddo

                  call center_xy ( J, I, IX1, IY1, dx, dy, name,
     1                             XX, XY, YX, YY, XYT, YXT,
     2                             XXT, YYT, LER, LERR, IXC, IYC,
     3                             first)
                  call savew2(jhead,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                        IXC , TRACEHEADER)
                  call savew2(jhead,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                        IYC , TRACEHEADER)

                  if (im .eq. nsamps)
     1            call savew2(jhead,ifmt_StaCor,l_StaCor, ln_StaCor,
     2                        30000 , TRACEHEADER)
                  call savew2(jhead,ifmt_VPick1,l_VPick1, ln_VPick1,
     1                        imt , TRACEHEADER)
                  call savew2(jhead,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        J   , TRACEHEADER)
                  call savew2(jhead,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        I   , TRACEHEADER)
                  call savew2(jhead,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                        J   , TRACEHEADER)
                  call savew2(jhead,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        I   , TRACEHEADER)
 
                 call sisseek (luout , ipntr)
                 call wrtape (luout , jhead, nbytes)
              ENDDO
          ENDDO

      ENDIF

      WRITE (IPRT, 310) ISLIMN,ISLIMX,ISDIMN,ISDIMX,
     &                  IRLIMN,IRLIMX,IRDIMN,IRDIMX,
     &                  ICLIMN,ICLIMX,ICDIMN,ICDIMX,
     &                  MINDST,MAXDST,MAXDMO,MAXFLD
  310 FORMAT (//, 30X, 'LIMITS FOUND ON DATASET:'
     &        //, 23X, '  MINIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DMO SWATH.. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DMO REDUNDANCY. . . . .',1X,I9  ,//)

      write(LER,*)' '
      write(LER,*)'End of Data:'
      write(LER,*)'DMOd ',NRREC,' records'
      ICC = 0

      RETURN
      END
