C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine CutPadTaper(Input,nxIN,nyIN,Xpad,Ypad,
     :     FilterLength,Xtaper,Ytaper,Output,nxOUT,nyOUT,
     :     dup)

c
c routine to pad and cosine taper an input array
c

      integer nxIN,nyIN,Xpad,Ypad,Xtaper,Ytaper,nxOUT,nyOUT
      integer top,bottom,left,right,FilterLength,OffsetX
      integer OffsetY
      logical dup

      real Input(nxIN,nyIN), Output(nxOUT,nyOUT), piBy2, weight

      piBy2 = 3.14159625/2.0
      top = 1
      bottom = nxIN
      left = 1
      right = nyIN

c -----
c taper in X
c -----
      IF (Xtaper .ne. 0) THEN

      do i = 1,Xtaper

         weight = cos(piBy2 - piBy2 * (float(i)/float(Xtaper)))

         do j = top,bottom

            Input(j,left+i-1) = Input(j,left+i-1) * weight
            Input(j,right-i+1) = Input(j,right-i+1) * weight

         enddo

      enddo
      ENDIF

c -----
c taper in Y
c -----
      IF (Ytaper .ne. 0) THEN

      do i = 1,Ytaper

         weight = cos(piBy2 - piBy2 * (float(i)/float(Ytaper)))

         do j = left,right

            Input(top+i-1,j) = Input(top+i-1,j) * weight
            Input(bottom-i+1,j) = Input(bottom-i+1,j) * weight

         enddo

      enddo
      ENDIF

c -----
c pad
c -----

      OffsetX = FilterLength/2 + Xpad 
      OffsetY = FilterLength/2 + Ypad

      do  j = 1,nyIN
         do  i = 1,nxIN

            Output(OffsetX+i,OffsetY+j) = Input(i,j)

         enddo
      enddo

c -----
c fill pad area with fringe samples of input slice
c -----
      IF ( dup ) THEN

c---
c  top fringe
c---
         do  i = 1, OffsetX
             do  j = 1, nyIN
                 Output ( i        , j+OffsetY) = Input ( 1   , j)
             enddo
         enddo
c---
c  bottom fringe
c---
         do  i = 1, OffsetX+1
             do  j = 1, nyIN
                 Output ( nxOUT-i+1, j+OffsetY) = Input ( nxIN, j)
             enddo
         enddo

c---
c  left fringe
c---
         do  j = 1, OffsetY
             do  i = 1, nxIN
                 Output ( i+OffsetX, j        ) = Input ( i, 1   )
             enddo
         enddo
c---
c  right fringe
c---
         do  j = 1, OffsetY+1
             do  i = 1, nxIN
                 Output ( i+OffsetX, nyOUT-j+1) = Input ( i, nyIN)
             enddo
         enddo

c---
c  top left corner
c---
         do  i = 1, OffsetX
         do  j = 1, OffsetY
             Output (i,j) = Input(1,1)
         enddo
         enddo
c---
c  bottom left corner
c---
         do  i = nxIN+OffsetX-1, nxOUT
         do  j = nyIN+OffsetY-1, nyOUT
             Output (i,j) = Input (nxIN,nyIN)
         enddo
         enddo
c---
c  top right corner
c---
         do  i = 1, OffsetX
         do  j = nyIN+OffsetY-1, nyOUT
             Output (i,j) = Input (1,nyIN)
         enddo
         enddo
c---
c  bottom left corner
c---
         do  i = nxIN+OffsetX-1, nxOUT
         do  j = 1, OffsetY
             Output (i,j) = Input(nxIN,1)
         enddo
         enddo

      ENDIF

      return
      end
