C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FKKFilter(Input,nxIN,nyIN,Filter,nIN,nIN2,Output,
     :     Xpad,Ypad,pass,avmed,med,har,iopa,ioph,chp,gauss,fmed)

      integer nxIN,nyIN,nIN,FilterCenter,StartRow,StartColumn
      integer nrows,ncols,Xpad,Ypad

      real    Input(nxIN,nyIN),Filter(nIN,nIN),Output(nxIN,nyIN)

      integer iopa, ioph
      real    chp
      logical pass, avmed, med, fmed, har, gauss

c -----
c convolve Input with Filter
c -----

      if (.not.avmed .and. .not.med .and. .not.fmed .and. .not.har) then

           FilterCenter = nint((float(nIN)**2)/2.)
           StartRow = NIN/2 + 1
           StartColumn = NIN/2 + 1
           nrows = nxIN - nIN
           ncols = nyIN - nIN

           call conv2d(Input,nxIN,StartRow,StartColumn,nrows,ncols,
     :                 Filter,nIN,nIN,FilterCenter,Output,nxIN,
     :                 StartRow,StartColumn,0)

      elseif (avmed .or. med .or. fmed) then

           call avemed (Input, Output, nxIN, nyIN, nIN, nIN2, 
     :                  Filter, med, fmed, iopa)

      elseif (har) then

           call nlmed  (Input, Output, nxIN, nyIN, nIN, nIN2, 
     :                  Filter, ioph, chp)

      endif

      IF(.not.pass)then

c -----
c remove flat events
c -----

         do j = 1,nyIN
            do i = 1,nxIN

               Output(i,j) = Input(i,j) - Output(i,j)

            enddo
         enddo

      ENDIF

      return
      end
