C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fitslice (ndi, nli, times, work, pass,
     1                     fit, iord, irtype, ilim, rmave
     2                     )
#include <f77/iounit.h>

c  times - input 2D matrix of values [dim ndi rows x nli cols]
c  work  - fitted surface to "times"
c  work  - output fitted surface or residual surface


      integer  nli, ndi
      real     times (ndi, nli), work (ndi, nli)
      
      real*8   space, trace, sample, ampls
      pointer  (wkspace, space (1))
      pointer  (wkampls, ampls (1))
      pointer  (wktrace, trace (1))
      pointer  (wksample, sample (1))
      integer  irtype,limord,ndf1(14),ndf2(14),ndf3,minord
      integer  if1max,ifumax,ipoly,ilim,ierr,itrial(14)

      real*8   coef(680),reg(14),ssr(14),ssd(14),sst,f1(14)
      real*8   delta

      integer  jsz

      logical  fit, pass, rmave

      call sizefloat(jsz)

         delta = 1.0d-6

         item  = 2 * nli * ndi + 2
         items = 2 * item + 680 * 2

         call galloc (wkspace,  items * jsz, ierr1, iab)
         call galloc (wkampls,  item  * jsz, ierr1, iab)
         call galloc (wktrace,  item  * jsz, ierr2, iab)
         call galloc (wksample, item  * jsz, ierr3, iab)
         if (ierr1.ne.0 .or. ierr2.ne.0 .or. ierr3.ne.0) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR'
            write(LERR,*)'Unable to allocate workspace (fkkstrip):'
            write(LERR,*)items * jsz,'  bytes'
            write(LERR,*)item * jsz,'  bytes'
            write(LERR,*)item * jsz,'  bytes'
            write(LERR,*)item * jsz,'  bytes'
            write(LER ,*)' '
            write(LER ,*)'FATAL ERROR'
            write(LER ,*)'Unable to allocate workspace (fkkstrip):'
            write(LERR,*)items * jsz,'  bytes'
            write(LER ,*)item * jsz,'  bytes'
            write(LERR,*)item * jsz,'  bytes'
            write(LERR,*)item * jsz,'  bytes'
            stop
         endif

         ic = 0
         do  j = 1, nli
             do  i = 1, ndi
                 ic = ic + 1
                 sample (ic) = dble (i)
                 trace  (ic) = dble (j)
                 ampls  (ic) = dble (times(i,j))
             enddo
         enddo
         nlidi = nli * ndi

         limord = 14
         isord  = iord

         call rob3sb(Trace,Sample,ampls,nlidi,irtype,limord,
     1               coef,reg,ssr,ssd,sst,ndf1,ndf2,ndf3,f1,minord,
     2               if1max,ifumax,ipoly,ilim,delta,ierr,itrial,
     3               space,isord)

         write(LERR,*)' '
         write(LERR,*)'Fit completed:'
         write(LERR,*)'min significant order  = ',minord
         write(LERR,*)'max significant order  = ',ifumax
         write(LERR,*)'recommended surf order = ',ipoly
         write(LERR,*)' '
         if (ipoly .eq. 0) then
            write(LER,*)'FATAL ERROR in fkkstrip surface fit:'
            write(LER,*)'Something bad happened in the fit, ierr= ',
     1      ierr
            write(LER,*)'ierr=1: insufficient data points to fit'
            write(LER,*)'ierr=2: no significant polynomial relationship 
     1found'
            stop 666
         endif

         iloc = ipoly*(ipoly+1) * (ipoly +2)/6

         call surfgen (ipoly, coef(iloc), ndi, nli, work)

         call gfree (wkspace)
         call gfree (wkampls)
         call gfree (wktrace)
         call gfree (wksample)

      IF (.not. pass) THEN
         do  j = 1, nli
         do  i = 1, ndi
            work (i,j) = times (i,j) - work (i,j)
         enddo
         enddo
      ENDIF

      IF (rmave) THEN
         ave = 0.
         do  j = 1, nli
         do  i = 1, ndi
            ave = ave + work (i,j)
         enddo
         enddo
         ave = ave / float(nli*ndi)
         do  j = 1, nli
         do  i = 1, ndi
            work (i,j) = work (i,j) - ave
         enddo
         enddo
      ENDIF

      return
      end
