C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c**********************************************************************
c
      subroutine isort(n,list,key)
c
c     subroutine work : this subroutine orders integer  numbers
c                       stored in 'list' in ascending sequence of
c                       their key values stored in key
c
c
c     input parameters:
c
c     n   : positive integer giving length of list
c     list: a list of length n of integers
c     key : a list of length n of single precision keys
c
c
c
c     output parameters:
c
c     n   : unchanged
c     list: a list of length n of integers sorted in ascending
c           sequence of their single precision keys
c     key : unchanged 
c
c
c     NOTE: this code uses an insertion sorting - efficient only
c           for n values less than 12 ( although may be system
c           dependent)
c
c
c     Reference : Efficient Sorting Algorithms in Fortran 77
c                 US Dept. of Commerce, NTIS, 1983
c                 University of Oxford, Dept. of Engineering
c                 Science Report, G.T. Houlsby and S.W. Sloan
c                 OUEL Report No. 1529/84
c
c     Adopted for use at Amoco Production Co.
c                      by Antony A. Vassiliou
c
c**********************************************************************
c
c
c
c
       integer n
       integer list(100000)
       real key(100000)
c
c
c
       integer i,j,k
       real value
c
c
c      set first pointer to minimum key
c
c
       j=1
       k=list(1)
       value=key(k)
       do 10 i=2,n
             if(key(list(i)).lt.value) then
             j=i
             value=key(list(i))
              end if
 10    continue
       list(1)=list(j)
       list(j)=k
c
c
c      carry out the insertion sort
c
c
       do 30 i=2,n
             j=i
             k=list(i)
             value=key(k)
  20         continue
                if(value.lt.key(list(j-1))) then
                   list(j)=list(j-1)
                   j=j-1
                   go to 20
                end if
                list(j)=k
 30          continue
             return
             end
