c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c  Subroutine to get the slope and bias of a least-squares line through
c  x,y data points.
c***********************************************************************
      subroutine ls_line(x,y,npts,slope,bias)
 
      integer npts
      real    x(npts),y(npts)
      real    slope,bias
 
      real*8  sum_x,sum_x2,sum_y,sum_xy,tmp_slope,tmp_bias
 
c-----------------------------------------------------------------------
c DONE WITH DECLARATIONS
c-----------------------------------------------------------------------
 
c Initialize
      sum_x  = 0.0
      sum_x2 = 0.0
      sum_y  = 0.0
      sum_xy = 0.0
      slope  = 0.0
      bias   = 0.0
 
c Compute sums
      do i = 1,npts
        sum_x  = sum_x  + x(i)
        sum_x2 = sum_x2 + x(i)*x(i)
        sum_y  = sum_y  + y(i)
        sum_xy = sum_xy + x(i)*y(i)
      enddo
 
c Solve for slope and bias
      tmp_slope = (sum_x*sum_y-npts*sum_xy)/(sum_x*sum_x-npts*sum_x2)
      tmp_bias  = (sum_x2*sum_y-sum_x*sum_xy)/(sum_x2*npts-sum_x*sum_x)
 
      slope = real(tmp_slope)
      bias  = real(tmp_bias)
 
c All Done
      return
      end
