C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c horvel3d reads velspec semblance records, 2 velocity-time
c picks (which define a velocity fairway), and picks made from
c several horizons of a stacked volume
c and puts it all together to automatically generate velocity
c functions. These functions in ascii form are written to an
c output file in special TDFN format suitable for vi3d
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77

#include <f77/iounit.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes
      integer     maxcol, hmin
      integer     irec, itrc
      integer     dphind, linind
      integer     limin, limax, dimin, dimax, nli, ndi

      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_DphInd,l_DphInd,ln_DphInd
      integer ifmt_LinInd,l_LinInd,ln_LinInd
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC
      integer ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC
      integer ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC
      integer ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC
      integer ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX
      integer ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY
      integer ifmt_hdrwdx,l_hdrwdx,ln_hdrwdx
      integer ifmt_hdrwdy,l_hdrwdy,ln_hdrwdy
 
      real    fmscl, mfscl, BXT, BYT, CX, CY
      real    DX, DY
      integer ICX, ICY, ICLI, ICDI
 
      REAL*8  XX, XY, YX, YY, XXT, XYT, YXT, YYT

c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      real        times, data
      pointer     (wktimes , times (1000000))
      pointer     (wkdata  , data  (1000000))

      integer     dcolor(SZLNHD)

      real        vello(SZLNHD), velhi(SZLNHD )
      real        velav(SZLNHD)
      real        tmp1(SZLNHD), tmp2(SZLNHD)
      real        velsem(SZLNHD)
      character   ntap * 256, otap * 256, name*8, stkpik(100) * 256
      character   velpik * 256, hdrwdx * 6, hdrwdy * 6, tag * 1
      logical     verbos, heap, linear, resamp, debug
      logical     gamma, lmrk, f2m, m2f, first, xsd
      logical     smooth, fit, below, above, notrp
      integer     argis,lunstk(100),lunvel,ierr,iab
 
c-----
c    we acces the floating point data through an equivalence statement
c    that starts the reals at 1/2-word 129
c-----
      data lbytes / 0 /, nbytes / 0 /, name/'HORVEL3D'/, first/.true./
      data tag /'G'/
 
c-----
c     read program parameters from command line card image file
c-----
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln (ntap,otap,stkpik,velpik,lunstk,luout,lunvel,
     1             igate,next,linear,thr,log,nord,verbos,
     2             vmin,vmax,dmul,limin,limax,dimin,dimax,
     4             debug, gamma,lmrk,f2m, m2f, nstk, lu_debug, xsd,
     5             IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4, DY, DX,
     6             hdrwdx, hdrwdy, hmin, notrp,
     7             smooth, fit, iord, irtype, ilim, nf, below, above)

c----
c  XY feet -> m or m-> feet scaler
c----
          if     ( f2m ) then
             xyscl = fmscl
          elseif ( m2f ) then
             xyscl = mfscl
          else
             xyscl = 1.0
          endif

c-----
c     get logical unit numbers for input and output of seismic data

c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used

c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)

c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'HORVEL: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     save certain parameters

c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position

c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'T_Unit', iscl , LINHED)
      if (iscl .le. 0 .AND. gamma) then
        write(LERR,*)'FATAL ERROR from horvel3d (gamma option):'
        write(LERR,*)'No proper gamma scale factor read from line'
        write(LERR,*)'header (',iscl,'). Should be value 10-1000'
        write(LERR,*)'Use in-place utop ... -h0T_Unit= to input value'
        call ccexit (666)
      endif
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      if (gamma .and. vmin .eq. 0.0) then
         vmin = iscl
      endif
      if (gamma .and. vmax .eq. 0.0) then
         vmax = iscl
      endif

      nli = limax - limin + 1
      ndi = dimax - dimin + 1

      nvel = ntrc

      if (ntrc/3 .lt. nord) then
         write(LERR,*)'WARNING from horvel3d:'
         write(LERR,*)'Smoothing order ',nord,' too large for ',ntrc
         nord = ntrc/3
         write(LERR,*)'records. Will reset to ',nord
      endif

      if (mod(nord,2) .eq. 0) then
         write(LERR,*)' '
         write(LERR,*)'WARNING from horval3d:'
         write(LERR,*)'Smoothing order must be odd - got ',nord
         nord = nord - 1
         write(LERR,*)'Will rest to ',nord
      endif
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      call savelu(hdrwdx,ifmt_hdrwdx,l_hdrwdx,ln_hdrwdx,TRACEHEADER)
      call savelu(hdrwdy,ifmt_hdrwdy,l_hdrwdy,ln_hdrwdy,TRACEHEADER)

c------
c     hlhprt prints out the historical line header of length lbytes AND

c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
c     call hlhprt (itr, lbytes, name, 8, LERR)

c-----
C build LI/DI coordinates
c-----
      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

      if (limax .eq. 0) then
          maxli = NX
      else
          maxli = limax
      endif
      if (limin .eq. 0) then
          minli = 1
      else
          minli = limin
      endif
      if (dimax .eq. 0) then
          maxdi = NY
      else
          maxdi = dimax
      endif
      if (dimin .eq. 0) then
          mindi = 1
      else
          mindi = dimin
      endif
 
      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1

 

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,stkpik, velpik, vmin,vmax,
     2                  limin,limax,dimin,dimax,resamp,
     3                  gamma, lmrk,minli,maxli,mindi,maxdi,
     4                  nli,ndi,nhor,iscl,xsd,hmin,igate,thr,
     6                  smooth,nf,fit,iord,irtype,below,above)
c     end if

      igate = igate / 2
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary

      si = nsi
      dt = real (nsi) * unitsc

c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c-----

c-----
c  read in 2-segment velocity fairway picks and build a low & high
c  velocity fairway to limit the search on the semblance panels in
c  the velocity direction
c----
      call fairway (lunvel,nsamp,si,velhi,vello,velav,
     1              tmp1, tmp2, gamma)
c----
c   velocity fairway all read in & checked out
c----

c----
c   check & identify horizon pick file
c   find number of distinct horizons
c----
      call horint (lunstk(1),nf,maxcol,dcolor,nhor,SZSMPD,
     1             lmrk,nstk)


c----
c   allocate memory for times matrix
c   allocate enough space for each semblance record
c----
      heap = .true.
      itemt = nli * ndi * nhor * SZSMPD 
      call galloc (wktimes, itemt, ierr, iab)
      if (ierr .ne. 0) heap = .false.

      itemd = ntrc * nsamp * SZSMPD
      call galloc (wkdata , itemd, ierr, iab)
      if (ierr .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'horvel3d: Unable to allocate workspace:'
         write(LERR,*) itemt,'  bytes'
         write(LERR,*) itemd,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'horvel3d: Unable to allocate workspace:'
         write(LER ,*) itemt,'  bytes'
         write(LER ,*) itemd,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemt,'  bytes'
         write(LERR,*) itemd,'  bytes'
         write(LERR,*)' '
      endif


c----
c   read pick file for times: currently only landmark horizon files
c   and xsd pick files are supported.
c----
      if (lmrk) then

         call lmrd  (lunstk, nli, ndi, nhor, minli, maxli, mindi, maxdi,
     1               times, SZSMPD, si, debug, IX1, IY1, DX, DY,
     2               XX, XY, YX, YY, XXT, XYT, YXT, YYT, xyscl, verbos,
     3               lu_debug, smooth, fit, iord, irtype, ilim, nf,
     4               notrp)

      elseif (xsd) then

         call timrd (lunstk, nli, ndi, nhor, limin, limax, dimin, dimax,
     1               dcolor, times, SZSMPD, si, maxcol, debug, lu_debug,
     2               verbos, lu_debug, smooth, fit, iord, irtype, ilim,
     3               nf, notrp)
      endif


c----
c  the array times now looks like below with all areal times interpolated
c  over the LI/DI grid for each horizon

c        li = 1, nli
c        di = 1, ndi
c        nh = 1, nhor

c                times (li, di, nh)
c----

c-----
c     read semblance records, auto pick, write TDFN functions to luout
c     for "gamma" data put a "G" at the top of the TDFN file to be
c     read by vi3d (this code will then know that the gammas have been
c     scaled by 1000)
c-----

      rewind luout
      if (gamma) then
         write(luout,'(a1)') tag
      endif
c-----
c     process desired trace records
c-----
      ir = 0
      it = 0

      ic = 0

      DO   JJ = 1, nrec
 
            first = .false.
            ic = ic + 1

            do    kk = 1, ntrc

                  nbytes = 0

                    call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                    if(nbytes .eq. 0) then
                       write(LERR,*)'End of file on input:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',kk
                       go to 999
                    endif
                    call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec   , TRACEHEADER)
                    call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          itrc   , TRACEHEADER)
                    call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                          linind , TRACEHEADER)
                    call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                          dphind , TRACEHEADER)
                    call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          dstsgn , TRACEHEADER)
                    velsem(kk) = dstsgn

                    call saver2(itr,ifmt_hdrwdx,l_hdrwdx, ln_hdrwdx,
     1                          ICX   , TRACEHEADER)
                    call saver2(itr,ifmt_hdrwdy,l_hdrwdy, ln_hdrwdy,
     1                          ICY   , TRACEHEADER)

                    if (.not. first) then

                       IWRN = 0
                       CX = ICX
                       CY = ICY
                       CALL XFMFWD (CX,CY,ICLI,ICDI,CXT,CYT,BXT,BYT,
     1                      IWRN,IX1,IY1,XX,XY,YX,YY,XXT,XYT,YXT,YYT,
     2                      DX, DY, NDI, NLI)

                       if (ICLI .gt. 0 .AND. ICLI .lt. 9999999 .AND.
     1                     ICDI .gt. 0 .AND. ICDI .lt. 9999999) then

                          IF (ICLI .LT. MINLI) IWRN = 1
                          IF (ICLI .GT. MAXLI) IWRN = 1
                          IF (ICDI .LT. MINDI) IWRN = 1
                          IF (ICDI .GT. MAXDI) IWRN = 1

                          if (IWRN .eq. 1) go to 100
                          first = .true.

                       else

                          go to 100

                       endif

                    endif


  
                    istrc = (kk-1) * nsamp
                    call vmov (itr(ITHWP1),1, data(istrc+1),1, nsamp)

                enddo

                call picker
     1                  (ntrc,nsamp,nhor,JJ,si,velsem,log,ICDI,
     2                   vello,velhi,times,data,nord,dvel,ICLI,
     3                   next,thr,linear,igate,pikout,svel,
     4                   LH,verbos,vmin,vmax,nrec,nli,ndi,luout,
     5                   gamma,iscl,hmin,ic,below,above)

                if (LH .lt. 1) then
                    go to 100
                endif


100         CONTINUE

      ENDDO

  999 continue


c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      close ( luout )

            write(LERR,*)'end of horvel, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
            write(LER ,*)'end of horvel, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'horvel3d auto-picks semblance records driven by horizons and'
        write(LER,*)
     :'optional velocity fairway.'
        write(LER,*)
     :'see manual pages for details ( online by typing uman horvel )'
        write(LER,*)' '
        write(LER,*)
     :'execute horvel3d by typing horvel and the program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)  : input semblance data file name'
        write(LER,*)
     :' -O [otap]    (stdout) : output velocity (TDFN) file name'
        write(LER,*)
     :' -P [stkpik]  (none)   : picks of stacked reflector horizons'
        write(LER,*)
     :'                         xsd or Landmark format event file'
        write(LER,*)
     :' -v [velpik]  (none)   : picks defining velocity fairway (not'
        write(LER,*)
     :'                         used for 3D prestack gamma input'
        write(LER,*) ' '
        write(LER,*)
     :' -g [igate]     (8)    : number samples in semblance time gate'
        write(LER,*)
     :' -B  hang semblance time gate below horizon time, or...'
        write(LER,*)
     :' -A  hang semblance time gate above horizon time, or...'
        write(LER,*)
     :'     default is center semblance time gate on horizon time'
        write(LER,*)
     :' -t [thr]       (.25)  : semblance threshold to use'
        write(LER,*)
     :' -s [nord]      (5)    : order of semblance smoothing'
        write(LER,*)
     :' -p [next]      (3)    : number of semblance peaks to test'
        write(LER,*)
     :' -l [log]   (no log)   : send semblance curves for this rec'
        write(LER,*)
     :'                       : to stderr (plot file with xgraph)'
        write(LER,*)
     :' -vs [vmin]  (ignore)  : peg 0-time velocity'
        write(LER,*)
     :' -ve [vmax]  (ignore)  : peg trace end time velocity'
        write(LER,*)
     :' -hmin [hmin]   (2)    : minimum # horizons for valid function'
        write(LER,*)
     :'                         (for gamma option this is 1)'
      write(LER,*)' '
      write(LER,*)
     :' -x1[x1]      (def = none)  : X-coord of Corner 1 (N-E)'
      write(LER,*)
     :' -y1[y1]      (def = none)  : Y-coord of Corner 1 (N-E)'
      write(LER,*)
     :' -x2[x2]      (def = none)  : X-coord of Corner 2'
      write(LER,*)
     :' -y2[y2]      (def = none)  : Y-coord of Corner 2'
      write(LER,*)
     :' -x3[x3]      (def = none)  : X-coord of Corner 3'
      write(LER,*)
     :' -y3[y3]      (def = none)  : Y-coord of Corner 3'
      write(LER,*)
     :' -x4[x4]      (def = none)  : X-coord of Corner 4'
      write(LER,*)
     :' -y4[y4]      (def = none)  : Y-coord of Corner 4'
      write(LER,*)
     :' -ildm[ildm]  (def = none)  : spacing along 1-2 direction (dy)'
      write(LER,*)
     :' -cldm[cldm]  (def = none)  : spacing along 2-3 direction (dx)'
      write(LER,*)
     :' -Hwx[hdrwdx] (def = CDPBCX): trc hdr word for X-coordinates'
      write(LER,*)
     :' -Hwy[hdrwdy] (def = CDPBCY): trc hdr word for Y-coordinates'
        write(LER,*) ' '
        write(LER,*)
     :' -limin [limin] (Line Hdr) : minimum LI override'
        write(LER,*)
     :' -limax [limax] (Line Hdr) : maximum LI override'
        write(LER,*)
     :' -dimin [dimin] (Line Hdr) : minimum DI override'
        write(LER,*)
     :' -dimax [dimax] (Line Hdr) : maximum DI override'
        write(LER,*) ' '
        write(LER,*)
     :' -gamma input semblances are gamma records from 3D pre-stack migr
     :ation'
        write(LER,*)'-SM        : nf x nf point median smooth times'
        write(LER,*)
     :' -nf[nf]   (def = none)  : length of side of median smoother'
        write(LER,*)'-FT        : fit surface to times'
        write(LER,*)
     :' -ord[ord]  (def = 14)   : surface order'
        write(LER,*)
     :' -iter[iter] (def = 5)   : number iterations for surf fit'
        write(LER,*)
     :' -ityp[ityp] (def = 1)   : 1=robust fit; 0=least squares'
c       write(LER,*)
c    :' -L  do not remove linear trend from const time semblance profile
c    :s'
        write(LER,*)
     :' -I  turn off input surface time interpolator (use only for -FT)'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:'
        write(LER,*)
     :'        horvel3d -N[] -O[] -P[] -v[] -g[] -s[] -p[] -l[] -t[]'
        write(LER,*)
     :'               -x1[] -y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
        write(LER,*)
     :'               -ildm[] -icdm[] [ -Hwx[] -Hwy[] ]'
        write(LER,*)
     :'               [ -limin[] -limax[] -dimin[] -dimax[] ]'
        write(LER,*)
     :'               [ -hmin[] -vs[] -ve[] ] [ -gamma -V ]'
        write(LER,*)
     :'               [ -SM -nf[] ] [ -FT -ord[] -iter[] -ityp[] [-I] ]'
        write(LER,*)
     :'               [ -B -A ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,stkpik,velpik,lunstk,luout,lunvel,
     1                  igate,next,linear,thr,log,nord,verbos,
     2                  vmin,vmax,dmul,limin,limax,dimin,dimax,
     4                  debug,gamma,lmrk,f2m, m2f, nstk, lu_debug, xsd,
     5                  IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4, DY, DX,
     6                  hdrwdx, hdrwdy, hmin, notrp,
     7                  smooth, fit, iord, irtype, ilim, nf, below,
     8                  above)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     verbos  L        verbose output or not
c-----
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      character   ntap*(*), otap*(*), velpik*(*)
      character   hdrwdx * 6, hdrwdy * 6
      character * 256 stkpik(100)
      character   debug_file * 14
      logical     verbos, linear, debug, gamma, lmrk, f2m, m2f, xsd
      logical     smooth, fit, below, above, notrp
      integer     argis, lunstk(100), lunvel, nord, igate
      integer     limin, limax, dimin, dimax, hmin
      integer     IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4
 
      call alloclun ( lunvel )
      call alloclun ( luout  )
      debug_file = 'HORVEL3D_times'
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.

c     For example program prgm might be invoked in the following way:

c     prgm  -Nxyz -Oabc

c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"

c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
      smooth =   (argis('-SM') .gt. 0)
      fit    =   (argis('-FT') .gt. 0)

         if (fit .and. smooth) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in horvel3d:'
            write(LERR,*)'Cannot have both -SM & -FT'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in horvel3d:'
            write(LER ,*)'Cannot have both -SM & -FT'
            stop
         endif

      below  =   (argis('-B') .gt. 0)
      above  =   (argis('-A') .gt. 0)
      debug  =   (argis('-debug') .gt. 0)
      gamma  =   (argis('-gamma') .gt. 0)
      f2m    =   (argis( '-f2m' ) .gt. 0)
      m2f    =   (argis( '-m2f' ) .gt. 0)
      notrp  =   (argis( '-I' ) .gt. 0)

         call argi4 ('-ord' , iord, 0 , 0 )
         call argi4 ('-iter', ilim, 5 , 5 )
         call argi4 ('-ityp', irtype, 1 , 1 )
         if (fit) then
            if (iord .eq. 0) iord = 14
            if (iord .gt. 14) then
               write(LERR,*)' '
               write(LERR,*)'WARNING from horvel3d cmdln:'
               write(LERR,*)'Maximum surface order is 14; will reset'
               write(LERR,*)'your input of ',iord
               iord = 14
            endif
         endif

         call argi4 ('-nf', nf, 1 , 1 )
         if (smooth .AND. nf .ge. 3) then
            if (mod(nf,2) .eq. 0) then
                nf = nf + 1
            endif
         elseif (smooth .AND. nf .lt. 3) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in horvel3d:'
            write(LERR,*)'Must have smoothing length >= 3'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in horvel3d:'
            write(LER ,*)'Must have smoothing length >= 3'
            stop
         endif

          call argstr( '-N', ntap, ' ', ' ' )
          call argstr( '-O', otap, ' ', ' ' )
          nstk = 0
          do  j = 1, 100
              call argstr( '-P', stkpik(j), ' ', ' ' )
              if (stkpik(j) .ne. ' ') then
                 nstk = nstk + 1
                 call alloclun ( lunstk(j) )
              endif
          enddo

          call argstr( '-v', velpik, ' ', ' ' )
          call argr4 ( '-lidmi', lidmi, 0.0, 0.0)
          call argr4 ( '-didmi', didmi, 0.0, 0.0)
          call argr4 ( '-lidmo', lidmo, 0.0, 0.0)
          call argr4 ( '-didmo', didmo, 0.0, 0.0)

          call argi4 ( '-limin', limin ,  0  , 0    )
          call argi4 ( '-limax', limax ,  0  , 0    )
          call argi4 ( '-dimin', dimin ,  0  , 0    )
          call argi4 ( '-dimax', dimax ,  0  , 0    )

          call argstr( '-Hwx', hdrwdx, 'CDPBCX', 'CDPBCX' )
          call argstr( '-Hwy', hdrwdy, 'CDPBCY', 'CDPBCY' )

          call argi4 ('-x1', ix1, 0 , 0 )
          call argi4 ('-y1', iy1, 0 , 0 )
 
          call argi4 ('-x2', ix2, 0 , 0 )
          call argi4 ('-y2', iy2, 0 , 0 )
 
          call argi4 ('-x3', ix3, 0 , 0 )
          call argi4 ('-y3', iy3, 0 , 0 )
 
          call argi4 ('-x4', ix4, 0 , 0 )
          call argi4 ('-y4', iy4, 0 , 0 )
    
          call argr4 ('-cldm', dx, 0., 0.)
     
          if (dx .eq. 0.) then
             write(LERR,*)' '
             write(LERR,*)'Fatal Error in horvel3d:'
             write(LERR,*)'Must enter x-line cell dimension -cldm[]'
             write(LER ,*)' '
             write(LER ,*)'Fatal Error in horvel3d:'
             write(LER ,*)'Must enter x-line cell dimension -cldm[]'
             stop
          endif

          call argr4 ('-ildm', dy, 0., 0.)
 
          if (dy .eq. 0.) then
             write(LERR,*)' '
             write(LERR,*)'Fatal Error in horvel3d:'
             write(LERR,*)'Must enter inline cell dimension -cldm[]'
             write(LER ,*)' '
             write(LER ,*)'Fatal Error in horvel3d:'
             write(LER ,*)'Must enter inline cell dimension -ildm[]'
             stop
          endif

          if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1         .AND.
     2         ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3         then
             write(LERR,*)' '
             write(LERR,*)'Fatal Error in horvel3d:'
             write(LERR,*)'Must enter 4 corners of survey using -x1[]'
             write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
             write(LER ,*)' '
             write(LER ,*)'Fatal Error in horvel3d:'
             write(LER ,*)'Must enter 4 corners of survey using -x1[]'
             write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
             stop
          endif


            call argi4 ( '-hmin', hmin, 0, 0)
            call argi4 ( '-s', nord, 5, 5)
            call argi4 ( '-l', log, 0, 0)
            call argi4 ( '-p', next, 3, 3)
            call argi4 ( '-g', igate, 0, 0)
            call argr4 ( '-t', thr, .25, .25)
            call argr4 ( '-vs', vmin, 0.0, 0.0)
            call argr4 ( '-ve', vmax, 0.0, 0.0)
            call argr4 ( '-d', dmul, 1.0, 1.0)

            IF (gamma) THEN
                if (igate .eq. 0) igate = 4
                if (hmin .eq. 0) hmin = 1
            ELSE
                if (igate .eq. 0) igate = 8
                if (hmin .eq. 0) hmin = 2
            ENDIF

            if (hmin .gt. nstk) hmin = nstk

            IF (nstk .eq. 0) THEN

               write(LERR,*)'Must enter picks of reflectors from stcked'
               write(LERR,*)'section using  -P[]  cmd line arg'
               stop

            ENDIF

            IF (.not.gamma .AND. (velpik(1:1) .eq. ' ') ) THEN

               write(LERR,*)'Must enter pickfile containing 2 velocity'
               write(LERR,*)'pick segments defining semblance fairway'
               stop

            ENDIF

            IF (otap(1:1) .eq. ' ') THEN
               luout = LOT
            ELSE
               open (unit=luout,file=otap,status='unknown',iostat=ierr)
    
               if (ierr .ne. 0) then
                  write(LERR,*)'Could not open output velocity file ',
     1                          otap
                  write(LERR,*)'Check directory permissions'
                  stop
               endif
            ENDIF

            DO  j = 1, nstk
                open (unit=lunstk(j),file=stkpik(j),status='old',
     1                iostat=ierr)
                if (ierr .ne. 0) then
                   write(LERR,*)'Could not open stkpik file ',stkpik(j)
                   write(LERR,*)'Check existence'
                   stop
                endif
            ENDDO

            IF (.not. gamma) THEN
               open (unit=lunvel,file=velpik,status='old',iostat=ierr)

               if (ierr .ne. 0) then
                  write(LERR,*)'Could not open velpik file ',velpik
                  write(LERR,*)'Check existence'
                  stop
               endif
            ENDIF

c---
c  if -XSD is set the landmark flag is made false, otherwise lmrk is true
c---
            lmrk   = .true.
            xsd    = .false.
            xsd    =   (argis('-XSD') .gt. 0)
            if (xsd) lmrk = .false.

            linear =   (argis('-L') .gt. 0)
            verbos =   (argis('-V') .gt. 0)

      if ( gamma ) linear = .true.

      if (debug) then
         call alloclun ( lu_debug )
         open (unit= lu_debug, file=debug_file,status='unknown',
     1         iostat=ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'WARNING from horvel3d:'
            write(LERR,*)'Could not open time debug file.'
            write(LERR,*)'Check permissions in working directory'
            debug = .false.
         endif
      endif


c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,stkpik,velpik,vmin,vmax,
     2                  limin,limax,dimin,dimax,resamp,
     3                  gamma, lmrk,minli,maxli,mindi,maxdi,
     4                  nli,ndi,nhor,iscl,xsd,hmin,igate,thr,
     6                  smooth,nf,fit,iord,irtype,below,above)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec, iform, hmin
      integer     limin,limax,dimin,dimax
      integer     minli,maxli,mindi,maxdi,nli,ndi,iscl,igate
      character   ntap*(*), otap*(*), velpik*(*)
      character * 256 stkpik(100)
      logical     resamp, gamma, lmrk, xsd, smooth, fit
      logical     below, above
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name    =  ', ntap
            write(LERR,*) ' output data set name   =  ', otap
            do  j = 1, nhor
            write(LERR,*) ' stack horizon picks    =  ',stkpik(j)
            enddo
            write(LERR,*) ' velocity fairway picks =  ',velpik
            if (vmin .ne. 0.0)
     1      write(LERR,*) ' Minimum velocity at time zero = ',vmin
            if (vmax .ne. 0.0)
     1      write(LERR,*) ' Maximum velocity at trace end = ',vmax
            write(LERR,*) ' Minimum # horizons for valid function =  ',
     1      hmin
            write(LERR,*) ' Input Survey Limits'
            write(LERR,*) ' Min LI in survey =  ', limin
            write(LERR,*) ' Max LI in survey =  ', limax
            write(LERR,*) ' Min DI in survey =  ', dimin
            write(LERR,*) ' Max DI in survey =  ', dimax
            write(LERR,*) ' Extracted Survey Limits'
            write(LERR,*) ' Min LI in survey =  ', minli
            write(LERR,*) ' Max LI in survey =  ', maxli
            write(LERR,*) ' Min DI in survey =  ', mindi
            write(LERR,*) ' Max DI in survey =  ', maxdi

      write(LER ,*)' '
      write(LER ,*)'*********************************'
      write(LER ,*)' '
      write(LER ,*)'Min LI asked for =  ',minli
      write(LER ,*)'Max LI asked for =  ',maxli
      write(LER ,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER ,*)'Min DI asked for =  ',mindi
      write(LER ,*)'Max DI asked for =  ',maxdi
      write(LER ,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER ,*)'*********************************'
      write(LER ,*)' '

            if (lmrk) then
            write(LERR,*) ' Stack picks in Landmark horizon file format'
            elseif (xsd) then
            write(LERR,*) ' Stack picks in xsd file format'
            endif
            if (gamma) then
            write(LERR,*) ' Input semblances from 3D prestack migration'
            write(LERR,*) ' Gamma scale factor=  ',iscl
            else
            write(LERR,*) ' Input semblances standard velocity spectra'
            endif

            write(LERR,*)' '
            if (below) then
            write(LERR,*)' Semblance gate length = ',2*igate
            write(LERR,*)' gate hung below horizon times'
            elseif (above) then
            write(LERR,*)' Semblance gate length = ',2*igate
            write(LERR,*)' gate hung above horizon times'
            else
            write(LERR,*)' Semblance gate length = ',igate
            write(LERR,*)' gate centered on horizon times'
            endif
            write(LERR,*)' semblance threshold   = ',thr
            write(LERR,*)' '

            if (smooth) then
            write(LERR,*) ' Doing median smoothing using ',nf,' x ',nf
            write(LERR,*) ' smoothing box'
            endif
            if (fit) then
            write(LERR,*) ' Doing surface fit:'
            write(LERR,*) '   fit type= ',irtype
            write(LERR,*) '   (1=robust; 0=least squares)'
            write(LERR,*) '   input order = ',iord
            endif
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
