C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine lmrd (iunit, nli, ndi, nhor, limin, limax, 
     1                 dimin, dimax, times, SZSMPD, si, debug,
     2                 IX1, IY1, DX, DY, XX, XY, YX, YY,
     3                 XXT, XYT, YXT, YYT, xyscl, verbos,
     4                 lu_debug, smooth, fit, iord, irtype, ilim,
     5                 nf, notrp)

#include <f77/iounit.h>

      real       times (ndi, nli, nhor)

      integer    iunit (*)
      integer    limin, limax, dimin, dimax, SZSMPD, lu_debug
      REAL*8     XX, XY, YX, YY, XXT, XYT, YXT, YYT
      logical    debug, verbos, smooth, fit, notrp

      write(LERR,*)' '
      write(LERR,*)'Horizon pick read messages:'
      write(LERR,*)' '

c----
c   read in all landmark horizons from the various horz files
c   store times in "times"
c----

      DO  j = 1, nhor

          lupik = iunit (j)
          call lanmrk (lupik, times(1,1,j), IX1, IY1,
     1                  XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                  DX, DY, NDI, NLI, limin, limax,
     3                  dimin, dimax, xyscl, verbos)
      ENDDO

      write(LERR,*)' '
      if (verbos) then
      write(LERR,*)'Functions As Read In'
      write(LERR,*)' '
      do  k = 1, nhor
          do  j = 1, nli
              do  i = 1, ndi
                  tt = times (i,j,k)
                  if (tt .gt. 0.)
     1            write(LERR,*)'Horizon= ',k,' LI= ',j,' DI= ',i,
     2                      ' time= ',tt
              enddo
          enddo
          write (LERR,777)
777       format ()
      enddo
      endif
      write(LERR,*)' '


      write(LERR,*)' '
      write(LERR,*)'From pick file:'
      write(LERR,*)'Min LI ',limin,'  Max LI ',limax
      write(LERR,*)'Min DI ',dimin,'  Max DI ',dimax
      write(LERR,*)' '

c-----
c  do 2Dx2D interpolation of the input times, matrices for each horizon
c  ensuring we have no zeroes in the horizon time arrays
c-----
      if ( .not. notrp) then

         do  k = 1, nhor
   
             call trp2d (limin, limax, dimin, dimax, nli, ndi,
     1                   times(1, 1, k), SZSMPD)
         enddo
      endif


c-----
c   optionally we can either fit a specific order surface to each horizon
c   time array (0=robust; 1=least squares), or do median smoothing of
c   each horz time array
c-----
      IF (fit .or. smooth) THEN

         do  k = 1, nhor

            call timmod (nli, ndi, nf, times(1, 1, k), smooth, fit,
     1                   iord, irtype, ilim, SZSMPD)
         enddo

      ENDIF


c-----
c  we can write out the modified horizon arrays into one big ascii file,
c  i.e. can be plotted using plotxy
c-----
      write(LERR,*)' '
      if (debug) then
         do  k = 1, nhor
         do  j = 1, nli
         do  i = 1, ndi
             write(lu_debug,555)
     1           j,i,times(i,j,k)
         enddo
         enddo
         write(lu_debug,777)
555      format (2i5,5x,f10.3)
         enddo
      endif
      write(LERR,*)' '

      return

666   continue
      write(LERR,*)'FATAL ERROR in reading pick file'
      write(LER ,*)'FATAL ERROR in reading pick file'
      stop 666
999   continue
      write(LERR,*)'FATAL ERROR in pick file: premature end of file'
      write(LER ,*)'FATAL ERROR in pick file: premature end of file'
      stop 666

      end
