C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine picker (ntrc,nsamp,nhor,jrec,si,velsem,log,di,
     1                   vello,velhi,times,data,nord,dvel,li,
     2                   next,thr,linear,igate,pikout,svel,
     3                   LH,verbos,vmn,vmx,nrecs,nli,ndi,luout,
     4                   gamma,iscl,hmin,il,below,above)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real      times (ndi, nli, nhor)
      real      data  (nsamp, ntrc)
      real      velsem(ntrc), vello(nsamp), velhi(nsamp)

      real      sem(SZLNHD), velf(SZLNHD), tf(SZLNHD), sig(SZLNHD)
      integer   jhor(SZLNHD), key(SZLNHD), itim(SZLNHD), ivel(SZLNHD)
      real      vp(SZLNHD)
      integer   ip(SZLNHD)
      integer   pass, di, li, currec, hmin, il
      character tag * 4

      integer   nord,log
      logical   linear, gamma, first, below, above
      logical   verbos

      tag = 'TDFN'
      ir0 = 0
      ir1 = 1
      i9  = 9
      igate2 = 2 * igate

c     write(0,*)' '
c     write(0,*)igate,igate2
c     write(0,*)(velsem(ii),ii=1,ntrc)

      if (gamma) then
c        scl = iscl
         scl = 1.0
      else
         scl = 1.0
      endif

      iflag = 0
      currec = (li-1) * ndi + di

c++++++
c  do automatic picking of semblance matrices for each horizon
c++++++

      write(LERR,*)' '

      LH = 0
      LF = 0
      vlast = 0

      DO  J = 1, nhor

          tj    = times(di,li,J)

c-------------------------------------------------------------------------
        IF (tj .ge. 0.) THEN


          itj   = tj / si + 1

          if (below) then
             itj1  = itj
             itj2  = itj + igate2
          elseif (above) then
             itj1  = itj - igate2
             itj2  = itj
          else
             itj1  = itj - igate
             itj2  = itj + igate
          endif

          if (itj1 .lt.     1) itj1 = 1
          if (itj2 .gt. nsamp) itj2 = nsamp

          vl    = vello(itj)
          vh    = velhi(itj)
          pass  = 0
          first = .true.

c     write(0,*)'j= ',j,tj,itj,vl,vh,(velsem(ii),ii=1,ntrc)
c     write(0,*)'j= ',j,li,di,tj,itj,vl,vh,itj1,itj2
c     write(0,*)'H,li,di,il,itj,tj= ',j,li,di,il,itj,tj

          do  k = 1, ntrc
              sem (k) = 0.
              sig (k) = 0.
          enddo

c----
c  within velocity fairway limits extract semblances over time gate and
c  stack within gate to build S/N
c----
          do  k = 1, ntrc

              vv = velsem(k)
              if (vv .ge. vl .AND. vv .le. vh) then
                 sem (k) = 0.
                 do  ii = itj1, itj2
                     amp = data(ii,k)
                     if (amp .gt. 0.0) then
                        sem (k) = sem (k) + data(ii,k)
                        sig (k) = sig (k) + 1.0
                     endif
                 enddo
              else
                 sem (k) = 0.0
              endif

          enddo

c----
c  check to see if any stacked semblance outliers are zero and compute where
c----
          do  k = 1, ntrc
              if (sem(k) .ne. 0.0) then
                  ivs = k
                  go to 31
              endif
          enddo
31        continue
 
          do  k = ntrc, ivs, -1
              if (sem(k) .ne. 0.0) then
                  ive = k
                  go to 41
              endif
          enddo
41        continue
 
 
          nc  = ive - ivs + 1

          if (nc .lt. 3) then
              write(LERR,*)'WARNING: semblances were all zero for'
              write(LERR,*)'stack DI/LI ',di,li,' semb rec ',jrec
              write(LERR,*)'horizon ',J,'  Horizon skipped.'
              go to 200
          endif

          xmin = velsem (ivs)
          xmax = velsem (ive)
c----
c   smooth composite semblance
c----
          if ( (nc/2+1 .ge. nord) .AND. (nord .ge. 3) )
     1    call SmoothFit ( sem(ivs), nc, nord )
c    1    call nave (nc, nord, sem(ivs))

c     write(0,*)(sem(ii),ii=1,ntrc)

          if (log .ne. 0) then
          if (mod(currec,log) .eq. 0) then

             write(LER,*)'"horz= ',J
             do l = 1, nc
                write(LER,*)ivs+l-1,sem(ivs+l-1)
             enddo
             write(LER,'()')

          endif
          endif

c----
c   normalize composite semblance
c----
          do  k = 1, ntrc
              if ( sig(k) .gt. 0.0 ) then
                 sem (k) = sem (k) / sig (k)
              endif
              sig (k) = 1.0
          enddo

c----
c   accept only those semblance values above threshold
c----
          do  k = 1, ntrc
              if ( sem(k) .lt. thr ) sem (k) = 0.
          enddo

c     write(0,*)(sem(ivs+ii-1),ii=1,nc)
c     call maxmgv (sem(ivs), 1, smax, sloc, nc)

          call peak   (sem, ntrc, iflag, vp, ip, np)
 
          if (np .eq. 0) then
              write(LERR,*)'WARNING: semblances were all zero for'
              write(LERR,*)'stack rec ',currec,' semb rec ',jrec
              write(LERR,*)'horizon ',J,'  Horizon skipped.'
              go to 200
          endif
 
100       continue
 
          call maxmgv (vp, 1, vmax, lc, np)
          locv = ip (lc)
          if (locv .gt. ivs .and. locv .lt. ive) then
             c1 = sem(locv-1)
             c2 = sem(locv  )
             c3 = sem(locv+1)
             call parab (c1, c2, c3, fv, vdum)
             delv = 0.5 * ( velsem(locv+1) - velsem(locv-1) )
             velcur = velsem(locv) + fv * delv
          else
             velcur = velsem(locv)
          endif
 
c     write(0,*)'H,il,itj,tj,itj1,itj2,tt/l= ',
c    1j,il,itj,tj,itj1,itj2,velcur,locv

c***********
          if (locv .le. ivs .OR. locv .ge. ive) then
 
             write(LERR,*)'WARNING: picker hit edge of fairway at'
             write(LERR,*)'rec= ',currec,' horz= ',J,' lo vel= ',vl,
     1                    ' vel= ',velcur,' hi vel= ',vh,ivs,locv,ive
             write(LERR,*)(vp(ii),ii=1,np)
             write(LERR,*)(ip(ii),ii=1,np)
 
             if (next .gt. 1) then
                 pass = pass + 1
                 if (pass .gt. next .or. pass+1 .gt. np) then
                    write(LERR,*)'Could not find alternate peak: horizon
     1 skipped'
                    go to 200
                 endif
                 write(LERR,*)'...trying alternate peak ',pass+1
                 vp (lc) = 0.
                 go to 100
              endif
 
          endif
c***********


          if (log .ne. 0) then
          if (mod(currec,log) .eq. 0) then
 
             write(LER,*)'"horz_smooth= ',J
             do l = 1, nc
                write(LER,*)ivs+l-1,sem(ivs+l-1)
             enddo
             write(LER,'()')
 
          endif
          endif

          LH = LH + 1
          jhor(LH) = J
          velf(LH) = velcur
          tf  (LH) = times(di, li, J)

          vlast = velcur

200       continue

        ENDIF
c-------------------------------------------------------------------------

      ENDDO

      IF (LH .lt. hmin) THEN

         write(LERR,*)'Less than ',hmin,' horizons picked: location skip
     1ped'
         return

      ELSE

c----
c  for the case of min # horizons == 1 we will duplicate the times
c  and velocities to make 2 identical "picks"
c----
         if (LH .eq. 1) then
             LH = 2
             tf (2)   = tf (1)
             tf (1)   = 0
             velf (2) = velf (1)
             jhor (1) = 0
             jhor (2) = 1

         else

            call sortr (tf, key, LH)
            do  i = 1, LH
                sig (i) = velf (key(i))
                ip  (i) = jhor (key(i))
            enddo
            do  i = 1, LH
                velf (i) = sig (i)
                jhor (i) = ip  (i)
            enddo

         endif

         if (vmn .gt. 0.0) then
            do  i = LH, 1, -1
                velf (i+1) = velf (i)
                tf   (i+1) = tf   (i)
            enddo
            velf (1) = vmn
            tf   (1) = 0
            LH = LH + 1
         endif

         if (vmx .gt. 0.) then
            LH = LH + 1
            velf (LH) = vmx
            tf   (LH) = (nsamp-1) * si
         endif

         do  i = 1, 100
             itim (i) = 0
             ivel (i) = 0
         enddo

         do  j = 1, LH
          jh = jhor(j)
          ivel (j) = nint (scl * velf (j) )
          if ( gamma ) then
             itim (j) = nint (tf   (j) / si )
          else
             itim (j) = nint (tf   (j) )
          endif
             write(LERR,*)'DI/LI= ',di,li,'  Horz= ',jh,'  time = ',
     1                     itim(j),'  velocity= ', ivel(j)
c            write(LER ,*)'DI/LI= ',di,li,'  Horz= ',jh,'  time = ',
c    1                     itim(j),'  velocity= ', ivel(j)
         enddo

         cards = float (LH) / 7.0
         ncards = ifix (cards - .001)
         left   = LH - 7 * ncards
         ih = -7
         write (luout,555) ir0, tag, li, di
555      format (i1, a4, 2i5)
         if (ncards .gt. 0) then
            do  i = 1, ncards
                ih = (i-1) * 7
                write (luout,777) i, tag,
     1          (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
            enddo
         endif
         ih = ih + 7
         write (luout,777) i9, tag,
     1   (itim(ih+ii), ivel(ih+ii), ii = 1, 7), li
777      format (i1, a4, 7(I4,I5), 7X, I5)

      ENDIF


      return
      end
