C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine timmod (nli, ndi, nf, times,
     1                   smooth, fit, iord, irtype, ilim,
     2                   SZSMPD)

c----
c   fit surface to array "times", or median smooth array, or
c   do nothing to "times"
c----

#include <f77/iounit.h>

      real     times (ndi, nli)
      integer  nli, ndi, nf, SZSMPD

      
      real     work, filter
      real*8   space, trace, sample, ampls
      pointer  (wkspace, space (1))
      pointer  (wkampls, ampls (1))
      pointer  (wktrace, trace (1))
      pointer  (wksample, sample (1))
      pointer  (wkfilter, filter (1))
      pointer  (wkwork  , work   (1))
      integer  irtype,limord,ndf1(14),ndf2(14),ndf3,minord
      integer  if1max,ifumax,ipoly,ilim,ierr,itrial(14)

      real*8   coef(680),reg(14),ssr(14),ssd(14),sst,f1(14)
      real*8   delta

      logical  fit, smooth

      IF (fit) THEN

         delta = 1.0d-6

         item  = 2 * nli * ndi + 2
         items = 2 * item + 680 * 2
         itemw = nli * ndi
         itemf = 1


         call galloc (wkspace,  items * SZSMPD, ierr1, iab)
         call galloc (wkampls,  item  * SZSMPD, ierr2, iab)
         call galloc (wktrace,  item  * SZSMPD, ierr3, iab)
         call galloc (wksample, item  * SZSMPD, ierr4, iab)
         call galloc (wkwork  , itemw * SZSMPD, ierr5, iab)
         call galloc (wkfilter, itemf * SZSMPD, ierr0, iab)
         if (ierr1.ne.0 .or. ierr2.ne.0 .or. ierr3.ne.0 .or.
     1       ierr4.ne.0 .or. ierr5.ne.0) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR'
            write(LERR,*)'Unable to allocate workspace (horvel3d):'
            write(LERR,*)items * SZSMPD,'  bytes'
            write(LERR,*)item * SZSMPD,'  bytes'
            write(LERR,*)item * SZSMPD,'  bytes'
            write(LERR,*)item * SZSMPD,'  bytes'
            write(LERR,*)itemw * SZSMPD,'  bytes'
            write(LER ,*)' '
            write(LER ,*)'FATAL ERROR'
            write(LER ,*)'Unable to allocate workspace (horvel3d):'
            write(LER ,*)items * SZSMPD,'  bytes'
            write(LER ,*)item * SZSMPD,'  bytes'
            write(LER ,*)item * SZSMPD,'  bytes'
            write(LER ,*)item * SZSMPD,'  bytes'
            write(LER ,*)itemw * SZSMPD,'  bytes'
            stop
         endif

         ic = 0
         do  j = 1, nli
             do  i = 1, ndi
                 ic = ic + 1
                 sample (ic) = dble (i)
                 trace  (ic) = dble (j)
                 ampls  (ic) = dble (times(i,j))
             enddo
         enddo
         nlidi = nli * ndi

         limord = 14
         isord  = iord

         call rob3sb(trace,sample,ampls,nlidi,irtype,limord,
     1               coef,reg,ssr,ssd,sst,ndf1,ndf2,ndf3,f1,minord,
     2               if1max,ifumax,ipoly,ilim,delta,ierr,itrial,
     3               space,isord)

         write(LERR,*)' '
         write(LERR,*)'Fit completed:'
         write(LERR,*)'min significant order  = ',minord
         write(LERR,*)'max significant order  = ',ifumax
         write(LERR,*)'recommended surf order = ',ipoly
         write(LERR,*)' '
         if (ipoly .eq. 0) then
            write(LER,*)'FATAL ERROR in horvel3d surface fit:'
            write(LER,*)'Something bad happened in the fit, ierr= ',
     1      ierr
            write(LER,*)'ierr=1: insufficient data points to fit'
            write(LER,*)'ierr=2: no significant polynomial relationship 
     1found'
            stop 666
         endif

         iloc = ipoly*(ipoly+1) * (ipoly +2)/6

         call surfgen (ipoly,coef(iloc),ndi,nli,work)

         call gfree (wkspace)
         call gfree (wkampls)
         call gfree (wktrace)
         call gfree (wksample)

      ELSEIF (smooth) THEN

         itemw = nli * ndi
         itemf = nf * nf
         call galloc (wkfilter, itemf * SZSMPD, ierr1, iab)
         call galloc (wkwork  , itemw * SZSMPD, ierr2, iab)
         if (ierr1.ne.0 .or. ierr2.ne.0) then
            write(LERR,*)' '
            write(LERR,*)'FATAL ERROR'
            write(LERR,*)'Unable to allocate workspace (horvel3d):'
            write(LERR,*)itemw * SZSMPD,'  bytes'
            write(LERR,*)itemf * SZSMPD,'  bytes'
            write(LER ,*)' '
            write(LER ,*)'FATAL ERROR'
            write(LER ,*)'Unable to allocate workspace (horvel3d):'
            write(LERR,*)itemw * SZSMPD,'  bytes'
            write(LERR,*)itemf * SZSMPD,'  bytes'
            stop
         endif

         call smth2d (nf, nli, ndi, filter, times, work)

      ELSE

         return

      ENDIF

      do  j = 1, nli
         do  i = 1, ndi
            ipntr = (j - 1) * ndi + i
            times (i,j) = work (ipntr)
         enddo
      enddo

      call gfree (wkwork)
      call gfree (wkfilter)



      return
      end
