C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  horzn_limit: read velocity flat files for 3D
C                     and using XY info and LI/DI limits output
c                            of given ampl. at specified times

c     currently reads the following format styles:
c     digicon
c     bfile
c     geco
C
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     argis
      real        fmscl, mfscl
#include <f77/pid.h>
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     limin, limax, dimin, dimax
      integer     luin , luout, il, nl
      
      CHARACTER   NAME * 11, ntap * 256, otap * 256

      logical     verbos,gecovel,bfilevel
      logical     f2m, m2f
 
      DATA NAME     /'HORZN_LIMIT'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./

      fmscl = 0.30480
      mfscl = 3.28084

c--------------------------------
c  get online help if necesssary
c--------------------------------
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(ntap,otap,limin,limax,dimin,dimax,verbos,
     1           IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,luin,luout,
     2           gecovel,bfilevel,f2m,m2f)

c----
c  XY feet -> m or m-> feet scaler
c----
          if     ( f2m ) then
             xyscl = fmscl
          elseif ( m2f ) then
             xyscl = mfscl
          else
             xyscl = 1.0
          endif

     
C**********************************************************************C
C     build LI/DI coordinates
C**********************************************************************C
      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

      if (limax .eq. 0) then
          maxli = NX
      else
          maxli = limax
      endif
      if (limin .eq. 0) then
          minli = 1
      else
          minli = limin
      endif
      if (dimax .eq. 0) then
          maxdi = NY
      else
          maxdi = dimax
      endif
      if (dimin .eq. 0) then
          mindi = 1
      else
          mindi = dimin
      endif

      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1
 
      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'XY scaler        =  ',xyscl
      write(LER,*)'*********************************'
      write(LER,*)' '

c----
c   read input file, output entries whose XYs fall within survey bounds
c----
      call timmat (luin, luout, minli, maxli, mindi, maxdi, nli, ndi,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, xyscl, verbos, il, nl)


999   continue

      write(LERR,*)'horzn_limit completed processing ',nl,' entries',
     1             ' output ',il,' entries'
      write(LER ,*)'horzn_limit completed processing ',nl,' entries',
     1             ' output ',il,' entries'

      close (luin)
      close (luout)

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for horzn_limit: read flat'
        write(LER,*)'file of 3D workstation time picks keyed to XYs'
        write(LER,*)'and output only those entries within input survey'
        write(LER,*)'bounds'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap] (def = stdin) : input seismic data'
        write(LER,*)'-O[otap] (def = stdout): output seismic data'
        write(LER,*)' '
        write(LER,*)
     :' -x1[x1]      (def = none)  : X-coord of Corner 1 (N-E)'
        write(LER,*)
     :' -y1[y1]      (def = none)  : Y-coord of Corner 1 (N-E)'
        write(LER,*)
     :' -x2[x2]      (def = none)  : X-coord of Corner 2'
        write(LER,*)
     :' -y2[y2]      (def = none)  : Y-coord of Corner 2'
        write(LER,*)
     :' -x3[x3]      (def = none)  : X-coord of Corner 3'
        write(LER,*)
     :' -y3[y3]      (def = none)  : Y-coord of Corner 3'
        write(LER,*)
     :' -x4[x4]      (def = none)  : X-coord of Corner 4'
        write(LER,*)
     :' -y4[y4]      (def = none)  : Y-coord of Corner 4'
        write(LER,*)
     :' -ildm[ildm]  (def = none)  : spacing along 1-2 direction (dy)'
        write(LER,*)
     :' -cldm[cldm]  (def = none)  : spacing along 2-3 direction (dx)'

        write(LER,*)' '
        write(LER,*)'-f2m       : scale XYs from feet to meters'
        write(LER,*)'-m2f       : scale XYs from meters to feet'
        write(LER,*)'             otherwise no XY scaling'
c       write(LER,*)'-I         : turn off interpolation/extrapolation'
c       write(LER,*)'-geco      : input velocity file is GECO format'
c       write(LER,*)'-bfile     : input velocity file is BFILE format'
        write(LER,*)'             pick file is Landmark format'
        write(LER,*)'-V         : verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'   horzn_limit -N[] -O[] -x1[] -y1[] -x2[]'
        write(LER,*)'             -y2[] -x3[] -y3[] -x4[] -y4[]'
        write(LER,*)'             -ildm[] -icdm[] [ -V ]'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     otap  - C*100  output file name
c      t0   - R      normal incidence time
c       v   - R      velocity (ft/s or m/s)
c      x0   - R      near offset
c     ntr   - I      number traces
c     nsi   - I      sample interval
c     amp   - R      amplitude of spikes
c      ns   - I      number samples
c    refl   - L      reflection
c    refr   - L      refraction
c    up     - L      updip refraction
c    down   - L      downdip refraction
c    dip    - R      dip angle of reflector/refractor
c    v2     - R      velocity below refractor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,limin,limax,dimin,dimax,
     1                 verbos,IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,
     2                 luin,luout,gecovel,bfilevel,
     3                 f2m,m2f)

#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    argis
      integer    limin,limax,dimin,dimax
      logical    verbos,gecovel,bfilevel,f2m,m2f

         call argstr ('-N',ntap,' ',' ')
         call argstr ('-O',otap,' ',' ')

         if (ntap(1:1) .eq. ' ' ) then
             luin = LIN
         else
             call alloclun ( luin )
             ln = lenth ( ntap )

             open (luin, file = ntap(1:ln), status = 'old',
     :             iostat = ierr)
             if(ierr .ne. 0) then
                write(LER,*)'horzn_limit: Could not open input pick file
     : ', ntap
                write(LER,*)'Check permissions/spelling and rerun'
                write(LER,*)'FATAL'
                stop
             endif
         endif

         if (otap(1:1) .eq. ' ' ) then
             luout = LOT
         else
             call alloclun ( luout )
             lo = lenth ( otap )
             open (luout, file = otap(1:lo), status = 'unknown',
     :             iostat = ierr)
             if(ierr .ne. 0) then
                write(LER,*)'horzn_limit: Could not open output pick fil
     :e ', otap
                write(LER,*)'Check permissions/spelling and rerun '
                write(LER,*)'FATAL'
                stop
             endif
         endif

         call argi4 ('-x1', ix1, 0 , 0 )
         call argi4 ('-y1', iy1, 0 , 0 )
 
         call argi4 ('-x2', ix2, 0 , 0 )
         call argi4 ('-y2', iy2, 0 , 0 )
 
         call argi4 ('-x3', ix3, 0 , 0 )
         call argi4 ('-y3', iy3, 0 , 0 )
 
         call argi4 ('-x4', ix4, 0 , 0 )
         call argi4 ('-y4', iy4, 0 , 0 )
 
         call argr4 ('-cldm', dx, 0., 0.)
         call argr4 ('-ildm', dy, 0., 0.)
 
         if (dx .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in horzn_limit:'
            write(LERR,*)'Must enter x-line cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in horzn_limit:'
            write(LER ,*)'Must enter x-line cell dimension -cldm[]'
            stop
         endif
 
         if (dy .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in horzn_limit:'
            write(LERR,*)'Must enter inline cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in horzn_limit:'
            write(LER ,*)'Must enter inline cell dimension -ildm[]'
            stop
         endif
 
         if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1   .AND.
     2       ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3   then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in horzn_limit:'
            write(LERR,*)'Must enter 4 corners of survey using -x1[]'
            write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in horzn_limit:'
            write(LER ,*)'Must enter 4 corners of survey using -x1[]'
            write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            stop
         endif

         call argi4 ('-dimin', MINDI , 1 , 1 )
         call argi4 ('-dimax', MAXDI , 0 , 0 )
         call argi4 ('-limin', MINLI , 1 , 1 )
         call argi4 ('-limax', MAXLI , 0 , 0 )

         f2m       = ( argis( '-f2m' ) .gt. 0 )
         m2f       = ( argis( '-m2f' ) .gt. 0 )
         gecovel   = ( argis( '-geco' ) .gt. 0 )
         bfilevel  = ( argis( '-bfile' ) .gt. 0 )
         verbos    = ( argis( '-V' ) .gt. 0 )

      return
      end
