c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
C***********************************************************************
C Copyright 2001, Allied Geophysics, Inc. All Rights Reserved          *
C***********************************************************************
c***********************************************************************
c find the sample of the first occurence of a specific value
c***********************************************************************
      subroutine find_val ( Trc,n1,val,isamp,lfwd )

      implicit none

c Arguments
      integer n1,isamp
      real    Trc(n1), val
      logical lfwd

c Local variables
      integer i1
      logical lfound

c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c Initialize
      lfound = .false.

c Select the search direction

      if (lfwd) then

c Search from front to back

        i1 = 0
        do while (.not.lfound .and. i1.lt.n1)
          i1 = i1+1
          if (Trc(i1) .eq. val) lfound = .true.
        enddo

      else

c Search from back to front

        i1 = n1+1
        do while (.not.lfound .and. i1.gt.1)
          i1 = i1-1
          if (Trc(i1) .eq. val) lfound = .true.
        enddo

      endif

c Set the value of Sample

      isamp = -1
      if (lfound) isamp = i1

c All done

      return
      end
