C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetNavData ( lunav, ntrc, FieldRecNum, Nav_Shot_X, 
     :     Nav_Shot_Y, Nav_Shot_WaterBottom, Nav_Group_X, Nav_Group_Y, 
     :     ns )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer lunav, FieldRecNum, ntrc, ns

      real Nav_Shot_X, Nav_Shot_Y, Nav_Shot_WaterBottom
      real Nav_Group_X(ntrc), Nav_Group_Y(ntrc)

c declare local variables

      integer trace(3), trndx, done

      real x(3), y(3)

      integer Num_Lines, Num_Cables

      character shot*1, group*1, test*1

c initialize variables

      call vclr (Nav_Group_X, 1, ntrc) 
      call vclr (Nav_Group_Y, 1, ntrc) 

      done = 0
      Num_Cables = 0

      do i = 1, 3
         trace(i) = 0.
         x(i) = 0.
         y(i) = 0.
      enddo

      shot = 'S'
      group = 'R'

c read past the W card

      read (lunav,'(a1)') test

c read shot information

      do while ( done .eq. 0 )
         read (lunav, 10, end=990, err=991 )test, FieldRecNum, 
     :        Nav_Shot_X, Nav_Shot_Y, Nav_Shot_WaterBottom
 10      format ( a1, 19x, i5, 21x, 2f9.1, f6.1 ) 
         if ( test .eq. 'T' ) Num_Cables = Num_Cables + 1
         if ( test .eq. shot ) done = 1
      enddo

c load group information

      Num_Lines = ntrc / Num_Cables 

      if (  mod( Num_Lines, 3 ) .ne. 0 ) then
          Num_Lines = nint( float(ntrc / 3) ) + Num_Cables -1
      else
         Num_Lines = nint( float(ntrc / 3) )
      endif

          
      trndx = ns

      do JJ = 1, Num_Lines

         read ( lunav, 20, end=990, err=991 ) test, 
     :        (trace(i), x(i), y(i), i= 1,3 )
 20      format( 1a, 3 ( i4, 2f9.1, 4x ) )

         if ( test .eq. group ) then

            do i = 1, 3

               if ( trace(i) .eq. trndx ) then
                  Nav_Group_X(trndx) = x(i)
                  Nav_Group_Y(trndx) = y(i)
                  trndx = trndx + 1
               endif

            enddo

         else

            return

         endif

      enddo

      return
 990  continue

      write(LERR,*)' '
      write(LERR,*)'EOF reached on UKOOA input file '
      write(LERR,*)' '

      return

 991  continue
      write(LERR,*)' '
      write(LERR,*)'ERROR reading UKOOA input file '
      write(LERR,*)'FATAL '
      write(LERR,*)' '
      write(LER,*)'NAVMERGE: '
      write(LER,*)'ERROR reading UKOOA input file '
      write(LER,*)'FATAL '
      stop
      end

      
