C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c pack3d take input prestack 3d sorted data and expands the seconadry
c sort fold (i.e. if the data is primary sorted into lines (LI) then the
c secondary sort is DI) and expands these sub-gathers into square data
c for input to 2-d programs, OR
c undoes the above, and
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     lhed ( SZLNHD )
      integer     itr  ( SZLNHD )
      integer     str  ( SZLNHD )
      integer     ltr  ( SZLNHD )
      real        head ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     li1, li2, di1, di2, nli, ndi
      integer     cur_keywrd, currec, recnum, trcnum, linind, dphind
      integer     indvec ( SZLNHD )
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     stacor
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      character   ntap * 256, otap * 256, name*6
      character   type1 * 1, type2 * 1, hdrwrd * 6
      logical     verbos, query, rev, inline, next, dead
      logical     stack, first, hold
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'PACK3D'/
      data inline/.true./, str/SZLNHD * 0/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,verbos,rev,stack,inds,ind,hdrwrd)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'PACK3D: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4
c-----------

c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      call saver(itr, 'NumTrc', ntrci, LINHED)
      call saver(itr, 'NumRec', nreci, LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'CDPFld', ifold, LINHED)
      call saver(itr, 'APIWNA', type1, LINHED)
      call saver(itr, 'APIWNB', type2, LINHED)
      call saver(itr, 'MnLnIn', li1  , LINHED)
      call saver(itr, 'MxLnIn', li2  , LINHED)
      call saver(itr, 'MnDpIn', di1  , LINHED)
      call saver(itr, 'MxDpIn', di2  , LINHED)

      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      nli = li2 -li1 + 1
      ndi = di2 -di1 + 1

      if     (type1 .eq. 'L' .AND. type2 .eq. 'D') then
                 inline = .true.
           write(LERR,*)'Inline data sort'
      elseif (type1 .eq. 'D' .AND. type2 .eq. 'L') then
                 inline = .false.
           write(LERR,*)'Crossline data sort'
      else
           write(LERR,*)'WARNING: Unknown sort type:'
           write(LERR,*)'Check flow to make sure you have run at least:'
           write(LERR,*)'1. presort3d'
           write(LERR,*)'2. sisort3d'
           write(LERR,*)'Or else post stack data is assumed.'
c          stop
      endif

      IF (.not. rev) THEN
         if (inline) then
            l_keywrd    = l_DphInd
            ln_keywrd   = ln_DphInd
            ifmt_keywrd = ifmt_DphInd
         else
            l_keywrd    = l_LinInd
            ln_keywrd   = ln_LinInd
            ifmt_keywrd = ifmt_LinInd
         endif
      ELSE
         if (inline) then
            l_keywrd    = l_LinInd
            ln_keywrd   = ln_LinInd
            ifmt_keywrd = ifmt_LinInd
         else
            l_keywrd    = l_DphInd
            ln_keywrd   = ln_DphInd
            ifmt_keywrd = ifmt_DphInd
         endif
      ENDIF

      if (.not. rev) then

         if (stack) then
            call savew(itr, 'NumTrc', ntrci, LINHED)
            call savew(itr, 'NumRec', nreci, LINHED)
            call savew(itr, 'OrNTRC', ntrci, LINHED)
            call savew(itr, 'OrNREC', nreci, LINHED)
            ntrco = ntrci
            nreco = nreci
         else
            call savew(itr, 'OrNTRC', ntrci, LINHED)
            call savew(itr, 'OrNREC', nreci, LINHED)
            ntrco = ifold
            if (inline) then
                nreco = ndi * nreci
            else
                nreco = nli * nreci
            endif
         endif

      else

            call saver(itr, 'OrNTRC', ntrco, LINHED)
            call saver(itr, 'OrNREC', nreco, LINHED)

      endif
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 4, LERR)
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco, LINHED)
 
      if (ind .eq. 0) ind = 1

      do  j = 1, ntrco
          indvec (j) = inds + (j-1) * ind
      enddo

c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrci, nreci, iform,
     1                  rev,ntap,otap)
      end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
 
c-----
c     process desired trace records
c-----

      IF  (stack) THEN

          DO  JJ = 1, nreci

              ic = 0
              ik = 0
              keylst = inds
              first  = .false.
              hold   = .false.

              DO  KK = 1, ntrci

                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 998
                  endif
                  ik = ik + 1
c------
c     use previously derived pointers to trace header values
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

                  IF (stacor .ne. 30000) THEN

                     call saver2(lhed,ifmt_keywrd,l_keywrd, ln_keywrd,
     1                           keywrd , TRACEHEADER)
                     call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                           recnum , TRACEHEADER)
                     call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                           dphind , TRACEHEADER)
                     call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                           linind , TRACEHEADER)

                     if (.not. first) then
                        currec = recnum
                        first = .true.
                     endif

                     if (keywrd .gt. keylst) then
                     
                        do  ii = keylst, keywrd-ind
                            ic = ic + 1
                            call savew2(str ,ifmt_DphInd,l_DphInd,
     1                                  ln_DphInd, dphind , TRACEHEADER)
                            call savew2(str ,ifmt_LinInd,l_LinInd,
     1                                  ln_LinInd, linind , TRACEHEADER)
                            call savew2(str ,ifmt_RecNum,l_RecNum,
     1                                  ln_RecNum, JJ     , TRACEHEADER)
                            call savew2(str ,ifmt_TrcNum,l_TrcNum,
     1                                  ln_TrcNum, ic     , TRACEHEADER)
                            call savew2(str ,ifmt_StaCor,l_StaCor,
     1                                  ln_StaCor, 30000  , TRACEHEADER)
                            call savew2(str ,ifmt_keywrd,l_keywrd,
     1                                  ln_keywrd, ii     , TRACEHEADER)
                            call wrtape (luout, str, nbytes)
                        enddo
                     endif

                     ic = ic + 1
                     call savew2(lhed,ifmt_RecNum,l_RecNum,
     1                           ln_RecNum, JJ     , TRACEHEADER)
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum, ic     , TRACEHEADER)
                     call wrtape (luout, itr, nbytes)
                     keylst = keywrd + ind

                     if (ic .eq. ntrci) then
                        go to 140
                     endif

                  ENDIF

              ENDDO

              IF (ic .lt. ntrci) THEN
                 do  ii = ic+1, ntrci
                     keywrd = keywrd + ind
                     call savew2(str ,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum, ii     , TRACEHEADER)
                     call savew2(str ,ifmt_StaCor,l_StaCor,
     1                           ln_StaCor, 30000  , TRACEHEADER)
                     call savew2(str ,ifmt_LinInd,l_LinInd,
     1                           ln_LinInd, linind , TRACEHEADER)
                     call savew2(str ,ifmt_keywrd,l_keywrd,
     1                           ln_keywrd, keywrd , TRACEHEADER)
                     call wrtape (luout, str, nbytes)
                 enddo
              ENDIF

140           CONTINUE

              IF (ik .lt. ntrci) THEN
                 do  ii = ik+1, ntrci
                     call rtape (luin, itr, nbytes)
                 enddo
              ENDIF
          ENDDO

      ELSE

      ir  = 1
      lnd = 0
      cur_keywrd = 0

      IF (.not. rev) THEN

      DO  1000 JJ  = 1, nreci
 
            ind = 0
            dead = .false.
            next = .true.

            do 1001  kk = 1, ntrci
 
20              continue

                if (next) then

                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 998
                  endif

                else

                  call move (1, itr, ltr, nbytes)
                  next = .true.
                  ind = 0

                endif
c------
c     use previously derived pointers to trace header values
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

                  if     (stacor .eq. 30000 .AND. dead) then
                         next = .true.
                         ind = 0
                         go to 1002
                  elseif (stacor .eq. 30000 .AND. .not. dead) then
                         cur_keywrd = -999999999
                         dead = .true.
                  endif

                  call saver2(lhed,ifmt_keywrd,l_keywrd, ln_keywrd,
     1                        keywrd , TRACEHEADER)

c------

                  if (keywrd .eq. cur_keywrd .OR. ind .eq. 0) then

                      ind = ind + 1
                      call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir     , TRACEHEADER)
                      call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            ind    , TRACEHEADER)
                      call wrtape (luout, itr, nbytes)
                      next = .true.
                      cur_keywrd = keywrd

                  else

                      call move (1, ltr, itr, nbytes)
                      do  i = ind+1, ntrco
                         
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir     , TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            i      , TRACEHEADER)
                      call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000  , TRACEHEADER)
                      call wrtape (luout, str, nbytes)

                      enddo
                      next = .false.
                      ind = 0
                      ir = ir + 1
                      go to 20

                  endif

 1002          continue

 1001          continue
 
c-----------
c finish up current rec
c-----------
               write(LERR,*)'Input rec= ',jj,'  ind,ntrco= ',ind,ntrco

               if (ind .ne. ntrco) then
                   do  i = ind+1, ntrco
                       call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                             ir     , TRACEHEADER)
                       call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                             i      , TRACEHEADER)
                       call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                             30000  , TRACEHEADER)
                       call wrtape (luout, str, nbytes)
                   enddo
                   ind = ntrco
               endif

 
 1000 CONTINUE

c-----------
c finish up last non-dead rec
c-----------
  998 continue
              write(LERR,*)'Input rec= ',jj,'  ind,ntrco= ',ind,ntrco

              if (ind .ne. ntrco) then
                  do  i = ind+1, ntrco
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir     , TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            i      , TRACEHEADER)
                      call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000  , TRACEHEADER)
                      call wrtape (luout, str, nbytes)
                  enddo
              endif
c-----------
c finish up dead recs
c-----------
              if (ir .ne. nreco) then
                DO  j = ir+1, nreco
                  do  i = 1, ntrco
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            j      , TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            i      , TRACEHEADER)
                      call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000  , TRACEHEADER)
                      call wrtape (luout, str, nbytes)
                  enddo
                ENDDO
              endif
      go to 999


      ELSE

      lnd = 0
      next = .true.
      DO  2000 JJ  = 1, nreci
 

            do 2001  kk = 1, ntrci
 
40              continue

                if (next) then

                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

                else

                  call move (1, itr, ltr, nbytes)
                  next = .true.
                  lnd = 0

                endif
c------
c     use previously derived pointers to trace header values

                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

                  if (stacor .ne. 30000) then

                     call move (1, ltr, itr, nbytes)
                     call saver2(lhed,ifmt_keywrd,l_keywrd, ln_keywrd,
     2                           keywrd , TRACEHEADER)
                  else
                     next = .true.
                     go to 2002
                  endif

c------

                  if (keywrd .eq. cur_keywrd .OR. lnd .eq. 0) then

                      lnd = lnd + 1
                      call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir     , TRACEHEADER)
                      call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            lnd    , TRACEHEADER)
                      call wrtape (luout, itr, nbytes)
                      next = .true.
                      cur_keywrd = keywrd
                  else

                      call move (1, ltr, itr, nbytes)
                      do  i = lnd+1, ntrco
                         
                      call savew2(str ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir     , TRACEHEADER)
                      call savew2(str ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            i      , TRACEHEADER)
                      call savew2(str ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                            30000  , TRACEHEADER)
                      call wrtape (luout, str, nbytes)

                      enddo
                      next = .false.
                      lnd = 0
                      ir = ir + 1
                      go to 40

                  endif

 2002          continue
 2001          continue
 
 
 2000 CONTINUE

      ENDIF

      ENDIF
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
            write(LERR,*)'end of pack3d, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'pack3d (un)pack 3D data into common LI & DI constant width'
        write(LER,*)
     :'       records for processing by 2D & 3D tools'
        write(LER,*)
     :'see manual pages for details ( online by typing xman )'
        write(LER,*)' '
        write(LER,*)
     :'execute pack3d by typing pack3d and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*) ' '
        write(LER,*)
     :' -R  include on command line to reverse operation'
        write(LER,*)
     :' -S  input data is stacked. Use following cmd line input:'
        write(LER,*)
     :' -is [inds]    (1)      : first index value for each rec'
        write(LER,*)
     :' -id [ind]     (1)      : index increment'
        write(LER,*)
     :' -hw [hdrwrd]  (DphInd) : hdr word mnemonic'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   pack3d -N[ntap] -O[otap] [-R -S -is[] -id[] -hw[] -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,verbos,rev,stack,inds,ind,hdrwrd)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     rev     L        undo previous pack3d
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), hdrwrd * 6
      logical     verbos, rev, stack
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program pack3d might be invoked in the following way:
 
c     pack3d  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into pack3d and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            rev    =   (argis('-R') .gt. 0)
            call argstr( '-hw', hdrwrd, 'DphInd', 'DphInd' )
            stack  =   (argis('-S') .gt. 0)
            call argi4 ('-is', inds, 1, 1)
            call argi4 ('-id', ind, 1, 1)
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  rev,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*)
      logical     rev
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' re pack data       =  ',rev
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

c-----
c    write out printout file in case program bombs later
c-----
c           call flush (LERR)
 
      return
      end
 
