      SUBROUTINE DVTAPE (IPRT,   ITAPIN,   IBYTES, ngrp,
     &             IREC,   NREC,   IOREC,  ICC, spread,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             NFOLD,  NTRCS,  NPAIRS, lusht, lurcv,
     &             DSTMIN, DSTMAX, NLI, NDI, luoff,
     &             NSAMPS, IFMT,   SI,      dt,     IX1, IY1,
     &             IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &             NTPL,   TRCSPC, verbos, norm, shot,
     &             restart, divexp, pr, ol, prew, TV, lslide)
C***********************************************************************00003620
C                                                                       00003630
C     PROGRAM NAME: DMTAPE (READ TAPE, DUMP AND WRITE MODIFIED OUTPUT)  00003640
C                                                                       00003650
C     LANGUAGE: FORTRAN                                                 00003660
C                                                                       00003670
C     AUTHOR: G.MURPHY                                                  00003680
C                                                                       00003690
C     DATE WRITTEN: 06/14/88                                            00003700
C                                                                       00003710
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00003730
C                                                                       00003750
C     ABSTRACT: READS INPUT DATASET DUMPS AND WRITES MODIFIED DATASET   00003760
C                                                                       00003770
C                                                                       00003780
C     MODIFICATION HISTORY: 06/14/88  -  INITIAL RELEASE                00003790
C                                                                       00003800
C***********************************************************************00003810
C                                                                       00003820
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

      DIMENSION     RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      REAL          stks   (SZLNHD)
      REAL          stkr   (SZLNHD)
      integer       obytes
      integer       intbin, irrec, nrrec
      REAL          spread (*)
      REAL          srcnvec, rcvnvec, offnvec, offauto
      REAL          srcnorm, rcvnorm, offnorm, auto, trace
      pointer       (wksrcnvec,   srcnvec(1))
      pointer       (wkrcvnvec,   rcvnvec(1))
      pointer       (wkoffnvec,   offnvec(1))
      pointer       (wkoffauto,   offauto(1))
      pointer       (wksrcnorm,   srcnorm(1))
      pointer       (wkrcvnorm,   rcvnorm(1))
      pointer       (wkoffnorm,   offnorm(1))
      pointer       (wkauto   ,   auto   (1))
      pointer       (wktrace  ,   trace  (1))

      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT
      logical       verbos, norm, shot, restart, TV

      integer       ISLIMN,ISDIMN,IRLIMN,IRDIMN,ICLIMN,ICDIMN,ISLIMX
      integer       ISDIMX,IRLIMX,IRDIMX,ICLIMX,ICDIMX,MINDST,MAXDST
      integer       MAXFLDs
      integer       MAXFLDr
      integer       MAXFLDx
      integer       minJ, maxJ, minI, maxI

      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
c     EQUIVALENCE  (TRACE, RHEAD(65))
      DATA IDSK1 / 97 /

      DATA ISLIMN / 999999999 /
      DATA ISDIMN / 999999999 /
      DATA IRLIMN / 999999999 /
      DATA IRDIMN / 999999999 /
      DATA ICLIMN / 999999999 /
      DATA ICDIMN / 999999999 /
      DATA ISLIMX /-999999999 /
      DATA ISDIMX /-999999999 /
      DATA IRLIMX /-999999999 /
      DATA IRDIMX /-999999999 /
      DATA ICLIMX /-999999999 /
      DATA ICDIMX /-999999999 /
      DATA MINDST / 999999999 /
      DATA MAXDST /-999999999 /
      DATA MAXFLDs /-999999999 /
      DATA MAXFLDr /-999999999 /
      DATA MAXFLDx /-999999999 /
      DATA minJ / 999999999 /
      DATA maxJ /-999999999 /
      DATA minI / 999999999 /
      DATA maxI /-999999999 /
      DATA IRREC  /0/
      DATA NRREC  /0/
      DATA IOLD   /0/

      nsi = ifix (si)
      lslide = lslide / nsi
      iovlp  = lslide / 2
      ilast = 0
      nwin  = 0
      do while (ilast .lt. nsamps)
         if (ilast .eq. 0) then
             ifirst = 1
             ilast  = lslide + iovlp
             nwin   = 1
         else
             nmove  = lslide + iovlp
             ifirst = ifirst + iovlp
             ilast  = ifirst + nmove -1
             nwin   = nwin + 1
         endif
      end do
      nwin0 = nwin

      pi  = 3.14159265
      deg = 180. / pi

      lpf  = ol / si
      lpr  = pr / si
      la   = lpf
      lf  = lpf + lpr
      lacorr  = (lpf + lpr)
      IF(lacorr .gt. lslide) lacorr = lslide
      lags = lacorr * nwin
      dxg  = TRCSPC
      prew = prew / 100.

      write(LERR,*)' '
      write(LERR,*)'For time varying option:'
      write(LERR,*)'autocorrelation length = ',lacorr
      write(LERR,*)'# sliding windows      = ',nwin
      write(LERR,*)'sliding window length  = ',lslide
      write(LERR,*)' '


C *** build pointers into trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcAz',ifmt_SrRcAz,l_SrRcAz,ln_SrRcAz,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      call savelu('TVPT01',ifmt_TVPT01,l_TVPT01,ln_TVPT01,TRACEHEADER)
      call savelu('TVPT02',ifmt_TVPT02,l_TVPT02,ln_TVPT02,TRACEHEADER)

      IREC = 0

C *** SET THE TRANSLATION SUBSYSTEM                                     00004570

      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

      write(LER,*)'IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY= ',
     1IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY
      
      if (MAXLI .eq. 0) then
          MAXLI  = NX
      endif
      if (MAXDI .eq. 0) then
          MAXDI  = NY
      endif
      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1

      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)'PRE-DECON (TV) starts:'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi
      write(LER,*)'Number of lags   =  ',lags
      write(LER,*)'Prediction samps =  ',lpr
      write(LER,*)'Operator samps   =  ',lpf
      write(LER,*)'Minimum offset   =  ',DSTMIN
      write(LER,*)'Maximum offset   =  ',DSTMAX
      write(LER,*)'*********************************'
      write(LER,*)' '

      NBYTR  = lags * SZSMPD
      NTRKS  = NX * NY
      obytes = NBYTR + SZTRHD

      NXNY  = (NX+1) * (NY+1)

      write(LERR,*)'nx,ny,nxny= ',nx,ny,nxny

      items = NXNY
      itemx = ngrp * lags
      itemo = ngrp
      itema = lags
      itemt = nsamps

      call galloc (wksrcnvec, SZSMPD * items , ierr1, iabort1)
      call galloc (wkrcvnvec, SZSMPD * items , ierr2, iabort2)
      call galloc (wkoffnvec, SZSMPD * itemo , ierr3, iabort3)
      call galloc (wkoffauto, SZSMPD * itemx , ierr4, iabort4)
      call galloc (wksrcnorm, SZSMPD * items , ierr5, iabort5)
      call galloc (wkrcvnorm, SZSMPD * items , ierr6, iabort6)
      call galloc (wkoffnorm, SZSMPD * itemo , ierr7, iabort7)
      call galloc (wkauto   , SZSMPD * itema , ierr8, iabort8)
      call galloc (wktrace  , SZSMPD * itemt , ierr9, iabort9)

      if (ierr1 .ne. 0 .or. ierr2 .ne. 0 .or. ierr3 .ne. 0 .or.
     1    ierr4 .ne. 0 .or. ierr5 .ne. 0 .or. ierr6 .ne. 0 .or.
     2    ierr7 .ne. 0 .or. ierr8 .ne. 0 .or. ierr9 .ne. 0) then
         write(LER ,*)'Unable to allocate arrays - too big'
         write(LER ,*)'4 arrays each sized ',SZSMPD*items,' Mb, and'
         write(LER ,*)'2 array sized ',SZSMPD*itemo,' Mb, and'
         write(LER ,*)'1 array sized ',SZSMPD*itemx,' Mb, and'
         write(LER ,*)'1 array sized ',SZSMPD*itema,' Mb, and'
         write(LER ,*)'1 array sized ',SZSMPD*itemt,' Mb'
         write(LER ,*)'Try killing off some of your jobs or'
         write(LER ,*)'rerunning on a bigger machine'
         stop
      endif

      call vclr (srcnvec, 1, NXNY)
      call vclr (rcvnvec, 1, NXNY)
      call vclr (srcnorm, 1, NXNY)
      call vclr (rcvnorm, 1, NXNY)
      call vclr (offnvec, 1, ngrp)
      call vclr (offnorm, 1, ngrp)
    

      write(LERR,*)' '
      write(LERR,*)'ix,iy ',IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX
      write(LERR,*)'x,y ',xx,xy,yx,yy,xxt,xyt,yxt,yyt
      write(LERR,*)'NX,NY,items= ',NX,NY,NDI,NLI,items
      write(LERR,*)'minli,maxli,mindi,maxdi= ',minli,maxli,mindi,maxdi
      write(LERR,*)'ntrcs= ',ntrcs
      write(LERR,*)'TRCSPC= ',TRCSPC,' SI= ',si,' norm? ',norm,shot
      write(LERR,*)' '

c-----
C *** adjust line header & write output LH
c-----
      call savew (JHEAD, 'NumTrc', NY     , LINHED)
      call savew (JHEAD, 'NumRec', NX     , LINHED)
      call savew (JHEAD, 'NumSmp', lags   , LINHED)
      call savew (JHEAD, 'Format', 3      , LINHED)
      call savew (JHEAD, 'CDPFld', NFOLD  , LINHED)
      call savew (JHEAD, 'MnLnIn', MINLI  , LINHED)
      call savew (JHEAD, 'MxLnIn', MAXLI  , LINHED)
      call savew (JHEAD, 'MnDpIn', MINDI  , LINHED)
      call savew (JHEAD, 'MxDpIn', MAXDI  , LINHED)
      call savew (JHEAD, 'ILClIn', DX     , LINHED)
      call savew (JHEAD, 'CLClIn', DY     , LINHED)

      if (.not. restart) then
         call savhlh (JHEAD, IBYTES, lbyout)
         CALL WRTAPE (lusht , JHEAD, lbyout)
         CALL WRTAPE (lurcv , JHEAD, lbyout)
         call savew (JHEAD, 'NumTrc', ngrp   , LINHED)
         call savew (JHEAD, 'NumRec', 1      , LINHED)
         CALL WRTAPE (luoff , JHEAD, lbyout)
      endif


c-----
C *** fill up output data set and the rewind and read over LH
c-----
      call vclr (trace, 1, nsamps)
      call vmov (trace, 1, jhead(ITHWP1), 1, nsamps)

      write(LER,*)'Building output files'
      if (.not. restart) then
         do  i = 1, NXNY
             call wrtape (lusht , jhead, obytes)
         enddo
         do  i = 1, NXNY
             call wrtape (lurcv , jhead, obytes)
         enddo
      endif
      call rwd (lusht )
      call rwd (lurcv )
      call sislgbuf (lusht , 'off')
      call sislgbuf (lurcv , 'off')
      call rtape (lusht , jhead, IBYTES)
      call rtape (lurcv , jhead, IBYTES)

      write(LER,*)'Ouput files successfully built'
      write(LER,*)'You have enough disk space'

c-----
C *** READ THE TRACES.                                                  00004650
c-----

 1500 CONTINUE

      IBYTES = 0
      call vclr (trace, 1, nsamps)

      CALL RTAPE (ITAPIN, JHEAD, IBYTES)
      call vmov  (JHEAD(ITHWP1), 1, TRACE, 1, NSAMPS)

C *** GO TO BEGIN OUTPUT IF END OF INPUT TAPE                           00004710

      IF (IBYTES .EQ. 0) GO TO 5000

      call saver2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            IRREC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            IRTRC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            IDEAD  , TRACEHEADER)
      call saver2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1            IDIST  , TRACEHEADER)

      IF (IRREC .NE. IOLD) THEN
         IOLD  = IRREC
         NRREC = NRREC + 1
         write(LER,*)'Correlation on Record ',NRREC
      END IF

C *** GET SOURCE TO RECEIVER DISTANCE                                   00004810

      IF (IDEAD .GE. 30000) GO TO 1500

      IDIST = IABS (IDIST)

C *** GET SHOT COORDINATE                                               00004930

         call saver2(JHEAD,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               ISX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1               ISY     , TRACEHEADER)
         SX = ISX
         SY = ISY

C *** GET RECEIVER COORDINATE                                           00004980

         call saver2(JHEAD,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               IRX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               IRY     , TRACEHEADER)
         RX = IRX
         RY = IRY

C *** GET THE CDP COORDINATE (if shot mode we have to compute it)

         ICDPX = 0.5 * float (ISX + IRX) + 0.5
         ICDPY = 0.5 * float (ISY + IRY) + 0.5
         CX = ICDPX
         CY = ICDPY


C *** TRANSLATE SHOT AND RECEIVER INTO GRID COORDINATE SYSTEM

      CALL XFMFWD (SX, SY, ISLI, ISDI, SXT, SYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NX, NY)

      CALL XFMFWD (RX, RY, IRLI, IRDI, RXT, RYT, DM, DM, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NX, NY)

      CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT, IWRN,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NX, NY)

      ISLIMN = MIN (ISLIMN, ISLI)
      ISDIMN = MIN (ISDIMN, ISDI)
      IRLIMN = MIN (IRLIMN, IRLI)
      IRDIMN = MIN (IRDIMN, IRDI)
      ICLIMN = MIN (ICLIMN, ICLI)
      ICDIMN = MIN (ICDIMN, ICDI)

      ISLIMX = MAX (ISLIMX, ISLI)
      ISDIMX = MAX (ISDIMX, ISDI)
      IRLIMX = MAX (IRLIMX, IRLI)
      IRDIMX = MAX (IRDIMX, IRDI)
      ICLIMX = MAX (ICLIMX, ICLI)
      ICDIMX = MAX (ICDIMX, ICDI)

      MINDST = MIN (MINDST, IDIST)
      MAXDST = MAX (MAXDST, IDIST)

         call saver2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               itrc    , TRACEHEADER)


C *** COMPUTE PRIMARY DIRECTION OF S/R AZIMUTH RELATIVE TO GRID
C *** COMPUTE offset and check offset limits

      DXT  = SXT - RXT
      DYT  = SYT - RYT
      off  = sqrt ( DXT*DXT + DYT*DYT )

      if (off .gt. DSTMAX) go to 1500
      if (off .lt. DSTMIN) go to 1500

c-----
c  figure out whether the S-R line is primarily in the DI (or X)
c  direction or the LI (orY) direction. this is necessary to
c  calculate the proper step sizes in each direction
c-----
      IF (ABS(DXT) .GE. ABS(DYT)) THEN
         DDX    = DX
         DDY    = abs (DYT * DDX / DXT )
      ELSE
         DDY    = DY
         DDX    = abs (DXT * DDY / DYT )
      END IF
c-----
c  based on the orientation of the S-R line we compute the sign
c  of the steps in the X and Y directions. thus we step from
c  the S cell location along the line to the R location.
c-----
      if (DXT .ne. 0.) then
          sgnx = -sign (1.0, DXT)
          DDX  = sgnx * DDX
      endif
      if (DYT .ne. 0.) then
          sgny = -sign (1.0, DYT)
          DDY  = sgny * DDY
      endif

c----
c   if the current midpoint, src, or rcvr locations of this trace are
c   out of bounds & if so
c   skip over any computations and drop to the end of the loop - go
c   back and read a new trace
c----

      IF (ICLI .LT. MINLI) IWRN = 1
      IF (ICLI .GT. MAXLI) IWRN = 1
      IF (ICDI .LT. MINDI) IWRN = 1
      IF (ICDI .GT. MAXDI) IWRN = 1

      IF (ISLI .LT. MINLI) IWRN = 1
      IF (ISLI .GT. MAXLI) IWRN = 1
      IF (ISDI .LT. MINDI) IWRN = 1
      IF (ISDI .GT. MAXDI) IWRN = 1

      IF (IRLI .LT. MINLI) IWRN = 1
      IF (IRLI .GT. MAXLI) IWRN = 1
      IF (IRDI .LT. MINDI) IWRN = 1
      IF (IRDI .GT. MAXDI) IWRN = 1

      IF (IWRN .EQ. 0) THEN

c----
c  compute TV autocorrelation for current input trace
c  compute normalization also
c----

      call dotpr (trace, 1, trace, 1, xnorm, nsamps)
      xnorm = sqrt ( xnorm / float(nsamps) )


      call pretvp (nsamps, trace, lslide, nwin, iovlp, lacorr,
     1             auto)

c-----
c  find the pointer into the spread array for the current offset
c-----

          joff = intbin (ngrp, dxg, spread, off)

c-----
c  extract the current auto's from this part of the output volume for
c  shot and receiver
c  do the same for the offset record (we hold this guy in memory because
c  it's small enough).
c  we update the normalization vectors: (1) the number of time something
c  got summed into a cell for shot, rcvr, & offset, and (2) the cummulating
c  trace norms
c            ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1
c            ipntr =      icd       +       jcl      * ndi + 1

c            ipnts = (ISDI - mindi) + (ISLI - minli) * ndi + 1
c            ipntr = (IRDI - mindi) + (IRLI - minli) * ndi + 1
c-----
             jsl = ISLI - minli
             isd = ISDI - mindi
             jrl = IRLI - minli
             ird = IRDI - mindi
             ipnts = isd + jsl * ndi + 1
             ipntr = ird + jrl * ndi + 1

             maxJ = max (maxJ, jsl, jrl)
             minJ = min (minJ, jsl, jrl)
             maxI = max (maxI, isd, ird)
             minI = min (minI, isd, ird)

             call sisseek (lusht , ipnts)
             call rtape (lusht , jhead, nbytes)
             call vmov (jhead(ITHWP1), 1, stks, 1, lags)

             call sisseek (lurcv , ipntr)
             call rtape (lurcv , jhead, nbytes)
             call vmov (jhead(ITHWP1), 1, stkr, 1, lags)

             call vadd (auto, 1, stks, 1, stks, 1, lags)
             call vadd (auto, 1, stkr, 1, stkr, 1, lags)

             is = (joff-1) * lags + 1
             call vadd (auto, 1, offauto(is), 1, offauto(is), 1, lags)

             srcnvec (ipnts) = srcnvec (ipnts) + 1.0
             rcvnvec (ipntr) = rcvnvec (ipntr) + 1.0
             offnvec (joff ) = offnvec (joff ) + 1.0

             srcnorm (ipnts) = srcnorm (ipnts) + xnorm
             rcvnorm (ipntr) = rcvnorm (ipntr) + xnorm
             offnorm (joff ) = offnorm (joff ) + xnorm
 
c     call maxmgv(stk,1,smax,loc,nsamps)
c     if (verbos) then
c     write(LER ,*)'S,D,R,bins: ',ISLI,ISDI,ICLI,ICDI,IRLI,IRDI,
c    1 off
c     endif

c-----
c  put the summed autos back into their respective storage on disk
c-----
             call savew2(JHEAD,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                   ICDPX   , TRACEHEADER)
             call savew2(JHEAD,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                   ICDPY   , TRACEHEADER)

             call vmov (stks, 1, jhead(ITHWP1), 1, lags)
             call sisseek (lusht , ipnts)
             call wrtape (lusht , jhead, obytes)

             call vmov (stkr, 1, jhead(ITHWP1), 1, lags)
             call sisseek (lurcv , ipntr)
             call wrtape (lurcv , jhead, obytes)

      ENDIF
c----
c  end of IWRN if block
c----

      go to 1500
 5000 CONTINUE

c----
c  re-normalize all the auto's and all the normalizations
c  store the norms in the trace headers so we can apply them later
c  in the decon step
c----
      write(IPRT,*)' '
      write(IPRT,*)'minI, maxI, minJ, maxJ= ',mini,maxi,minj,maxj
      write(IPRT,*)' '
      write(LER,*)' '
      write(LER,*)'Now Normalizing and Storing Autocorrelations'
      write(LER,*)' '

      DO  I = minI, maxI
          DO  J = minJ, maxJ
 

              ipnt = I + J * ndi + 1

              call sisseek (lusht , ipnt)
              call rtape (lusht , jhead, nbytes)
              call vmov (jhead(ITHWP1), 1, auto, 1, lags)

              xlive = srcnvec (ipnt)
              maxflds = MAX ( maxflds, nint(xlive) )
              if (xlive .gt. 0.0) then
                  xnorm = srcnorm (ipnt) / xlive
                  call vsdiv (auto, 1, xlive, auto, 1, lags)
              else
                  xnorm = 0.0
              endif

              call putfp2(jhead,ifmt_TVPT01,l_TVPT01, ln_TVPT01,
     1                    xlive  , TRACEHEADER)
              call putfp2(jhead,ifmt_TVPT02,l_TVPT02, ln_TVPT02,
     1                    xnorm  , TRACEHEADER)
              call sisseek (lusht , ipnt)
              call vmov (auto, 1, jhead(ITHWP1), 1, lags)
              call savew2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    ICLI   , TRACEHEADER)
              call savew2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    ICDI   , TRACEHEADER)
              call savew2(JHEAD,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                    ICLI   , TRACEHEADER)
              call savew2(JHEAD,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    ICDI   , TRACEHEADER)
              call sisseek (lusht , ipnt)
              call wrtape (lusht , jhead, obytes)

              call sisseek (lurcv , ipnt)
              call rtape (lurcv , jhead, nbytes)
              call vmov (jhead(ITHWP1), 1, auto, 1, lags)

c     write(0,*)'i,j= ',i,j,xlive
c     write(0,*)(auto(ii),ii=1,lags)

              xlive = rcvnvec (ipnt)
              maxfldr = MAX ( maxfldr, nint(xlive) )
              if (xlive .gt. 0.0) then
                  xnorm = rcvnorm (ipnt) / xlive
                  call vsdiv (auto, 1, xlive, auto, 1, lags)
              else
                  xnorm = 0.0
              endif

              call putfp2(jhead,ifmt_TVPT01,l_TVPT01, ln_TVPT01,
     1                    xlive  , TRACEHEADER)
              call putfp2(jhead,ifmt_TVPT02,l_TVPT02, ln_TVPT02,
     1                    xnorm  , TRACEHEADER)
              call sisseek (lusht , ipnt)
              call vmov (auto, 1, jhead(ITHWP1), 1, lags)
              call savew2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    ICLI   , TRACEHEADER)
              call savew2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    ICDI   , TRACEHEADER)
              call savew2(JHEAD,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                    ICLI   , TRACEHEADER)
              call savew2(JHEAD,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    ICDI   , TRACEHEADER)
              call sisseek (lurcv , ipnt)
              call wrtape (lurcv , jhead, obytes)



          ENDDO
      ENDDO

      DO  j = 1, ngrp

          is = (j-1) * lags + 1
          call vmov (offauto(is), 1, auto, 1, lags)

              xlive = offnvec (j)
              maxfldx = MAX ( maxfldx, nint(xlive) )
              if (xlive .gt. 0.0) then
                  xnorm = offnorm (j) / xlive
              else
                  xnorm = 0.0
              endif

              call vmov  (auto, 1, jhead(ITHWP1), 1, lags)
              call putfp2(jhead,ifmt_TVPT01,l_TVPT01, ln_TVPT01,
     1                    xlive  , TRACEHEADER)
              call putfp2(jhead,ifmt_TVPT02,l_TVPT02, ln_TVPT02,
     1                    xnorm  , TRACEHEADER)
              call wrtape (luoff , jhead, obytes)
      ENDDO

      WRITE (IPRT, 310) ISLIMN,ISLIMX,ISDIMN,ISDIMX,
     &                  IRLIMN,IRLIMX,IRDIMN,IRDIMX,
     &                  ICLIMN,ICLIMX,ICDIMN,ICDIMX,
     &                  MINDST,MAXDST,maxflds,maxfldr,maxfldx
  310 FORMAT (//, 30X, 'LIMITS FOUND ON DATASET:'
     &        //, 23X, '  MINIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM SOURCE REDUNDANCY . . .',4X,I9,
     &        //, 23X, '  MAXIMUM RECEIVER REDUNDANCY. . ',5X,I9,
     &        //, 23X, '  MAXIMUM OFFSET REDUNDANCY.. . .',1X,I9  ,//)

      write(LER,*)' '
      write(LER,*)'End of Data:'
      write(LER,*)'predecon3d: processed ',NRREC,' records'
      ICC = 0

      RETURN
      END
