C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE prdapp (LPR, LA, peo, PREW, acorrn, work)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      DIMENSION peo (*), work (*)
      DIMENSION acorrn (*)

      real      right (SZLNHD), decop (SZLNHD)

C                                                                       
C     THIS SUBROUTINE COMPUTES THE LA-LENGTH SINGLE CHANNEL WIENER      
C     PREDICTION FILTER FOR PREDICTION DISTANCE LPR I.E., IT SOLVES     
C     THE SYSTEM OF NORMAL EQUATIONS,                                   
C                                                                       
C                                                                       
C         R(1),R(2),...R(LA)   A(1)     R(1+LPR)                        
C         R(2)          .      A(2)     R(2+LPR),  (R=AUTOPRODUCT OF A) 
C          .            .       .    =   .                              
C          .            .       .        .                              
C          .            .       .        .                              
C         R(LA),...,   R(1)    A(LA)    R(LA+LPR)                       
C                                                                       
C     AUTHOR--S.TREITEL, 10/5/1965                                      
C                                                                       
C     INPUTS ARE                                                        
C        LB=LENGTH OF INPUT B                                           
C         B=INPUT B                                                     
C       LPR=PREDICTION DISTANCE (MUST BE .GE. 0)                        
C        LA=LENGTH OF PREDICTION FILTER A                               
C      PREW=PREWHITENING LEVEL OF AUTO-CORR MATRIX (B X B)              
C     OUTPUTS ARE                                                       
C        A=PREDICTION FILTER A                                          
C        ASE=AVERAGE SQUARE PREDICTION ERROR FOR PRED. DIST. LPR        
C        SPACE=4*LA CELLS OF WORKING SPACE                              
C           FIRST LA CELLS CONTAIN  R(1),...R(LA)                       
C           NEXT  LA CELLS CONTAIN  R(1+LPR),...R(LA+LPR)               
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT RETROSPECTION     
C             ERROR OPERATOR, STORED IN REVERSE ORDER                   
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT PREDICTION        
C             ERROR OPERATOR, STORED IN REVERSE ORDER                   
C                                                                       
C     IF LPR .GT. LB, A IS THE NULL FILTER A(1)=A(2)=...A(LA)=0         
C                                                                       
                                                                      
            LAPR = LA + LPR
            acorrn (1) = (1.0+prew) * acorrn (1)

            if (LPR .le. 1) then
               call vmov (acorrn(2), 1, right, 1, LA)
            else
               call vmov (acorrn(LPR+1), 1, right, 1, LA)
            endif

            if (acorrn(1) .gt. 0.0) then
               call wiener (LA, acorrn, right, decop, peo, 1, ierr)
            else
               ierr = 1
            endif

            if (ierr .ne. 0) then
               call vclr (decop, 1, LA)
               call vclr (peo  , 1, LA)
               peo (1) = 1.0
            endif

C +----------------------------------------------------+
C | CREATE PROPER peo FOR GIVEN PREDICTION DISTANCE    |
C +----------------------------------------------------+

            if (LPR .gt. 1) then

               do  i = LA, 1, -1
                   work (i+LPR) = -decop (i)
               end do
               do  i = 1, LPR
                   work (i) = 0.0
               enddo
               work (1) = 1.

            else

               do  i = 1, LA
                   work (i) = peo (i)
               enddo

            endif


      RETURN                                                            
      END 
