C***********************************************************************00000010
C                                                                       00000020
C     PROGRAM NAME: DM3D  (DIP MOVEOUT FOR 3D DATA)                     00000030
C                                                                       00000040
C     LANGUAGE: FORTRAN                                                 00000050
C                                                                       00000060
C     AUTHOR: G.MURPHY                                                  00000070
C                                                                       00000080
C     DATE WRITTEN: 07/01/88                                            00000090
C                                                                       00000100
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00000120
C                                                                       00000140
C     ABSTRACT: OUTPUT CDP GATHERS WITH PSUEDO TRACE SPACING.           00000150
C                                                                       00000160
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00000170
C                                                                       00000180
C***********************************************************************00000190
C                                                                       00000200
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      CHARACTER*66  CTITLE
      character     ntap * 256, name*10
      character     stap * 256, rtap * 256, xtap * 256
      real          spread (SZLNHD)
      integer       argis
      logical       verbos, norm, shot, restart, query, TV
      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
      DATA CTITLE/'                      DIP MOVEOUT FOR 3-D DATA       
     &             '/                                                   
      DATA ICRD   /35/
      DATA IBYTES /32256/
      DATA name /'PREDECON3D'/

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help ()
          stop
      endif

      IPRT = LERR

#include <f77/open.h>
 
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-SHOT', stap, ' ', ' ' )
      call argstr( '-GRUP', rtap, ' ', ' ' )
      call argstr( '-XOFF', xtap, ' ', ' ' )

      restart = (argis('-R') .gt. 0)

      call getln(ITAPIN, ntap,'r', 0)

      if (.not. restart) then
         call getln(lusht, stap,'w+', -1)
      else
         call getln(lusht, stap,'r+', -1)
         call rwd  (lusht)
      endif

      if (lusht .lt. 1 .or. stap(1:1) .eq. ' ') then
         write(IPRT,*)' '
         write(IPRT,*)'Fatal error in predecon3d:'
         write(IPRT,*)'The shot autocorrelation file must be on disk'
         write(IPRT,*)'using the command argument -s[]'
         stop
      endif

      if (.not. restart) then
         call getln(lurcv, rtap,'w+', -1)
      else
         call getln(lurcv, rtap,'r+', -1)
         call rwd  (lurcv)
      endif

      if (lurcv .lt. 1 .or. rtap(1:1) .eq. ' ') then
         write(IPRT,*)' '
         write(IPRT,*)'Fatal error in predecon3d:'
         write(IPRT,*)'The rcvr autocorrelation file must be on disk'
         write(IPRT,*)'using the command argument -r[]'
         stop
      endif

      if (.not. restart) then
         call getln(luoff, xtap,'w+', -1)
      else
         call getln(luoff, xtap,'r+', -1)
         call rwd  (luoff)
      endif

      if (luoff .lt. 1 .or. xtap(1:1) .eq. ' ') then
         write(IPRT,*)' '
         write(IPRT,*)'Fatal error in predecon3d:'
         write(IPRT,*)'The offset autocorrelation file must be on disk'
         write(IPRT,*)'using the command argument -x[]'
         stop
      endif


C *** INITIALIZE PROGRAM

      CALL DMLINE (CTITLE, IPRT,   ITAPIN, NFOLD,
     &             NREC,   ICC,    IBYTES, NTRCS,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &             RECLEN, NSAMPS, dt, si, restart)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** READ 1DM3D CARD AND ONE TDFN FUNCTION

      CALL DMCARD (IPRT,   ICRD,   NTRCS, NFOLD, ngrp,
     &             NREC,   ICC,    IOREC, DSTMIN, DSTMAX,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             RECLEN, IX1, IY1, IX2, IY2, IX3,
     &             IY3, IX4, IY4,  NTPL,  NLI, NDI,
     &             DIVEXP, TRCSPC, verbos, norm, shot,
     &             spread, pr, ol, prew, TV, lslide, ist, ied, vel)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** PROCESS THE INPUT DATA SET.

      IF (TV) THEN

          CALL DVTAPE (IPRT,   ITAPIN, IBYTES, ngrp,
     &                 IREC,   NREC,   IOREC,  ICC, spread,
     &                 MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &                 NFOLD,  NTRCS,  NPAIRS, lusht, lurcv,
     &                 DSTMIN, DSTMAX, NLI, NDI, luoff,
     &                 NSAMPS, IFMT,   SI,      dt,    IX1, IY1,
     &                 IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &                 NTPL,   TRCSPC, verbos, norm, shot,
     &                 restart, divexp, pr, ol, prew, TV, lslide)

      ELSE

          CALL DMTAPE (IPRT,   ITAPIN, IBYTES, ngrp,
     &                 IREC,   NREC,   IOREC,  ICC, spread,
     &                 MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX,
     &                 NFOLD,  NTRCS,  NPAIRS, lusht, lurcv,
     &                 DSTMIN, DSTMAX, NLI, NDI, luoff,
     &                 NSAMPS, IFMT,   SI,      dt,    IX1, IY1,
     &                 IX2,    IY2,    IX3,    IY3,    IX4, IY4,
     &                 NTPL,   TRCSPC, verbos, norm, shot,
     &                 restart, divexp, pr, ol, prew, ist, ied, vel)

      ENDIF

C *** FINISHED -- CLOSE I/O DEVICES

 9999 CONTINUE

      CALL LBCLOS (ITAPIN)
      CALL LBCLOS (lusht)
      CALL LBCLOS (lurcv)
      CALL LBCLOS (luoff)

      CALL CCEXIT (ICC)

      END
