C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE preprd (LB, B, LPR, LA, space, work, lx)

#include <f77/iounit.h>

      DIMENSION B (*), work (*)
      DIMENSION SPACE (*)

C                                                                       
C     THIS SUBROUTINE COMPUTES THE LA-LENGTH SINGLE CHANNEL WIENER      
C     PREDICTION FILTER FOR PREDICTION DISTANCE LPR I.E., IT SOLVES     
C     THE SYSTEM OF NORMAL EQUATIONS,                                   
C                                                                       
C                                                                       
C         R(1),R(2),...R(LA)   A(1)     R(1+LPR)                        
C         R(2)          .      A(2)     R(2+LPR),  (R=AUTOPRODUCT OF A) 
C          .            .       .    =   .                              
C          .            .       .        .                              
C          .            .       .        .                              
C         R(LA),...,   R(1)    A(LA)    R(LA+LPR)                       
C                                                                       
C     AUTHOR--S.TREITEL, 10/5/1965                                      
C                                                                       
C     INPUTS ARE                                                        
C        LB=LENGTH OF INPUT B                                           
C         B=INPUT B                                                     
C       LPR=PREDICTION DISTANCE (MUST BE .GE. 0)                        
C        LA=LENGTH OF PREDICTION FILTER A                               
C      PREW=PREWHITENING LEVEL OF AUTO-CORR MATRIX (B X B)              
C     OUTPUTS ARE                                                       
C        A=PREDICTION FILTER A                                          
C        ASE=AVERAGE SQUARE PREDICTION ERROR FOR PRED. DIST. LPR        
C        SPACE=4*LA CELLS OF WORKING SPACE                              
C           FIRST LA CELLS CONTAIN  R(1),...R(LA)                       
C           NEXT  LA CELLS CONTAIN  R(1+LPR),...R(LA+LPR)               
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT RETROSPECTION     
C             ERROR OPERATOR, STORED IN REVERSE ORDER                   
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT PREDICTION        
C             ERROR OPERATOR, STORED IN REVERSE ORDER                   
C                                                                       
C     IF LPR .GT. LB, A IS THE NULL FILTER A(1)=A(2)=...A(LA)=0         
C                                                                       
C                                                                       

      lacorr = LA + LPR
      lwind  = LB
      lx2    = lx / 2

      call vclr  (space, 1, lacorr)
      call vclr  (work , 1, lx    )
      call vmov  (B, 1, work, 1, LB)
      call acorf (work, space, lacorr, lx2)

      if (space(1) .gt. 1.e-30) then

         xmax = space (1)
         do  i = 1, lacorr
             space (i) = space (i) / xmax
         enddo

      endif

      RETURN
      END
