C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, dtmsec, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, Start_Azimuth, End_Azimuth, 
     :     Delta_Azimuth, Scoping, ntrc_bin, nreco, nsampo, 
     :     Reverse, c_PriSrt, ntrc_live, verbos)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne
      integer    ntrc_bin, nsampo, nreco, ntrc_live
      real       dtmsec, Start_Azimuth, End_Azimuth, Delta_Azimuth

      character  ntap*(*), otap*(*), c_PriSrt*(*)

      logical    Scoping, Reverse, verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', dtmsec
      write(LERR,*)' '
      if ( ntrc_bin .gt. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' Output Line Header Parameters'
         write(LERR,*)' '
         write(LERR,*) ' samples per trace     =  ', nsampo
         write(LERR,*) ' traces per record     =  ', ntrc_bin
         write(LERR,*) ' number of records     =  ', nreco
      endif
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', irs 
      write(LERR,*) ' processing start trace  =  ', ns
      write(LERR,*) ' processing end trace    =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' processing azimuth start = ', Start_Azimuth
      write(LERR,*) ' processing azimuth end   = ', End_Azimuth
      write(LERR,*) ' processing azimuth incr  = ', Delta_Azimuth
      write(LERR,*)' minimum number of live traces to pass = ',ntrc_live
      if ( Scoping ) write(LERR,*)' In Scoping Mode only'

      if ( Reverse )  then
         write(LERR,*) ' sorting back to endpoint'
         write(LERR,*) ' Primary inverse sorting Mnemonic = ',c_PriSrt
      endif

      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
