C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  rstak3d:  stack n records vertically together
C
C**********************************************************************C
C
C rstak3d READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C vertically stacks 3D swath data either in-line or cross-line
C into distance bins, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>


      INTEGER * 2 ITR ( SZLNHD )
      INTEGER * 2 ITR0( SZLNHD )
      INTEGER     LHED( SZLNHD ), LHEDO( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, stacor, linind, dphind
      integer     errcod, abort
      REAL        xtr( SZLNHD ), spread( SZLNHD )
c     REAL        dist( SZLNHD )
c     REAL        rept( SZLNHD )
c     REAL        static( SZLNHD )

      real        tabl1(SZLNHD), tabl2(SZLNHD), zz(4*SZLNHD)
      integer     iz(SZLNHD)

      integer     ITRH, ITRHO
c     REAL        data, out, dist, rept, static
      REAL        data, out
      pointer     (wkdata  ,  data(1))
      pointer     (wkaddr  ,   out(1))
      pointer     (wkdist  ,  dist(1))
      pointer     (wkrept  ,  rept(1))
      pointer     (wkstatic,static(1))
      pointer     (wkitrh  ,  itrh(1))
      pointer     (wkitrho,  itrho(1))
      CHARACTER   NAME * 7,  ntap * 100, otap * 100
#include <f77/pid.h>
      logical     verbos,query,vector,heap,split,cross,abslt
 
      EQUIVALENCE ( ITR (  1), LHED (1) )
      EQUIVALENCE ( ITR0(  1), LHEDO(1) )
      DATA NAME     /'RSTAK3D'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      data verbos/.false./, vector/.false./
      data abort/ 0 /
      data itr0 / SZLNHD * 0 /

c-------------------------------------
c  get online help if necessary
c-------------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call  help ()
           stop
      endif

c----------------------------------
c  open printout file
c----------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln (ntap,otap,far,dx,nstk,verbos,split,cross,abslt)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )

      if (cross) then
         call getln (luout, otap, 'w+', 1 )
      else
         call getln (luout, otap, 'w', 1 )
      endif

      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'rstak3d: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c--------------------------
c  get key header values
#include <f77/saveh.h>

      call saver(itr, 'MnLnIn', nl1  , LINHED)
      call saver(itr, 'MxLnIn', nl2  , LINHED)
      call saver(itr, 'MnDpIn', nd1  , LINHED)
      call saver(itr, 'MxDpIn', nd2  , LINHED)
      call saver(itr, 'CDPFld', ifld  ,LINHED)
      call saver(itr, 'NTrLnS', jtr   ,LINHED)

      CALL HLHprt ( ITR, LBYTES, NAME, 5, LERR        )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------------------------------------
c  figure out which type of stack and output
c  # recs per line (either inline or x-line

      call saver(itr, 'MnLnIn', nl1  , LINHED)
      call saver(itr, 'MxLnIn', nl2  , LINHED)
      call saver(itr, 'MnDpIn', nd1  , LINHED)
      call saver(itr, 'MxDpIn', nd2  , LINHED)

      nli = nl2 - nl1 + 1
      ndi = nd2 - nd1 + 1

      IF (cross) THEN
         
         if(nstk .eq. 0) nstk = nrec
         xrec  = float(nrec)/float(nstk)
         nrecc = ifix(xrec+.99)
         left  = nrec - nstk*ifix(xrec)
         nreco = nli * nrecc
      ELSE
         if(nstk .eq. 0) nstk = nli
         xrec  = float(nli)/float(nstk)
         nrecc = ifix(xrec+.99)
         left  = nli - nstk*ifix(xrec)
         nreco = ndi * nrecc
      ENDIF

      write(LERR,*)'xrec= ',xrec,' nrecc= ',nrecc,' left= ',left,
     1             ' nreco= ',nreco
c

        write(LERR,*) ' '
        write(LERR,*) ' '
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform

C**********************************************************************C
C     update historical line header; write out header
C**********************************************************************C
      if(nsamp .gt. SZLNHD) nsamp = SZLNHD
      nsampo = nsamp
      obytes = SZTRHD + SZSMPD * nsampo
      call savhlh ( itr, lbytes, lbyout )

        write(LERR,*) ' '
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsampo
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc
        write(LERR,*) ' Records per X-line =  ', nli
        write(LERR,*) ' Records per in-line=  ', ndi
        write(LERR,*) ' Records per Line   =  ', nreco,' (stacked)'
        write(LERR,*) ' Records per Line   =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Records to stack   =  ', nstk
        write(LERR,*) ' '
        if(left .ne. 0) then
          write(LERR,*)'Last group of records=  ',left
          write(LERR,*)'Less than ',nstk,' specified on cmnd line'
        endif
        write(LERR,*) ' '
        write(LERR,*) 'Bin option selected:'
        write(LERR,*) ' Far offset for spread =  ', far
        write(LERR,*) ' Bin size              =  ', dx
        if (abslt)
     1  write(LERR,*) ' Input trace distances will be forced positive'
        write(LERR,*) ' '

c-------
c for bin option:
c compute spread model
c-------
         if (split) then

            x  = 0.
            dx = abs(dx)
            do  j = 1, SZSMPM
   
                if (x .gt. abs(far)) then
                    ngrp2 = j - 1
                    go to 20
                else
                    xtr (j) = x
                endif
                x = x + dx
   
            enddo
20          continue
            ngrp = 2 * ngrp2 - 1

            ic = 0
            do  j = 2, ngrp2
                ic = ic + 1
                spread (ngrp2-ic) = -xtr(j)
            enddo
            ic = 0
            do  j = 1, ngrp2
                ic = ic + 1
                spread (ngrp2+ic-1) = xtr(j)
            enddo
   
         else

            x = 0.
            do  j = 1, SZSMPM
   
                if (far .gt. 0.) then
   
                   if (x .gt. far) then
                       ngrp = j - 1
                       go to 21
                   else
                       spread (j) = x
                   endif
   
                elseif (far .lt. 0.) then
   
                   if (x .gt. 0.0) then
                       ngrp = j - 1
                       go to 21
                   else
                       spread (j) = x
                   endif
   
                endif
                x = x + dx
            enddo
 21      continue
   
         endif

         do  j = 1, ngrp
             if (spread(j) .eq. 0.0) then
                tabl2 (j) = .01 * dx
             else
                tabl2 (j) = spread (j)
             endif
         enddo
         call maxmgv (tabl2, 1, xmax, loc, ngrp)

         write(LERR,*)' '
         write(LERR,*)'Spread model:'
         write(LERR,*)'Number of groups in spread   = ',ngrp
         write(LERR,*)(spread(i),i=1,ngrp)
         write(LERR,*)' '

c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      ntrcm = max0(ngrp,ifld)
      itemi = ntrcm * ITRWRD
      items = ntrcm * nsamp
      itemo = ntrcm * ITRWRD

      if (cross) then
         itemd = ntrcm * nli
      else
         itemd = ntrcm
      endif


      call galloc (wkdist  , itemd*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkrept  , itemd*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkstatic, itemd*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      call galloc (wkitrh, itemi*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkitrho, itemo*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkdata, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkaddr, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) itemo*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemd*SZSMPD,'  bytes'
         write(LERR,*) itemd*SZSMPD,'  bytes'
         write(LERR,*) itemd*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else 
         write(LERR,*)' ' 
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) itemo*SZSMPD,'  bytes'
         write(LERR,*) items*SZHFWD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemd*SZSMPD,'  bytes'
         write(LERR,*) itemd*SZSMPD,'  bytes'
         write(LERR,*) itemd*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
      call savew( itr, 'NumRec', nreco, LINHED)
      call savew( itr, 'NumTrc', ntrcm, LINHED)

      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

      IF (cross) THEN

         DO  J = 1, nrecc
             DO  L = 1, nli
                 DO  K = 1, ntrcm
                     call wrtape (luout, itr0, obytes)
                 ENDDO
             ENDDO
         ENDDO
         call lbclos (luout)
         call getln (luout, otap, 'r+', 1 )
         call sislgbuf (luout, 'off')
         call rtape (luout, itr0, lbytes)

      ENDIF

C**********************************************************************C
C
C     READ TRACE, DO rstak3d, WRITE TO OUTPUT FILE
C
C**********************************************************************C
      nstk0 = nstk
      irec  = 0

c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c cross line output
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      IF (cross) THEN

      DO 100 JJ = 1, NRECC

        irec = irec + 1

        if(jj.eq.nrecc .and. left.ne.0) then
          nstk0 = left
        else
          nstk0 = nstk
        endif

        call vclr ( out, 1, nsamp*ntrcm )

c-----------------------------
c  loop over stacking groups

        call vclr (rept  , 1, nli*ntrcm)
        call vclr (static, 1, nli*ntrcm)

        istak = 0


        DO 99 LL = 1, NSTK0

          istak = istak + 1

        DO    LI = 1, nli

          live = 0
          call vclr ( data, 1, nsamp*ntrcm )

          DO 91 KK = 1, IFLD

              nbytes = 0
              CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  group= ',ll,' trace ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
               call dotpr (xtr,1,xtr,1,xdot,nsamp)

               call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     ireci  , TRACEHEADER)
               call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                     linind , TRACEHEADER)
               call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                     dphind , TRACEHEADER)
               call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                     idist  , TRACEHEADER)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     stacor , TRACEHEADER)

               if (abslt) idist = iabs (idist)

               isli = (LI-1) * ntrcm
               if (stacor .ne. 30000) then
                   call dotpr (xtr,1,xtr,1,xdot,nsamp)
                   if (xdot .ne. 0.) then
                       live = live + 1
                       istrc = (live-1) * nsamp
                       call vmov (xtr, 1, data(istrc+1), 1, nsamp)
                       dist(isli + live) = idist
                       rept(isli + live) = rept(isli + live) + 1
                   endif
               endif 

               if (LL .eq. 1) then
c______________________________________________________________________
c                 for 1st group of LI's in stack, copy in headers.
c                 (this will give us something in the headers)
c                 if subsequent live trace, copy in valid header values.
c______________________________________________________________________
                  ishdr = (kk-1) * ITRWRD
                  call vmov (lhed,1, itrh(ishdr+1),1,ITRWRD)
               endif

   91     CONTINUE

          ioff = (JJ-1) * (nli*ntrcm) + (LI-1) * ntrcm + 1
          call sisseek (luout, ioff)

          DO  92  KK = 1, NTRCM

              CALL RTAPE  ( LUOUT, ITR, NBYTES         )

               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
               istrc = (KK-1) * nsamp
               call vmov (xtr, 1, out (istrc+1), 1, nsamp)
               ishdr = (kk-1) * ITRWRD
               call vmov (lhed,1, itrho(ishdr+1),1,ITRWRD)
 
  92      CONTINUE


          icinit = 1
          isli = (LI-1) * ntrcm + 1
          call  binsum (ntrc, ngrp, ntrcm, nsamp, dist(isli), xmax,
     1                  tabl1, tabl2, zz, iz, icinit, live, dx,
     2                  spread, data, out, itrh, itrho)

          if (istak .ne. 0) then
             scl   = 1. / float(istak)
          else
             scl   = 0.
          endif

          ioff = (JJ-1) * (nli*ntrcm) + (LI-1) * ntrcm + 1
          call sisseek (luout, ioff)

          DO 75 KK = 1, NTRCM

            isli  = (LI-1) * ntrcm
            istrc = (kk-1) * nsamp
            ishdr = (kk-1) * ITRWRD

            call vmov  ( out(istrc+1), 1, xtr, 1, nsamp )
            call dotpr ( xtr, 1, xtr, 1, xdot, nsamp)
            call vmov  ( xtr, 1, lhed(ITHWP1), 1, nsamp)
c------------------------
c  reconstitute headers
            call vmov (itrho(ishdr+1),1,lhed ,1,ITRWRD)

            if (xdot .lt. 1.e-30) then
               call vclr  (lhed, 1, SZLNHD)
               call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                             30000  , TRACEHEADER)
            endif

            idist = spread (KK)
            ili   = nl1 + li - 1  
            idi   = nd1 + (ll-1) * nstk0
            call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          idist  , TRACEHEADER)
            call savew2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                          idi    , TRACEHEADER)
            call savew2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                          ili    , TRACEHEADER)
            call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec   , TRACEHEADER)
            call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          KK     , TRACEHEADER)
c------------------------
            call wrtape(luout,itr,obytes)

   75     CONTINUE

      ENDDO

        if(verbos) then
           write(LERR,*)'Stacking Record ',ireci,'  DI ',dphind
        endif


 99   CONTINUE

      if(verbos) then
         write(LERR,*)'Output Stacked Record ',irec
      endif


100   CONTINUE
      

      ELSE

c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c in-line output
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


      DO 200 JJ = 1, NDI

        irec = irec + 1

c-----------------------------
c  loop over stacking groups

        istak = 0
        DO    IS = 1, nrecc

        if(IS.eq.nrecc .and. left.ne.0) then
          nstk0 = left
        else
          nstk0 = nstk
        endif

        call vclr ( out, 1, nsamp*ntrcm )

        DO 199 LL = 1, NSTK0

          istak = istak + 1

          live = 0
          call vclr (data  , 1, nsamp*ntrcm )
          call vclr (rept  , 1, ntrcm)
          call vclr (static, 1, ntrcm)


          DO 191 KK = 1, IFLD

              nbytes = 0
              CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  group= ',ll,' trace ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
               call dotpr (xtr,1,xtr,1,xdot,nsamp)

               call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     ireci  , TRACEHEADER)
               call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                     linind , TRACEHEADER)
               call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                     idist  , TRACEHEADER)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     stacor , TRACEHEADER)

               if (stacor .ne. 30000) then
                   call dotpr (xtr,1,xtr,1,xdot,nsamp)
                   if (xdot .ne. 0.) then
                       live = live + 1
                       istrc = (live-1) * nsamp
                       call vmov (xtr, 1, data(istrc+1), 1, nsamp)
                       dist(live) = idist
                       rept(live) = rept(live) + 1
                   endif
               endif 

               if (LL .eq. 1) then
c______________________________________________________________________
c                 for 1st group of LI's in stack, copy in headers.
c                 (this will give us something in the headers)
c                 if subsequent live trace, copy in valid header values.
c______________________________________________________________________
                  ishdr = (kk-1) * ITRWRD
                  call vmov (lhed,1, itrh(ishdr+1),1,ITRWRD)
               endif

  191     CONTINUE

          icinit = 1
          call  binsum (ntrc, ngrp, ntrcm, nsamp, dist, xmax,
     1                  tabl1, tabl2, zz, iz, icinit, live, dx,
     2                  spread, data, out, itrh, itrho)

          if (istak .ne. 0) then
             scl   = 1. / float(istak)
          else
             scl   = 0.
          endif

          DO 175 KK = 1, NTRCM

            istrc = (kk-1) * nsamp
            ishdr = (kk-1) * ITRWRD

            call vmov  ( out(istrc+1), 1, xtr, 1, nsamp )
            call dotpr ( xtr, 1, xtr, 1, xdot, nsamp)
            call vmov  ( xtr, 1, lhed(ITHWP1), 1, nsamp)
c------------------------
c  reconstitute headers
            call vmov (itrho(ishdr+1),1,lhed ,1,ITRWRD)

            if (xdot .lt. 1.e-30) then
               call vclr  (lhed, 1, SZLNHD)
               call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                             30000  , TRACEHEADER)
            endif

            idist = spread (KK)
            idi   = nd1 + jj - 1
            ili   = nl1 + (is-1) * nstk0
            call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          idist  , TRACEHEADER)
            call savew2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                          idi    , TRACEHEADER)
            call savew2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                          ili    , TRACEHEADER)
            call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec   , TRACEHEADER)
            call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          KK     , TRACEHEADER)
c------------------------
            call wrtape(luout,itr,obytes)

  175     CONTINUE

        if(verbos) then
           write(LERR,*)'Stacking Record ',ireci,'  LI ',linind
        endif

199   CONTINUE

      if(verbos) then
         write(LERR,*)'Output Stacked Record ',irec
      endif

      ENDDO

200   CONTINUE
      

      ENDIF
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  999 continue

       call lbclos(luin)
       call lbclos(luout)
      END

c------------------------------------
c  online help section
c------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for rstak3d: stack groups'
        write(LER,*)'                                of n records'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-S         -- split spread (-far,...,0,...,far)'
        write(LER,*)'              stack into bins defined by xf,xd'
        write(LER,*)'-A         -- input trc distances forced positive'
        write(LER,*)'-C         -- output is single cross-line, else'
        write(LER,*)'              output is single in-line'
        write(LER,*)'-xf[far]   -- bin option: far offset (ft,m)'
        write(LER,*)'-xd[dx]    -- bin option: bin size override (ft,m)'
        write(LER,*)'-n[nstk]   -- stack groups of nstk records'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      rstak3d -N[] -O[] -n[] [ -V ]'
        write(LER,*)'            [ [-xf[] -xd[] -S -A ]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    nstk   - I      number of groups of records to stack
c    igath  - I      force number traces in gather to stack
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,far,dx,nstk,verbos,split,cross,abslt)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      real       far, dx
      integer    argis,nstk
      logical    verbos, split, cross, abslt

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           cross  = ( argis( '-C' ) .gt. 0 )
           abslt  = ( argis( '-A' ) .gt. 0 )

           if (cross .AND. otap(1:1) .eq. ' ') then
              write(LERR,*)'FATAL error in rstak3d:'
              write(LERR,*)'Output file must be a named disk file.'
              write(LERR,*)'Rerun using -O[filename]'
              stop
           endif

           call argr4('-xf',far,0.,0.)
           call argr4('-xd',dx ,0.,0.)
           call argi4('-n',nstk,0,0)

           if (far .eq. 0.) then
              write(LERR,*)'FATAL error in rstak3d:'
              write(LERR,*)'must enter far offset using'
              write(LERR,*)'-xf[] cmd line argument'
              stop
           endif

           split  = ( argis( '-S' ) .gt. 0 )
           verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
