C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE AKSTOP(P, PL, M, N, AKCODE, ITEND)
      REAL P, PL
      INTEGER M, N, AKCODE, ITEND
C
C FOLLOWING THE AKAIKE GOODNESS-OF-FIT CRITERION, WE
C SAY THAT M-1 IS OPTIMAL IF M IS THE SMALLEST POSITIVE
C INTEGER FOR WHICH,
C
C IF THE MEAN IS SUBTRACTED OUT,
C
C      P*(N+(M+1))/(N-(M+1)).GT.PL*(N+M)/(N-M),
C
C BUT OTHERWISE
C
C      P*(N+M)/(N-M).GT.PL*(N+(M-1))/(N-(M-1)).
C
C
C HERE N IS THE LENGTH OF THE TIME SERIES,
C M IS THE NUMBER OF COEFFICIENTS, P IS THE MEAN SQUARE
C RESIDUAL, AND PL IS THE CORRESPONDING QUANTITY FOR
C M-1 COEFFICIENTS.
C
C AKCODE IS AN INTEGER INPUT PARAMETER WHICH
C MUST BE SET TO 1 IF THE MEAN IS SUBTRACTED
C OUT OF THE TIME SERIES, AND WHICH MUST BE
C SET TO 0 OTHERWISE.
C ITEND IS AN INTEGER OUTPUT PARAMETER WHICH IS SET
C TO 1 IF THE AKAIKE CRITERION IS SATISIFIED, AND WHICH
C IS SET TO 0 OTHERWISE.
C
C LOCAL VARIABLES -
      REAL XN, XM
      ITEND = 0
      XN = N
      XM = M
      IF (AKCODE.NE.1) GO TO 10
      IF (P*((XN+XM+1.0)/(XN-XM-1.0)).GT.PL*((XN+XM)/(XN-XM)
     * )) ITEND = 1
      RETURN
   10 CONTINUE
      IF (P*((XN+XM)/(XN-XM)).GT.PL*((XN+XM-1.0)/(XN-XM+1.0)
     * )) ITEND = 1
      RETURN
      END
