C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE CHSOL(N, NT,L, B, SS)
      REAL B, L, SS
      INTEGER N, NT
      DIMENSION B(N), L(NT)
C
C     SOLVES LUX = B (U = TRANSPOSE OF THE N*N LOWER
C     TRAINGULAR MATRIX L), X OVERWRITING B.  LOWER
C     TRIANGLE OF L STORED BY ROWS IN L.  FORMS IN SS
C     THE SQUARE OF THE 2-NORM OF Y = UX.  NT MUST BE
C     NO SMALLER THAN N*(N + 1)/2.  BASED ON THE MARTIN-
C     PETERS-WILKINSON ALGORITHM CHOLSOL2.
C
C     NO PROGRAM UNITS CALLED
C
C     LOCAL VARIABLES -
C
      REAL T, X, ZERO
      INTEGER I, IREV, K, KREV, P, Q, S
C
C     CONSTANTS -
C
      ZERO = 0.E0
C
C     SOLVE LY = B AND FORM SS -
C
      T = ZERO
      P = 1
      DO 30 I=1,N
         Q = I - 1
         X = B(I)
         IF (Q.LT.1) GO TO 20
         DO 10 K=1,Q
            X = X - L(P)*B(K)
            P = P + 1
   10    CONTINUE
   20    B(I) = X*L(P)
         P = P + 1
         T = T + B(I)**2
   30 CONTINUE
      SS = T
C
C     SOLVE UX = Y -
C
      DO 60 IREV=1,N
         I = N + 1 - IREV
         S = P - 1
         P = S
         Q = I + 1
         X = B(I)
         IF (Q.GT.N) GO TO 50
         DO 40 KREV=Q,N
            K = N + Q - KREV
            X = X - L(S)*B(K)
            S = S - K + 1
   40    CONTINUE
   50    B(I) = X*L(S)
   60 CONTINUE
      RETURN
      END
