C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln (ntap,otap,ttap,ptap,vtap,IX1,IY1,DX,DY,NLI,NDI,
     1                  luin,luvel,luout,lunrm,lupik,f2m,m2f,verbos,
     2                  XX, XY, YX, YY, XXT, XYT, YXT, YYT, lhed,
     3                  name, debug, lu_debug, nhor, restart, minli,
     4                  maxli, mindi, maxdi, nsi, nsamp, ntrc, nrec,
     5                  lbytes, nattr, unitsc, si, stk,trp,xyscl,nmoap,
     6                  mstart, mlast, thresh, fcut, IX2,IY2,IX3,IY3,
     7                  IX4,IY4, global, hdrwrd, TmMsFS, cdp, iord,
     8                  refwrd,atrwrd)

#include <f77/iounit.h>

      integer       lhed (*)
      character     ntap * 256, otap(100) * 256, ttap(100) * 256
      character     vtap * 256, ptap * 256, name*(*), dtap * 14
      character     hdrwrd * 6
      character     refwrd * 6
      character     atrwrd * 6
      integer       argis
      integer       luin, luout(100), lunrm(100), lupik
      integer       minli, maxli, mindi, maxdi
      integer       limin, limax, dimin, dimax
      integer       IX1, IY1, IX2, IY2, IX3, IY3, IX4, IY4
      real          DY, DX
      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT
      logical       verbos, debug, f2m, m2f, restart, stk, trp
      logical       nmoap, global, cdp

      dtap = 'SCOPE_HORIZONS'
      debug = .false.


      global  = (argis('-global') .gt. 0)
      cdp     = (argis('-cdp') .gt. 0)
      debug   = (argis('-debug') .gt. 0)
      verbos  = (argis('-V') .gt. 0)
      restart = (argis('-R') .gt. 0)
      f2m     = ( argis( '-f2m' ) .gt. 0 )
      m2f     = ( argis( '-m2f' ) .gt. 0 )
      stk     = ( argis( '-stk' ) .gt. 0 )
      trp     = ( argis( '-trp' ) .gt. 0 )
      nmoap   = ( argis( '-nmo' ) .gt. 0 )
      if ( global ) nmoap = .false.

      call argstr( '-hw', hdrwrd, 'StaCor', 'StaCor' )
      call argstr( '-rw', refwrd, '      ', '      ' )
      call argstr( '-aw', atrwrd, 'StaCor', 'StaCor' )

      call argi4 ( '-min', mstart ,   2  ,  2    )
      call argi4 ( '-max', mlast  ,   0  ,  0    )
      call argi4 ( '-ord', iord   ,   0  ,  0    )
      call argr4 ( '-th', thresh, 12.0, 12.0)
      call argr4 ( '-fc', fcut, 0.0, 0.0)

      nattr = 19

c  load XY feet -> m or m-> feet scaler
      fmscl = 0.30480
      mfscl = 3.28084
      if ( f2m ) then
         xyscl = fmscl
      elseif ( m2f ) then
         xyscl = mfscl
      else
         xyscl = 1.0
      endif

      call argstr( '-N', ntap, ' ', ' ' )
      call getln (luin, ntap, 'r', 0)

      call rtape(luin, lhed, lbytes)
      if (lbytes .eq. 0) then
         write(LER,*)'SCOPE3D: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(lhed, 'NumSmp', nsamp, 0)
      call saver(lhed, 'SmpInt', nsi  , 0)
      call saver(lhed, 'NumTrc', ntrc , 0)
      call saver(lhed, 'NumRec', nrec , 0)
      call saver(lhed, 'UnitSc', unitsc,0)
      call saver(lhed, 'TmMsFS', TmMsFS,0)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(lhed, 'UnitSc', unitsc, LINHED)
      endif
      si = nsi
      if (.not. restart) then
         call hlhprt (lhed, lbytes, name, 7, LERR)
         call savhlh (lhed, lbytes, lbyout )
      endif
      lbytes = lbyout


      if ( .not. stk .AND. nmoap ) then

         call argstr( '-v', vtap, ' ', ' ' )
         if (vtap(1:1) .eq. ' ') then
            write(LERR,*)'FATAL ERROR in scope3d:'
            write(LERR,*)'Velocity data set must be a disk file. Use'
            write(LERR,*)'-v[] on cmd line'
            write(LER ,*)'FATAL ERROR in scope3d:'
            write(LER ,*)'Velocity data set must be a disk file. Use'
            write(LER ,*)'-v[] on cmd line'
            stop
         endif
         call getln (luvel, vtap, 'r', -1)
         if (luvel .lt. 1) then
           write(LERR,*)' '
           write(LERR,*)'FATAL ERROR in scope3d:'
           write(LERR,*)'Cannot pipe into velocity tape input. Must'
           write(LERR,*)'use named disk file using -v[]'
           write(LER ,*)' '
           write(LER ,*)'FATAL ERROR in scope3d:'
           write(LER ,*)'Cannot pipe into velocity tape input. Must'
           write(LER ,*)'use named disk file using -v[]'
           stop
         endif
         call sislgbuf (luvel, 'off')

      endif


      call argi4 ('-x1', ix1, 0 , 0 )
      call argi4 ('-y1', iy1, 0 , 0 )
      call argi4 ('-x2', ix2, 0 , 0 )
      call argi4 ('-y2', iy2, 0 , 0 )
      call argi4 ('-x3', ix3, 0 , 0 )
      call argi4 ('-y3', iy3, 0 , 0 )
      call argi4 ('-x4', ix4, 0 , 0 )
      call argi4 ('-y4', iy4, 0 , 0 )
      call argr4 ('-cldm', dx, 0., 0.)
      call argr4 ('-ildm', dy, 0., 0.)
      call argi4 ('-limin', limin , 1 , 1 )
      call argi4 ('-limax', limax , 0 , 0 )
      call argi4 ('-dimin', dimin , 1 , 1 )
      call argi4 ('-dimax', dimax , 0 , 0 )


      if (dx .eq. 0. .OR. dy .eq. 0.) then
         write(LERR,*)' '
         write(LERR,*)'Fatal Error in ',name
         write(LERR,*)'Must enter cell dimensions -cldm[] -ildm[]'
         write(LER ,*)' '
         write(LER ,*)'Fatal Error in ',name
         write(LER ,*)'Must enter cell dimensions -cldm[] -ildm[]'
         stop
      endif
      if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1     .AND.
     2    ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0
     3    ) then
         write(LERR,*)' '
         write(LERR,*)'Fatal Error in ',name
         write(LERR,*)'Must enter 4 corners of survey: use -x1[]'
         write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
         write(LER ,*)' '
         write(LER ,*)'Fatal Error in ',name
         write(LER ,*)'Must enter 4 corners of survey: use -x1[]'
         write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
         stop
      endif

      CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1            IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

      if (limax .eq. 0) then
          maxli = NX
      else
          maxli = limax
      endif
      if (limin .eq. 0) then
          minli = 1
      else
          minli = limin
      endif
      if (dimax .eq. 0) then
          maxdi = NY
      else
          maxdi = dimax
      endif
      if (dimin .eq. 0) then
          mindi = 1
      else
          mindi = dimin
      endif
 
      NDI    = maxdi - mindi + 1
      NLI    = maxli - minli + 1


      call argstr ( '-P', ptap, ' ', ' ')

c*****
c  for global we assume the data has been properly nmo corrected and windowed
c  and is ready for attribute calculations. Otherwise we need a horizon file(s)
c  for global we can only have 1 horizon
c*****
      IF ( global ) THEN

      nhor = 1

      ELSE

      call alloclun ( lupik )
      open (unit=lupik,file=ptap,status='old',iostat=ierr)
 
      if (ierr .ne. 0) then
          write(LERR,*)'FATAL ERROR in ',name,':'
          write(LERR,*)'Could not open input horizon pick file ',
     1                  ptap
          write(LERR,*)'Check directory permissions'
          write(LER ,*)'FATAL ERROR in ',name,':'
          write(LER ,*)'Could not open input horizon pick file ',
     1                  ptap
          write(LER ,*)'Check directory permissions'
          stop
      endif

c----
c   The horizon files must all be packed into one file with each horzn
c   separated by a null or blank line. The size of the output volume
c   will be determined by horz file nli & ndi and the cmd line input nsampo
c----
      call hint3d (lupik, nhor, minli, maxli, mindi, maxdi,
     1             nli, ndi, name, IX1, IY1,
     2             NX, NY, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     3             DX, DY)

      ENDIF
c*****

      do  i = 1, nhor

          call argstr ('-O', otap(i), ' ', ' ')
          if (otap(i) .eq. ' ') then
            write(LERR,*)'FATAL ERROR in ',name,':'
            write(LERR,*)'Need more -O[] files to equal number of'
            write(LERR,*)'horizons ( = ',nhor,' )'
            write(LER ,*)'FATAL ERROR in ',name,':'
            write(LER ,*)'Need more -O[] files to equal number of'
            write(LER ,*)'horizons ( = ',nhor,' )'
            stop
          endif
          if (restart) then
             call getln (luout(i), otap(i), 'r+', -1)
          else
             call getln (luout(i), otap(i), 'w+', -1)
          endif
          if (luout(i) .lt. 1) then
            write(LERR,*)'FATAL ERROR in ',name,':'
            write(LERR,*)'Cannot open output unit for ',otap(i)
            write(LER ,*)'FATAL ERROR in ',name,':'
            write(LER ,*)'Cannot open output unit for ',otap(i)
            stop
          endif
          call sislgbuf (luout(i), 'off')
          
          call argstr ('-T', ttap(i), ' ', ' ')
          if (ttap(i) .eq. ' ') then
            write(LERR,*)'FATAL ERROR in ',name,':'
            write(LERR,*)'Need more -T[] files to equal number of'
            write(LERR,*)'horizons ( = ',nhor,' )'
            write(LER ,*)'FATAL ERROR in ',name,':'
            write(LER ,*)'Need more -T[] files to equal number of'
            write(LER ,*)'horizons ( = ',nhor,' )'
            stop
          endif
          if (restart) then
             call getln (lunrm(i), ttap(i), 'r+', -1)
          else
             call getln (lunrm(i), ttap(i), 'w+', -1)
          endif
          if (lunrm(i) .lt. 1) then
            write(LERR,*)'FATAL ERROR in ',name,':'
            write(LERR,*)'Cannot open output unit for ',ttap(i)
            write(LER ,*)'FATAL ERROR in ',name,':'
            write(LER ,*)'Cannot open output unit for ',ttap(i)
            stop
          endif
          call sislgbuf (luout(i), 'off')
          

      enddo



      if ( debug ) then
         call alloclun ( lu_debug )
         open (unit=lu_debug,file=dtap,status='unknown',iostat=ierr)
 
         if (ierr .ne. 0) then
             write(LERR,*)'FATAL ERROR in ',name,':'
             write(LERR,*)'Could not open output horizon file ',
     1                     dtap
             write(LERR,*)'Check directory permissions'
             write(LER ,*)'FATAL ERROR in ',name,':'
             write(LER ,*)'Could not open output horizon file ',
     1                     dtap
             write(LER ,*)'Check directory permissions'
             stop
         endif
      endif


      return
      end
