      SUBROUTINE DMTAPE (IPRT,   luin, luout , IBYTES, luvel, nhor,
     &             IREC,   NREC,   lbytes, horizons, unitsc, si,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX, iord,
     &             NFOLD,  NTRCS,  NPAIRS, XM, TM, hdrwrd,refwrd,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, TmMsFS,
     &             NSAMPS, NSI, IX1, IY1, IX2, IY2, IX3, IY3, IX4,
     &             IY4, ist, ied, name, dxg, nattr, cdp, atrwrd,
     &             verbos, mute, restart, lunrm, nmoap,
     &             spread, ngrp, thresh, fcut, pkthr,
     &             XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     &             ifmin, ifmax, ifdel, stk, mstart, mlast,global)
C***********************************************************************00003620
C                                                                       00003630
C     PROGRAM NAME: DMTAPE (READ TAPE, DUMP AND WRITE MODIFIED OUTPUT)  00003640
C                                                                       00003650
C     LANGUAGE: FORTRAN                                                 00003660
C                                                                       00003670
C     AUTHOR: G.MURPHY                                                  00003680
C                                                                       00003690
C     DATE WRITTEN: 06/14/88                                            00003700
C                                                                       00003710
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00003730
C                                                                       00003750
C     ABSTRACT: READS INPUT DATASET DUMPS AND WRITES MODIFIED DATASET   00003760
C                                                                       00003770
C                                                                       00003780
C     MODIFICATION HISTORY: 06/14/88  -  INITIAL RELEASE                00003790
C                                                                       00003800
C***********************************************************************00003810
C                                                                       00003820
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

      real          horizons (ndi, nli, nhor)
      integer       intbin
      DIMENSION     XM (*), TM (*)
      DIMENSION     RHEAD  (SZLNHD)
      DIMENSION     TRACE  (SZLNHD)
      INTEGER       VHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      INTEGER       lhed  (SZLNHD)
      integer       luout (*)
      integer       lunrm (*), obytes, recnum, trcnum
      real          spread (*)
      real          wrk1(SZLNHD), wrk2(SZLNHD)
      real          sig(SZLNHD), vel(SZLNHD)
      real          tab(SZLNHD), sum(SZLNHD)
      real          stkt(SZLNHD)
      real          fwrk1(3), fwrk2(96), coefs(2,32)
      real          covm (9), cof (3)
      integer       array (3)
      integer       abort1

      real        work(1), fwork(1)
      real        freqs(1)

      pointer     (pwork,work)
      pointer     (pfwork,fwork)
      pointer     (pamp,c_amp_spec)
      pointer     (pamps,amp_spec)
      pointer     (pfreqs,freqs)
 
cprg----
c   max entropy vectors
cprg----
      real        v_mem, vc_mem, s_mem, sc_mem, a_mem
      pointer     (wkadra , a_mem (1))
      pointer     (wkadrv , v_mem (1))
      pointer     (wkadrs , s_mem (1))
      pointer     (wkadrvc, vc_mem(1))
      pointer     (wkadrsc, sc_mem(1))

      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT
      character     name * 7, hdrwrd * 6, refwrd * 6, atrwrd * 6
      logical       verbos, mute, stk, nmoap, global, cdp
      logical       first, restart

      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)

      DATA first   / .false. /
      DATA abort1 /0/

      DATA ISLIMN / 999999999 /
      DATA ISDIMN / 999999999 /
      DATA IRLIMN / 999999999 /
      DATA IRDIMN / 999999999 /
      DATA ICLIMN / 999999999 /
      DATA ICDIMN / 999999999 /
      DATA ISLIMX /-999999999 /
      DATA ISDIMX /-999999999 /
      DATA IRLIMX /-999999999 /
      DATA IRDIMX /-999999999 /
      DATA ICLIMX /-999999999 /
      DATA ICDIMX /-999999999 /
      DATA MINDST / 999999999 /
      DATA MAXDST /-999999999 /
      DATA MAXFLD /-999999999 /

      IRREC   = 0
      NRREC   = 0
      IOLD    = 0
      SI = NSI
      dt = si * unitsc

      do  j = 1, 3
          array(i) = i
      enddo

      ied0 = (nsamps-1) * nsi
      ist  = ist / nsi
      if (ist .le. 0) ist = 1
      ied = ied / nsi
      if (ied .le. 0) then
         write(LERR,*)'FATAL ERROR in scope3d:'
         write(LERR,*)'End window time must be > 0'
         write(LER ,*)'FATAL ERROR in scope3d:'
         write(LER ,*)'End window time must be > 0'
         call ccexit (666)
      endif

      fl = ifmin
      fh = ifmax
      call bwcoef ( fl, fh, dt, coefs, xnorm, 2, ift)

c----
c   open velocity tape if we're applying NMO; read line header
c----
      if (.not.stk .AND. nmoap) then

         call rtape (luvel, lhed, lvbytes)
         if (lvbytes .eq. 0) then
            write(LER,*)'SCOPE3D: no line header on velocity dataset',
     1                   luvel
            write(LER,*)'FATAL'
            stop
         endif

         call saver(lhed, 'NumSmp', nsampv, 0)
         call saver(lhed, 'SmpInt', nsiv  , 0)
         call saver(lhed, 'NumTrc', ntrcv , 0)
         call saver(lhed, 'NumRec', nrecv , 0)
         nvel = ntrcv * nrecv
      endif

      lwin = ied + ist + 1

      if (mlast .lt. 0) then
         mlast = lwin / 4
         write(LERR,*)'No mlast parameter given -- setting it to ',mlast
      elseif (mlast .eq. 0) then
         mlast = 2
      endif

      nfreq  = ifmax - ifmin + 1
      df = 1.0

      if (nfreq .lt. 3*iord) then
         write(LERR,*)'FATAL ERROR in scope3d:'
         write(LERR,*)'Number of freqs ',nfreq,' must be > ',3*iord
         write(LERR,*)'which is 3x spectral smooth order of ',iord
         write(LER ,*)'FATAL ERROR in scope3d:'
         write(LER ,*)'Number of freqs ',nfreq,' must be > ',3*iord
         write(LER ,*)'which is 3x spectral smooth order of ',iord
         call ccexit (666)
      endif

cprg----
c    max entropy  gallocs
cprg----
      mdim  = mlast * (mlast + 1)
      itemv = mdim  * ISZBYT
      itema = mlast * ISZBYT

      ier = 0
      jer  = 0
      iget = max(lwin,nfreq) * ISZBYT
      abort1 = 0
cprg----
c    max entropy  gallocs
 
      call galloc (wkadrv, itemv, jer, abort1)
      memsum=itemv
      if(jer.ne.0)ier=ier+1
      call galloc (wkadra, itema, jer, abort1)
      memsum=memsum+itema
      if(jer.ne.0)ier=ier+1
      call galloc (wkadrs, itema, jer, abort1)
      memsum=memsum+itema
      if(jer.ne.0)ier=ier+1
      call galloc (wkadrvc, itemv, jer, abort1)
      memsum=memsum+itemv
      if(jer.ne.0)ier=ier+1
      call galloc (wkadrsc, itema, jer, abort1)
      memsum=memsum+itema
      if(jer.ne.0)ier=ier+1
cprg----
      call galloc (pfreqs, iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1
      call galloc (pwork, iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1
      call galloc (pfwork, iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1
      call galloc (pamp,  iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1
      call galloc (pamps,  iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1
      call galloc (pfreq, iget, jer, abort1)
      memsum=memsum+iget
      if(jer.ne.0)ier=ier+1


      if (ier.ne.0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         stop
      endif

      icut = 0
      do  i = 1, nfreq

          freqs (i) = ifmin + (i-1) * df
          if (freqs(i) .le. fcut) then
              icut = icut + 1
          endif
      enddo
      ifc = icut

      pi    = 3.14159265
      deg   = 180. /  pi

      if (.not. stk) then
         call minmgv (spread, 1, xmin, loc, ngrp)
         write(LER,*)' '
         write(LER,*)'Minimum offset= ',xmin,' at group ',loc
         if (abs (xmin) .lt. 1.e-10) then
            spread (loc) = .0005
         endif
         write(LER,*)' '
         sprdmax = spread (ngrp)
         sprdmin = spread (1)
      endif

C *** build pointers into trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcAz',ifmt_SrRcAz,l_SrRcAz,ln_SrRcAz,TRACEHEADER)
      call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)
      if (refwrd(1:1) .ne. ' ')
     1 call savelu(refwrd,ifmt_refwrd,l_refwrd,ln_refwrd,TRACEHEADER)
      if (atrwrd(1:1) .ne. ' ')
     1 call savelu(atrwrd,ifmt_atrwrd,l_atrwrd,ln_atrwrd,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      IREC = 0

c---
c  there are 2 output files that are basically read/write:

c  (1) output data itself - consists of binned attribute stacks with

c  (2) normalization data set - consists of sample-by-sample normalization
c      for each of the output attribute traces (will be the same size as the
c      main output data set).

c      in addition there is the RMS velocity data set (which must be sampled
c      the same as the input data).
c---
      mfreqo = (ifmax - ifmin) / ifdel + 1

      ngrp1 = ngrp - 1

      if (ngrp .gt. 1) then
         nsampo = (nattr + mfreqo) + (nattr * ngrp1 + 2 * nattr) +
     1            (mfreqo * ngrp1) + lwin
         nsampa = (nattr + mfreqo) + (nattr * ngrp1 + 2 * nattr) +
     1            (mfreqo * ngrp1)
      else
         nsampo = (nattr + mfreqo) + lwin
         nsampa = (nattr + mfreqo)
      endif



      write(LERR,*)' '
      write(LERR,*)'*********************************'
      write(LERR,*)'scope3d starts:'
      write(LERR,*)' '
      write(LERR,*)'Min LI asked for =  ',minli
      write(LERR,*)'Max LI asked for =  ',maxli
      write(LERR,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LERR,*)'Min DI asked for =  ',mindi
      write(LERR,*)'Max DI asked for =  ',maxdi
      write(LERR,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LERR,*)'Number attributes=  ',nattr
      write(LERR,*)'Start frequency  =  ',ifmin
      write(LERR,*)'End frequency    =  ',ifmax
      write(LERR,*)'Delta frequency  =  ',ifdel
      write(LERR,*)'Number of freqs  =  ',mfreqo
      write(LERR,*)'Number of samps  =  ',nsampo
      write(LERR,*)'Number trc samps =  ',lwin
      write(LERR,*)'Start MEM order  =  ',mstart
      write(LERR,*)'End MEM order    =  ',mlast
      write(LERR,*)'Sample unit scale=  ',unitsc
      write(LERR,*)'Time 1st sample  =  ',TmMsFS,' (ms)'
      if (refwrd(1:1) .ne. ' ')
     1write(LERR,*)'Time reference wrd=  ',refwrd
      if (atrwrd(1:1) .ne. ' ')
     1write(LERR,*)'Attribute hdr wrd =  ',atrwrd
      write(LERR,*)'Cutoff freq (Q)  =  ',fcut,' f index= ',ifc
      write(LERR,*)'Spectral smooth  =  ',iord,'( order)'
      iTmMsFS = nint ( TmMsFS / float(nsi) )
      write(LERR,*)'Time 1st sample  =  ',iTmMsFS,' (samps)'
      if (stk) then
      write(LERR,*)'Input is stack data'
      else
      if (cdp) then
      write(LERR,*)'Use CDPBCX & CDPBCY for trace XYs'
      else
      write(LERR,*)'Use src & rcvr XYs'
      endif
      write(LERR,*)'Min offset used   =   ',DSTMIN
      write(LERR,*)'Max offset used   =   ',DSTMAX
      write(LERR,*)'Number offset bins=  ',ngrp1
      endif
      write(LERR,*)' '
      write(LERR,*)'          Trace Organization of Attributes:'
      write(LERR,*)'*************'
      write(LERR,*)'All Offsets:'
      write(LERR,*)'Sample   1:   absolute maximum amplitude'
      write(LERR,*)'Sample   2:   its time'
      write(LERR,*)'Sample   3:   maximum positive amplitude'
      write(LERR,*)'Sample   4:   its time'
      write(LERR,*)'Sample   5:   maximum negative amplitude'
      write(LERR,*)'Sample   6:   its time'
      write(LERR,*)'Sample   7:   standard deviation'
      write(LERR,*)'Sample   8:   peak frequency'
      write(LERR,*)'Sample   9:   Q'
      write(LERR,*)'Sample  10:   envelope maximum'
      write(LERR,*)'Sample  11:   its time'
      write(LERR,*)'Sample  12:   response phase'
      write(LERR,*)'Sample  13:   response amplitude'
      write(LERR,*)'Sample  14:   response length'
      write(LERR,*)'Sample  15:   instantaneous bandwidth'
      write(LERR,*)'Sample  16:   trace header attribute value'
      write(LERR,*)'Sample  17:   integrated power'
      write(LERR,*)'Sample  18:   instantaneous frequency'
      write(LERR,*)'Sample  19:   response frequency'
      write(LERR,*)' '
      do  i = 1, mfreqo
      ii = nattr + i
      ff = ifmin + (i-1) * ifdel
      write(LERR,*)'Sample  ',ii,':   amplitude at frequency ',ff
      enddo
      write(LERR,*)' '
      write(LERR,*)'*************'
      IF (.not.stk .or. ngrp .gt. 1) then
      ioff = nattr + mfreqo
      do  j = 1, ngrp1
      npntr = (j-1) * nattr + ioff
      write(LERR,*)'For Binned Offset ',spread(j),' - ',spread(j+1),
     1             '   ***********'
      ii = npntr + 1
      write(LERR,*)'Sample  ',ii,':   absolute maximum amplitude'
      ii = npntr + 2
      write(LERR,*)'Sample  ',ii,':   its time'
      ii = npntr + 3
      write(LERR,*)'Sample  ',ii,':   maximum positive amplitude'
      ii = npntr + 4
      write(LERR,*)'Sample  ',ii,':   its time'
      ii = npntr + 5
      write(LERR,*)'Sample  ',ii,':   maximum negative amplitude'
      ii = npntr + 6
      write(LERR,*)'Sample  ',ii,':   its time'
      ii = npntr + 7
      write(LERR,*)'Sample  ',ii,':   standard deviation'
      ii = npntr + 8
      write(LERR,*)'Sample  ',ii,':   peak frequency'
      ii = npntr + 9
      write(LERR,*)'Sample  ',ii,':   Q'
      ii = npntr + 10
      write(LERR,*)'Sample  ',ii,':   envelope maximum'
      ii = npntr + 11
      write(LERR,*)'Sample  ',ii,':   its time'
      ii = npntr + 12
      write(LERR,*)'Sample  ',ii,':   response phase'
      ii = npntr + 13
      write(LERR,*)'Sample  ',ii,':   response amplitude'
      ii = npntr + 14
      write(LERR,*)'Sample  ',ii,':   response length'
      ii = npntr + 15
      write(LERR,*)'Sample  ',ii,':   instantaneous bandwidth'
      ii = npntr + 16
      write(LERR,*)'Sample  ',ii,':   trace header attribute value'
      ii = npntr + 17
      write(LERR,*)'Sample  ',ii,':   integrated power'
      ii = npntr + 18
      write(LERR,*)'Sample  ',ii,':   instantaneous frequency'
      ii = npntr + 19
      write(LERR,*)'Sample  ',ii,':   response frequency'
      enddo

      ioff = ioff + nattr * ngrp1

      write(LERR,*)' '
      ii = ioff + 1
      write(LERR,*)'Sample  ',ii,':   slope absolute maximum amplitude'
      ii = ioff + 2
      write(LERR,*)'Sample  ',ii,':   slope its time'
      ii = ioff + 3
      write(LERR,*)'Sample  ',ii,':   slope maximum positive amplitude'
      ii = ioff + 4
      write(LERR,*)'Sample  ',ii,':   slope its time'
      ii = ioff + 5
      write(LERR,*)'Sample  ',ii,':   slope maximum negative amplitude'
      ii = ioff + 6
      write(LERR,*)'Sample  ',ii,':   slope its time'
      ii = ioff + 7
      write(LERR,*)'Sample  ',ii,':   slope standard deviation'
      ii = ioff + 8
      write(LERR,*)'Sample  ',ii,':   slope peak frequency'
      ii = ioff + 9
      write(LERR,*)'Sample  ',ii,':   slope Q'
      ii = ioff + 10
      write(LERR,*)'Sample  ',ii,':   slope envelope maximum'
      ii = ioff + 11
      write(LERR,*)'Sample  ',ii,':   slope its time'
      ii = ioff + 12
      write(LERR,*)'Sample  ',ii,':   slope response phase'
      ii = ioff + 13
      write(LERR,*)'Sample  ',ii,':   slope response amplitude'
      ii = ioff + 14
      write(LERR,*)'Sample  ',ii,':   slope response length'
      ii = ioff + 15
      write(LERR,*)'Sample  ',ii,':   slope instantaneous bandwidth'
      ii = ioff + 16
      write(LERR,*)'Sample  ',ii,':   slope trace header value'
      ii = ioff + 17
      write(LERR,*)'Sample  ',ii,':   slope integrated power'
      ii = ioff + 18
      write(LERR,*)'Sample  ',ii,':   slope instantaneous frequency'
      ii = ioff + 19
      write(LERR,*)'Sample  ',ii,':   slope response frequency'
      write(LERR,*)' '
      ii = ioff + 20
      write(LERR,*)'Sample  ',ii,':   offset absolute maximum amplitude'
      ii = ioff + 21
      write(LERR,*)'Sample  ',ii,':   offset its time'
      ii = ioff + 22
      write(LERR,*)'Sample  ',ii,':   offset maximum positive amplitude'
      ii = ioff + 23
      write(LERR,*)'Sample  ',ii,':   offset its time'
      ii = ioff + 24
      write(LERR,*)'Sample  ',ii,':   offset maximum negative amplitude'
      ii = ioff + 25
      write(LERR,*)'Sample  ',ii,':   offset its time'
      ii = ioff + 26
      write(LERR,*)'Sample  ',ii,':   offset standard deviation'
      ii = ioff + 27
      write(LERR,*)'Sample  ',ii,':   offset peak frequency'
      ii = ioff + 28
      write(LERR,*)'Sample  ',ii,':   offset Q'
      ii = ioff + 29
      write(LERR,*)'Sample  ',ii,':   offset envelope maximum'
      ii = ioff + 30
      write(LERR,*)'Sample  ',ii,':   offset its time'
      ii = ioff + 31
      write(LERR,*)'Sample  ',ii,':   offset response phase'
      ii = ioff + 32
      write(LERR,*)'Sample  ',ii,':   offset response amplitude'
      ii = ioff + 33
      write(LERR,*)'Sample  ',ii,':   offset response length'
      ii = ioff + 34
      write(LERR,*)'Sample  ',ii,':   offset instantaneous bandwidth'
      ii = ioff + 35
      write(LERR,*)'Sample  ',ii,':   offset trc header attribute value'
      ii = ioff + 36
      write(LERR,*)'Sample  ',ii,':   offset integrated power'
      ii = ioff + 37
      write(LERR,*)'Sample  ',ii,':   offset instantaneous frequency'
      ii = ioff + 38
      write(LERR,*)'Sample  ',ii,':   offset response frequency'
      write(LERR,*)' '

      ioff = ioff + 2 * nattr

      do  j = 1, ngrp1
      write(LERR,*)'For Binned Offset ',spread(j),' - ',spread(j+1),
     1             '   ***********'
      do  i = 1, mfreqo
      ii = (j-1) * mfreqo + ioff + i
      ff = ifmin + (i-1) * ifdel
      write(LERR,*)'Sample  ',ii,':   amplitude at frequency ',ff
      enddo
      enddo
      ENDIF
      write(LERR,*)' '
      ioff = ii + 1
      write(LERR,*)'Samples ',ioff,' to ',nsampo,': stack windowed trc'
      write(LERR,*)' '
      write(LERR,*)'*********************************'
      write(LERR,*)' '

      write(LER ,*)' '
      write(LER ,*)'          Trace Organization of Attributes:'
      write(LER ,*)'*************'
      write(LER ,*)'All Offsets:'
      write(LER ,*)'Sample   1:   absolute maximum amplitude'
      write(LER ,*)'Sample   2:   its time'
      write(LER ,*)'Sample   3:   maximum positive amplitude'
      write(LER ,*)'Sample   4:   its time'
      write(LER ,*)'Sample   5:   maximum negative amplitude'
      write(LER ,*)'Sample   6:   its time'
      write(LER ,*)'Sample   7:   standard deviation'
      write(LER ,*)'Sample   8:   peak frequency'
      write(LER ,*)'Sample   9:   Q'
      write(LER ,*)'Sample  10:   envelope maximum'
      write(LER ,*)'Sample  11:   its time'
      write(LER ,*)'Sample  12:   response phase'
      write(LER ,*)'Sample  13:   response amplitude'
      write(LER ,*)'Sample  14:   response length'
      write(LER ,*)'Sample  15:   instantaneous bandwidth'
      write(LER ,*)'Sample  16:   trace header attribute value'
      write(LER ,*)'Sample  17:   integrated power'
      write(LER ,*)'Sample  18:   instantaneous frequency'
      write(LER ,*)'Sample  19:   response frequency'
      write(LER ,*)' '
      do  i = 1, mfreqo
      ii = nattr + i
      ff = ifmin + (i-1) * ifdel
      write(LER ,*)'Sample  ',ii,':   amplitude at frequency ',ff
      enddo
      write(LER ,*)' '
      write(LER ,*)'*************'
      IF (.not.stk .or. ngrp .gt. 1) then
      ioff = nattr + mfreqo
      do  j = 1, ngrp1
      npntr = (j-1) * nattr + ioff
      write(LER ,*)'For Binned Offset ',spread(j),' - ',spread(j+1),
     1             '   ***********'
      ii = npntr + 1
      write(LER ,*)'Sample  ',ii,':   absolute maximum amplitude'
      ii = npntr + 2
      write(LER ,*)'Sample  ',ii,':   its time'
      ii = npntr + 3
      write(LER ,*)'Sample  ',ii,':   maximum positive amplitude'
      ii = npntr + 4
      write(LER ,*)'Sample  ',ii,':   its time'
      ii = npntr + 5
      write(LER ,*)'Sample  ',ii,':   maximum negative amplitude'
      ii = npntr + 6
      write(LER ,*)'Sample  ',ii,':   its time'
      ii = npntr + 7
      write(LER ,*)'Sample  ',ii,':   standard deviation'
      ii = npntr + 8
      write(LER ,*)'Sample  ',ii,':   peak frequency'
      ii = npntr + 9
      write(LER ,*)'Sample  ',ii,':   Q'
      ii = npntr + 10
      write(LER ,*)'Sample  ',ii,':   envelope maximum'
      ii = npntr + 11
      write(LER ,*)'Sample  ',ii,':   its time'
      ii = npntr + 12
      write(LER ,*)'Sample  ',ii,':   response phase'
      ii = npntr + 13
      write(LER ,*)'Sample  ',ii,':   response amplitude'
      ii = npntr + 14
      write(LER ,*)'Sample  ',ii,':   response length'
      ii = npntr + 15
      write(LER ,*)'Sample  ',ii,':   instantaneous bandwidth'
      ii = npntr + 16
      write(LER ,*)'Sample  ',ii,':   trace header attribute value'
      ii = npntr + 17
      write(LER ,*)'Sample  ',ii,':   integrated power'
      ii = npntr + 18
      write(LER ,*)'Sample  ',ii,':   instantaneous frequency'
      ii = npntr + 19
      write(LER ,*)'Sample  ',ii,':   response frequency'
      enddo

      ioff = ioff + nattr * ngrp1

      write(LER ,*)' '
      ii = ioff + 1
      write(LER ,*)'Sample  ',ii,':   slope absolute maximum amplitude'
      ii = ioff + 2
      write(LER ,*)'Sample  ',ii,':   slope its time'
      ii = ioff + 3
      write(LER ,*)'Sample  ',ii,':   slope maximum positive amplitude'
      ii = ioff + 4
      write(LER ,*)'Sample  ',ii,':   slope its time'
      ii = ioff + 5
      write(LER ,*)'Sample  ',ii,':   slope maximum negative amplitude'
      ii = ioff + 6
      write(LER ,*)'Sample  ',ii,':   slope its time'
      ii = ioff + 7
      write(LER ,*)'Sample  ',ii,':   slope standard deviation'
      ii = ioff + 8
      write(LER ,*)'Sample  ',ii,':   slope peak frequency'
      ii = ioff + 9
      write(LER ,*)'Sample  ',ii,':   slope Q'
      ii = ioff + 10
      write(LER ,*)'Sample  ',ii,':   slope envelope maximum'
      ii = ioff + 11
      write(LER ,*)'Sample  ',ii,':   slope its time'
      ii = ioff + 12
      write(LER ,*)'Sample  ',ii,':   slope response phase'
      ii = ioff + 13
      write(LER ,*)'Sample  ',ii,':   slope response amplitude'
      ii = ioff + 14
      write(LER ,*)'Sample  ',ii,':   slope response length'
      ii = ioff + 15
      write(LER ,*)'Sample  ',ii,':   slope instantaneous bandwidth'
      ii = ioff + 16
      write(LER ,*)'Sample  ',ii,':   slope trace header value'
      ii = ioff + 17
      write(LER ,*)'Sample  ',ii,':   slope integrated power'
      ii = ioff + 18
      write(LER ,*)'Sample  ',ii,':   slope instantaneous frequency'
      ii = ioff + 19
      write(LER ,*)'Sample  ',ii,':   slope response frequency'
      write(LER ,*)' '
      ii = ioff + 20
      write(LER ,*)'Sample  ',ii,':   offset absolute maximum amplitude'
      ii = ioff + 21
      write(LER ,*)'Sample  ',ii,':   offset its time'
      ii = ioff + 22
      write(LER ,*)'Sample  ',ii,':   offset maximum positive amplitude'
      ii = ioff + 23
      write(LER ,*)'Sample  ',ii,':   offset its time'
      ii = ioff + 24
      write(LER ,*)'Sample  ',ii,':   offset maximum negative amplitude'
      ii = ioff + 25
      write(LER ,*)'Sample  ',ii,':   offset its time'
      ii = ioff + 26
      write(LER ,*)'Sample  ',ii,':   offset standard deviation'
      ii = ioff + 27
      write(LER ,*)'Sample  ',ii,':   offset peak frequency'
      ii = ioff + 28
      write(LER ,*)'Sample  ',ii,':   offset Q'
      ii = ioff + 29
      write(LER ,*)'Sample  ',ii,':   offset envelope maximum'
      ii = ioff + 30
      write(LER ,*)'Sample  ',ii,':   offset its time'
      ii = ioff + 31
      write(LER ,*)'Sample  ',ii,':   offset response phase'
      ii = ioff + 32
      write(LER ,*)'Sample  ',ii,':   offset response amplitude'
      ii = ioff + 33
      write(LER ,*)'Sample  ',ii,':   offset response length'
      ii = ioff + 34
      write(LER ,*)'Sample  ',ii,':   offset instantaneous bandwidth'
      ii = ioff + 35
      write(LER ,*)'Sample  ',ii,':   offset trc header attribute value'
      ii = ioff + 36
      write(LER ,*)'Sample  ',ii,':   offset integrated power'
      ii = ioff + 37
      write(LER ,*)'Sample  ',ii,':   offset instantaneous frequency'
      ii = ioff + 38
      write(LER ,*)'Sample  ',ii,':   offset response frequency'
      write(LER ,*)' '

      ioff = ioff + 2 * nattr

      do  j = 1, ngrp1
      write(LER ,*)'For Binned Offset ',spread(j),' - ',spread(j+1),
     1             '   ***********'
      do  i = 1, mfreqo
      ii = (j-1) * mfreqo + ioff + i
      ff = ifmin + (i-1) * ifdel
      write(LER ,*)'Sample  ',ii,':   amplitude at frequency ',ff
      enddo
      enddo
      ENDIF
      write(LER ,*)' '
      ioff = ii + 1
      write(LER ,*)'Samples ',ioff,' to ',nsampo,': stack windowed trc'
      write(LER ,*)' '
      write(LER ,*)'*********************************'
      write(LER ,*)' '


      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)'scope3d starts:'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'Number attributes=  ',nattr
      write(LER,*)'Start frequency  =  ',ifmin
      write(LER,*)'End frequency    =  ',ifmax
      write(LER,*)'Delta frequency  =  ',ifdel
      write(LER,*)'Number of freqs  =  ',mfreqo
      write(LER,*)'Number of samps  =  ',nsampo
      write(LER,*)'Number trc samps =  ',lwin
      if (stk) then
      write(LER,*)'Input is stack data'
      else
      write(LER,*)'Min offset used   =   ',DSTMIN
      write(LER,*)'Max offset used   =   ',DSTMAX
      write(LER,*)'Number offset bins=  ',ngrp1
      endif
      write(LER,*)'*********************************'
      write(LER,*)' '

      NRECo  = NLI
      NTRCo  = NDI
      

      obytes = SZTRHD + nsampo * SZSMPD

      NXNY  = NLI * NDI

      if (nvel .ne. nxny .AND. .not.stk .AND. nmoap) then
         write(LERR,*)'FATAL ERROR in scope3d:'
         write(LERR,*)'Number of records in velocity tape data set'
         write(LERR,*) nrecv
         write(LERR,*)'is not equal to number of output cells'
         write(LERR,*) nxny
         write(LERR,*)'Check velocity tape building steps'
         write(LER ,*)'FATAL ERROR in scope3d:'
         write(LER ,*)'Number of records in velocity tape data set'
         write(LER ,*) nrecv
         write(LER ,*)'is not equal to number of output cells'
         write(LER ,*) nxny
         write(LER ,*)'Check velocity tape building steps'
         stop
      endif
      if (nsampv .ne. nsamps .AND. .not.stk .AND. nmoap) then
         write(LERR,*)'FATAL ERROR in scope3d:'
         write(LERR,*)'Number of velocity samples ',nsampv,' not equal'
         write(LERR,*)'to input trace length ',nsamps,' Fix velocities.'
         write(LER ,*)'FATAL ERROR in scope3d:'
         write(LER ,*)'Number of velocity samples ',nsampv,' not equal'
         write(LER ,*)'to input trace length ',nsamps,' Fix velocities.'
         stop
      endif

c---
c  tab   - I/O vector for the D/A normalization file
c---

c-----
C *** adjust line header & write output LH
c-----
      call savew (JHEAD, 'NumTrc', NTRCo  , LINHED)
      call savew (JHEAD, 'NumRec', NRECo  , LINHED)
      call savew (JHEAD, 'NumSmp', NSAMPo , LINHED)
      call savew (JHEAD, 'Format', 3      , LINHED)
      call savew (JHEAD, 'MnLnIn', MINLI  , LINHED)
      call savew (JHEAD, 'MxLnIn', MAXLI  , LINHED)
      call savew (JHEAD, 'MnDpIn', MINDI  , LINHED)
      call savew (JHEAD, 'MxDpIn', MAXDI  , LINHED)
      call savew (JHEAD, 'ILClIn', DX     , LINHED)
      call savew (JHEAD, 'CLClIn', DY     , LINHED)

      if (.not. restart) then

         do  iu = 1, nhor
             call rwd (luout (iu) )
             CALL WRTAPE (luout (iu) , JHEAD, lbytes)
         enddo
         do  iu = 1, nhor
            call rwd (lunrm (iu))
            call savew (JHEAD, 'NumTrc', nang   , LINHED)
            call savew (JHEAD, 'NumRec', NXNY   , LINHED)
            CALL WRTAPE (lunrm (iu), JHEAD, lbytes)
         enddo

         call savew (JHEAD, 'NumTrc', NTRCo  , LINHED)
         call savew (JHEAD, 'NumRec', NRECo  , LINHED)
         call savew (JHEAD, 'NumSmp', NSAMPo , LINHED)

      else

         do  iu = 1, nhor
             call rwd (luout (iu) )
             CALL  RTAPE (luout (iu) , JHEAD, LBYTES)
             if (lbytes .eq. 0) then
             write(LERR,*)'Fatal error in scope3d:'
             write(LERR,*)'Restart failed because output file does'
             write(LERR,*)'not have a line header. You must re-run'
             write(LERR,*)'from scratch.'
             stop 666
             endif
         enddo
         do  iu = 1, nhor
            call sislgbuf (lunrm (iu), 'off')
            call rwd (lunrm (iu))
            CALL RTAPE (lunrm (iu), JHEAD, KBYTES)
             if (KBYTES .eq. 0) then
             write(LERR,*)'Fatal error in scope3d:'
             write(LERR,*)'Restart failed because norml file does'
             write(LERR,*)'not have a line header. You must re-run'
             write(LERR,*)'from scratch.'
             stop 666
             endif
         enddo

      endif


c-----
c     fill up output data set and the rewind and read over LH
c     do same for the normalizations data
c-----
      call vmov (tab, 1, jhead(ITHWP1), 1, nsampo)

      if (.not. restart) then
         call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               30000 , TRACEHEADER)
         call savew2(JHEAD,ifmt_VPick1,l_VPick1, ln_VPick1,
     1               0     , TRACEHEADER)
         do  iu = 1, nhor
             write(LER,*)'Building output data file ',iu,
     1                   ' with ',NXNY,' traces'
             do  i = 1, NXNY
                 call wrtape (luout(iu) , jhead, obytes)
             enddo
             call sislgbuf (luout(iu) , 'off')
         enddo

      endif

      call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            0 , TRACEHEADER)

c-----
c *** fill up file for normalization
c-----
      if (.not.restart) then

         write(LER,*)'Building normalization data file',
     1                   ' with ',NXNY,' traces'
         call vmov (tab, 1, jhead(ITHWP1), 1, nsampo)
         do  iu = 1, nhor
           do  i = 1, NXNY
               call wrtape (lunrm (iu), jhead, obytes)
           enddo
           call sislgbuf (lunrm (iu), 'off')
         enddo

      endif


      write(LER,*)'Built I/O files: you have enough disk space'

c-----
C *** zero out output and normalization panels
c-----
      call vclr (stkt, 1, nsampo)
      call vclr (sum , 1, nsampo)

c-----
c     For the spread geometry (trace distances) and for all bins:
c     read the velocities; pre-compute all the ray traced angles (which
c     we'll need when turning the trace to be stacked on and off), and
c     store the angle info on disk in decimated form
c-----
      IF (restart) go to 1400

      write(LER ,*)' '
      write(LER ,*)'Computing atttributes:'
      write(LER ,*)'mindi,maxdi,minli,maxli= ',mindi,maxdi,minli,maxli

1400  CONTINUE

      write(LER,*)'Now reading traces'

      if ( verbos ) then
         write(LERR,*)
     :   '       LI        DI      time  start    end   samps   offset'
      endif
c-----
C *** READ THE TRACES.                                                  00004650
c-----

      trcnum = 0
      recnum = 1

 1500 CONTINUE

      IBYTES = 0
      IWRN = 0
      call vclr (trace, 1, nsampo)

      CALL RTAPE (luin, JHEAD, IBYTES)
      call vmov  (JHEAD(ITHWP1), 1, TRACE, 1, NSAMPS)

C *** GO TO BEGIN OUTPUT IF END OF INPUT TAPE                           00004710

      IF (IBYTES .EQ. 0) GO TO 5000

c     call saver2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
c    1            IRREC  , TRACEHEADER)
c     call saver2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
c    1            IRTRC  , TRACEHEADER)
      call saver2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            IDEAD  , TRACEHEADER)
      call saver2(JHEAD,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1            icenter, TRACEHEADER)
      if (refwrd(1:1) .ne. ' ') then
         call saver2(JHEAD,ifmt_refwrd,l_refwrd, ln_refwrd,
     1               ireftim, TRACEHEADER)
         reftim = nint ( float(ireftim) / float(nsi) )
      else
         reftim = 0
      endif
      if (atrwrd(1:1) .ne. ' ') then
         call saver2(JHEAD,ifmt_atrwrd,l_atrwrd, ln_atrwrd,
     1               iatrwrd, TRACEHEADER)
      endif

      trcnum = trcnum + 1
      IF (trcnum .gt. NTRCS) THEN
         write(LER,*)'Done attribute analysis on seql Record ',recnum
         trcnum = 1
         recnum = recnum + 1
      END IF

C *** GET SOURCE TO RECEIVER DISTANCE                                   00004810

      IF (IDEAD .GE. 30000) GO TO 1500

C *** GET SHOT COORDINATE                                               00004930
      IF ( stk .OR. cdp ) THEN

         call saver2(JHEAD,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1               ICDPX   , TRACEHEADER)
         call saver2(JHEAD,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1               ICDPY   , TRACEHEADER)

         CX = ICDPX
         CY = ICDPY
         CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT, IWRN,
     1                IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                DX, DY, NDI, NLI)

      ELSE

         call saver2(JHEAD,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               ISX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1               ISY     , TRACEHEADER)
         SX = ISX
         SY = ISY
         CALL XFMFWD (SX, SY, ISLI, ISDI, SXT, SYT, DM, DM, IWRN,
     1                IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                DX, DY, NDI, NLI)


C *** GET RECEIVER COORDINATE                                           00004980

         call saver2(JHEAD,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               IRX     , TRACEHEADER)
         call saver2(JHEAD,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               IRY     , TRACEHEADER)
         RX = IRX
         RY = IRY
         CALL XFMFWD (RX, RY, IRLI, IRDI, RXT, RYT, DM, DM, IWRN,
     1                IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                DX, DY, NDI, NLI)


C *** GET THE CDP COORDINATE (if shot mode we have to compute it)

         ICDPX = 0.5 * float (ISX + IRX) + 0.5
         ICDPY = 0.5 * float (ISY + IRY) + 0.5
         CX = ICDPX
         CY = ICDPY
         CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT,BXT,BYT, IWRN,
     1                IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                DX, DY, NDI, NLI)

      ENDIF


C *** TRANSLATE SHOT AND RECEIVER INTO GRID COORDINATE SYSTEM

      ISLIMN = MIN (ISLIMN, ISLI)
      ISDIMN = MIN (ISDIMN, ISDI)
      IRLIMN = MIN (IRLIMN, ISLI)
      IRDIMN = MIN (IRDIMN, ISDI)
      ICLIMN = MIN (ICLIMN, ISLI)
      ICDIMN = MIN (ICDIMN, ISDI)
      ISLIMX = MAX (ISLIMX, ISLI)
      ISDIMX = MAX (ISDIMX, ISDI)
      IRLIMX = MAX (IRLIMX, ISLI)
      IRDIMX = MAX (IRDIMX, ISDI)
      ICLIMX = MAX (ICLIMX, ISLI)
      ICDIMX = MAX (ICDIMX, ISDI)


C *** COMPUTE PRIMARY DIRECTION OF S/R AZIMUTH RELATIVE TO GRID
C *** COMPUTE offset and check offset limits

      IF ( .not. stk ) THEN

         if ( cdp ) then
            call saver2(JHEAD,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                  idist, TRACEHEADER)
            off = idist
         else
            DXT  = SXT - RXT
            DYT  = SYT - RYT
            off  = sqrt ( DXT*DXT + DYT*DYT )
         endif

         if (off .gt. DSTMAX) go to 1500
         if (off .lt. DSTMIN) go to 1500

         IF ( .not. cdp ) THEN

c-----
c  figure out whether the S-R line is primarily in the DI (or X)
c  direction or the LI (orY) direction. this is necessary to
c  calculate the proper step sizes in each direction
c-----
            IF (ABS(DXT) .GE. ABS(DYT)) THEN
               DDX    = DX
               DDY    = abs (DYT * DDX / DXT )
            ELSE
               DDY    = DY
               DDX    = abs (DXT * DDY / DYT )
            END IF
c-----
c  based on the orientation of the S-R line we compute the sign
c  of the steps in the X and Y directions. thus we step from
c  the S cell location along the line to the R location.
c-----
            if (DXT .ne. 0.) then
                sgnx = -sign (1.0, DXT)
                DDX  = sgnx * DDX
            endif
            if (DYT .ne. 0.) then
                sgny = -sign (1.0, DYT)
                DDY  = sgny * DDY
            endif

         ENDIF

      ENDIF

c----
c   if the current midpoint location of this trace is out of bounds
c   skip over any computations and drop to the end of the loop - go
c   back and read a new trace
c----

      IF (ICLI .LT. MINLI) IWRN = 1
      IF (ICLI .GT. MAXLI) IWRN = 1
      IF (ICDI .LT. MINDI) IWRN = 1
      IF (ICDI .GT. MAXDI) IWRN = 1

      IF (IWRN .EQ. 0) THEN

c-----
c  for pre-stack data:
c  find the pointer into the spread array for the current offset
c-----
          if ( .not. stk) then
             joff = intbin (ngrp1, dxg, spread, off)
             IDIST = off
             MINDST = MIN (MINDST, IDIST)
             MAXDST = MAX (MAXDST, IDIST)
          else
             joff = 1
          endif

c-----
c  for pre-stack data:
c  get velocity if it is a velocity tape data set. each velocity trace
c  must reside at a location corresponding to the output grid. If
c  the velocity trace is coarsely sampled the interpolate.
c-----
          jli   = ICLI - minli + 1
          jdi   = ICDI - mindi + 1
          ipntr = (ICDI - mindi) + (ICLI - minli) * ndi + 1

          IF ( .not. stk .AND. nmoap ) THEN

             call sisseek (luvel, ipntr)
             call rtape (luvel, vhead, nvbytes)
             if (nvbytes .eq. 0) then
                 write(LERR,*)'FATAL ERROR in scope3d:'
                 write(LERR,*)'Premature end of velocity data at LI/DI= 
     1',ICLI,ICDI
                 write(LERR,*)'Check velocity tape building steps.'
                 stop
             endif
             call vmov (vhead(ITHWP1), 1, vel, 1, nsampv)
             call minv (vel, 1, vmin, loc, nsamps)
             if (vmin .le. 0.) then
                 write(LERR,*)'FATAL ERROR in scope3d:'
                 write(LERR,*)'detected velocity < 0. Something bad'
                 write(LERR,*)'either in input velocity traces'
                 stop
             endif

          ENDIF

          DO  iu = 1, nhor

c-----
c  (1) extract the current stacked attribute trace from this cell
c  (2) extract the current normalization trace from this cell
c  (3) extract the windowed data based on (a) internally carried
c      window center time in the trace header, or (b) window time
c      extracted from a horizon file derived time matrix
c-----
              call vclr (tab, 1, nsampo)

              call sisseek (luout(iu) , ipntr)
              call rtape (luout(iu) , jhead, nbytes)
              call vmov (jhead(ITHWP1), 1, stkt, 1, nsampo)

              call sisseek (lunrm(iu), ipntr)
              call rtape   (lunrm(iu), jhead, nbytes)
              call vmov (jhead(ITHWP1), 1, sum, 1, nsampo)

c----
c   find window center time for current trace.
c   if global we get time from trace header...
c----
              if ( global ) then

                 itime = nint ( float(icenter) / float(nsi) )

c----
c   ... or if we're working from a horz file we get time from a matrix
c   of times by areal location
c----
              else

                 itime = nint ( horizons ( jdi, jli, iu) / si )
                 if (itime .le. 0 .OR. itime .ge. ied0)  then
                    write(LERR,*)'LI/DI ',icli,icdi,
     1              '  bypassed because no valid horizon time'
                    go to 1500
                 endif

              endif

c----
c   reduce time in case input data has had previous wind operation
c----
              itime = itime - iTmMsFS
c----
c   compute start and end times relative to center time
c----

              it1 = itime - ist
              it2 = itime + ied
              if (it1 .le. 0) it1 = 1
              if (it2 .ge. nsamps) it2 = nsamps
              nit = it2 - it1 + 1

              if ( verbos ) then
              write(LERR,231)ICLI,ICDI,itime,it1,it2,nit,idist
              write(LER ,231)ICLI,ICDI,itime,it1,it2,nit,idist
231           format(2i10,5x,5(i5,2x))
              endif

c     call maxmgv(trace,1,xmax,loc,nsamps)
c     write(LER ,*)'trc,li,di,t,xmax,joff= ',irtrc,ICLI,ICDI,itime,xmax,
c    1nit,joff

c-----
c  take current input trace, compute attributes, stuff into working trace,
c  then sum into current output trace from this cell
c-----

              call stack (trace, stkt, sum, wrk1, wrk2, vel, nsampo,
     1                    dt, off, mute, xm, tm, nm, si, stk, nsamps,
     2                    joff, nattr, nit, icli, icdi, work, freqs,
     3                    c_amp_spec,sig,ifc,qq,pf,thresh,mstart,it1,
     4                    mlast,v_mem,vc_mem,s_mem,sc_mem,mdim,a_mem,
     5                    m_mem,ssq_mem,fsr,nfreq,fwork,ngrp1,pkthr,
     6                    ifmin,ifmax,ifdel,fwrk1,fwrk2,coefs,xnorm,
     7                    ierr,nmoap,mfreqo,amp_spec,iord,reftim,
     8                    itime,iatrwrd)

              if (ierr .ne. 0) go to 1500
c-----
c  put new summed attribute stack & normalization back into current cell
c-----
              call sisseek (luout(iu) , ipntr)
              call vmov (stkt, 1, jhead(ITHWP1), 1, nsampo)
              call savew2(JHEAD,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    0      , TRACEHEADER)
              call wrtape (luout(iu) , jhead, obytes)

              call vmov (sum, 1, jhead(ITHWP1), 1, nsampo)
              call sisseek (lunrm(iu), ipntr)
              call wrtape  (lunrm(iu), jhead, obytes)

         ENDDO

      ENDIF

      go to 1500
 5000 CONTINUE


      write(LER,*)' '
      write(LER,*)'Completed reading data...'

      do  iu = 1, nhor
         call rwd (lunrm(iu))
         CALL RTAPE (lunrm(iu), JHEAD, KBYTES)
      enddo

      write(LER,*)'... now doing normalization step'
      write(LER,*)'min/max li/di= ',minli,maxli,mindi,maxdi
      write(LER,*)' '

      call vclr (trace, 1, nsamps)

      DO  J = mindi, maxdi
          DO  I = minli, maxli

              ipntr  = (I - minli) * ndi + (J - mindi) + 1 

                  do  iu = 1, nhor

                      call vclr (trace, 1, nsampo)
                      call vclr (tab, 1, nsampo)
                      call sisseek (lunrm(iu), ipntr)
                      call rtape   (lunrm(iu), jhead, nbytes)
                      call vmov (jhead(ITHWP1), 1, tab, 1, nsampo)

                      call sisseek (luout(iu) , ipntr)
                      call rtape (luout(iu) , jhead, nbytes)
                      call vmov (jhead(ITHWP1), 1, trace, 1, nsampo)

c----
c   normalize attribute portion of volume
c----
                      do  ii = 1, nsampa
c     if (ii.eq.39.or.ii.eq.56.or.ii.eq.73.or.ii.eq.90.or.ii.eq.107)
c    1write(0,*)'i,j,ii= ',i,j,ii,trace (ii)
                          xlive = tab (ii)
                          if (xlive .ne. 0.) then
                              trace (ii) = trace (ii) / xlive
                          endif
                      enddo

c----
c   normalize stacked trace window
c----
                      do  ii = nsampa+1, nsampo
                          xlive = tab (ii)
                          if (xlive .ne. 0.) then
                              trace (ii) = trace (ii) / xlive
                          endif
                          live = nint (xlive)
                          maxfld = max (maxfld, live)
                      enddo

                      ioff = nattr + mfreqo
                      moff = nattr + mfreqo + nattr * ngrp1
                      ampmax = trace (1)

c----
c   If we are pre-stack and if the trace window for all offsets is nonzero
c   then we compute offset dependent slopes for the attributes (but
c   only for the nonzero max amplitudes in each offset bin). We also
c   compute a parabolic fit if there are at least 3 nonzero amplitude
c   entries and output the offset at which the maximum (or minimum)
c   occurs
c----

                      IF ( .not. stk .AND. (ampmax .gt. 1.e-30) ) THEN

                         do  ia = 1, nattr

                             mpntr = moff + ia
                             iy = 0
                             do  ix = 1, ngrp1

                                 npntr  = ioff + (ix - 1) * nattr + ia
                                 npntr1 = ioff + (ix - 1) * nattr + 1
                                 ampia1 = trace (npntr)

                                 if (ampia1 .gt. 1.e-30) then
                                    iy = iy + 1
                                    wrk1 (iy) = spread (ix)
                                    wrk2 (iy) = trace (npntr)
                                    sig  (iy) = 1.0
                                 endif
                             enddo

                             if (iy .ge. 3) then

                                xmin = wrk1 (1)
                                xmax = wrk1 (iy)
                                call fitf (wrk1, wrk2, sig, iy, cof, 3,
     1                                     array, covm, 3, chi, xmin,
     2                                     xmax, 0, 3)
                                aa = cof(3)
                                bb = cof(2)
                                if (abs(aa) .gt. 1.e-30) then
                                   xloc = -.5 * bb / aa
                                else
                                   xloc = 0.
                                endif
                                if (xloc .gt. sprdmax) xloc = sprdmax
                                if (xloc .lt. sprdmin) xloc = sprdmin
                                call lavo (iy, wrk1, wrk2, a, b, sig)
                                trace (mpntr) = a
c                               trace (mpntr+nattr) = xloc
                                trace (mpntr+nattr) = aa

                             elseif (iy .eq. 2) then

                                a = (wrk2(2) - wrk2(1))/
     1                              (wrk1(2) - wrk1(1))
                                trace (mpntr) = a
                                trace (mpntr+nattr) = 0.

                             else

                                trace (mpntr) = 0.
                                trace (mpntr+nattr) = 0.

                             endif
                         enddo


                      ENDIF

                      call center_xy ( I, J, IX1, IY1, dx, dy, name,
     1                                 XX, XY, YX, YY, XYT, YXT,
     2                                 XXT, YYT, LER, LERR, IXC, IYC,
     3                                 first)
                      call savew2(jhead,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                            IXC , TRACEHEADER)
                      call savew2(jhead,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                            IYC , TRACEHEADER)

                      call savew2(jhead,ifmt_VPick1,l_VPick1, ln_VPick1,
     1                            imt , TRACEHEADER)
                      call savew2(JHEAD,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            I      , TRACEHEADER)
                      call savew2(JHEAD,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            J      , TRACEHEADER)
                      call savew2(jhead,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                            I   , TRACEHEADER)
                      call savew2(jhead,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                            J   , TRACEHEADER)

                      call sisseek (luout(iu) , ipntr)
                      call vmov (trace, 1, jhead(ITHWP1), 1, nsampo)
                      call wrtape (luout(iu) , jhead, nbytes)
c                     call sisseek (lunrm(iu), ipntr)
c                     call vmov (tab, 1, jhead(ITHWP1), 1, nsampo)
c                     call wrtape (lunrm(iu) , jhead, nbytes)
                  enddo
          ENDDO
      ENDDO

      WRITE (IPRT, 310) ISLIMN,ISLIMX,ISDIMN,ISDIMX,
     &                  IRLIMN,IRLIMX,IRDIMN,IRDIMX,
     &                  ICLIMN,ICLIMX,ICDIMN,ICDIMX,
     &                  MINDST,MAXDST,MAXFLD
  310 FORMAT (//, 30X, 'LIMITS FOUND ON DATASET:'
     &        //, 23X, '  MINIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT SOURCE. .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT SOURCE .',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX AT RECEIVER.',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX AT RECEIVER',1X,I9  ,
     &        //, 23X, '  MINIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM LINE INDEX. . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DEPTH INDEX . . . . . .',1X,I9  ,
     &        //, 23X, '  MINIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM DISTANCE. . . . . . . .',1X,I9  ,
     &        //, 23X, '  MAXIMUM STACK REDUNDANCY. . . .',1X,I9  ,//)

      write(LER,*)' '
      write(LER,*)'End of Data:'
      write(LER,*)'scope3d processed ',NRREC,' records'
      ICC = 0

      RETURN
      END
