C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine lmrd (lupik, nli, ndi, nhor, limin, limax, 
     1                 dimin, dimax, times, SZSMPD, si, debug,
     2                 IX1, IY1, DX, DY, XX, XY, YX, YY,
     3                 XXT, XYT, YXT, YYT, xyscl, verbos,
     4                 lu_debug, name, livec, divec, work, nmax,
     5                 trp)

#include <f77/iounit.h>

      real       times (ndi, nli, nhor), livec (nli), divec (ndi)
      real       work (nmax)
      character  name*(*)

      integer    lupik, IX1, IY1, nmax
      integer    limin, limax, dimin, dimax, SZSMPD, lu_debug
      real       DX, DY
      REAL*8     XX, XY, YX, YY, XXT, XYT, YXT, YYT
      logical    debug, verbos, trp

      itmax = -9999999

      write(LERR,*)' '
      write(LERR,*)'Horizon pick read messages:'
      write(LERR,*)' '

      call lanmrk (lupik, times, IX1, IY1,
     1             XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, NDI, NLI, limin, limax,
     3             dimin, dimax, xyscl, verbos, nhor, name)

      write(LERR,*)' '
      if (verbos) then
      write(LERR,*)'Functions As Read In'
      write(LERR,*)' '
      do  k = 1, nhor
          do  j = 1, nli
              do  i = 1, ndi
                  tt = times (i,j,k)
                  write(LERR,*)'Horizon= ',k,' LI= ',j,' DI= ',i,
     1                      ' time= ',tt
                  if (nint(tt) .ge. itmax) itmax = nint (tt)
              enddo
          enddo
          write (LERR,777)
777       format ()
      enddo
      endif
      write(LERR,*)' '


      write(LERR,*)' '
      write(LERR,*)'From pick file:'
      write(LERR,*)'Min LI ',limin,'  Max LI ',limax
      write(LERR,*)'Min DI ',dimin,'  Max DI ',dimax
      write(LERR,*)' '
c-----
c  do 2Dx2D interpolation of the input times, matrices for each horizon
c-----
      if ( trp ) then

         do  k = 1, nhor

             call trp2d (limin, limax, dimin, dimax, nli, ndi,
     1                   times(1, 1, k), SZSMPD)
         enddo

      endif


      write(LERR,*)' '
      if (debug) then
         do  k = 1, nhor
         do  j = 1, nli
         do  i = 1, ndi
             write(lu_debug,555)
     1           j,i,times(i,j,k)
         enddo
         enddo
         write(lu_debug,777)
555      format (2i5,5x,f10.3)
         enddo
         close ( lu_debug )
      endif
      write(LERR,*)' '

      return

      end
