C***********************************************************************00000010
C                                                                       00000020
C     PROGRAM NAME: scope3d  (pre-stack horizon attribute scoping tool)
C                                                                       00000040
C     LANGUAGE: FORTRAN                                                 00000050
C                                                                       00000060
C     AUTHOR: G.MURPHY                                                  00000070
C                                                                       00000080
C     DATE WRITTEN: 07/01/88                                            00000090
C                                                                       00000100
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       00000120
C                                                                       00000140
C     ABSTRACT: OUTPUT CDP GATHERS WITH PSUEDO TRACE SPACING.           00000150
C                                                                       00000160
C     MODIFICATION HISTORY: 07/01/88  -  INITIAL RELEASE                00000170
C                                                                       00000180
C***********************************************************************00000190
C                                                                       00000200
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      REAL          RHEAD  (SZLNHD)
      INTEGER       JHEAD  (SZLNHD)
      INTEGER       IHEAD  (SZLNHD)
      CHARACTER*66  CTITLE
      real          spread (SZLNHD), tm (SZLNHD), xm (SZLNHD)
      character     ntap * 256, otap(100) * 256, ttap(100) * 256, name*7
      character     vtap * 256
      character     ptap * 256
      character     hdrwrd * 6
      character     refwrd * 6
      character     atrwrd * 6
      integer       argis, iabort, ierr1, ierr2, ierr3, ierr4
      integer       ITAPOT(100), ITANRM(100), luvel, lupik, lu_debug
      real          fmscl, mfscl
      real          DX, DY
      REAL*8        XX, XY, YX, YY, XXT, XYT, YXT, YYT

      real          horizons, work1, livec, divec
      pointer       (wkhorz , horizons(1000000))
      pointer       (wkadrl , livec   (1000000))
      pointer       (wkadrd , divec   (1000000))
      pointer       (wkadrk1, work1   (1000000))

      logical       verbos, query, nmoap, global, cdp
      logical       f2m, m2f, debug, restart, stk, trp
      COMMON /DM3D/ RHEAD
      EQUIVALENCE  (JHEAD, IHEAD, RHEAD)
      DATA CTITLE/'                      scoping tool FOR 3-D DATA       
     &             '/                                                   
      DATA IBYTES /32256/
      DATA name /'SCOPE3D'/
      DATA iabort /1/


      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help ()
          stop
      endif

      IPRT = LERR
      fmscl = 0.30480
      mfscl = 3.28084

#include <f77/open.h>
 
      call cmdln (ntap,otap,ttap,ptap,vtap,IX1,IY1,DX,DY,NLI,NDI,
     1            itapin,luvel,itapot,itanrm,lupik,f2m,m2f,verbos,
     2            XX, XY, YX, YY, XXT, XYT, YXT, YYT, IHEAD,
     3            name, debug, lu_debug, nhor, restart, minli,
     4            maxli, mindi, maxdi, nsi, nsamps, ntrc, nrec,
     5            lbytes, nattr, unitsc, si, stk, trp, xyscl, nmoap,
     6            mstart, mlast, thresh, fcut, IX2,IY2,IX3,IY3,IX4,IY4,
     7            global, hdrwrd, TmMsFS, cdp, iord, refwrd, atrwrd)

      item  = nhor * NLI * NDI
      itemk = max (ndi,nli,nsamps,nattr)
      call galloc (wkhorz, item  * SZSMPD, ierr1, iabort)
      call galloc (wkadrl, itemk * SZSMPD, ierr2, iabort)
      call galloc (wkadrd, itemk * SZSMPD, ierr3, iabort)
      call galloc (wkadrk1,itemk * SZSMPD, ierr4, iabort)
      if (ierr1.ne.0.OR.ierr2.ne.0.OR.ierr3.ne.0.OR.ierr4.ne.0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         write(LER ,*) itemk * SZSMPD, '  bytes'
         go to 9999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
         write(LERR,*) itemk * SZSMPD, '  bytes'
      endif

      IF ( .not. global ) THEN

        call lmrd  (lupik, nli, ndi, nhor, minli, maxli, mindi, maxdi,
     1              horizons, SZSMPD, si, debug, IX1, IY1, DX, DY,
     2              XX, XY, YX, YY, XXT, XYT, YXT, YYT, xyscl, verbos,
     3              lu_debug, name, livec, divec, work1, itemk, trp)

      ENDIF

C *** READ 1DM3D CARD AND ONE TDFN FUNCTION

      CALL DMCARD (IPRT,   ICRD,   NTRC, NFOLD, thresh, fcut,
     &             NREC,   ICC,    DSTMIN, DSTMAX, global,
     &             MINLI,  MAXLI,  MINDI, MAXDI,  DY, DX,
     &             ANGMAX, xm,     tm,    NPAIRS, ANGMIN,
     &             IX1, IY1, IX2, IY2, IX3, spread, stk,
     &             IY3, IX4, IY4, NLI, NDI, ngrp, dxg, pkthr,
     &             verbos, mute, ist, ied, nsi, ifmin, ifmax, 
     &             ifdel,hdrwrd,TmMsFS)

C *** CHECK FOR ANY ERRORS

      IF (ICC .NE. 0) GO TO 9999

C *** PROCESS THE INPUT DATA SET.

      CALL DMTAPE (IPRT,   ITAPIN, ITAPOT, IBYTES, luvel, nhor,
     &             IREC,   NREC,   lbytes, horizons, unitsc, si,
     &             MINLI,  MAXLI,  MINDI,  MAXDI,  DY, DX, iord,
     &             NFOLD,  NTRC,  NPAIRS, XM, TM, hdrwrd,refwrd,
     &             DSTMIN, DSTMAX, ANGMAX, NLI, NDI, TmMsFS,
     &             NSAMPS, NSI, IX1, IY1, IX2, IY2, IX3, IY3, IX4,
     &             IY4, ist, ied, name, dxg, nattr, cdp,atrwrd,
     &             verbos, mute, restart, ITANRM, nmoap,
     &             spread, ngrp, thresh, fcut, pkthr,
     &             XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     &             ifmin, ifmax, ifdel, stk, mstart, mlast,global)

C *** FINISHED -- CLOSE I/O DEVICES

 9999 CONTINUE

      CALL LBCLOS (ITAPIN)
      do  ii = 1, nhor
          CALL LBCLOS (ITAPOT (ii))
          CALL LBCLOS (ITANRM (ii))
      enddo

      CALL CCEXIT (ICC)

      END
