C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap,otap,irs,ire,StartRec,EndRec,FilterLength,
     :     Intercept,CosTaper,Xtaper,Ytaper,Xpad,Ypad,pass,verbos,a,
     :     edge,avmed,med,nts,fact,cosine,bart,box,bess,inv,dup)

#include <f77/iounit.h>

      integer   irs, ire, FilterLength, StartRec, EndRec, Xpad, Ypad
      integer   Xtaper, Ytaper, argis, nts

      real      Intercept, CosTaper, a, fact

      character ntap*(*), otap*(*)

      logical   verbos, pass, diff, edge
      logical   med, avmed, cosine, bart, box, bess, inv, dup

      pass   = .true.
      diff   = (argis('-diff') .gt. 0)
      dup    = (argis('-dup') .gt. 0)
      if (diff) pass = .false.
      cosine = (argis('-cos') .gt. 0)
      bart   = (argis('-bart') .gt. 0)
      box    = (argis('-box') .gt. 0)
      bess   = (argis('-bess') .gt. 0)
      inv    = (argis('-I') .gt. 0)

      call argstr('-N',ntap,' ',' ') 
      call argstr('-O',otap,' ',' ')
      call argr4('-w', fact , 1.0 , 1.0 )
      call argr4('-a', a , 26.5 , 26.5 )
      call argi4('-e',EndRec,0,0)
      EndRec = 0
      call argr4('-ftaper',CosTaper,50.0,50.0)
      call argr4('-i',Intercept,0.05,0.05)
      call argi4('-l',FilterLength, 3, 3)
      call argi4('-t',nts, 5, 5)
      call argi4('-re',ire,0,0)
      call argi4('-rs',irs,1,1)
      ire = 0
      irs = 1
      call argi4('-s',StartRec,1,1)
      StartRec = 1
      call argi4('-xtaper',Xtaper,0,0)
      call argi4('-xpad',Xpad,10,10)
      call argi4('-ytaper',Ytaper,0,0)
      call argi4('-ypad',Ypad,10,10)
      avmed    = (argis('-AM') .gt. 0)
      med      = (argis('-M') .gt. 0)
      edge     = (argis('-E') .gt. 0)
      verbos   = (argis('-V') .gt. 0)

c     if (edge) then
c        fact = 1.0
c        box    = .true.
c        bess   = .false.
c        cosine = .false.
c        bart   = .false.
c     endif

      if (edge) then

         FilterLength = 3
         nts = 3
         Xtaper = 0
         Ytaper = 0

      else

         if (mod(FilterLength,2) .eq. 0) then
            FilterLength = FilterLength + 1
            write(LERR,*)' '
            write(LERR,*)'WARNING from smooth3d (non-edge option):'
            write(LERR,*)'Spatial Filter length must be odd.',
     1                    'Resetting to ',FilterLength
         endif
         if (mod(nts,2) .eq. 0) then
            nts = nts + 1
            write(LERR,*)' '
            write(LERR,*)'WARNING from smooth3d (non-edge option):'
            write(LERR,*)'Filter length must be odd. ',
     1                    'Resetting to ',nts
         endif
         if (Xpad .eq. 0) then
             Xpad   = FilterLength / 2 + 1
             write(LERR,*)'Default Xpad set to ',Xpad
         endif
         if (Ypad .eq. 0) then
             Ypad   = FilterLength / 2 + 1
             write(LERR,*)'Default Ypad set to ',Ypad
         endif
c        Xtaper = 0
c        Ytaper = 0

      endif

      if (.not.cosine .AND. .not.bart .AND. .not.box .AND. .not.bess
     1    ) box = .true.

      return
      end
