C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  lfit ( x, y, ndata, a1, a0, siga, sigb,
     1                    chi2, q, ang)

#include <f77/iounit.h>

c  routine to linearly fit data with  y = a1*x + a0

c  input:
c          x,y  -  ndata input points

c output:
c          a1,b  -  coefficients of straight line
c   siga, sigb   -  deviations of a1 & a0
c        chi2    -  chi-square
c           q    -  goodness-of-fit probability (chi-sq or better)

      real    x(*), y(*)

      pi = 3.14159265

      sx = 0.               !  initialize sums
      sy = 0.
      st2= 0.
      b  = 0.

         do  12  i = 1, ndata
             sx = sx + x(i)
             sy = sy + y(i)
12       continue
         ss = float(ndata)

      sxoss = sx/ss

         do  14  i = 1, ndata
             t = x(i) - sxoss
             st2 = st2 + t*t
             b = b + t * y(i)
14       continue

      a1 = b/st2           !  solve for a1 & a0, and for sigma (a1 & a0)
      a0 = (sy - sx * a1)/ss
      ang = 180. * atan (a1) / pi
      siga = sqrt( (1. + sx*sx/(ss*st2))/ss)
      sigb = sqrt( 1./st2)
      chi2 = 0.           !  calculate chi-squre

      if (ndata .lt. 3) then
         siga = 0.
         sigb = 0.
         chi2 = 0.
         q    = 1.
         return
      endif

          do  15  i = 1, ndata
              chi2 = chi2 + (y(i) - a0 - a1*x(i)) **2
15        continue
          q = 1.
          sigdat = sqrt( chi2/float(ndata-2))
          siga   = siga * sigdat
          sigb   = sigb * sigdat

      return
      end
      
