C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine flex_get_traces( IX, IY, IXE, IYE, ICELL, 
     :     itemk, KOUNT, num_flex_traces, 
     :     flex_dist_required, itemu, PARTS, lstart, NX, NY, 
     :     CDPBCX, CDPBCY, off, dstdel,
     :     ifmt_indexx, l_indexx, ln_indexx,
     :     ifmt_indexy, l_indexy, ln_indexy, 
     :     ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :     iteme, flex_radial_dist, flex_pointer, 
     :     flex_trdist, flex_lui, flex_count, IFL, radius )

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare variables passed from the calling routine

      integer IX, IY, IXE, IYE, ICELL, itemk, num_flex_traces, itemu
      integer NX, NY, CDPBCX, CDPBCY, iteme, flex_count
      integer ifmt_indexx, l_indexx, ln_indexx
      integer ifmt_indexy, l_indexy, ln_indexy
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer KOUNT(itemk), PARTS(itemu), lstart(1000), IFL(itemk)
      integer flex_pointer(iteme), flex_trdist(iteme), flex_lui(iteme)

      real flex_dist_required(num_flex_traces)
      real flex_radial_dist(iteme)
      real dstdel, radius

      logical off

c declare local variables

      integer lui, k, j, i, IPTS, IPTE, ipti, nbytes
      integer indexx, indexy, DstSgn, xdiff, ydiff, flex_cell
      integer ITR(SZLNHD)

      real x_term, y_term, radial_dist

c initialize variables

c
c IX is the X direction sequential bin counter
c IY is the Y direction sequential bin counter
c KOUNT[] contains fold info for all bins in the sr3d2 volume
c lui[] contains logical unit in numbers for the sr3d2 volume[s]
c itemk is the size of KOUNT[]
c flex_dist_required[] contains offsets missing from gather[]
c num_flex_traces is the number of missing offsets


c for the simple case [defaults with sort order inline] the following
c works:
c
c ICELL is the cell number of the current bin which is pointed to
c by IFL(ICELL) where IFL is the first location pointer file for
c the binned data.  It contains the trace number of the first trace
c of that bin in the sr3d2 volume.  To get to an arbitrary bin
c location you must know the number of bins in each dimension
c NX,NY and the location of the current bin IX,IY.  From there
c you can figure the ICELL for any bin in the sr3d2 volume using:
c
c
c To go ahead/behind inline by N bins is simply Flex_Bin = ICELL +/- N
c to go next door you need to know a little more:
c
c Flex_Bin = ICELL +/- NY * NumDIs +/- N
c
c where N can range over -m,+m or be equal to zero in the case of 
c right next door.
c 
c For the first test lets look only at bins that abutt the current
c bin, i.e.
c
c           LI
c      |_|_|_|_|_|
c      |_|1|2|3|_|
c  DI  |_|4|x|5|_|
c      |_|6|7|8|_|
c      |_|_|_|_|_|

c
c           LI
c      |_|_|_|_|_|
c      |_|3|2|1|_|
c  DI  |_|5|x|4|_|
c      |_|8|7|6|_|
c      |_|_|_|_|_|

c           DI
c      |_|_|_|_|_|
c      |_|1|4|6|_|
c  LI  |_|2|x|7|_| 
c      |_|3|5|8|_|
c      |_|_|_|_|_|
c

c           DI
c      |_|_|_|_|_|
c      |_|3|5|8|_|
c  LI  |_|2|x|7|_| 
c      |_|1|4|6|_|
c      |_|_|_|_|_|
c
c and accept into the search any traces that fall into the bins
c of missing offsets identified by the histogram proceedure.  This of
c course means searching 8 bins for each bin coming in, but, we 
c usually progress in an orderly fashion and so should be able to 
c write a rolling logic of some sort to speed things up.  For instance
c we have just done location "x" above and know that if we are
c progressing normally location 7 will be the next X, 4 will be the
c next 1, x will be the next 2, 5 will be the next 3 etc.
c
c fill flex_trdist and flex_trndx arrays for surrounding traces
c that fall within global offset limits

      flex_count = 0

      if ( IY .gt. 1 .and. 
     :     IX .gt. 1 .and. 
     :     IY .lt. IYE .and. 
     :     IX .lt. IXE ) then

c make sure there are bins around us then set bin pointer to location
c 1 above and get distances and pointers for traces from bins 1,4,6
         
         DO k = 1, 3
            
            flex_cell = ICELL - NY - 2 + k
            IPTS = IFL(flex_cell)

            if (KOUNT(flex_cell) .ne. 0 ) then

               IPTE = IPTS + KOUNT(flex_cell) - 1
               j = 0

               do i  = IPTS, IPTE

c position pointer for trace read

                  J = J + 1
                  lui = parts (i)
                  ipti = I - lstart(lui) + 1
                  call sisseek (lui, ipti)

c read trace retreive x, y, and DstSgn
         
                  call rtape   (lui, ITR, nbytes)

                  call saver2(itr,ifmt_indexx,l_indexx, ln_indexx,
     1                 indexx    , TRACEHEADER)
                  call saver2(itr,ifmt_indexy,l_indexy, ln_indexy,
     1                 indexy    , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                 DstSgn , TRACEHEADER)

c store radial distance, DstSgn and index for later retreival if
c needed if this DstSgn fits the search criteria

                  if ( float(DstSgn) .ge. flex_dist_required(1) .and. 
     :                 float(DstSgn) .le. 
     :                 flex_dist_required(num_flex_traces) .and. 
     :                 .not. off ) then

c had to do the following to prevent an ieee invalid by doing a float
c inside the sqrt()....bummer

                     xdiff = CDPBCX - indexx
                     ydiff = CDPBCY - indexy
                     x_term = float ( xdiff * xdiff )
                     y_term = float ( ydiff * ydiff )
                     radial_dist =  sqrt ( x_term + y_term )

                     if ( radial_dist .le. radius ) then
                     
c this is for the case where we are flexbinning but NOT doing offset
c sorting.  We only want the trace if it fits inside the radius of 
c investigation for flexbinning [-radius on commandline]
                     
                        flex_count = flex_count + 1

                        flex_radial_dist(flex_count) = radial_dist
                        flex_pointer(flex_count) = ipti
                        flex_trdist(flex_count) = DstSgn
                        flex_lui(flex_count) = lui

                     endif

                  elseif (  float(DstSgn) .ge. 
     :                    ( flex_dist_required(1) - dstdel/2. ) .and. 
     :                    float(DstSgn) .le. 
     :                    ( flex_dist_required(num_flex_traces) + 
     :                    dstdel/2. ) .and. off ) then
                     
c this is for the case where we are flexbinning and doing offset
c sorting.  In this case we need to look +/- dstdel/2 around the 
c current bin.  The num_flex_traces will always be unity.
                     
                     xdiff = CDPBCX - indexx
                     ydiff = CDPBCY - indexy
c had to do the following to prevent an ieee invalid by doing a float
c inside the sqrt()....bummer

                     x_term = float ( xdiff * xdiff )
                     y_term = float ( ydiff * ydiff )
                     radial_dist = sqrt ( x_term + y_term )
                     
                     if ( radial_dist .le. radius ) then

c only flex if traces are inside radius of investigation

                        flex_count = flex_count + 1

                        flex_radial_dist(flex_count) = radial_dist
                        flex_pointer(flex_count) = ipti
                        flex_trdist(flex_count) = DstSgn
                        flex_lui(flex_count) = lui
                     endif

                  endif
               enddo
            endif
         ENDDO

c add in distances and pointers for qualifying traces from bins 3,5,8
         
         DO k = 1, 3
            
            flex_cell = ICELL + NY - 2 + k
            IPTS = IFL(flex_cell)

            if (KOUNT(flex_cell) .ne. 0 ) then

               IPTE = IPTS + KOUNT(flex_cell) - 1
               j = 0

               do i  = IPTS, IPTE

c position pointer for trace read

                  J = J + 1
                  lui = parts (i)
                  ipti = I - lstart (lui) + 1
                  call sisseek (lui, ipti)

c read trace retreive x, y, and DstSgn
         
                  call rtape   (lui, ITR, nbytes)

                  call saver2(itr,ifmt_indexx,l_indexx, ln_indexx,
     1                 indexx    , TRACEHEADER)
                  call saver2(itr,ifmt_indexy,l_indexy, ln_indexy,
     1                 indexy    , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                 DstSgn , TRACEHEADER)

c store radial distance, DstSgn and index for later retreival if
c needed if this DstSgn fits the search criteria

                  if ( float(DstSgn) .ge. flex_dist_required(1) .and. 
     :                 float(DstSgn) .le. 
     :                 flex_dist_required(num_flex_traces) .and. 
     :                 .not. off ) then

c this is for the case where we are flexbinning but NOT doing offset
c sorting

                     xdiff = CDPBCX - indexx
                     ydiff = CDPBCY - indexy

c had to do the following to prevent an ieee invalid by doing a float
c inside the sqrt()....bummer

                     x_term = float ( xdiff * xdiff )
                     y_term = float ( ydiff * ydiff )
                     radial_dist = sqrt ( x_term + y_term )

                     
                     if ( radial_dist .le. radius ) then
                     
c this is for the case where we are flexbinning but NOT doing offset
c sorting.  We only want the trace if it fits inside the radius of 
c investigation for flexbinning [-radius on commandline]
                     

                        flex_count = flex_count + 1

                        flex_radial_dist(flex_count) = radial_dist
                        flex_pointer(flex_count) = ipti
                        flex_trdist(flex_count) = DstSgn
                        flex_lui(flex_count) = lui

                     endif

                  elseif ( float(DstSgn) .ge. 
     :                    ( flex_dist_required(1) - dstdel/2. ) .and. 
     :                    float(DstSgn) .le. 
     :                    ( flex_dist_required(num_flex_traces) + 
     :                    dstdel/2. ) .and. off ) then
                     
c this is for the case where we are flexbinning and doing offset
c sorting.  In this case we need to look +/- dstdel/2 around the 
c current bin.  The num_flex_traces will always be unity.
                     
                     xdiff = CDPBCX - indexx
                     ydiff = CDPBCY - indexy

c had to do the following to prevent an ieee invalid by doing a float
c inside the sqrt()....bummer

                     x_term = float ( xdiff * xdiff )
                     y_term = float ( ydiff * ydiff )
                     radial_dist = sqrt ( x_term + y_term )

                     if ( radial_dist .le. radius ) then

c only flex if traces are inside radius of investigation
                     
                        flex_count = flex_count + 1
                        flex_radial_dist(flex_count) = radial_dist
                        flex_pointer(flex_count) = ipti
                        flex_trdist(flex_count) = DstSgn
                        flex_lui(flex_count) = lui
                     endif
                  endif
               enddo
            endif
         ENDDO

c now add in distances and pointers for qualifying traces from 2 

         flex_cell = ICELL - 1
         IPTS = IFL(flex_cell)

         if (KOUNT(flex_cell) .ne. 0 ) then

            IPTE = IPTS + KOUNT(flex_cell) - 1
            j = 0

            do i  = IPTS, IPTE

c position pointer for trace read

               J = J + 1
               lui = parts (i)
               ipti = I - lstart (lui) + 1
               call sisseek (lui, ipti)

c read trace retreive x, y, and DstSgn
         
               call rtape   (lui, ITR, nbytes)

               call saver2(itr,ifmt_indexx,l_indexx, ln_indexx,
     1              indexx    , TRACEHEADER)
               call saver2(itr,ifmt_indexy,l_indexy, ln_indexy,
     1              indexy    , TRACEHEADER)
               call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              DstSgn , TRACEHEADER)

c store radial distance, DstSgn and index for later retreival if
c needed if this DstSgn fits the search criteria

               if ( float(DstSgn) .ge. flex_dist_required(1) .and. 
     :              float(DstSgn) .le. 
     :              flex_dist_required(num_flex_traces) .and.
     :              .not. off ) then

c this is for the case where we are flexbinning but NOT doing offset
c sorting
                     
                  xdiff = CDPBCX - indexx
                  ydiff = CDPBCY - indexy

c had to do the following to prevent an ieee invalid by doing a float
c inside the sqrt()....bummer

                  x_term = float ( xdiff * xdiff )
                  y_term = float ( ydiff * ydiff )
                  radial_dist =  sqrt ( x_term + y_term )
                  
                  if ( radial_dist .le. radius ) then
                     
c this is for the case where we are flexbinning but NOT doing offset
c sorting.  We only want the trace if it fits inside the radius of 
c investigation for flexbinning [-radius on commandline]
                     


                     flex_count = flex_count + 1
                     
                     flex_radial_dist(flex_count) = radial_dist
                     flex_pointer(flex_count) = ipti
                     flex_trdist(flex_count) = DstSgn
                     flex_lui(flex_count) = lui
                     
                  endif

               elseif ( float(DstSgn) .ge. 
     :                 ( flex_dist_required(1) - dstdel/2. ) .and. 
     :                 float(DstSgn) .le. 
     :                 ( flex_dist_required(num_flex_traces) + 
     :                 dstdel/2. ) .and. off ) then
                     
c this is for the case where we are flexbinning and doing offset
c sorting.  In this case we need to look +/- dstdel/2 around the 
c current bin.  The num_flex_traces will always be unity.
                     
                  xdiff = CDPBCX - indexx
                  ydiff = CDPBCY - indexy

c had to do the following to prevent an ieee invalid by doing a float
c inside the sqrt()....bummer

                  x_term = float ( xdiff * xdiff )
                  y_term = float ( ydiff * ydiff )
                  radial_dist = sqrt ( x_term + y_term )
                     
                  if ( radial_dist .le. radius ) then

c only flex if traces are inside radius of investigation

                     flex_count = flex_count + 1
                     flex_radial_dist(flex_count) = radial_dist
                     flex_pointer(flex_count) = ipti
                     flex_trdist(flex_count) = DstSgn
                     flex_lui(flex_count) = lui
                  endif
               endif
            enddo
         endif

c now add in distances and pointers for qualifying traces from 8 

         flex_cell = ICELL + 1
         IPTS = IFL(flex_cell)

         if (KOUNT(flex_cell) .ne. 0 ) then

            IPTE = IPTS + KOUNT(flex_cell) - 1
            j = 0

            do i  = IPTS, IPTE

c position pointer for trace read

               J = J + 1
               lui = parts (i)
               ipti = I - lstart (lui) + 1
               call sisseek (lui, ipti)

c read trace retreive x, y, and DstSgn
         
               call rtape   (lui, ITR, nbytes)

               call saver2(itr,ifmt_indexx,l_indexx, ln_indexx,
     1              indexx    , TRACEHEADER)
               call saver2(itr,ifmt_indexy,l_indexy, ln_indexy,
     1              indexy    , TRACEHEADER)
               call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              DstSgn , TRACEHEADER)

c store radial distance, DstSgn and index for later retreival if
c needed if this DstSgn fits the search criteria

               if ( float(DstSgn) .ge. flex_dist_required(1) .and. 
     :              float(DstSgn) .le. 
     :              flex_dist_required(num_flex_traces) .and. 
     :              .not. off ) then
                     
c this is for the case where we are flexbinning but NOT doing offset
c sorting
                     
                  xdiff = CDPBCX - indexx
                  ydiff = CDPBCY - indexy
                     

c had to do the following to prevent an ieee invalid by doing a float
c inside the sqrt()....bummer

                  x_term = float ( xdiff * xdiff )
                  y_term = float ( ydiff * ydiff )
                  radial_dist = sqrt ( x_term + y_term )
                     
                  if ( radial_dist .le. radius ) then

c only flex if traces are inside radius of investigation

                     flex_count = flex_count + 1
                     flex_radial_dist(flex_count) = radial_dist
                     flex_pointer(flex_count) = ipti
                     flex_trdist(flex_count) = DstSgn
                     flex_lui(flex_count) = lui
                  endif

               elseif ( float(DstSgn) .ge. 
     :                 ( flex_dist_required(1) - dstdel/2. ) .and. 
     :                 float(DstSgn) .le. 
     :                 ( flex_dist_required(num_flex_traces) + 
     :                 dstdel/2. ) .and. off ) then
                     
c this is for the case where we are flexbinning and doing offset
c sorting.  In this case we need to look +/- dstdel/2 around the 
c current bin.  The num_flex_traces will always be unity.
                     
                  xdiff = CDPBCX - indexx
                  ydiff = CDPBCY - indexy

c had to do the following to prevent an ieee invalid by doing a float
c inside the sqrt()....bummer

                  x_term = float ( xdiff * xdiff )
                  y_term = float ( ydiff * ydiff )
                  
                  radial_dist =  sqrt ( x_term + y_term )
                  
                  if ( radial_dist .le. radius ) then
                     
c this is for the case where we are flexbinning but NOT doing offset
c sorting.  We only want the trace if it fits inside the radius of 
c investigation for flexbinning [-radius on commandline]
                     
                     flex_count = flex_count + 1
                     flex_radial_dist(flex_count) = radial_dist
                     flex_pointer(flex_count) = ipti
                     flex_trdist(flex_count) = DstSgn
                     flex_lui(flex_count) = lui
                  endif
               endif
            enddo
         endif
      endif

      return
      end
