C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( vverbos, verbos, stp, oline, go, off, 
     :     ntap, otap, dtap, ptap, num_sr3d2_vols, irt3d0, mode0, ilog, 
     :     nsampi, RI1, RIINCR, LINE1, LININC, DI1, DIINCR, isli, isdi, 
     :     ieli, iedi, dstmin, dstmax, dstdel, flexbin, nodead, radius )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer num_sr3d2_vols, irt3d0, mode0, ilog, nsampi
      integer RI1, RIINCR, LINE1, LININC, DI1, DIINCR
      integer isli, isdi, ieli, iedi

      real dstmin, dstmax, dstdel, radius

      character ntap*256, otap*256, dtap(1000)*256, ptap*256 

      logical vverbos, verbos, stp, oline, go, off, flexbin
      logical nodead

c
      write(LERR,*)' '
      write(LERR,*)' sr3d2 command line input '
      write(LERR,*)' ------------------------ '
      write(LERR,*)' '

      IF ( stp )  then
         write(LERR,*) ' Running sr3d2 in -stop mode '
         write(LERR,*) ' '
         length = lenth(ntap)
         write(LERR,*) ' Input seismic dataset = ', ntap(1:length)
         write(LERR,*) ' '
         length = lenth(ptap)
         write(LERR,*) ' Input sr3d1 table = ', ptap(1:length)
         write(LERR,*) ' '
         do i = 1, num_sr3d2_vols
            write(LERR,*) ' sr3d2 volume(',i,') =  ', dtap(i)
         enddo
         write(LERR,*) ' '
         if ( irt3d0 .ne. -999 ) then
            if ( irt3d0 .eq. 0 ) then
               write(LERR,*)' Output bins in LI order '
            elseif ( irt3d0 .eq. 1 ) then
               write(LERR,*)' Output bins in Serpentine LI order '
            endif
         endif
         if ( nsampi .ne. 0 ) 
     :        write(LERR,*)' Number of samples in input = ',nsampi
         if ( ilog .ne. -1 ) 
     :        write(LERR,*)' Log input messages every ',ilog,' traces'

      ELSEIF ( go )  then
         
         write(LERR,*) ' Running sr3d2 in -go mode '
         write(LERR,*) ' '
         length = lenth(ptap)
         write(LERR,*) ' Input sr3d1 table = ', ptap(1:length)
         write(LERR,*) ' '
         do i = 1, num_sr3d2_vols
            write(LERR,*) ' sr3d2 volume(',i,') =  ', dtap(i)
         enddo
         write(LERR,*) ' '

         if ( nodead ) then
            write(LERR,*)' '
            write(LERR,*)' output no dead gathers'
            write(LERR,*)' ----------------------'
            write(LER,*)' '
            write(LER ,*)' output no dead gathers'
            write(LER ,*)' ----------------------'
         endif
         if ( off ) then
            write(LERR,*)' '
            write(LERR,*)' constant offset sort requested'
            write(LERR,*)' ------------------------------'
            write(LER,*)' '
            write(LER,*)' constant offset sort requested'
            write(LER,*)' ------------------------------'
         endif
         if ( flexbin ) then
            write(LERR,*)' '
            write(LERR,*)' flexbinning requested'
            write(LERR,*)' ------------------------------'
            write(LER,*)' '
            write(LER,*)' flexbinning requested'
            write(LER,*)' ------------------------------'
         endif
         if ( off .or. flexbin ) then
            write(LERR,*)' model spread near offset = ',dstmin
            write(LERR,*)' model spread far offset = ',dstmax
            write(LERR,*)' model spread group interval = ',dstdel
            write(LERR,*)' maximum radius allowed in flex = ',radius
            write(LER,*)' model spread near offset = ',dstmin
            write(LER,*)' model spread far offset = ',dstmax
            write(LER,*)' model spread group interval = ',dstdel
            write(LER,*)' maximum radius allowed in flex = ',radius
         endif

         if ( oline ) then
            write(LERR,*) ' an output gather contains a line'
         else
            write(LERR,*) ' an output gather contains a bin'
         endif
         write(LERR,*) ' '
         write(LERR,*) ' Limiting Options Chosen '
         write(LERR,*) ' -----------------------'
         write(LERR,*) ' '
         write(LERR,*) ' Starting Output LI = ',isli
         if (ieli .ne. 99999999 ) then
            write(LERR,*) ' Ending Output LI = ',ieli
         else
            write(LERR,*) ' All LIs will be output'
         endif
         write(LERR,*) ' '
         write(LERR,*) ' Starting Output DI = ',isdi
         if (iedi .ne. 99999999 ) then
            write(LERR,*) ' Ending Output DI = ',iedi
         else
            write(LERR,*) ' All DIs will be output'
         endif

         write(LER,*) ' '
         write(LER,*) ' sr3d2 Limiting Options Chosen '
         write(LER,*) ' -----------------------------'
         write(LER,*) ' '
         write(LER,*) ' Starting Output LI = ',isli
         if (ieli .ne. 99999999 ) then
            write(LER,*) ' Ending Output LI = ',ieli
         else
            write(LER,*) ' All LIs will be output'
         endif
         write(LER,*) ' '
         write(LER,*) ' Starting Output DI = ',isdi
         if (iedi .ne. 99999999 ) then
            write(LER,*) ' Ending Output DI = ',iedi
         else
            write(LER,*) ' All DIs will be output'
         endif

         if ( LINE1 .ne. 0 .or.
     :        DI1 .ne. 0 .or.
     :        RI1 .ne. 0 .or.
     :        LININC .ne. 0 .or.
     :        DIINCR .ne. 0 .or.
     :        RIINCR .ne. 0 ) then
            write(LERR,*) ' '
            write(LERR,*) ' Renumbering Options Chosen '
            write(LERR,*) ' --------------------------'
            write(LERR,*) ' '
            if ( LINE1 .ne. 0 ) write(LERR,*)' Number initial LI as', 
     :           LINE1
            if ( DI1 .ne. 0 ) write(LERR,*)' Number initial DI as', DI1
            if ( RI1 .ne. 0 ) write(LERR,*)' Number initial RI as', RI1
            if ( LININC .ne. 0 ) write(LERR,*)' LI increment set to ',
     :           LININC
            if ( DIINCR .ne. 0 ) write(LERR,*)' DI increment set to ', 
     :           DIINCR
            if ( RIINCR .ne. 0 ) write(LERR,*)' RI increment set to ', 
     :           RIINCR

            write(LER,*) ' '
            write(LER,*) ' sr3d2 Renumbering Options Chosen '
            write(LER,*) ' --------------------------------'
            write(LER,*) ' '
            if ( LINE1 .ne. 0 ) write(LER,*)' Number initial LI as', 
     :           LINE1
            if ( DI1 .ne. 0 ) write(LER,*)' Number initial DI as', DI1
            if ( RI1 .ne. 0 ) write(LER,*)' Number initial RI as', RI1
            if ( LININC .ne. 0 ) write(LER,*)' LI increment set to ',
     :           LININC
            if ( DIINCR .ne. 0 ) write(LER,*)' DI increment set to ', 
     :           DIINCR
            if ( RIINCR .ne. 0 ) write(LER,*)' RI increment set to ', 
     :           RIINCR
         endif

      ENDIF

      write(LERR,*) ' '
      if (verbos ) write(LERR,*) ' verbose Printout requested '
      if (vverbos ) write(LERR,*) ' very verbose Printout requested '
      
      return
      end
