C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stacksub(uin,bufin,uout,bufout,lenhed,SZLNHD,itr,BC,
     1                    nsamp,nbytes,type1,type2,mgath,nli,ndi,
     2                    ugather,usum,udenom,
     3                    weight,xtemp,taper,icount,
     4                    power,ic,icc,irec,ngath,ntpr,ifmt_CDPBCX,
     5                    hbegin,luin,luout,lerr,verbos,ifmt_CDPBCY,
     6               semb,semwt,snorm,dwgt,l_CDPBCX,ln_CDPBCX,ln_CDPBCY,
     7               d1neg,d2neg,d1pos,d2pos,l_SrRcMX,l_SrRcMY,l_CDPBCY,
     8               l_FlReFN,l_ToStUn,l_ToTmAU,l_RecNum,l_TrcNum,
     9               l_RecInd,l_DphInd,l_SrcLoc,l_SrcPnt,
     a               l_StaCor,l_DstSgn,l_LinInd,l_SoPtNm,ln_SrRcMX,
     8               ln_FlReFN,ln_ToStUn,ln_ToTmAU,ln_RecNum,ln_TrcNum,
     9               ln_RecInd,ln_DphInd,ln_SrcLoc,ln_SrcPnt,
     a               ln_StaCor,ln_DstSgn,ln_LinInd,ln_SoPtNm,ln_SrRcMY,
     8               ifmt_FlReFN,ifmt_ToStUn,ifmt_ToTmAU,ifmt_RecNum,
     9               ifmt_TrcNum,ifmt_RecInd,ifmt_DphInd,ifmt_SrcLoc,
     a               ifmt_SrcPnt,ifmt_StaCor,ifmt_DstSgn,
     b               ifmt_LinInd,ifmt_SoPtNm,ifmt_SrRcMX,ifmt_SrRcMY,
     c  ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,
     d  ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,
     d  ifmt_FoldNm,l_FoldNm,ln_FoldNm)

      parameter  (pi=3.14159265,twopi=2.*pi)
      parameter  (eps=1.e-20)
      integer    hbegin

      integer    bufin(*)
      integer    bufout(*)
      integer    itr(*)
      integer    SZLNHD

      real       uin(hbegin:nsamp)
      real       uout(hbegin:nsamp)
      real       ugather(nsamp,mgath)
      real       usum(nsamp)
      real       udenom(nsamp)
      real       taper(mgath,mgath)     
      real       weight(nsamp,mgath) 
      real       xtemp(mgath)       
      integer    icount(nsamp), idist, trccnt, reccnt
      integer    cur_keywrd
      logical    semb,semwt,verbos,snorm,dwgt,next,BC
      character  type1 * 1, type2 * 1

      powerinv=1./power
      next = .false.

c----
c   ngath = the # trc per input record (this could span several
c           actual LI/DI gathers or ensembles
c   mgath = the max # trcs per individual LI/DI gathers
c----

c_______________________________________________________________________
c     zero out output data array and trace header
c_______________________________________________________________________
      if     (type1 .eq. 'L' .AND. type2 .eq. 'D') then

             ifmt_keywrd = ifmt_DphInd
                l_keywrd =    l_DphInd
               ln_keywrd =   ln_DphInd
               ipanel    =  ndi

      elseif (type1 .eq. 'D' .AND. type2 .eq. 'L') then

             ifmt_keywrd = ifmt_LinInd
                l_keywrd =    l_LinInd
               ln_keywrd =   ln_LinInd
                panel    =  float(ngath) / float(mgath) + .4999999
               ipanel    = nint (panel)
c              ipanel    =  ngath / nli + 1
      else

             ifmt_keywrd = ifmt_RecNum
                l_keywrd =    l_RecNum
               ln_keywrd =   ln_RecNum
 
      endif


      cur_keywrd = 0
      IP = 0
      trccnt = 0
      reccnt = 0
      dstmin = 9999999.

1     CONTINUE

      do 10000 j=1,lenhed
       bufout(j)=0
10000 continue

      do 12000 isamp=1,nsamp
       udenom(isamp)=eps
       icount(isamp)=0
       uout  (isamp)=0.0
       usum  (isamp)=0.0
12000 continue

      do  jj = 1, mgath
          do  ii = 1, nsamp
              ugather (ii,jj) = 0.
              weight  (ii,jj) = 0.
          enddo
      enddo

      reccnt = reccnt + 1


      noffset = 0
      cdpxsum = 0.
      cdpysum = 0.
      live = 0
      DO  20000 K = 1, mgath


       if (next) then
          call move (1, bufin, itr, nbytes)
          next = .false.
       else
          trccnt = trccnt + 1
          if (trccnt .gt. ngath) then
             if (verbos)
     1       write(lerr,*)'finished input rec = ',irec
             return
          endif
          nbytes=0
          call rtape(luin,uin(hbegin),nbytes)
          if(nbytes .eq. 0) then
             write(lerr,*)'End of file on input:'
             write(lerr,*)'  rec= ',irec,'  trace= ',k
             return      
          endif
       endif


       call saver2(bufin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             istatic  , 1)

      if(verbos) then
         if (noffset .eq. 0) then
         write(lerr,*)'IP= ',ip,' K= ',k,' n/mgath= ',ngath,mgath,trccnt
     1,ipanel,' w= ',i_keywrd,cur_keywrd,noffset
         endif
      endif


c----
c   ensembles (gathers) can be in line or di packed format
c   i.e. with no dead trcs until the end of a record (a rec
c   could well be many thousands of trcs long in the case of
c   a line sorted sisort3d),
c   or in sr3d format with the gathers padded with dead trcs
c   and the di index varying fastest (in this form there will
c   be gathers that are completely dead in order to fill out
c   the survey)
c----
       IF (istatic .ne. 30000) THEN

c_____________________________________________________________________
c         trace falls within gather window.         
c_____________________________________________________________________

          call saver2(bufin,ifmt_keywrd,l_keywrd, ln_keywrd,
     1                i_keywrd , 1)
          call saver2(bufin,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                idist    , 1)

c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
          if ( i_keywrd .eq. cur_keywrd .OR. noffset .eq. 0) then

             cur_keywrd = i_keywrd
             dist = idist
c************
             if(dist .ge. d2neg .and. dist .le. d1neg .OR.
     1          dist .ge. d1pos .and. dist .le. d2pos) then

                      live = live + 1
c_____________________________________________________________________
c               trace falls within distance window.
c_____________________________________________________________________
                noffset=noffset+1
                noffsav = noffset
                if (abs(dist) .le. dstmin) dstmin = abs(dist)
                xtemp(noffset)=dist
                call vmov(uin(1),1,ugather(1,noffset),1,nsamp)
                call vfill(dist,weight(1,noffset),1,nsamp)
c_____________________________________________________________________
c               capture important trace header information
c_____________________________________________________________________
                   call saver2(bufin,ifmt_FlReFN,l_FlReFN, ln_FlReFN,
     1                         i_FlReFN , 1)
                   call saver2(bufin,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                         i_ToStUn , 1)
                   call saver2(bufin,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                         i_ToTmAU , 1)
                   call saver2(bufin,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         i_RecNum , 1)
                   call saver2(bufin,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                         i_TrcNum , 1)
                   call saver2(bufin,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                         i_RecInd , 1)
                   call saver2(bufin,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                         i_SrcLoc , 1)
                   call saver2(bufin,ifmt_SrcPnt,l_SrcPnt, ln_SrcPnt,
     1                         i_SrcPnt , 1)
                   call saver2(bufin,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                         i_SoPtNm , 1)
                   call saver2(bufin,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                         i_LinInd , 1)
                   call saver2(bufin,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                         i_DphInd , 1)
                   call saver2(bufin,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                         i_SrRcMX , 1)
                   call saver2(bufin,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                         i_SrRcMY , 1)
                   if ( BC ) then
                      call saver2(bufin,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                            i_SrPtXC , 1)
                      call saver2(bufin,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                            i_SrPtYC , 1)
                      call saver2(bufin,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                            i_RcPtXC , 1)
                      call saver2(bufin,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                            i_RcPtYC , 1)
                      cdpx = 0.5 * float (i_SrPtXC + i_RcPtXC) + 0.5
                      cdpy = 0.5 * float (i_SrPtYC + i_RcPtYC) + 0.5
                      cdpxsum = cdpxsum + cdpx
                      cdpysum = cdpysum + cdpy
                   else
                      call saver2(bufin,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                            i_CDPBCX , 1)
                      call saver2(bufin,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                            i_CDPBCY , 1)
                   endif



                if(verbos) then
         if(noffset .eq. 1)
     1   write(lerr,'(10a10)')
     2            'ioffset','RecNum','TrcNum','SrcLoc',
     3            'DphInd','LinInd','SoPtNm','DstSgn',
     4            'SrRcMX','SrRcMY'
                   write(lerr,'(10i10)')
     1                   noffset,i_recnum,i_trcnum,i_srcloc,
     2                   i_dphind,i_linind,i_soptnm,idist
     3                   i_srrcmx,i_srrcmy
                endif

                if (trccnt .eq. ngath) go to 20001

              endif
c************

c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
             else
                noffsav = noffset
                noffset = 0
                call move (1, itr, bufin, nbytes)
                next = .true.
                go to 20001
             endif
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
       ELSE
c----
c  if we have records with dead traces
c  we need to make sure we read to the
c  end of the current ensemble
c  if we have reached the end we whip to
c  the wrtape section

c  if we used sisort there won't be any dead trcs
c  until the end of each "line" or "di"
c  if we used sr3d then there could be many padded
c  gathers or even completely dead gathers
c----
          next = .false.
          if (K .eq. mgath .and. noffset .eq. 0)  then
             go to 76000
          elseif (K .lt. mgath .and. noffset .ne. 0) then
             go to 20000
          endif
c----
c  we've hit the end of an ensemble padded with dead
c  trcs so we jump out of the read portion and into the
c  wieghting/summing posrtion
c----
          if (K .eq. mgath .and. noffset .ne. 0) then
             go to 20001
          endif

       ENDIF

20000 CONTINUE

20001 CONTINUE

      noffset = noffsav

      if(noffset .eq. 0) then
         write(lerr,*)'WARNING0: no traces in gather',irec,icc
         write(ler ,*)'WARNING0: no traces in gather',irec,icc
      endif

      if(snorm) then
c_____________________________________________________________________
c        count how many non zero samples there are in each gather.
c        shift nonzero samples to the left.
c_____________________________________________________________________
         do 25000 k=1,noffset
          do 22000 isamp=1,nsamp
           if(ugather(isamp,k) .ne. 0.) then
              icount(isamp)=icount(isamp)+1
              ugather(isamp,icount(isamp))=ugather(isamp,k)
              weight(isamp,icount(isamp))=weight(isamp,k)       
           endif
22000     continue
25000    continue
         if(dwgt) then
c_____________________________________________________________________
c           calculate and normalize weights proportional to distance.
c_____________________________________________________________________
            do 30000 isamp=1,nsamp
             sum=0.
             do 26000 k=1,icount(isamp)
              xtemp(k)=weight(isamp,k)*taper(k,icount(isamp))
              sum=sum+xtemp(k)               
26000        continue
             if(sum .ne. 0.) then
                do 28000 k=1,icount(isamp)
                 weight(isamp,k)=xtemp(k)/sum
28000           continue
             else
                do 29000 k=1,icount(isamp)
                  weight(isamp,k)=0.
29000           continue
             endif
30000       continue
         else
c_____________________________________________________________________
c           weights invariant with distance. copy taper into weight.       
c_____________________________________________________________________
            do 30050 isamp=1,nsamp
             do 26050 k=1,icount(isamp)
              weight(isamp,k)=taper(k,icount(isamp))
26050        continue
30050       continue
         endif
      else
c_____________________________________________________________________
c        simple normalization by the number of live traces in the 
c        window.
c_____________________________________________________________________
         if(dwgt) then
c_____________________________________________________________________
c           calculate and normalize weights proportional to distance.
c_____________________________________________________________________
            sum=0.
            do 26100 k=1,noffset             
             xtemp(k)=weight(1,k)*taper(k,noffset)             
             sum=sum+xtemp(k)               
26100       continue
            if(sum .ne. 0.) then
               do 28100 k=1,noffset        
                do 28050 isamp=1,nsamp
                 weight(isamp,k)=xtemp(k)/sum
28050           continue
28100          continue
            else
               call vclr(weight,1,nsamp*noffset)
               write(lerr,*) 'possible error in routine stacksub'
               write(lerr,*) 'distance weights are all zero!'
               write(lerr,*) 'noffset = ',noffset,' rec= ',irec
               write(lerr,*) 'xtemp ',(xtemp(k),k=1,noffset)
            endif
         else
c_____________________________________________________________________
c           weights invariant with distance. taper into weight.           
c_____________________________________________________________________
            do 30150 k=1,noffset  
             do 26150 isamp=1,nsamp         
              weight(isamp,k)=taper(k,noffset)             
26150        continue
30150       continue
         endif
      endif
c
      if(power .ne. 1.) then
c_____________________________________________________________________
c        do power-th root stack of the input data.
c_____________________________________________________________________
         do 35000 k=1,noffset
          do 31000 isamp=1,nsamp
           ampl=sign(abs(ugather(isamp,k))**powerinv,
     1                                       ugather(isamp,k))
           usum(isamp)=ampl+usum(isamp)
31000     continue
c_____________________________________________________________________
c         raise stacked trace to the power 'power'
c_____________________________________________________________________
          do 32000 isamp=1,nsamp
           usum(isamp)=sign(abs(usum(isamp))**power,usum(isamp))
32000     continue
35000    continue
      elseif(semb .or. semwt) then
         do 50000 k=1,noffset
c_____________________________________________________________________
c         do power-th root stack of the input data.
c_____________________________________________________________________
          do 40000 isamp=1,nsamp
           usum(isamp)=usum(isamp)+ugather(isamp,k)
           udenom(isamp)=udenom(isamp)+ugather(isamp,k)**2
40000     continue
50000    continue
      elseif(snorm) then
c_____________________________________________________________________
c        weighted stack honoring mute zones (zero valued samples).
c_____________________________________________________________________
         do 55000 isamp=1,nsamp
          do 52000 k=1,icount(isamp)
           usum(isamp)=usum(isamp)
     1                  +ugather(isamp,k)*weight(isamp,k)           
52000     continue
55000    continue
      else
c_____________________________________________________________________
c        simple weighting (with or without normalization).        
c_____________________________________________________________________
         do 70000 k=1,noffset
          do 60000 isamp=1,nsamp
           usum(isamp)=usum(isamp)+ugather(isamp,k)*weight(isamp,k)
60000     continue
70000    continue
      endif

      if(noffset .eq. 0) then
         write(lerr,*)'WARNING: no traces in gather',irec,icc
         noffset = 1
      endif

      if(semb) then
c_____________________________________________________________________
c        output the semblance.             
c_____________________________________________________________________
         do 72000  isamp=1,nsamp
          uout(isamp)=(usum(isamp)**2)/udenom(isamp)
72000    continue
      elseif(semwt) then
c_____________________________________________________________________
c        output the semblance weighted stack
c_____________________________________________________________________
         do  74000  isamp=1,nsamp
          uout(isamp)=(usum(isamp)**3)/(udenom(isamp)*noffset)
74000    continue
      else
c_____________________________________________________________________
c        output non semblance weighted stack
c_____________________________________________________________________
         do 75000 isamp=1,nsamp
          uout(isamp)=usum(isamp)
75000    continue
      endif

c----
c                         write output stacked trace
c----

76000 continue
      icc = icc + 1

c----
c   deal with completely dead gather
c----
      if (live .eq. 0) then
         do  ii = 1, lenhed+nsamp
             bufout (ii) = 0
         enddo
         call savew2(bufout,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               30000 , 1)
         i_ToStUn = 0
         i_ToTmAU = 0
         i_DphInd = 0
         i_LinInd = 0
         i_SrcLoc = 0
         i_SrcPnt = 0
         i_SoPtNm = 0
         i_CDPBCX = 0
         i_CDPBCY = 0
      else
        if ( BC ) then
           cdpxsum = cdpxsum / noffset
           cdpysum = cdpysum / noffset
           i_CDPBCX = cdpxsum
           i_CDPBCY = cdpysum
        endif
      endif
      idstmin = dstmin

c----
c   put proper indexing into stacked trace
c----

                   call savew2(bufout,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                         idstmin  , 1)
                   call savew2(bufout,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                         i_ToStUn , 1)
                   call savew2(bufout,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                         i_ToTmAU , 1)
                   call savew2(bufout,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         irec     , 1)
                   call savew2(bufout,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                         icc      , 1)
                   call savew2(bufout,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                         i_RecInd , 1)
                   call savew2(bufout,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                         i_DphInd , 1)
                   call savew2(bufout,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                         i_SrcLoc , 1)
                   call savew2(bufout,ifmt_SrcPnt,l_SrcPnt, ln_SrcPnt,
     1                         i_SrcPnt , 1)
                   call savew2(bufout,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                         i_LinInd , 1)
                   call savew2(bufout,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                         i_SoPtNm , 1)
                   call savew2(bufout,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                         i_SrRcMX , 1)
                   call savew2(bufout,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                         i_SrRcMY , 1)
                   call savew2(bufout,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                         i_CDPBCX , 1)
                   call savew2(bufout,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                         i_CDPBCY , 1)
                   call savew2(bufout,ifmt_FoldNm,l_FoldNm, ln_FoldNm,
     1                         noffset , 1)

c----
c   update trc & rec counters
c----
      if(mod(icc,ntpr) .eq. 0) then
        irec=irec+1                 
        icc = 0
      endif

      ic=ic+1
      if (verbos)
     1write(lerr,*)'rec= ',irec,' trc= ',icc,' di/li= ',i_DphInd,
     2i_LinInd

      call wrtape(luout,bufout,nbytes)

c----
c   since the input data from 3D sort programs may be organized
c   into records (ngath long) that contain several ensembles (with
c   a max of mgath trcs) we need to make sure we've got all the
c   ensembles in ngath
c----
      IP = IP + 1
      if (trccnt .le. ngath) then
         go to 1
      else
         write(lerr,*)'done with rec ',irec
      endif

      return
      end
