C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine veltrp (index, irec, nrecc, nsamp, first, last,
     1                   iposl, iposr, vel, vell, velr, luout, lhed,
     2                   ITHWP1,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     3                   obytes, short, ione)

#include <f77/iounit.h>

      real    vel (*), vell (*), velr (*)
      integer index (*), lhed (*)
      integer irec, nrecc, nsamp, ITHWP1, obytes, luout, ione
      logical first, last, short

      if (first) then

         do  j = 1, nrecc

             if (irec .eq. index(j)) then
                ifirst = j
                go to 1
             endif
         enddo
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in velint:'
         write(LERR,*)'Unable to find index corrsponding to ',irec
         write(LERR,*)'found on first velocity trace. Index array'
         write(LERR,*)'starts at ',index(1),' and goes to ',
     1                index(nrecc),' incremented by 1'
         write(LERR,*)' '
         call ccexit (666)
1        continue

         call vmov (vel, 1, lhed(ITHWP1), 1, nsamp)
         DO  i = index(1), index(ifirst), ione
             call savew2 (lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd, i, 1)
             call wrtape  (luout, lhed, obytes)
         ENDDO

         iposl = ifirst
         first = .false.
         call vmov (vel, 1, vell, 1, nsamp)

      elseif (short) then

         write(LERR,*)' '
         write(LERR,*)'WARNING FROM velint (2D):'
         write(LERR,*)'Encountered premature end of velocity traces.'
         write(LERR,*)'Will use last velocity trace to the end'
         write(LERR,*)' '

         DO  i = index(iposl), index(nrecc), ione
             call savew2 (lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd, i, 1)
             call wrtape  (luout, lhed, obytes)
         ENDDO

      else

         do  j = iposl, nrecc
        
             if (irec .eq. index(j)) then
                icur = j
                go to 2
             endif
         enddo
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in velint:'
         write(LERR,*)'Unable to find index corrsponding to ',irec
         write(LERR,*)'found on this velocity trace. Index array'
         write(LERR,*)'started at ',index(iposl),' and went to ',
     1                index(nrecc),' incrementing by 1'
         write(LERR,*)' '
         call ccexit (666)
2        continue

         dindx = index(icur) - index(iposl)
         DO  i = index(iposl+1), index(icur), ione
             s = ( float(i) - float(index(iposl)) ) / dindx

             do  ii = 1, nsamp
                 velr (ii) = (1.-s) * vell(ii) + s * vel (ii)
             enddo  
             call savew2 (lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd, i, 1)
             call vmov (velr, 1, lhed(ITHWP1), 1, nsamp)
             call wrtape  (luout, lhed, obytes)
         ENDDO

         if (last) then

             DO  i = index(icur+1), index(nrecc), ione
                 call savew2 (lhed,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd, i,1)
                 call wrtape  (luout, lhed, obytes)
             ENDDO

         else

            call vmov (vel, 1, vell, 1, nsamp)
            iposl = icur

         endif


      endif


      return
      end
