C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c   program vfill3d - build 3d velocity model
c-----------------------------------------------------------------------
c
#include  <localsys.h>
#include  <f77/iounit.h>
#include  <f77/lhdrsz.h>
#include  <f77/sisdef.h>
c-----------------------------------------------------------------------
c
      REAL    * 4 u(3000)
c
      real    * 4 xy, seis
      integer     iheadr

      pointer (xyadr,xy(1))
      pointer (seisadr,seis(1))
      pointer (wkhdr  ,iheadr(1))
c
      integer * 4 lhed( 3000  )
      integer * 2 itr ( 6128 )
c
      character   ntap * 120, otap * 120 ,name * 5, grp*4
      character   line*120
      character   pfile * 100
c
#include  <f77/pid.h>
c
      logical verbos, query
      integer argis
c
      EQUIVALENCE ( ITR(129), U   (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
c
      DATA  lu8 , lu10, LU44, LU55, LU77
     :    /   8 ,   10,   44,   55,   77  /
      DATA PI / 3.141592 /
      DATA name /'VMOD3D' /
      data iabort / 0 /
C-----------------------------------------------------------------------
C
C      open file for output
C
C-----------------------------------------------------------------------
#include <f77/open.h>
C-----------------------------------------------------------------------
C
C      get online help
C
C-----------------------------------------------------------------------
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
            call help()
            stop
      end if
c
      call gcmdln (ntap, otap, pfile, ns, ne, irs, ire,
     :	 vel,verbos,iref,zinc,zbias,xinc,xbias,yinc,ybias)
c
C-----------------------------------------------------------------------
C
C      get logical unit numbers for input and output
C
C-----------------------------------------------------------------------
      call getln (luin,  ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
C-----------------------------------------------------------------------
C
C      read lineheader and save key values
C
C-----------------------------------------------------------------------
      lbytes = 0
      call rtape4 ( luin, itr, lbyte, lbytes )
      if (lbytes .eq. 0) then
            write(LOT, *)'DATUM: no header read from unit ', luin
            write(LOT, *)'FATAL'
            stop
      endif
#include <f77/saveh.h>
      call savelh(itr,nsamp,nsi,ntrc,nrec,iform)
C-----------------------------------------------------------------------
C
C      verify command line parameters
C
C-----------------------------------------------------------------------
      call cmdchk ( ns, ne, irs, ire, ntrc, nrec )
C-----------------------------------------------------------------------
C
C      modify lineheader to agree with command line arguments
C
C-----------------------------------------------------------------------
      nrecc = ire -irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      ntrace = ne - ns + 1
      call savew(itr, 'NumTrc', ntrace,   LINHED)
      call savhlh(itr, lbyte, lbyout )
      CALL WRTAPE ( LUOUT, ITR, lbyout                      )
c-----------------------------------------------------------------------
c     set general parameters
c
c
      dt = real (nsi) * unitsc
c
      tmax = dt * float( nsamp - 1 )
C-----------------------------------------------------------------------
C
C      verbose listing of parameters
C
C-----------------------------------------------------------------------
        call verbal(nsamp, nsi, ntrc, nrec, iform,
     :     ntap,otap,vel,zinc,zbias,xinc,xbias,yinc,ybias)
c-----------------------------------------------------------------------
c
c      get array space
c
      ispace = nrec*ntrace*SZSMPD
      iwkhdr = ITRWRD*ntrace*SZSMPD
      call galloc(xyadr, ispace, ierr, iabort)
      call galloc(wkhdr, iwkhdr, ierr, iabort)

      if (ierr .ne. 0) then
        write(LER,10) nrec * ntrc
        stop
      endif
 
      call galloc(seisadr, nsamp*ntrc*SZSMPD, ierr, iabort)
      if (ierr .ne. 0) then
        write(LER,10) 2000*ntrace
        stop
      endif
   10 format(' VMOD3D: memory allocation failed: attempted to get ',
     1     i7,' words ',/,' FATAL')
C
C     read input surface picks
      call rfile (xy,nrec,ntrc,nsamp,
     1                 zinc,zbias,xinc,xbias,yinc,ybias,icount)
c
c     print*, " past rfile"
C     interpolate picks
      call pickfill (xy,nrec,ntrc)
     
C-----------------------------------------------------------------------
C       skip unwanted records
C
       call recskp(1, irs - 1, luin, ntrc, itr)
C-----------------------------------------------------------------------
C
C-----Loop over Records
C
      do 450 irec = irs, ire
        write (LERR, * )' PROCESSING RECORD' ,IREC
        write (LER , * )' PROCESSING RECORD' ,IREC
C-----------------------------------------------------------------------
C
C       Read Record into 2D array and get trace header info
C
        do 460 jx = 1,ntrc
C-----------------------------------------------------------------------
C
C         READ A TRACE.
C
          NBYTES = 0
          call vclr (u,1,nsamp)
          CALL RTAPE ( LUIN, ITR, NBYTES                 )
            if (nbytes .le. 0 ) then
                  write(LER,*) 'read EOF on record'
                  write(LER,*) 'terminating job'
                      go to 9999
            end if
          CALL CHECKA ( nsamp, U )
c
         ishdr = (jx-1) * ITRWRD
         call move(1,iheadr(ishdr+1),itr,SZTRHD)
c
            istrc = (jx-1) * nsamp
            call vmov(u,1,seis(istrc+1),1,nsamp)
c
460   continue
c     finished reading a record
c
      call velfill (seis, xy, nsamp, ntrc, nrec, irec, vel)
C-----------------------------------------------------------------------
C
C       APPEND TRACE HEADERS AND WRITE OUT A RECORD
C
        DO 540 JXI = 1,ntrc
           ishdr = (jxi-1) * ITRWRD
           call move(1,itr,iheadr(ishdr+1),SZTRHD)
                 istrc = (jxi-1) * nsamp
                 do 547 ii = 1, nsamp
                    u(ii) = seis( istrc + ii )
547              continue
c
              CALL WRTAPE ( luout, ITR, nbytes          )
540     CONTINUE
C
C     END LOOP OVER INPUT RECORDS
C
450   CONTINUE
C-----------------------------------------------------------------------
C
C     CLOSE INPUT AND OUTPUT FILES
C
C-----------------------------------------------------------------------
9999      continue
      CLOSE (UNIT=LU44,STATUS='KEEP')
c     PRINT*,'LU44 CLOSED'
      CLOSE (UNIT=LU55,STATUS='KEEP')
c     PRINT*,'LU55 CLOSED'
      CLOSE (UNIT=LU77,STATUS='KEEP')
c     PRINT*,'LU77 CLOSED'
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP
      END
c
      SUBROUTINE CHECKA ( NX  , X )
      REAL    * 4 X ( * ), XMAX, XMIN
      INTEGER * 4 NX
      DATA  XMAX  ,   XMIN / 1.0e+15, 1.0e-15/
C*******************************************************************C
C                                                                   C
C  SUBROUTINE ARGUMENTS                                             C
C                                                                   C
C  X      = INPUT VECTOR                                            C
C  NX     = NUMBER OF SAMPLES/TRACE                                 C
C                                                                   C
C*******************************************************************C
      DO 10 I = 1, NX
        IF (ABS ( X (I) ) .LT. XMIN       ) THEN
            X ( I ) = 0.0
        ENDIF
        IF (ABS ( X (I) ) .GT. XMAX       ) THEN
            X ( I ) = 0.0
        ENDIF
10      continue
      RETURN
      END
c-----------------------------------------------------------------------
      subroutine help
#include <f77/iounit.h>
 
      write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'vfill3d - interpolate picks and build a 3-D Velocity Model'
      write(LER,*)
      write(LER,*)
     :'execute vfill3d by typing level followed by command line',
     :' parameters.'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
      write(LER,*)
     :'users enter the following parameters, or use default values'
        write(LER,*)
        write(LER,*)
     :' -N [ntap]        (none) : input seimic data file name'
        write(LER,*)
     :' -P [otap]        (none) : input horizon picks'
       write(LER,*)
     :' -O [otap]        (none) : output velocity file'
       write(LER,*)
     :' -ns[ns]          (first : start trace number'
       write(LER,*)
     :' -ne[ne]          (last) : end trace number'
       write(LER,*)
     :' -rs[irs]         (first : start record number'
       write(LER,*)
     :' -re[ire]         (last) : end record number'
       write(LER,*)
     :' -vel[vel]        (none) : velocity below input horizon'
       write(LER,*)
     :' -zinc[zinc]      (1)    : z (sample) incement of output '
       write(LER,*)
     :' -zbias[zbias]    (0)    : bias for z (sample) coordinate'
       write(LER,*)
     :' -xinc[xinc]      (1)    : x (trace) increment for output'
       write(LER,*)
     :' -xbias[xbias]    (0)    : bias for x (trace) coordinate'
       write(LER,*)
     :' -yinc[yinc]      (1)    : y (record) increment for output'
       write(LER,*)
     :' -ybias[ybias]    (0)    : bias for y (record) coordinate'
       write(LER,*)
     :' -V                      : -V to get additional printout.'
       write(LER,*)
     :' -?                      : enter -? to get online help.'
        write(LER,*)
        write(LER,*)
        write(LER,*) 'usage:  vfill3d -N[ntap] -O[otap] -P[pfile]'
        write(LER,*)
     :  '        -rs[irs] -re[ire] -ns[ns] -ne[ne] -V -?'
        write(LER,*)
     :  '        -Vel[vel] -zinc[zinc] xinc[xinc]-rs[irs] -re[ire] '
        write(LER,*) '        -ns[ns] -ne[ne] -V -?'      
        write(LER,*)
     :'***************************************************************'
      return
 
      end
 
C***********************************************************************
      subroutine gcmdln (ntap, otap, pfile, ns, ne, irs, ire,
     :	 vel,verbos,iref,zinc,zbias,xinc,xbias,yinc,ybias)
c-----
c     get command arguments
c
c     ntap  - c*120     input file name
c     otap  - c*120     output file name
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos  - L   verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), pfile*(*)
      integer *4 ns, ne, irs, ire
      logical verbos
      integer argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-P', pfile, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
	    call argr4('-vel',vel,0.0, 0.0)
	    call argr4('-zinc',zinc,1.0, 1.0)
	    call argr4('-xinc',xinc,1.0, 1.0)
	    call argr4('-yinc',yinc,1.0, 1.0)
	    call argr4('-zbias',zbias,0.0, 0.0)
	    call argr4('-xbias',xbias,0.0, 0.0)
	    call argr4('-ybias',ybias,0.0, 0.0)
            
            call argi4('-Ref', iref, -99999, -99999)
            verbos = ( argis( '-V' ) .gt. 0 )
c
            open (unit=LUN, file=pfile, status='old', iostat=ierr)
            if (ierr. ne. 0) then
               write (LERR,*) 'Could not open statics input file'
               write (LERR,*) 'Check Existence of this file'
               stop
            endif
c
      return
      end
c
        subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     :     ntap,otap,vel,zinc,zbias,xinc,xbias,yinc,ybias)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, iform
      character ntap*(*), otap*(*)
 
            write(LERR ,*)' '
            write(LERR ,*)' line header values after default check '
            write(LERR, *) ' # of samples/trace =  ', nsamp
            write(LERR ,*) ' sample interval    =  ', nsi
            write(LERR ,*) ' traces per record  =  ', ntrc
            write(LERR, *) ' records per line   =  ', nrec
            write(LERR ,*) ' format of data     =  ', iform
            write(LERR ,*) ' input data         =  ', ntap
            write(LERR ,*) ' output data set    =  ', otap
            write(LERR ,*)' '
            write(LERR ,*)' Program Run Parameters '
            write(LERR, *) ' Replacement Vel    =  ', vel
            write(LERR, *) ' Z (Sample) increment  =  ', zinc
            write(LERR, *) ' Z (Sample) Bias        =  ', zbias
            write(LERR, *) ' X (Record) increment  =  ', xinc
            write(LERR, *) ' X (Record) Bias        =  ', xbias
            write(LERR, *) ' Y (Trace) increment   =  ', yinc
            write(LERR, *) ' Y (Trace) Bias        =  ', ybias
            write(LERR ,*)' '
 
      return
      end
C***********************************************************************
      subroutine savelh(itr,nsamp,nsi,ntrc,nrec,iform)
      character grp*4
      LINHED = 0
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
c     call saver(itr, 'GrpIn0', intvl0, LINHED)
c     call saver(itr, 'GrpIn1', intvl1, LINHED)
c     call saver(itr, 'GrpIn2', intvl2, LINHED)
c     call saver(itr, 'GrpIn3', intvl3, LINHED)
c     grp(1:1) =  char ( intvl0 )
c     grp(2:2) =  char ( intvl1 )
c     grp(3:3) =  char ( intvl2 )
c     grp(4:4) =  char ( intvl3 )
c     read (  grp(1:4), fmt = '(i4)' ) intvl
c     read (  grp(1:4), fmt = '(r4)' ) grpint
c     GRPINT = intvl
      return
      end
c
C***********************************************************************
      subroutine rfile (xy,nrec,ntrc,nsamp,
     1                 zinc,zbias,xinc,xbias,yinc,ybias,icount)
      real * 4 xy(nrec, ntrc)
c
#include <f77/iounit.h>
c
      do 200 ii = 1,nrec
       do 300 jj = 1,ntrc
          xy(ii,jj) = -9999.0
300    continue
200   continue
c
      icount = 0
c
10    continue
         read (lun, *, end=20, err=20) record, trace, sample
         icount = icount + 1
         irecord= 1 +anint( (record + ybias) / yinc  )
         itrace = 1 +anint( (trace  + xbias) / xinc  )
         isamp  = 1 +anint( (sample + zbias) / zinc  )

         if ( ( (irecord .le. nrec) .and. (irecord .gt. 0) ) .and.   
     1        ( (itrace  .le. ntrc) .and. (itrace  .gt. 0) ) .and.   
     1        ( (isamp  .le. nsamp) .and. (isamp  .gt. 0) )      ) then
  
              xy( irecord, itrace ) = real( isamp )
c         print*, "rec, tr, samp"," ", irecord," ", 
c    1                             itrace," ", xy(irecord, itrace)
         endif
      goto 10
20    continue
      return
      end
c
C***********************************************************************
      subroutine pickfill (xy,nrec,ntrc)
 
      real * 4 xy(nrec, ntrc)
      integer * 4 trpkmax, trpkmin, rcpkmin, rcpkmax

c     Interpolate in trace direction
c
      do 10 irec = 1, nrec
c
        trpkmax = -99999
        trpkmin = 999999
c       find min and max traces with a record with good values
        do 15 itrc = 1, ntrc
c
         if ( (xy(irec, itrc) .gt. 0.) .and. (itrc .lt. trpkmin) )
     1                 trpkmin = itrc
         if ( (xy(irec, itrc) .gt. 0.) .and. (itrc .gt. trpkmax) )
     1                  trpkmax = itrc
15      continue
c
c        interpolate only if there are picks
         if ( trpkmax .gt. 0 ) then  
c
            do 20 itrc = 1, trpkmin 
            xy(irec,itrc) = xy(irec, trpkmin )
20          continue
c
            do 30 itrc = trpkmax, ntrc 
            xy(irec,itrc) = xy(irec, trpkmax )
30          continue
         
            iflag = 1
            ilast = 1

            do 40 itrc = 2, ntrc
              if ( xy( irec, itrc)  .lt. 0. ) then
                iflag = 0
              else
                if (iflag .eq. 0) then
                  sl=(xy(irec,itrc)-xy(irec,ilast))/(float(itrc-ilast))
                  do 50 jj = ilast, itrc
                    xy(irec, jj) = sl * (jj - ilast) + xy(irec, ilast)
50                continue
                  ilast = itrc
                  iflag = 1
                else
                  ilast = itrc
                endif
              endif
40          continue

         endif
c      do 80 ii = 1, ntrc
c         print*, "rec, tr, samp", irec," ",ii, " ", xy(irec, ii) 
c0     continue
10    continue
c         print*, " Finished inline picks"
c
c
c     Interpolate in record direction
c
      do 100 itrc = 1, ntrc

         rcpkmax = -99999
         rcpkmin = 999999

c        find min and max records with good values
         do 150 irec = 1, nrec
          if ( (xy(irec, itrc) .gt. 0.) .and. (irec .lt. rcpkmin) )
     1                  rcpkmin = irec
          if ( (xy(irec, itrc) .gt. 0.) .and. (irec .gt. rcpkmax) )
     1                   rcpkmax = irec
150      continue

c           extrapolate to first record with trace gather
            do 200 irec = 1, rcpkmin 
            xy(irec,itrc) = xy(rcpkmin, itrc)
200          continue
c
c           extrapolate to last record with trace gather
            do 300 irec = rcpkmax, nrec 
            xy(irec,itrc) = xy(rcpkmax, itrc)
300          continue
         
            iflag = 1
            ilast = 1

c           interpolation
            do 400 irec = 2, nrec
              if ( xy( irec, itrc)  .lt. 0. ) then
                iflag = 0
              else
                if (iflag .eq. 0) then
                  sl=(xy(irec,itrc)-xy(ilast,itrc))/(float(irec-ilast))
                  do 500 jj = ilast, irec
                    xy(jj,itrc) = sl * (jj - ilast) + xy(ilast, itrc)
500                continue
                  ilast = irec
                  iflag = 1
                else
                  ilast = irec
                endif
              endif
400          continue

100   continue
c      do 800 jj = 1, nrec
c        do 900 ii = 1, ntrc
c           print*, "rec, tr, samp", jj," ",ii, " ", xy(jj, ii) 
c00      continue
c00    continue
c         print*, " Finished crossline picks"
c

      return
      end
c
C***********************************************************************
      subroutine velfill (seis, xy, nsamp, ntrc, nrec, irec, vel)
c
      real * 4 xy(nrec, ntrc)
      real * 4 seis( nsamp, ntrc )
c
         do 10 i = 1, ntrc
c
c           fill output velocity with new velocity
            istart = anint( xy( irec, i) ) 
c           print*, "tr, istart =", i, " ", istart
            if ((istart .gt. 0) .and. (istart .le. nsamp)) then
               do 20 j = istart, nsamp
                  seis(j, i) = vel
20             continue
            endif
10       continue
      return
      end
        


