C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Single_Taper ( x, x1, x2, x3, x4, pass, pi, Taper )

c variables passed from calling routine

      real x, x1, x2, x3, x4, pi, Taper 

      logical pass

c local variables

      integer On, Off

      if ( pass ) then
         On = 0
         Off = 1
      else
         On = 1
         Off = 0
      endif

c x inside pass/reject zone

         if ( x4 .lt. x1 ) then

c stradling the origin

            if ( x .ge. x2 .or. x .le. x3 ) then
               if ( pass ) then
                  Taper = 1.0
               else
                  Taper = 0.0
               endif
               return
            endif
         else
            if ( x .ge. x2 .and. x .le. x3 ) then
               if ( pass ) then
                  Taper = 1.0
               else
                  Taper = 0.0
               endif
               return
            endif
         endif

c x completely outside filter



      if ( x4 .lt. x1 ) then

c watch out for aperture stradling origin

         if ( x .lt. x1 .and. x .gt. x4) then

            if ( pass ) then
               Taper = 0.0
            else
               Taper = 1.0
            endif
            return
         endif
      else

         if ( x .lt. x1 .or. x .gt. x4 ) then
            if ( pass ) then
               Taper = 0.0
            else
               Taper = 1.0
            endif
            return
         endif
      endif

c x in on/off taper zone

      if ( x .ge. x1 .and. x .lt. x2 ) then
         call CosTaper( x, x1, x2, Taper, pi, On )
         return
      elseif ( x .gt. x3 .and. x .le. x4 ) then 
         call CosTaper( x, x3, x4, Taper, pi, Off )
         return
      endif

      end

      

