C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Azimuth_Taper ( a, a1, a2, a3, a4, 
     :     a1_sym, a2_sym, a3_sym, a4_sym, pass, pi, Taper )

c routine to return taper value for point along azimuth (a).  The azimuthal
c filter points are a1, a2, a3, a4.  The filter must be defined in a counter-
c clockwise rotation.

c variables passed from calling routine

      real a, a1, a2, a3, a4 
      real a1_sym, a2_sym, a3_sym, a4_sym
      real pi, Taper 

      logical pass

c local variables

      integer OnsetTaperFlag, OffsetTaperFlag


c set the taper onset/offset flag.  A value of zero will result in
c a taper up from zero to 1.0.  A value of unity will result in a 
c taper down from 1.0 to 0.0

      if ( pass ) then
         OnsetTaperFlag = 0
         OffsetTaperFlag = 1
      else
         OnsetTaperFlag = 1
         OffsetTaperFlag = 0
      endif

c There are basically 2 classes of conditions.  Either the filter
c points a1 through a4_sym increase between 0 and 360 degrees, or 
c they don't.  I will handle the case where they do first:

      IF ( a1 .ge. 0.0 .and. a1 .lt. a4_sym ) then

c azimuth between 0.0 and a1
         
         if ( a .ge. 0.0 .and. a .lt. a1 ) then
            Taper = 1.0
            if ( pass ) Taper = 0.0
            return
         endif

c azimuth between a1 and a2
         
         if ( a .ge. a1 .and. a .lt. a2 ) then
            call CosTaper( a, a1, a2, Taper, pi, OnsetTaperFlag )
            return
         endif

c azimuth between a2 and a3
         
         if ( a .ge. a2 .and. a .le. a3 ) then
            Taper = 0.0
            if ( pass ) Taper = 1.0
            return
         endif

c azimuth between a3 and a4

         if ( a .gt. a3 .and. a .le. a4 ) then
            call CosTaper( a, a3, a4, Taper, pi, OffsetTaperFlag )
            return
         endif

c azimuth between a4 and a1_sym

         if ( a .gt. a4 .and. a .lt. a1_sym ) then
            Taper = 1.0
            if (pass) Taper = 0.0
            return
         endif

c azimuth between a1_sym and a2_sym

         if ( a .ge. a1_sym .and. a .lt. a2_sym ) then
            call CosTaper( a, a1_sym, a2_sym, Taper, pi, 
     :           OnsetTaperFlag )
            return
         endif

c azimuth between a2_sym and a3_sym

         if ( a .ge. a2_sym .and. a .le. a3_sym ) then
            Taper = 0.0
            if (pass) Taper = 1.0
            return
         endif

c azimuth between a3_sym and a4_sym

         if ( a .gt. a3_sym .and. a .le. a4_sym ) then
            call CosTaper( a, a3_sym, a4_sym, Taper, pi, 
     :           OffsetTaperFlag )
            return
         endif

c azimuth between a4_sym and 360

         if ( a .gt. a4_sym .and. a .le. 360.0 ) then
            Taper = 1.0
            if (pass) Taper = 0.0
            return
         endif

c Now I will handle the symetrical case where all filter points increase
c but a1_sym is closest to zero instead of a1 as in the above case:

      ELSEIF ( a1_sym .ge. 0.0 .and. a1_sym .lt. a4 ) then
          
c azimuth between 0.0 and a1_sym
         
         if ( a .ge. 0.0 .and. a .lt. a1_sym ) then
            Taper = 1.0
            if ( pass ) Taper = 0.0
            return
         endif

c azimuth between a1_sym and a2_sym
         
         if ( a .ge. a1_sym .and. a .lt. a2_sym ) then
            call CosTaper( a, a1_sym, a2_sym, Taper, pi, 
     :           OnsetTaperFlag )
            return
         endif

c azimuth between a2_sym and a3_sym
         
         if ( a .ge. a2_sym .and. a .le. a3_sym ) then
            Taper = 0.0
            if ( pass ) Taper = 1.0
            return
         endif

c azimuth between a3_sym and a4_sym

         if ( a .gt. a3_sym .and. a .le. a4_sym ) then
            call CosTaper( a, a3_sym, a4_sym, Taper, pi, 
     :           OffsetTaperFlag )
            return
         endif

c azimuth between a4_sym and a1

         if ( a .gt. a4_sym .and. a .lt. a1 ) then
            Taper = 1.0
            if (pass) Taper = 0.0
            return
         endif

c azimuth between a1 and a2

         if ( a .ge. a1 .and. a .lt. a2 ) then
            call CosTaper( a, a1, a2, Taper, pi, OnsetTaperFlag )
            return
         endif

c azimuth between a2 and a3

         if ( a .ge. a2 .and. a .le. a3 ) then
            Taper = 0.0
            if (pass) Taper = 1.0
            return
         endif

c azimuth between a3 and a4

         if ( a .gt. a3 .and. a .le. a4 ) then
            call CosTaper( a, a3, a4, Taper, pi, OffsetTaperFlag )
            return
         endif

c azimuth between a4 and 360

         if ( a .gt. a4 .and. a .le. 360.0 ) then
            Taper = 1.0
            if (pass) Taper = 0.0
            return
         endif

c now I will handle the case where the filter brackets the 0/360 boundary.  
c This of course raises two additional cases.  Either the a1 though 4 points
c cross the boundary or the a1_sym though a4_sym points cross the boundary.  I
c will handle the a1 through a4 case first:

      ELSEIF ( a3 .ge. 0.0 .and. a3 .lt. a2 ) then

c azimuth is between 0 and a3

         if ( a .ge. 0.0 .and. a .lt. a3 ) then
            Taper = 0.0
            if (pass) Taper = 1.0
            return
         endif

c azimuth is between a3 and a4

         if ( a .ge. a3 .and. a .lt. a4 ) then
            call CosTaper( a, a3, a4, Taper, pi, OffsetTaperFlag )
            return
         endif

c azimuth is between a4 and a1_sym

         if ( a .gt. a4 .and. a .lt. a1_sym ) then
            Taper = 1.0
            if (pass) Taper = 0.0
            return
         endif

c azimuth between a1_sym and a2_sym

         if ( a .ge. a1_sym .and. a .lt. a2_sym ) then
            call CosTaper( a, a1_sym, a2_sym, Taper, pi, 
     :           OnsetTaperFlag )
            return
         endif

c azimuth between a2_sym and a3_sym

         if ( a .ge. a2_sym .and. a .le. a3_sym ) then
            Taper = 0.0
            if (pass) Taper = 1.0
            return
         endif

c azimuth between a3_sym and a4_sym

         if ( a .gt. a3_sym .and. a .le. a4_sym ) then
            call CosTaper( a, a3_sym, a4_sym, Taper, pi, 
     :           OffsetTaperFlag )
            return
         endif

c azimuth between a4_sym and a1

         if ( a .gt. a4_sym .and. a .lt. a1 ) then
            Taper = 1.0
            if (pass) Taper = 0.0
            return
         endif

c azimuth between a1 and a2
         
         if ( a .ge. a1 .and. a .lt. a2 ) then
            call CosTaper( a, a1, a2, Taper, pi, OnsetTaperFlag )
            return
         endif

c azimuth between a2 and 360
         
         if ( a .ge. a2 .and. a .le. 360.0 ) then
            Taper = 0.0
            if ( pass ) Taper = 1.0
            return
         endif

c now I will handle the symetrical case where the a1_sym through a4_sym
c filter points straddle the 0/360 boundary

      ELSEIF ( a3_sym .ge. 0.0 .and. a3_sym .lt. a2_sym ) then

c azimuth is between 0 and a3_sym

         if ( a .ge. 0.0 .and. a .lt. a3_sym ) then
            Taper = 0.0
            if (pass) Taper = 1.0
            return
         endif

c azimuth between a3_sym and a4_sym

         if ( a .gt. a3_sym .and. a .le. a4_sym ) then
            call CosTaper( a, a3_sym, a4_sym, Taper, pi, 
     :           OffsetTaperFlag )
            return
         endif

c azimuth between a4_sym and a1

         if ( a .gt. a4_sym .and. a .lt. a1 ) then
            Taper = 1.0
            if (pass) Taper = 0.0
            return
         endif

c azimuth between a1 and a2
         
         if ( a .ge. a1 .and. a .lt. a2 ) then
            call CosTaper( a, a1, a2, Taper, pi, OnsetTaperFlag )
            return
         endif

c azimuth between a2 and a3
         
         if ( a .ge. a2 .and. a .le. a3 ) then
            Taper = 0.0
            if ( pass ) Taper = 1.0
            return
         endif

c azimuth between a3 and a4

         if ( a .gt. a3 .and. a .le. a4 ) then
            call CosTaper( a, a3, a4, Taper, pi, OffsetTaperFlag )
            return
         endif

c azimuth between a4 and a1_sym

         if ( a .gt. a4 .and. a .lt. a1_sym ) then
            Taper = 1.0
            if (pass) Taper = 0.0
            return
         endif

c azimuth between a1_sym and a2_sym

         if ( a .ge. a1_sym .and. a .lt. a2_sym ) then
            call CosTaper( a, a1_sym, a2_sym, Taper, pi, 
     :           OnsetTaperFlag )
            return
         endif

c azimuth between a2_sym and 360

         if ( a .ge. a2_sym .and. a .le. 360.0 ) then
            Taper = 0.0
            if (pass) Taper = 1.0
            return
         endif

      ENDIF

      end

      
