C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetAzimuth( dkx, dky, pi, Azimuth )

      real dkx, dky, pi, Azimuth

      if ( dkx .gt. 0.0 .and. dky .ge. 0.0 ) then

c Quadrant Four
         Azimuth = atan2 ( abs(dkx), abs(dky) )
         Azimuth = Azimuth  * 180. / pi + 270.

      elseif ( dky .gt. 0.0 .and. dkx .le. 0.0 ) then

c Quadrant Three
         Azimuth = atan2 ( abs(dky), abs(dkx) )
         Azimuth = Azimuth  * 180. / pi + 180.

      elseif ( dkx .lt. 0.0 .and. dky .le. 0.0 ) then

c Quadrant Two
         Azimuth = atan2 ( abs(dkx), abs(dky) )
         Azimuth = Azimuth  * 180. / pi + 90.

      elseif ( dky .lt. 0.0 .and. dkx .ge. 0.0 ) then

c Quadrant One
         Azimuth = atan2 ( abs(dky), abs(dkx) )
         Azimuth = Azimuth  * 180. / pi

      elseif ( abs(dkx) .lt. 1.e-30 .and. abs(dky) .lt. 1.e-30 ) then

c Origin, here the azimuth is undefined but we do NOT want to filter
c out Kx = Ky = 0.0 as we will toast all flat events so lets set the
c Azimuth negative so no azimuthal rejection will be done.

         Azimuth = -999.99

      endif

      return
      end

