C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fft2dee (work, nsamp, ntrc, nx, nx2, ny, lenitabx, 
     :     lenrtabx, lenitaby, lenrtaby, forward_rtabx, forward_rtaby, 
     :     forward_itabx, forward_itaby, cdata, forward_initx, 
     :     forward_inity)

c  routine to do 2-d fft

c  input

c      work  -  matrix of real input data
c      nsamp  -  # samps in work
c       ntrc  -  # traces in work
c         nx  -  power of 2 time samples
c         ny  -  power of 2 # traces
c     revers  -  reverse transform

c output

c      cdata  -  matrix of complex transformed values
#include <f77/iounit.h>
#include <f77/lhdrsz.h>


      integer  nx, ny, nsamp, ntrc, nx2
      integer  lenitabx, lenitaby, lenrtabx, lenrtaby
      integer  forward_itabx (lenitabx), forward_itaby (lenitaby)

      real  work(nx2, ny)
      real  forward_rtabx (lenrtabx), forward_rtaby (lenrtaby)

      complex  cdata(nx , ny)
      complex  workc(2*SZLNHD)


      nxmid = nx2 / 2
      nymid = ny  / 2

c------------
c  	.. Fourier transform:  (y,x) --> (ky,kx)

      DO     j = 1, ntrc
c load in x,y data 
         do     i = 1, nsamp
            workc (i) = cmplx (work(i,j), 0.0)
         enddo

c----
c   power of 2 Math Adv calls
c              call  cfft  (workc, nx, +1)
c              call cfftsc (workc, nx)

c----
c   equivalent
c   mixed radix call
c   in dimension T
c   (transform & normalization)
c   (init must = 1 first time through to build sine & cos tables)
c----
         call cfftm  (workc, 2, nx, 1, forward_initx, forward_itabx, 
     :        forward_rtabx, ierr)
         forward_initx = 0
         call cfftss (workc, 2, nx)

c load out kx,y data
         do  i = 1, nx
            cdata (i,j) = workc(i)
         enddo
      ENDDO

      DO  i = 1, nx
c load in kx,y data
         do  j = 1, ny
            workc(j) = cdata(i,j)
         enddo
           
c----
c   power of 2 Math Adv calls
c              call cfft   (workc, ny, +1)
c              call cfftsc (workc, ny)

c----
c   equivalent
c   mixed radix call
c   in dimension X
c   (transform & normalization)
c   (init must = 1 first time through to build sine & cos tables)
c----

         call cfftm  (workc, 2, ny, 1, forward_inity, forward_itaby, 
     :        forward_rtaby, ierr)
         forward_inity = 0
         call cfftss (workc, 2, ny)
           
c load out kx,ky data
         do  j = 1, ny
            cdata (i, j) = workc (j)
         enddo
      ENDDO

      DO  kx = 1, ny

         if (kx .gt. nymid) then
            kxout = kx - nymid
         else

c if ny/2 is non-integer the mapping needs to change slightly.  The following
c checks the modulus 2 of ny and reacts accordingly.

            if ( mod(ny,2) .gt. 0 ) then
               kxout = nymid + kx + 1
            else
               kxout = nymid + kx
            endif
         endif
         ix = kxout
         
         do  kt = 1, nx
            
            if (kt .gt. nx/2) then

c if nt/2 is non-integer the mapping needs to change slightly.  The following
c checks the modulus 2 of nt and reacts accordingly.

               if ( mod(nx,2) .gt. 0 ) then
                  ktout = kt - nx/2 - 1
               else
                  ktout = kt - nx/2 
               endif
            else
               ktout = nx/2 + kt
            endif
            
            if ( mod(nx,2) .gt. 0 ) then
               iamp   = nx  - ktout
               iphase = nx2 - ktout
            else
               iamp   = nx  - ktout + 1
               iphase = nx2 - ktout + 1
            endif
            
            work(iamp, ix  ) = cabs ( cdata(kt,kx) )
            
            if (work(iamp, ix  ) .eq. 0.) then
               work(iphase, ix  ) = 0.
            else
               work(iphase, ix  ) =
     1              atan2 ( aimag(cdata(kt,kx)),
     2              real(cdata(kt,kx))  )
            endif
         enddo
      enddo

      return
      end
