C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fft2ree (work, nsamp, ntrc, nx, nx2, ny, lenitabx, 
     :     lenrtabx, lenitaby, lenrtaby, rtabx, rtaby, itabx, 
     :     itaby, cdata, initx, inity )

c  routine to do 2-d fft

c  input

c      work  -  matrix of real input data
c      nsamp  -  # samps in work
c       ntrc  -  # traces in work
c         nx  -  power of 2 time samples
c         ny  -  power of 2 # traces
c     revers  -  reverse transform

c output

c      cdata  -  matrix of complex transformed values
#include <f77/iounit.h>
#include <f77/lhdrsz.h>


      	integer	 nx, ny, nsamp, ntrc, nx2, nxmid, nymid
        integer  lenitabx, lenitaby, lenrtabx, lenrtaby
        integer  itabx (lenitabx), itaby (lenitaby)

      	real 	 work(nx2, ny)
        real     rtabx (lenrtabx), rtaby (lenrtaby)
        complex  cdata(nx , ny)
        complex  workc(2*SZLNHD)


        nxmid = nx / 2
        nymid = ny / 2
c------------
c       .. unpack amp & phase into real & imag

       do  kx = 1, ny

           if (kx .gt. nymid) then
               kxout = kx - nymid
           else

c if nx/2 is non-integer the mapping needs to change slightly.  The following
c checks the modulus 2 of nx and reacts accordingly.

              if ( mod(ny,2) .gt. 0 ) then
                 kxout = nymid + kx + 1
              else
                 kxout = nymid + kx
              endif
           endif
           ix = kxout

           do  kt = 1, nx

c if nt/2 is non-integer the mapping needs to change slightly.  The following
c checks the modulus 2 of nt and reacts accordingly.

              if (kt .gt. nxmid) then
                 if ( mod(nx,2) .gt. 0 ) then
                    ktout = kt - nxmid - 1
                 else
                    ktout = kt - nxmid
                 endif                     
              else
                 ktout = nxmid + kt
              endif

             if ( mod(nx,2) .gt. 0 ) then
                iamp   = nx  - ktout
                iphase = nx2 - ktout 
             else
                iamp   = nx  - ktout + 1
                iphase = nx2 - ktout + 1
             endif

             cdata(kt,kx) =  work(iamp  , ix)    *
     1            cexp ( cmplx(0.,work(iphase, ix)) )

          enddo
       enddo

c------------
c  	.. Fourier transform:  (ky,kx) --> (y,x)

           do  i = 1, nx
               do  j = 1, ny
                   workc(j) = cdata(i,j)
               enddo

c----
c   power of 2 Math Adv calls
c              call cfft   (workc, ny, -1)
c----
c   equivalent
c   mixed radix call
c   in dimension X
c   (init must = 1 first time through to build sine & cos tables)
c----
               call cfftm  (workc, 2, ny, -1, inity, itaby, rtaby, ierr)
               inity = 0

               do  j = 1, ny
                   cdata (i, j) = workc (j)
               enddo
           enddo

            do     j = 1, ntrc
               do     i = 1, nx
                      workc(i) = cdata(i,j)
               enddo

c----
c   power of 2 Math Adv calls
c              call cfft   (workc, nx, -1)
c----
c   equivalent
c   mixed radix call
c   in dimension T
c   (init must = 1 first time through to build sine & cos tables)
c----
               call cfftm  (workc, 2, nx, -1, initx, itabx, rtabx, ierr)
               initx = 0

               do  i = 1, nsamp
                   work (i,j) = real (workc(i))
               enddo
           enddo

      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
