C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Read_TDFN ( luin, MaxNumElements, npairs, velocity, 
     :     time_depth, LI, DI, verbos , gamma, si)

#include <f77/iounit.h>

c read a single function from the attached TDFN function file
      
c declare variables passed from calling routine

      integer  luin, MaxNumElements, npairs
      integer  LI, DI 
      real     si

      real velocity(MaxNumElements), time_depth(MaxNumElements)

      logical  verbos, gamma

c declare local variables
      
      integer  ivelocity(7), itime_depth(7)
      integer  card_number, icount

c initialize variables

      npairs = 0
      icount = -6
      
c read the 0TDFN card and retrieve the LI and DI values

      read(luin, 15, end=999, err=990 ) card_number, LI, DI
 15   format(i1,4x,i5,i5)

      if ( card_number .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' No 0TDFN card found'
         write(LERR,*)' FATAL'
         write(LER,*)' '
         write(LER,*)' VI3D: No 0TDFN card found'
         write(LER,*)' FATAL'
         stop
      else
         if (verbos ) then
            write(LERR,*) ' '
            write(LERR,*) ' '
            write(LERR,*)' LI = ',LI,' DI = ',DI
            write(LERR,*) ' '
         endif
      endif

c read the TDFN cards and retrieve the time_depth, velocity pairs
c while doing this only watch for the 9TDFN card which will signal the
c end of the current function.  The number of cards that come before 
c is unimportant.

      DO while ( 1 .eq. 1 )

         icount = icount + 7

         read ( luin, 110, end=999, err=990 ) card_number,
     :        ( itime_depth(i), ivelocity(i), i= 1,7 )
 110     format( i1, 4x, 7(I4,I5) )

         IF ( card_number .ne. 9 ) then

            do i = icount, icount + 6
               time_depth(i) = float( itime_depth(i - icount + 1) )
               velocity(i) = float( ivelocity(i - icount + 1 ) )
               npairs = npairs + 1
	    enddo
	
         ELSEIF ( card_number .eq. 9 ) then

            do i = icount, icount + 6
               time_depth(i) = float( itime_depth(i - icount + 1 ) )
               velocity(i) = float( ivelocity(i - icount + 1 ) )

c watch for zero entries on the last card
c prg: watch for a fully filled last card (if we don't break out we'll
c prg: end up going back to read the very next card as part of the 
c prg: current function

               if( time_depth(i) .ge. 0. .and. velocity(i) .gt. 0.) then
                  npairs = npairs + 1
                  if (i .eq. (icount+6) ) go to 999
               else
                  goto 999
               endif
               
            enddo
         
         ENDIF

      ENDDO

 999  continue

      if ( gamma ) then
         do  i = 1, npairs
             time_depth(i) = si * time_depth(i)
         enddo
      endif

      if ( verbos ) then
         do i = 1, npairs
            write (LERR,*) time_depth(i), velocity(i)
         enddo
      endif

      return

 990  continue

      write(LERR,*)' '
      write(LERR,*)'Error reading TDFN file '
      write(LERR,*)'Check file and resubmit '
      write(LERR,*)'FATAL'
      write(LER,*)' '
      write(LER,*)'VI3D: Error reading TDFN file '
      write(LER,*)'      Check file and resubmit '
      write(LER,*)'FATAL'
      stop

      end
