C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine vi3d2 ( minLI, maxLI, LIincr, minDI, maxDI, DIincr, 
     :     cell_X, cell_Y, tol, X, Y, DI_pointer, LI_pointer, obytes, 
     :     weight, neighborhood, MaxNumFunctions, work, USP_trace, 
     :     sample, nfunc, velocity_fcns, MAXVEL, luout, nsi, nsampo,
     :     ifmt_RecNum, l_RecNum, ln_RecNum,
     :     ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :     ifmt_LinInd, l_LinInd, ln_LinInd,
     :     ifmt_DphInd, l_DphInd, ln_DphInd,
     :     ifmt_StaCor, l_StaCor, ln_StaCor, exponent,
     :     TrcNum_start, RecNum_start, delta_TrcNum, delta_RecNum, 
     :     vel_scalar, X_sorted, Y_sorted, Cosine, min_num_desired,
     :     median, scoping ) 

      implicit none

C     3D areal velocity interpolation
C 
C     interpolate velocities over an areal grid using a 
c     distance-azimuthal weighting (neighborhood) criteria

c algorithm is:
c
c    1. find all input functions that lay within the radius of
c       investigation of the current location

c    2. weight all functions according to radial distance and
c       form a weighted normalized sum of the velocities to 
c       output

c    3. load header structure and output velocity trace

#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine

      integer  MaxNumFunctions, MAXVEL, nfunc, nsi, nsampo 
      integer  minLI, maxLI, LIincr, minDI, maxDI, DIincr
      integer  luout, obytes, min_num_desired
      integer  DI_pointer( MaxNumFunctions)
      integer  LI_pointer( MaxNumFunctions)
      integer  ifmt_RecNum, l_RecNum, ln_RecNum
      integer  ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer  ifmt_LinInd, l_LinInd, ln_LinInd
      integer  ifmt_DphInd, l_DphInd, ln_DphInd
      integer  ifmt_StaCor, l_StaCor, ln_StaCor
      integer  neighborhood( MaxNumFunctions)
      integer  TrcNum_start, RecNum_start, delta_TrcNum, delta_RecNum

      real  tol, cell_Y, cell_X, exponent, vel_scalar

      real X(MaxNumFunctions), Y(MaxNumFunctions) 
      real X_sorted(MaxNumFunctions), Y_sorted(MaxNumFunctions) 
      real work(nsampo) 
      real weight(MaxNumFunctions) 
      real velocity_fcns(MAXVEL) 
      real USP_trace(nsampo), sample(nsampo) 

      logical Cosine, median, scoping

c declare local variables

      integer  itr( SZLNHD ), LI, DI, Nfound, StaCor, NTP
      integer xlower, ylower, RecNum, TrcNum, StaCor_dead

      real XC, YC, PIby2

c Variable Definition

C     minLI  - MINIMUM LINE  INDEX IN THE GRID 
C     maxLI  - MAXIMUM LINE  INDEX IN THE GRID 
C     LIincr - LINE INDEX INCREMENT 
C     minDI  - MINIMUM DEPTH INDEX IN THE GRID 
C     maxDI  - MAXIMUM DEPTH INDEX IN THE GRID 
C     DIincr - DEPTH INDEX INCREMENT 
C     cell_X - IN-LINE    CELL INCREMENT 
C     cell_Y - CROSS-LINE CELL INCREMENT 
C     tol    - RADIUS FOR ACCEPTABLE NEIGHBORS 
C     X[]    - RELATIVE X-COORDINATES 
C     Y[]    - RELATIVE Y-COORDINATES 
C     DI_pointer[] - INDEXES FOR RELATIVE X-COORDINATES 
C     LI_pointer[] - INDEXES FOR RELATIVE Y-COORDINATES 
C     weight[] - NEIGHBORHOOD WEIGHTS 
C     neighborhood[]  - NEIGHBORS 
C     MaxNumFunctions - MAXIMUM NUMBER OF INPUT VELOCITY FUNCTIONS 
C     work[] - WORK BUFFER 
C     USP_trace[] - WORK BUFFER to build output trace
C     sample[]  - BUFFER OF SAMPLED TIMES 
C     nsampo   - NUMBER OF POINTS IN THE VELOCITY FUNCTION 
C     nfunc  - NUMBER OF VELOCITY FUNCTIONS INPUT 
C     velocity_fcns[] - SAMPLED & INTERPOLATED VELOCITY FUNCTIONS FOR ENTIRE GRID 
C     MAXVEL  - MAXIMUM SIZE OF "velocity_fcns" 
C     luout  - output dataset logical unit
C     RecNum_start  - starting line number
C     TrcNum_start  - starting trace number

c initialize variables

      StaCor = 0
      StaCor_dead = -30000
      PIby2 = 2. * atan(1.0)
      xlower = 0
      ylower = 0

c sort the indexes pointing to x-coordinates & y-coordinates for subroutine amneb 
c note that I am sorting X and keeping the pointer information in DI_pointer so
c I do not forget that X is associated with DI information.  Similarly Y is 
c associated with LI information as organized in this code.

      call SRTIDX ( X , DI_pointer , nfunc ) 
      call SRTIDX ( Y , LI_pointer , nfunc ) 

      call vmov ( X, 1, X_sorted, 1, nfunc )
      call vmov ( Y, 1, Y_sorted, 1, nfunc )

      call hsort ( nfunc, X_sorted )
      call hsort ( nfunc, Y_sorted )

C process all bins requested 

      RecNum = RecNum_start - delta_RecNum

      DO LI = minLI, maxLI, LIincr 

         RecNum = RecNum + delta_RecNum
         xlower = 0
         
         TrcNum = TrcNum_start - delta_TrcNum

         DO DI = minDI, maxDI, DIincr 

            TrcNum = TrcNum + delta_TrcNum

C VELOCITY FIELD; 
C   compute the relative coordinates of the point to be interpolated 
C   find all functions in the neighborhood about this point 

            XC = cell_X * ( DI - minDI ) 
            YC = cell_Y * ( LI - minLI ) 
            NTP = 0 

c find all functions within the radius of investigation of this location

            call Get_Neighbors ( X_sorted, Y_sorted, XC, YC, 
     :           neighborhood, weight, Nfound, DI_pointer, LI_pointer, 
     :           tol, nfunc, Cosine, PIby2, xlower, ylower, 
     :           min_num_desired, exponent, scoping )

c if Nfound is zero then output a dead trace and flag it dead

            IF ( Nfound .eq. 0  ) then

               if ( .not. scoping ) then

                  write(LERR,*)'something fishy as vi3d is writing dead'
                  write(LERR,*)'traces and you have not specified '
                  write(LERR,*)'-scoping on the command line.  Better'
                  write(LERR,*)'call the USP shop and get this thing'
                  write(LERR,*)'fixed'
                  write(LER,*)'VI3D:' 
                  write(LER,*)' something fishy as vi3d is writing dead'
                  write(LER,*) 'traces and you have not specified '
                  write(LER,*) '-scoping on the command line.  Better'
                  write(LER,*) 'call the USP shop and get this thing'
                  write(LER,*)' fixed' 
                  write(LER,*)'WARNING'

               endif

               call vclr ( USP_trace, 1, nsampo )

               call savew2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor_dead, TRACEHEADER )

            ELSE

C using the neighborhood and weights determined, compute a weighted average of the
c velocity functions for the point in question or if requested simply compute the 
c samplewise median of all traces in the neighborhood.

               if ( median ) then

                  call MED ( velocity_fcns, MAXVEL, neighborhood, 
     :                 MaxNumFunctions, Nfound, nsampo, work, USP_trace, 
     :                 vel_scalar )
               
               else

                  call WGTAVG ( velocity_fcns, MAXVEL, weight, 
     :                 neighborhood, MaxNumFunctions, Nfound, nsampo,
     :                 work, USP_trace, vel_scalar )
               endif 

               call savew2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )

            ENDIF

c load trace header with LI, DI information for this location   

            call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd, 
     :           LI, TRACEHEADER )
            call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd, 
     :           DI, TRACEHEADER )

            if ( TrcNum_start .ne. -9999 .or. RecNum_start .ne. -9999 ) 
     :           then
               call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )
               call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              TrcNum, TRACEHEADER )
            else
               call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              LI, TRACEHEADER )
               call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              DI, TRACEHEADER )
            endif

c move the velocity trace to the output buffer
           
            call vmov ( USP_trace, 1, itr(ITHWP1), 1, nsampo )

c write the output trace

            call wrtape ( luout, itr, obytes )

         ENDDO
      ENDDO

      return 
      end 


