C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine frostfmt (luin, luout, ivel, itim, IX1, IY1,
     1                    XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                    DX, DY, NDI, NLI, minli, maxli,
     3                    mindi, maxdi, key, itmp, verbos,
     4                    RC, scl, tscl, itmax)

#include <f77/iounit.h>

      integer     itim (*), ivel (*), key (*), itmp (*)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     minli, maxli, mindi, maxdi, li, di
      character   card * 80, tag * 4, head * 4, blank * 80
      logical     verbos,got,EOF,RC,avoid
      data        head/'****'/
      data        blank/'                             '/

      tag = 'TDFN'
      ir0 = 0
      ir1 = 1
      i9  = 9

C**********************************************************************C
C     read input vel file
C**********************************************************************C
      ixlst  = 0
      iylst  = 0
      if = 0
      nf = 0
      got = .false.
      avoid = .true.
 
      DO while (1.eq.1)
         read (luin, '(a80)', end=110, err=666) card
         write(LERR,*) card
         if (card(2:5) .eq. head) go to 120
         go to 111
110      continue
         write(LERR,*)'FATAL ERROR in vi3din (frost option):'
         write(LERR,*)'Could not read past file header'
         write(LER ,*)'FATAL ERROR in vi3din (frost option):'
         write(LER ,*)'Could not read past file header'
         call ccexit (666)
111      continue
      ENDDO

120   continue

      DO while (1.eq.1)
 
         do while (1.eq.1)
            read (luin, '(a80)', end=123, err=666) card
            if (card(1:25) .eq. blank(1:25)) then
               if ( avoid ) then
                  read (luin, '(a80)', end=123, err=666) card
                  nf = nf + 1
                  avoid = .false.
                  go to 122
               endif
               got = .true.
               nf = nf + 1
               avoid = .false.
               go to 121
            endif
            if (avoid) go to 665
            go to 122
123         continue

            if (if .gt. 1) then
               write(LERR,*)'Hit EOF trying to read next function'
               write(LER ,*)'Hit EOF trying to read next function'
               EOF = .true.
               got = .true.
               nf = nf + 1
               go to 121
            else
               write(LERR,*)'Completed reading velocities'
               write(LERR,*)'Found ',nf,' functions'
               write(LER ,*)'Completed reading velocities'
               write(LER ,*)'Found ',nf,' functions'
               return
            endif

            if (nf .eq. 0) then
            write(LERR,*)'FATAL ERROR in vi3din (frost option):'
            write(LERR,*)'Hit EOF without reading any functions'
            write(LER ,*)'FATAL ERROR in vi3din (frost option):'
            write(LER ,*)'Hit EOF without reading any functions'
            call ccexit (666)
            endif
122         continue

c----
c   read "card" for input values. The valid ones are ICX,ICY,time,vel
c   the first 2 can be dummy integers (this is basically Landmark format).
c----
            if (if .eq. 0) then
               call fsscnf (card,'%f %f %f %f',
     1                      anline,ixline,CX,CY)
               IWRN = 0
               IF ( RC ) THEN
                  LI = anline
                  DI = ixline
               ELSE
                  CX = CX * scl
                  CY = CY * scl
                  IWRN = 0
                  CALL XFMFWD (CX, CY, LI, DI, CXT,CYT,BXT,BYT, IWRN,
     1                         IX1,IY1,XX,XY,YX,YY,XXT, XYT,YXT,YYT,
     2                         DX, DY, NDI, NLI)
               ENDIF
 
               IF (LI .LT. MINLI) IWRN = 1
               IF (LI .GT. MAXLI) IWRN = 1
               IF (DI .LT. MINDI) IWRN = 1
               IF (DI .GT. MAXDI) IWRN = 1
               if (IWRN .eq. 1) then
                  write(LERR,*)'Function located at ',ICX,ICY,
     1            ' out of bounds'
                  avoid = .true.
               else
                  write(LERR,*)'Function located at ',ICX,ICY,
     1            ' inside box'
                  avoid = .false.
               endif
               if (IWRN .eq. 1) go to 665
               if = 1

            elseif (if .gt. 0) then
               call fsscnf (card,'%f %d', time, nvel)
               ivel (if) = nvel
               itim (if) = nint (time * tscl)
               if = if + 1

            endif

         enddo

121      continue

c----
c   for completed valid function:
c   sort in case times are not in ascending order
c----
               IF ( if .gt. 1) THEN

                  if = if - 1
                  iff = 0
                  do  i = 1, if
                      itimi = itim(i)
                      if (itimi .lt. itmax .AND. ivel(i) .gt. 0) then
                         iff = iff + 1
                         ivel (iff) = ivel (i)
                         itim (iff) = itimi
                      endif
                  enddo
                  if = iff
                  call sort (itim, key, if)
                  do  i = 1, if
                      itmp (i) = ivel (key(i))
                  enddo
                  do  i = 1, if
                      ivel (i) = itmp (i)
                  enddo

c----
c   build TDFN input for vi3d
c----
                  xcards = float (if) / 7.0
                  ncards = ifix  (xcards - .001)
                  left = if - 7 * ncards
                  i1 = 7 * ncards + left + 1
                  i2 = 7 * (ncards + 1)
                  do  i = i1, i2
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
          
                  write (luout,555) ir0, tag, li, di
555               format (i1, a4, 2i5)
 
                  ih = -7
                  itag = 0
                  if (ncards .gt. 0) then
                     do  i = 1, ncards
                         itag = itag + 1
                         if (itag .ge. 9) itag = 1
                         ih = (i-1) * 7
                         write (luout,777) itag, tag,
     1                   (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
                     enddo
                  endif
                  ih = ih + 7
                  write (luout,777) i9, tag,
     1            (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
777               format (i1, a4, 7(I4,I5), 7X, I5)
 
c----
c   clear velocity & time arrays. If this is really the last function
c   then we don't want to jump up to read another card - we need to exit
c----
                  do  i = 1, if
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
                  if = 0
                  got = .false.
                  if (EOF) go to 999
 
               ENDIF

665      CONTINUE
 
      ENDDO

      if (nf .eq. 0) go to 667

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nf,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nf,' line was:',card

      go to 999
 
667   continue
 
      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din:'
      write(LERR,*)'Yikes! no valid functions read from file. Check'
      write(LERR,*)'to see if corner coords are correct; check XYs'
      write(LERR,*)'in input file; is each funtion together not'
      write(LERR,*)'scattered throughout input file?'
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din:'
      write(LER ,*)'Yikes! no valid functions read from file. Check'
      write(LER ,*)'to see if corner coords are correct; check XYs'
      write(LER ,*)'in input file; is each funtion together not'
      write(LER ,*)'scattered throughout input file?'

 
999   continue

      return
      end
