C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine prom3d (luin, luout, ivel, itim, IX1, IY1,
     1                    XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                    DX, DY, NDI, NLI, minli, maxli,
     3                    mindi, maxdi, key, itmp, verbos,
     4                    RC, scl, tscl, itmax)

#include <f77/iounit.h>

      integer     itim (*), ivel (*), key (*), itmp (*)
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      real        x(10)
      integer     minli, maxli, mindi, maxdi, li, di
      integer     dilast, lilast
      character   card * 80, tag * 4, head * 20, blank * 80
      logical     verbos,got,EOF,RC,first
      data        head/'--------------------'/
      data        blank/'                             '/

      tag = 'TDFN'
      ir0 = 0
      ir1 = 1
      i9  = 9

C**********************************************************************C
C     read input vel file
C**********************************************************************C
      ixlst  = 0
      iylst  = 0
      if = 1
      nf = 0
      nc = 80
      got = .false.
      first = .true.
 
c---
c  read to start of first function
c---
      DO while (1.eq.1)
         read (luin, '(a80)', end=110, err=666) card
         call ctrim (card, im)
         write(LERR,*) card
         if (card(1:20) .eq. head) go to 120
         go to 111
110      continue
         write(LERR,*)'FATAL ERROR in vi3din (PROMAX 3D option):'
         write(LERR,*)'Could not read past file header'
         write(LER ,*)'FATAL ERROR in vi3din (PROMAX 3D option):'
         write(LER ,*)'Could not read past file header'
         call ccexit (666)
111      continue
      ENDDO

120   continue

c---
c  read first function; then read all other functions
c---
      DO while (1.eq.1)
 
c----
c   read "card" for input values. The valid ones are ICX,ICY,time,vel
c   the first 2 can be dummy integers (this is basically Landmark format).
c   ctrim trims off leading blanks
c----
               read (luin, '(a80)', end=210, err=666) card
               call ctrim (card, im)
               go to 221
210            continue
               if (nf .gt. 0 .AND. if .gt. 1) then
                   EOF = .true.
                   go to 121
               elseif (nf .gt. 0 .AND. if .eq. 0) then
                   go to 999
               endif
221            continue

c----
c   decode the card image:  we don't know how many floats are on this
c   card so gliner reads anywhere from 2 to 10 real numbers
c   iwcount counts the number of floats on a card image
c----
            iw = iwcount (card, 80)
c     write(0,*)'IW= ',iw
            do i = 1, 10
               x (i) = 0
            enddo
            call gliner (card, x)
            x1 = x(1)
            x2 = x(2)
            x3 = x(3)
            x4 = x(4)
            x5 = x(5)
            x6 = x(6)

c----
c   if we have 6 elements then this is the start of a new function
c   and we have read in the LI, DI, X, Y, time, velocity
c----
            if (iw .eq. 6) then

                if (nf .gt. 0) then
                    got = .true.
                    go to 121
                else
                    if = 1
                    nf = 1
                endif

c----
c   we are within the current function reading the time velocity pair
c----
            elseif (iw .eq. 2) then

                if = if + 1

            endif
c----
c   this is where we need to be fter we have fully read in the current function,
c   and detected the start of the next, and have stored away the current function
c   using the block below "121" below
c----
125         continue

c----
c   this is for the card image which contains the location of the new function
c   and the time velocity
c----
            if (if .eq. 1) then
               IWRN = 0
               IF ( RC ) THEN
                  DI = x1
                  LI = x2
                  CX = LI
                  CY = DI
                  ICX = LI
                  ICY = DI
               ELSE
                  CX = x3 * scl
                  CY = x4 * scl
                  IWRN = 0
                  CALL XFMFWD (CX, CY, LI, DI, CXT,CYT,BXT,BYT, IWRN,
     1                         IX1,IY1,XX,XY,YX,YY,XXT, XYT,YXT,YYT,
     2                         DX, DY, NDI, NLI)
               ENDIF
 
               IF (LI .LT. MINLI) IWRN = 1
               IF (LI .GT. MAXLI) IWRN = 1
               IF (DI .LT. MINDI) IWRN = 1
               IF (DI .GT. MAXDI) IWRN = 1

c----
c   if the start of the current function is out of bounds then
c   we must read through to the start of the next function
c----
               if (IWRN .eq. 1) then
                  write(LERR,*)'Function located at ',ICX,ICY,
     1            ' out of bounds'
                  do  while (1.eq.1)
                      read (luin, '(a80)', end=310, err=666) card
                      go to 311
310                   continue
                      go to 665
311                   continue
                      call ctrim (card, im)
                      iw = iwcount (card, 80)
c----
c   we find the start of the next function, extract the floats and then
c   go to "125" to see if this is within bounds
c----
                      if (iw .eq. 6) then
                         if = 1
                         do i = 1, 10
                            x (i) = 0
                         enddo
                         call gliner (card, x)
                         x1 = x(1)
                         x2 = x(2)
                         x3 = x(3)
                         x4 = x(4)
                         x5 = x(5)
                         x6 = x(6)
                         go to 125
                      endif
                  enddo
               else
                  write(LERR,*)'Function located at ',ICX,ICY,
     1            ' inside box'
                  got = .true.
                  lilast = LI
                  dilast = DI
               endif

c----
c   for the first card of new function we are within bounds so grab the time & vel
c----
               ivel (if) = x6
               itim (if) =  nint (x5 * tscl)
               go to 665

c----
c   we are within the current function so grab the time & vel
c----
            elseif (if .gt. 1) then

               ivel (if) = x2
               itim (if) = nint (x1 * tscl)
               go to 665

            endif

121      continue

c----
c   for completed valid function:
c   sort in case times are not in ascending order
c----
               IF (got .AND. (if .gt. 1) ) THEN

                  iff = 0
                  do  i = 1, if
                      itimi = itim(i)
                      if (itimi .lt. itmax .AND. ivel(i) .gt. 0) then
                         iff = iff + 1
                         ivel (iff) = ivel (i)
                         itim (iff) = itimi
                      endif
                  enddo
                  if = iff
                  call sort (itim, key, if)
                  do  i = 1, if
                      itmp (i) = ivel (key(i))
                  enddo
                  do  i = 1, if
                      ivel (i) = itmp (i)
                  enddo

c----
c   build TDFN input for vi3d
c----
                  xcards = float (if) / 7.0
                  ncards = ifix  (xcards - .001)
                  left = if - 7 * ncards
                  i1 = 7 * ncards + left + 1
                  i2 = 7 * (ncards + 1)
                  do  i = i1, i2
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
          
                  write (luout,555) ir0, tag, lilast, dilast
555               format (i1, a4, 2i5)
 
                  ih = -7
                  itag = 0
                  if (ncards .gt. 0) then
                     do  i = 1, ncards
                         itag = itag + 1
                         if (itag .ge. 9) itag = 1
                         ih = (i-1) * 7
                         write (luout,777) itag, tag,
     1                   (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
                     enddo
                  endif
                  ih = ih + 7
                  write (luout,777) i9, tag,
     1            (itim(ih+ii), ivel(ih+ii), ii = 1, 7), ir1
777               format (i1, a4, 7(I4,I5), 7X, I5)
 
c----
c   clear velocity & time arrays. If this is really the last function
c   then we don't want to jump up to read another card - we need to exit
c----
                  do  i = 1, if
                      itim (i) = 0
                      ivel (i) = 0
                  enddo
                  nf = nf + 1
                  if = 1
                  got = .false.
                  if (EOF) go to 999
                  go to 125
 
               ENDIF

665      CONTINUE
 
      ENDDO

      if (nf .eq. 0) go to 667

      go to 999
 
666   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din:'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)'file for function number ',nf,' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din:'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)'file for function number ',nf,' line was:',card

      go to 999
 
667   continue
 
      write(LERR,*)' '
      write(LERR,*)'ERROR in vi3din:'
      write(LERR,*)'Yikes! no valid functions read from file. Check'
      write(LERR,*)'to see if corner coords are correct; check XYs'
      write(LERR,*)'in input file; is each funtion together not'
      write(LERR,*)'scattered throughout input file?'
      write(LER ,*)' '
      write(LER ,*)'ERROR in vi3din:'
      write(LER ,*)'Yikes! no valid functions read from file. Check'
      write(LER ,*)'to see if corner coords are correct; check XYs'
      write(LER ,*)'in input file; is each funtion together not'
      write(LER ,*)'scattered throughout input file?'

 
999   continue

      return
      end
