C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c ----------------------------------------------------------------------
c
      subroutine rsamp2d ( n1, n2, ipass, n1_out, n2_out, o1, o2,
     1     d1, d2, d1_out, d2_out, o1_out, o2_out, nsinc, bc,
     2     data_in, data_out, data_tmp, index1, index2,
     3     x1, y1, rem1, rem2, sys1, sys2, mask1, mask2,
     4     do_x, do_y, inv, zero, blin )
c
c
      integer n1, n2, ipass, n1_out, n2_out, nsinc, bc
      integer	index1(n1_out), index2(n2_out)

      integer i1,i2
c
      real o1, o2, d1, d2
      real d1_out, d2_out, o1_out, o2_out
c
      real data_in(n1,n2)
      real data_out(n1_out,n2_out)
      real data_tmp(n1_out,n2)
      real x1(n1_out)
      real y1(n2_out)
      real rem1(n1_out)
      real rem2(n2_out)
      real sys1(n1_out,n2)
      real sys2(n1_out,n2_out)

      integer mask1(n1_out), mask2(n2_out)

      character*1 sinc, zap, inverse

      logical do_x, do_y, inv, zero, blin

c initialize variables

c      if (ipass .eq. 1) then
c took this out as inverse, zap and sinc do not
c retain these values on the SGI causing bilinear
c to go back to sinc after record one etc.
c Garossino Apr 28,2003

         inverse = 'n'
         if (inv) inverse = 'y'
         zap = 'n'
         if (zero) zap = 'y'
         sinc = 'y'
         if (blin) sinc = 'n'
c      endif

c
c make the interpolated arrays
c
      if (do_x) then

         call rsamp1_r( n1, n2, data_in, data_tmp, d1_out, o1_out, d1, 
     :        o1, n1_out, sinc, inverse, zap, nsinc, ipass, index1, 
     :        rem1, mask1, sys1, x1, bc )
       else
           do i2 = 1, n2
              do  i1 = 1, n1
                  data_tmp(i1,i2) = data_in(i1,i2)
              enddo
           enddo
       endif
 
       if (do_y) then
          call rsamp2_r( n1_out, n2, data_tmp, data_out, d2_out, 
     :         o2_out, d2, o2, n2_out, sinc, inverse, zap, nsinc,
     :         ipass, index2, rem2, mask2, sys2, y1, bc )
       else
           do i2 = 1, n2_out
              do  i1 = 1, n1_out
                  data_out(i1,i2) = data_tmp(i1,i2)
              enddo
           enddo
       endif

       ipass = ipass + 1
c
       return
       end
c
c
c ----------------------------------------------------------------------
c
      subroutine rsamp1_r( n1, n2, data_in, data_out, d1_new, o1_new, 
     :     d1_old, o1_old, n1_new, sinc, inverse, zap, nsinc, ipass, 
     :     index, rem, mask, sys1, x1, bc )
c
      integer n1, n2, n1_new, nsinc, ipass, bc
      integer index(n1_new)
      integer mask(n1_new)

      integer i1, i2, ishift 
      integer i1_here
c
      real data_in(n1, n2)
      real data_out(n1_new, n2)
      real d1_new, o1_new, d1_old, o1_old
      real stdd, pi
      real rem(n1_new), sys1(n1_new, n2), x1(n1_new)
c     
      character*1 sinc, inverse, zap

c initialize variables

      parameter(pi=3.1415926535)
        
c
c make the taper for the sinc
c
	stdd=.707/(float(nsinc)/4.)
c
	if(ipass .eq. 1)then
c
c compute the indicies and remainders
c
	   do i1=1,n1_new
		index(i1)=int(((i1-1)*d1_new+o1_new-o1_old)/d1_old)+1
	        rem(i1)=(o1_new+d1_new*(i1-1)-
     1				((index(i1)-1)*d1_old+o1_old))/d1_old
c
		if(rem(i1) .eq. 1.)then
		   rem(i1)=0.
		   index(i1)=index(i1)+1
		end if
c
	        mask(i1)=1
c
	   end do
c
	   if(sinc .eq. 'n')then
	     do i1=1,n1_new
c
	        if(index(i1) .ge. n1)then
		  mask(i1)=0
	          index(i1)=n1-1
		  rem(i1)=1.
	        end if
c
	        if(index(i1) .lt. 1)then
		  mask(i1)=0
	          index(i1)=1
		  rem(i1)=0.
	        end if
c
	     end do
c
	   else
c
	     do i1=1,n1_new
c
	        if(index(i1) .ge. n1)then
		  mask(i1)=0
	          index(i1)=n1
		  rem(i1)=0.
	        end if
c
	        if(index(i1) .lt. 1)then
		  mask(i1)=0
	          index(i1)=1
		  rem(i1)=0.
	        end if
c
	     end do
c
	   end if
c
c end of checking for first time through
c
	end if
c
c
c if we are supposed to interpolate the inverse (as in slowness)
c
	if(inverse .eq. 'y')then
	   do i2=1,n2
	      do i1=1,n1
		 data_in(i1,i2)=1./data_in(i1,i2)
	      end do
	   end do
	end if
c
c make the interpolated arrays
c
        if(sinc .eq. 'n')then
c
           do i2=1,n2
              do i1=1,n1_new
                 data_out(i1,i2) = ( 1.0 - rem(i1) ) * 
     :                data_in( index(i1), i2 ) + 
     :                rem(i1) * data_in( index(i1) + 1, i2 )
              enddo
           enddo
c
	else
c
c do the collection for the nearest point
c
		do i1=1,n1_new
c
		  if(rem(i1) .ne. 0.)then
		     x1(i1)=sin(pi*rem(i1))/(pi*rem(i1))*
     1				exp(-(stdd*rem(i1))**2)
		  else
		     x1(i1)=1.0
		  end if
c
	        end do
c
	        do i2=1,n2
		   do i1=1,n1_new
		      data_out(i1,i2)=x1(i1)*data_in(index(i1),i2)
		   end do
	        end do
c
c now do all the rest of the stencil
c
		do ishift=1,nsinc
c
c first work on the upper part of the 1-d stencil
c
		    do i1=1,n1_new
c
		       i1_here=index(i1)+ishift
c
		       if(bc .eq. 0)then
c
			  if(i1_here .gt. n1)then
		             do i2=1,n2
		                sys1(i1,i2)=0.
		             end do
			  else
		             do i2=1,n2
		                sys1(i1,i2)=data_in(i1_here,i2)
		             end do
			  end if
c
		       else
c
			  if(i1_here .gt. n1)then
		             do i2=1,n2
		                sys1(i1,i2)=data_in(n1,i2)
		             end do
			  else
		             do i2=1,n2
		                sys1(i1,i2)=data_in(i1_here,i2)
		             end do
			  end if
c
			end if
		          
c
c make the relative position
c
		       x1(i1)=ishift-rem(i1)
c
		    end do
c
		    do i2=1,n2
		       do i1=1,n1_new
c
			  data_out(i1,i2)=data_out(i1,i2)+
     1				sin(pi*x1(i1))/(pi*x1(i1))
     2				*exp(-(stdd*x1(i1))**2)*sys1(i1,i2)
c
		        end do
		    end do
c
c ok, now do the lower part of the stencil
c
		    do i1=1,n1_new
c
		       i1_here=index(i1)-ishift
c
		       if(bc .eq. 0)then
c
			  if(i1_here .lt. 1)then
		             do i2=1,n2
		                sys1(i1,i2)=0.
		             end do
			  else
		             do i2=1,n2
		                sys1(i1,i2)=data_in(i1_here,i2)
		             end do
			  end if
c
		       else
c
			  if(i1_here .lt. 1)then
		             do i2=1,n2
		                sys1(i1,i2)=data_in(1,i2)
		             end do
			  else
		             do i2=1,n2
		                sys1(i1,i2)=data_in(i1_here,i2)
		             end do
			  end if
c
			end if
c
c make the relative position
c
		       x1(i1)=rem(i1)+ishift
c
		    end do
c
		    do i2=1,n2
		       do i1=1,n1_new
c
			  data_out(i1,i2)=data_out(i1,i2)+
     1				sin(pi*x1(i1))/(pi*x1(i1))
     2				*exp(-(stdd*x1(i1))**2)*sys1(i1,i2)
c
		        end do
		    end do
c
c end of loop over shifts
c
		end do
c
c end of sinc or no sinc
c
	    end if
c
c invert if we need to
c
	   if(inverse .eq. 'y')then
	   do i2=1,n2
	      do i1=1,n1_new
		 data_out(i1,i2)=1./data_out(i1,i2)
	      end do
	   end do
	   end if
c
c zero out outside values if requested
c
	   if(zap .eq. 'y')then
		 do i2=1,n2
		    do i1=1,n1_new
		       data_out(i1,i2)=mask(i1)*data_out(i1,i2)
		    end do
		 end do
	    end if
c
	return
	end
c
c ----------------------------------------------------------------------
c
      subroutine rsamp2_r( n1, n2, data_in, data_out, d2_new, o2_new, 
     :     d2_old, o2_old, n2_new, sinc, inverse, zap, nsinc, ipass, 
     :     index, rem, mask, sys1, y1, bc )
c
      integer n1, n2, n2_new, nsinc, ipass, bc
      integer i1, i2, ishift, i2_here
      integer index(n2_new)
      integer mask(n2_new)
c
      real data_in(n1, n2)
      real data_out(n1, n2_new)
      real d2_new, o2_new, d2_old, o2_old
      real stdd

      real rem(n2_new), sys1(n1, n2_new), y1(n2_new)
      real pi
c
      character*1 sinc, inverse, zap
c

      parameter(pi=3.1415926535)
c
c compute the length of the sinc taper
c
      stdd=.707/(float(nsinc)/4.)
c
      if(ipass .eq. 1)then
c
c compute the indicies and remainders
c
         do i2=1,n2_new
            index(i2)=int(((i2-1)*d2_new+o2_new-o2_old)/d2_old)+1
            rem(i2)=(o2_new+d2_new*(i2-1)-
     1           ((index(i2)-1)*d2_old+o2_old))/d2_old
c
            if(rem(i2) .eq. 1)then
               rem(i2)=0.
               index(i2)=index(i2)+1
            end if
c     
            mask(i2)=1
c     
         end do
c     
         if(sinc .eq. 'n')then
            do i2=1,n2_new
               if(index(i2) .ge. n2)then
		  mask(i2)=0
	          index(i2)=n2-1
		  rem(i2)=1.
               end if
c
               if(index(i2) .lt. 1)then
		  mask(i2)=0
	          index(i2)=1
		  rem(i2)=0.
               end if
            end do
         else
            do i2=1,n2_new
               if(index(i2) .ge. n2)then
		  mask(i2)=0
	          index(i2)=n2
		  rem(i2)=0.
               end if
c
               if(index(i2) .lt. 1)then
		  mask(i2)=0
	          index(i2)=1
		  rem(i2)=0.
               end if
            end do
         end if
c
c end of checking for first time through
c
      end if
c
c
c if we are supposed to interpolate the inverse (as in slowness)
c
      if(inverse .eq. 'y')then
         do i2=1,n2
            do i1=1,n1
               data_in(i1,i2)=1./data_in(i1,i2)
            end do
         end do
      end if
c
c make the interpolated arrays
c
      if(sinc .eq. 'n')then
c
         do i2=1,n2_new
            do i1=1,n1
               data_out(i1,i2) = (1.0 -rem(i2) ) * 
     :              data_in( i1, index(i2) ) +
     1              rem(i2) * data_in( i1, index(i2)+1 )
            end do
         end do
c     
      else
c
c do the collection for the nearest point
c
         do i2=1,n2_new
c
            if(rem(i2) .ne. 0.)then
               y1(i2)=sin(pi*rem(i2))/(pi*rem(i2))*
     1              exp(-(stdd*rem(i2))**2)
            else
               y1(i2)=1.0
            end if
c     
         end do
c     
         do i2=1,n2_new
            do i1=1,n1
               data_out(i1,i2)=y1(i2)*data_in(i1,index(i2))
            end do
         end do
c
c now do all the rest of the stencil
c
         do ishift=1,nsinc
c
c first work on the upper part of the 1-d stencil
c
            do i2=1,n2_new
c
               i2_here=index(i2)+ishift
c
               if(bc .eq. 0)then
c
                  if(i2_here .gt. n2)then
                     do i1=1,n1
                        sys1(i1,i2)=0.
                     end do
                  else
                     do i1=1,n1
                        sys1(i1,i2)=data_in(i1,i2_here)
                     end do
                  end if
c
               else
c
                  if(i2_here .gt. n2)then
                     do i1=1,n1
                        sys1(i1,i2)=data_in(i1,n2)
                     end do
                  else
                     do i1=1,n1
                        sys1(i1,i2)=data_in(i1,i2_here)
                     end do
                  end if
c     
               end if
		          
c
c make the relative position
c
               y1(i2)=ishift-rem(i2)
c
            end do
c
            do i2=1,n2_new
               do i1=1,n1
c
                  data_out(i1,i2)=data_out(i1,i2)+
     1                 sin(pi*y1(i2))/(pi*y1(i2))
     2                 *exp(-(stdd*y1(i2))**2)*sys1(i1,i2)
c
               end do
            end do
c
c ok, now do the lower part of the stencil
c
            do i2=1,n2_new
c     
               i2_here=index(i2)-ishift
c     
               if(bc .eq. 0)then
c
                  if(i2_here .lt. 1)then
                     do i1=1,n1
                        sys1(i1,i2)=0.
                     end do
                  else
                     do i1=1,n1
                        sys1(i1,i2)=data_in(i1,i2_here)
                     end do
                  end if
c
               else
c
                  if(i2_here .lt. n2)then
                     do i1=1,n1
                        sys1(i1,i2)=data_in(i1,1)
                     end do
                  else
                     do i1=1,n1
                        sys1(i1,i2)=data_in(i1,i2_here)
                     end do
                  end if
c
               end if
c
c make the relative position
c
               y1(i2)=rem(i2)+ishift
c
            end do
c
            do i2=1,n2_new
               do i1=1,n1
c
                  data_out(i1,i2)=data_out(i1,i2)+
     1                 sin(pi*y1(i2))/(pi*y1(i2))
     2                 *exp(-(stdd*y1(i2))**2)*sys1(i1,i2)
c
               end do
            end do
c
c end of loop over shifts
c
         end do
c
c end of sinc or no sinc
c
      end if
c
c invert if we need to
c
      if(inverse .eq. 'y')then
         do i2=1,n2_new
            do i1=1,n1
               data_out(i1,i2)=1./data_out(i1,i2)
            end do
         end do
      end if
c
c zero out outside values if requested
c
      if(zap .eq. 'y')then
         do i2=1,n2_new
            do i1=1,n1
               data_out(i1,i2)=mask(i2)*data_out(i1,i2)
            end do
         end do
      end if
c
c all done
c
      return
      end
