C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tr2ti( rt, rv, nn)

c tr2ti converts an input RMS velocity function to INTERVAL velocity 
c using Dix Equation. 
c
c it is assumed that:
c
c  rt() = 2way TIME in seconds
c  rv() = RMS velocity in units/second
c
c on output rv() = INTERVAL velocity in units/second
c velocity is referenced to the bottom of the interval

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer nn, i

      real rt(*), rv(*), vint(SZLNHD)
      real IntervalTime(SZLNHD)

c initialize memory
      
      call vclr( vint, 1, SZLNHD )
      call vclr( IntervalTime, 1, SZLNHD )

c assign first interval velocity

      vint(1) = rv(1)

c assign IntervalTime[1]

      IntervalTime(1) = rt(1) / 2.

      DO i = 2, nn
         IntervalTime(i) = ( rt(i) - rt(i-1) ) / 2.

c form numerator

         Numerator = ( rv(i)**2 * rt(i) / 2. ) - 
     :        ( rv(i-1)**2 * rt(i-1) / 2. )

c POLICEMAN: check to see if numerator is negative (ie. rms velocity inversion)
c            if so, then stop and warn user of this problem and suggest
c            options......use interval velocities....supply maxtime rms velocity

c calculate vint
         if ( Numerator .lt. 0. ) then
             vint(i) = vint (i-1)
         else
             vint(i) = sqrt ( Numerator / IntervalTime(i) )
         endif


      ENDDO

c handle zero TIME entry, since interval velocity is referenced to the
c base of the interval the first entry [if zero] must contain the 
c same velocity as at the base of the first interval.

      IF ( rt(1) .gt. 1.0e-20 ) then

c there is no zero time entry, must manufacture one
c bump rt() values up one slot to make room for zero entry

         do i = nn + 1, 2, -1
            rt(i) = rt(i-1)
         enddo

c assign zero TIME rt() value

         rt(1) = 0.

c load INTERVAL velocities to rv()

         call vmov( vint, 1, rv(2), 1, nn )

c assign zero TIME rv[1] value

         rv(1) = rv(2)

c increase function count by one

         nn = nn + 1

      ELSE

c load INTERVAL velocities to rv()

         call vmov( vint, 1, rv, 1, nn )

      ENDIF   
         
      return
      end

